/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataReader;

import Alachisoft.NCache.Common.DataReader.ColumnCollection;
import Alachisoft.NCache.Common.DataReader.RecordColumn;
import Alachisoft.NCache.Common.DataReader.RecordRow;
import Alachisoft.NCache.Common.DataReader.RecordSet;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumerator;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumeratorImpl;
import Alachisoft.NCache.Common.DataReader.RowCollection;
import Alachisoft.NCache.Common.DataReader.SubsetInfo;
import Alachisoft.NCache.Common.DataStructures.ColumnDataType;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;
import java.time.LocalDateTime;

public class RecordSetImpl
implements RecordSet,
InternalCompactSerializable {
    private ColumnCollection _columns;
    private RowCollection _rows;
    private SubsetInfo _subsetInfo;
    private int _nextIndex = 0;

    public RecordSetImpl() {
        this._columns = new ColumnCollection();
        this._rows = new RowCollection(this._columns);
    }

    public RecordSetImpl(ColumnCollection columnMetaData) {
        this._columns = columnMetaData;
        this._rows = new RowCollection(this._columns);
    }

    public static String getString(Object obj, ColumnDataType dataType) {
        switch (dataType) {
            case DateTime: {
                return String.format("%d", (LocalDateTime)obj);
            }
            case String: {
                return (String)obj;
            }
        }
        return obj.toString();
    }

    public final int getNextIndex() {
        return this._nextIndex;
    }

    public final void setNextIndex(int value) {
        this._nextIndex = value;
    }

    @Override
    public final SubsetInfo getSubsetInfo() {
        return this._subsetInfo;
    }

    @Override
    public final void setSubsetInfo(SubsetInfo value) {
        this._subsetInfo = value;
    }

    public final ColumnCollection getColumns() {
        return this._columns;
    }

    @Override
    public final RowCollection getRows() {
        return this._rows;
    }

    public final RecordSet getSubRecordSet(int startingRowIndex, int count) {
        RecordSetImpl subRecordSet = new RecordSetImpl(this._columns);
        int i = -1;
        for (i = startingRowIndex; i < startingRowIndex + count && i < this.getRowCount(); ++i) {
            subRecordSet.addRow((RecordRow)this.getRow(i).clone());
        }
        subRecordSet.setSubsetInfo(new SubsetInfo());
        subRecordSet.getSubsetInfo().setLastAccessedRowID(i < this.getRowCount() ? i - 1 : this.getRowCount() - 1);
        return subRecordSet;
    }

    public final int getSize() {
        return 0;
    }

    @Override
    public final void addColumn(RecordColumn column) {
        this._columns.add(column);
    }

    @Override
    public final RecordRow createRow() {
        RecordRow row = new RecordRow(this._columns);
        return row;
    }

    @Override
    public final void addRow(RecordRow row) {
        this._rows.add(row);
    }

    @Override
    public final RecordRow getRow(int rowID) {
        return this._rows.getRow(rowID);
    }

    @Override
    public final boolean containsRow(int rowID) {
        return this._rows.contains(rowID);
    }

    @Override
    public final void removeRow(int rowID) {
        this._rows.removeRow(rowID);
    }

    @Override
    public final int removeRows(int startingIndex, int count) {
        if (startingIndex < 0 || count < 0) {
            return 0;
        }
        int removed = 0;
        for (int i = startingIndex; i < startingIndex + count; ++i) {
            if (!this._rows.removeRow(i)) continue;
            ++removed;
        }
        return removed;
    }

    @Override
    public final ColumnCollection getColumnMetaData() {
        return this._columns;
    }

    @Override
    public final int getRowCount() {
        return this._rows.getCount();
    }

    @Override
    public final RecordSetEnumerator getEnumerator() {
        return new RecordSetEnumeratorImpl(this);
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        Object tempVar = reader.ReadObject();
        this._columns = tempVar instanceof ColumnCollection ? (ColumnCollection)tempVar : null;
        Object tempVar2 = reader.ReadObject();
        this._rows = tempVar2 instanceof RowCollection ? (RowCollection)tempVar2 : null;
        Object tempVar3 = reader.ReadObject();
        this._subsetInfo = tempVar3 instanceof SubsetInfo ? (SubsetInfo)tempVar3 : null;
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this._columns);
        writer.WriteObject((Object)this._rows);
        writer.WriteObject((Object)this._subsetInfo);
    }
}

