/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class InstantaneousIndex<T>
implements Cloneable,
Iterable<T> {
    private ArrayList<T> _activitesList = new ArrayList();
    private HashMap _table = new HashMap();
    private boolean _checkDuplication;
    private long privateClockTime;
    private long privateMinActivityId;
    private long privateMaxActivityId;

    public final long getClockTime() {
        return this.privateClockTime;
    }

    public final void setClockTime(long value) {
        this.privateClockTime = value;
    }

    public final long getMinActivityId() {
        return this.privateMinActivityId;
    }

    public final void setMinActivityId(long value) {
        this.privateMinActivityId = value;
    }

    public final long getMaxActivityId() {
        return this.privateMaxActivityId;
    }

    public final void setMaxActivityId(long value) {
        this.privateMaxActivityId = value;
    }

    public final boolean getEnableDuplicationCheck() {
        return this._checkDuplication;
    }

    public final void setEnableDuplicationCheck(boolean value) {
        this._checkDuplication = value;
    }

    public final void AddEntry(long entryId, T activity) {
        if (this._checkDuplication) {
            this._table.put(activity, entryId);
        }
        this._activitesList.add(activity);
        if (this._activitesList.size() == 1) {
            this.setMinActivityId(entryId);
        }
        this.setMaxActivityId(entryId);
    }

    public final boolean CheckDuplication(T activity) {
        return this._table.containsKey(activity);
    }

    public final ArrayList<T> GetClientActivites(long lastEnteryId) {
        ArrayList clientActivities = new ArrayList();
        if (lastEnteryId < this.getMinActivityId()) {
            return this._activitesList;
        }
        if (lastEnteryId < this.getMaxActivityId()) {
            int startingIndex = (int)(lastEnteryId - this.getMinActivityId()) + 1;
            int length = (int)(this.getMaxActivityId() - lastEnteryId);
            return this.getRange(this._activitesList, startingIndex, length);
        }
        return clientActivities;
    }

    private ArrayList<T> getRange(ArrayList<T> list, int start, int last) {
        ArrayList<T> temp = new ArrayList<T>();
        for (int x = start; x <= last; ++x) {
            temp.add(list.get(x));
        }
        return temp;
    }

    public boolean equals(Object obj) {
        InstantaneousIndex other = (InstantaneousIndex)obj;
        return other != null && other.getClockTime() == this.getClockTime();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public final Object clone() {
        InstantaneousIndex<T> clone = new InstantaneousIndex<T>();
        clone._activitesList.addAll(this.getRange(this._activitesList, 0, this._activitesList.size()));
        return clone;
    }

    public final Iterator<T> GetEnumerator() {
        return this._activitesList.iterator();
    }

    @Override
    public Iterator<T> iterator() {
        return this._activitesList.iterator();
    }
}

