/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.QueueClosedException;
import Alachisoft.NCache.Common.Enum.Priority;
import Alachisoft.NCache.Common.Threading.Monitor;
import java.util.LinkedList;
import tangible.RefObject;

public class Queue {
    private static final Object endMarker = new Object();
    private LinkedList[] _queues = new LinkedList[3];
    private boolean closed = false;
    private int size = 0;
    private Object mutex = new Object();
    private int num_markers = 0;

    public Queue() {
        this._queues[Priority.Critical.getValue()] = new LinkedList();
        this._queues[Priority.Normal.getValue()] = new LinkedList();
        this._queues[Priority.Low.getValue()] = new LinkedList();
    }

    public final int getCount() {
        return this.size - this.num_markers;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void add(Object obj) {
        this.add(obj, Priority.Normal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(Object obj, Priority priority) {
        if (obj == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new QueueClosedException();
            }
            if (this.num_markers > 0) {
                throw new QueueClosedException("Queue.add(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
            }
            this._queues[priority.getValue()].offer(obj);
            ++this.size;
            Monitor.pulse(this.mutex);
        }
    }

    public final Object remove() throws QueueClosedException, InterruptedException {
        Object retval = null;
        retval = this.remove(Long.MAX_VALUE);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object remove(long timeout) throws QueueClosedException, InterruptedException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.size == 0) {
                if (this.closed) {
                    throw new QueueClosedException();
                }
                boolean wait = false;
                try {
                    Monitor.wait(this.mutex, timeout);
                }
                catch (InterruptedException ex) {
                    wait = true;
                }
                boolean bl = false;
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            if (this._queues[Priority.Critical.getValue()].size() > 0) {
                retval = this.removeInternal(this._queues[Priority.Critical.getValue()]);
            } else if (this._queues[Priority.Normal.getValue()].size() > 0) {
                retval = this.removeInternal(this._queues[Priority.Normal.getValue()]);
            } else if (this._queues[Priority.Low.getValue()].size() > 0) {
                retval = this.removeInternal(this._queues[Priority.Low.getValue()]);
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            return retval;
        }
    }

    public final Object peek() {
        Object retval = null;
        boolean success = false;
        RefObject<Boolean> tempRef_success = new RefObject<Boolean>(success);
        retval = this.peek(Long.MAX_VALUE, tempRef_success);
        success = (Boolean)tempRef_success.argvalue;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object peek(long timeout, RefObject<Boolean> success) {
        Object retval = null;
        success.argvalue = true;
        Object object = this.mutex;
        synchronized (object) {
            block11: {
                if (this.size == 0) {
                    if (this.closed) {
                        throw new QueueClosedException();
                    }
                    try {
                        long millis = System.currentTimeMillis();
                        if (timeout != 0L) {
                            Monitor.wait(this.mutex, timeout * 1000L);
                            if (System.currentTimeMillis() - millis > timeout * 1000L) {
                                success.argvalue = false;
                                return null;
                            }
                            break block11;
                        }
                        success.argvalue = false;
                        return null;
                    }
                    catch (InterruptedException ex) {
                        success.argvalue = false;
                        return null;
                    }
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            retval = this.peekInternal();
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
        }
        return retval;
    }

    private Object peekInternal() {
        Object retval = null;
        if (this._queues[Priority.Critical.getValue()].size() > 0) {
            retval = this._queues[Priority.Critical.getValue()].peek();
        } else if (this._queues[Priority.Normal.getValue()].size() > 0) {
            retval = this._queues[Priority.Normal.getValue()].peek();
        } else if (this._queues[Priority.Low.getValue()].size() > 0) {
            retval = this._queues[Priority.Low.getValue()].peek();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean flush_entries) {
        Object object = this.mutex;
        synchronized (object) {
            if (flush_entries) {
                try {
                    this.add(endMarker, Priority.Low);
                    ++this.num_markers;
                }
                catch (QueueClosedException queueClosedException) {
                    // empty catch block
                }
                return;
            }
            this.closed = true;
            Monitor.pulse(this.mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.num_markers = 0;
            if (!this.closed) {
                this.close(false);
            }
            this.size = 0;
            this._queues[Priority.Critical.getValue()].clear();
            this._queues[Priority.Normal.getValue()].clear();
            this._queues[Priority.Low.getValue()].clear();
            this.closed = false;
            Monitor.pulse(this.mutex);
        }
    }

    public String toString() {
        return "Queue (" + this.getCount() + ") messages";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeInternal(LinkedList queue) {
        Object obj = null;
        Object object = this.mutex;
        synchronized (object) {
            int count = queue.size();
            if (count <= 0) {
                return null;
            }
            obj = queue.poll();
            --this.size;
            if (this.size < 0) {
                this.size = 0;
            }
            if (this.peekInternal() == endMarker) {
                this.closed = true;
            }
        }
        return obj;
    }
}

