/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.QEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class QueueDictionary<V>
implements Iterable {
    private Map<V, QEntry<V>> store = new HashMap<V, QEntry<V>>();
    private QEntry<V> head = null;
    private QEntry<V> tail = null;

    public final int getCount() {
        return this.store.size();
    }

    public boolean Enqueue(V value) {
        if (this.store.containsKey(value)) {
            return false;
        }
        QEntry<V> entry = new QEntry<V>(value);
        this.store.put((QEntry<V>)value, (QEntry<QEntry<V>>)entry);
        if (this.head == null && this.tail == null) {
            this.head = entry;
        } else if (this.tail != null || this.head != null) {
            entry.Prev = this.tail;
            this.tail.Next = entry;
        }
        this.tail = entry;
        return true;
    }

    public boolean Remove(V value) {
        QEntry<V> entry = null;
        entry = this.store.get(value);
        if (entry != null) {
            if (this.store.remove(value) == null) {
                return false;
            }
            if (this.store.isEmpty()) {
                this.tail = null;
                this.head = null;
                return true;
            }
            if (entry.Prev == null) {
                this.head = this.head.Next;
                if (this.head != null) {
                    this.head.Prev = null;
                }
            } else {
                entry.Prev.Next = entry.Next;
                if (entry.Next != null) {
                    entry.Next.Prev = entry.Prev;
                } else {
                    this.tail = entry.Prev;
                }
            }
            return true;
        }
        return false;
    }

    public boolean Contains(V value) {
        return this.store.containsKey(value);
    }

    public V Peek() {
        if (this.head == null || this.head.Value == null) {
            return null;
        }
        return this.head.Value;
    }

    public V Dequeue() {
        if (this.head == null) {
            return null;
        }
        Object takeAway = this.head.Value;
        if (!this.Remove(takeAway)) {
            return null;
        }
        return takeAway;
    }

    public void dispose() {
        if (this.store != null) {
            this.store.clear();
            this.store = null;
        }
        this.head = null;
        this.tail = null;
    }

    public final Collection<V> getKeys() {
        return this.store.keySet();
    }

    public Iterator iterator() {
        return this.store.entrySet().iterator();
    }
}

