/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.DataStructures.RedBlackEnumerator;
import Alachisoft.NCache.Common.DataStructures.RedBlackException;
import Alachisoft.NCache.Common.DataStructures.RedBlackNode;
import Alachisoft.NCache.Common.DataStructures.RedBlackNodeReference;
import Alachisoft.NCache.Common.Util.WildcardEnabledRegex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedBlack {
    private int intCount;
    private RedBlackNode rbTree;
    private RedBlackNode _sentinelNode = new RedBlackNode();
    private RedBlackNode lastNodeFound;
    private String _cacheName;

    public RedBlack() {
        this._sentinelNode.setRight(this._sentinelNode);
        this._sentinelNode.setLeft(this._sentinelNode.getRight());
        this._sentinelNode.setParent(null);
        this._sentinelNode.setColor(1);
        this.rbTree = this._sentinelNode;
        this.lastNodeFound = this._sentinelNode;
    }

    public RedBlack(String cacheName) {
        this();
        this._cacheName = cacheName;
    }

    public final RedBlackNode getSentinelNode() {
        return this._sentinelNode;
    }

    public final Object Add(Comparable key, Object data) throws RedBlackException {
        boolean collision = false;
        RedBlackNodeReference keyNodeRfrnce = null;
        try {
            if (key == null || data == null) {
                throw new RedBlackException("RedBlackNode key and data must not be null");
            }
            int result = 0;
            RedBlackNode node = new RedBlackNode();
            RedBlackNode temp = this.rbTree;
            while (temp != this._sentinelNode) {
                node.setParent(temp);
                result = key instanceof String ? key.toString().toLowerCase().compareTo(temp.getKey().toString().toLowerCase()) : key.compareTo(temp.getKey());
                if (result == 0) {
                    collision = true;
                    break;
                }
                if (result > 0) {
                    temp = temp.getRight();
                    collision = false;
                    continue;
                }
                temp = temp.getLeft();
                collision = false;
            }
            if (collision) {
                temp.getData().put(data, null);
                keyNodeRfrnce = temp.getRBNodeReference();
            } else {
                node.setKey(key);
                node.getData().put(data, null);
                node.setLeft(this._sentinelNode);
                node.setRight(this._sentinelNode);
                if (node.getParent() != null) {
                    result = key instanceof String ? node.getKey().toString().toLowerCase().compareTo(node.getParent().getKey().toString().toLowerCase()) : node.getKey().compareTo(node.getParent().getKey());
                    result = node.getKey().compareTo(node.getParent().getKey());
                    if (result > 0) {
                        node.getParent().setRight(node);
                    } else {
                        node.getParent().setLeft(node);
                    }
                } else {
                    this.rbTree = node;
                }
                this.RestoreAfterInsert(node);
                this.lastNodeFound = node;
                ++this.intCount;
                keyNodeRfrnce = node.getRBNodeReference();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keyNodeRfrnce;
    }

    private void RestoreAfterInsert(RedBlackNode x) {
        while (x != this.rbTree && x.getParent().getColor() == 0) {
            RedBlackNode y;
            if (x.getParent() == x.getParent().getParent().getLeft()) {
                y = x.getParent().getParent().getRight();
                if (y != null && y.getColor() == 0) {
                    x.getParent().setColor(1);
                    y.setColor(1);
                    x.getParent().getParent().setColor(0);
                    x = x.getParent().getParent();
                    continue;
                }
                if (x == x.getParent().getRight()) {
                    x = x.getParent();
                    this.RotateLeft(x);
                }
                x.getParent().setColor(1);
                x.getParent().getParent().setColor(0);
                this.RotateRight(x.getParent().getParent());
                continue;
            }
            y = x.getParent().getParent().getLeft();
            if (y != null && y.getColor() == 0) {
                x.getParent().setColor(1);
                y.setColor(1);
                x.getParent().getParent().setColor(0);
                x = x.getParent().getParent();
                continue;
            }
            if (x == x.getParent().getLeft()) {
                x = x.getParent();
                this.RotateRight(x);
            }
            x.getParent().setColor(1);
            x.getParent().getParent().setColor(0);
            this.RotateLeft(x.getParent().getParent());
        }
        this.rbTree.setColor(1);
    }

    public final void RotateLeft(RedBlackNode x) {
        RedBlackNode y = x.getRight();
        x.setRight(y.getLeft());
        if (y.getLeft() != this._sentinelNode) {
            y.getLeft().setParent(x);
        }
        if (y != this._sentinelNode) {
            y.setParent(x.getParent());
        }
        if (x.getParent() != null) {
            if (x == x.getParent().getLeft()) {
                x.getParent().setLeft(y);
            } else {
                x.getParent().setRight(y);
            }
        } else {
            this.rbTree = y;
        }
        y.setLeft(x);
        if (x != this._sentinelNode) {
            x.setParent(y);
        }
    }

    public final void RotateRight(RedBlackNode x) {
        RedBlackNode y = x.getLeft();
        x.setLeft(y.getRight());
        if (y.getRight() != this._sentinelNode) {
            y.getRight().setParent(x);
        }
        if (y != this._sentinelNode) {
            y.setParent(x.getParent());
        }
        if (x.getParent() != null) {
            if (x == x.getParent().getRight()) {
                x.getParent().setRight(y);
            } else {
                x.getParent().setLeft(y);
            }
        } else {
            this.rbTree = y;
        }
        y.setRight(x);
        if (x != this._sentinelNode) {
            x.setParent(y);
        }
    }

    public final Object GetData(Comparable key, COMPARE compareType) {
        ArrayList keyList = new ArrayList();
        RedBlackNode treeNode = this.rbTree;
        RedBlackEnumerator en = this.GetEnumerator();
        HashMap finalTable = null;
        HashMap skippedKeys = null;
        boolean isStringValue = false;
        if (key instanceof String) {
            isStringValue = true;
        }
        switch (compareType) {
            case EQ: {
                while (treeNode != this._sentinelNode) {
                    int result = isStringValue && treeNode.getKey() instanceof String ? treeNode.getKey().toString().toLowerCase().compareTo(key.toString().toLowerCase()) : treeNode.getKey().compareTo(key);
                    if (result == 0) {
                        this.lastNodeFound = treeNode;
                        keyList.addAll(treeNode.getData().keySet());
                        return keyList;
                    }
                    if (result > 0) {
                        treeNode = treeNode.getLeft();
                        continue;
                    }
                    treeNode = treeNode.getRight();
                }
                break;
            }
            case NE: {
                finalTable = new HashMap();
                while (en.MoveNext()) {
                    int result = isStringValue && en.getKey() instanceof String ? ((Comparable)en.getKey()).toString().toLowerCase().compareTo(key.toString().toLowerCase()) : ((Comparable)en.getKey()).compareTo(key);
                    if (result == 0) continue;
                    HashMap tmp = (HashMap)(en.getValue() instanceof HashMap ? en.getValue() : null);
                    for (Map.Entry pair : tmp.entrySet()) {
                        finalTable.put(pair.getKey(), pair.getValue());
                    }
                }
                return new ArrayList(finalTable.keySet());
            }
            case GT: {
                finalTable = new HashMap();
                while (en.MoveNext()) {
                    int result = isStringValue && en.getKey() instanceof String ? ((Comparable)en.getKey()).toString().toLowerCase().compareTo(key.toString().toLowerCase()) : ((Comparable)en.getKey()).compareTo(key);
                    if (result <= 0) continue;
                    HashMap tmp = (HashMap)(en.getValue() instanceof HashMap ? en.getValue() : null);
                    for (Map.Entry pair : tmp.entrySet()) {
                        finalTable.put(pair.getKey(), pair.getValue());
                    }
                }
                return new ArrayList(finalTable.keySet());
            }
            case LT: {
                finalTable = new HashMap();
                while (en.MoveNext()) {
                    int result = isStringValue && en.getKey() instanceof String ? ((Comparable)en.getKey()).toString().toLowerCase().compareTo(key.toString().toLowerCase()) : ((Comparable)en.getKey()).compareTo(key);
                    if (result >= 0) continue;
                    HashMap tmp = (HashMap)(en.getValue() instanceof HashMap ? en.getValue() : null);
                    for (Map.Entry pair : tmp.entrySet()) {
                        finalTable.put(pair.getKey(), pair.getValue());
                    }
                }
                return new ArrayList(finalTable.keySet());
            }
            case GTEQ: {
                finalTable = new HashMap();
                while (en.MoveNext()) {
                    int result = isStringValue && en.getKey() instanceof String ? ((Comparable)en.getKey()).toString().toLowerCase().compareTo(key.toString().toLowerCase()) : ((Comparable)en.getKey()).compareTo(key);
                    if (result < 0) continue;
                    HashMap tmp = (HashMap)(en.getValue() instanceof HashMap ? en.getValue() : null);
                    for (Map.Entry pair : tmp.entrySet()) {
                        finalTable.put(pair.getKey(), pair.getValue());
                    }
                }
                return new ArrayList(finalTable.keySet());
            }
            case LTEQ: {
                int result;
                finalTable = new HashMap();
                while (en.MoveNext() && (result = isStringValue && en.getKey() instanceof String ? ((Comparable)en.getKey()).toString().toLowerCase().compareTo(key.toString().toLowerCase()) : ((Comparable)en.getKey()).compareTo(key)) <= 0) {
                    HashMap tmp = (HashMap)(en.getValue() instanceof HashMap ? en.getValue() : null);
                    for (Map.Entry pair : tmp.entrySet()) {
                        finalTable.put(pair.getKey(), pair.getValue());
                    }
                }
                return new ArrayList(finalTable.keySet());
            }
            case REGEX: {
                finalTable = new HashMap();
                String pattern = (String)((Object)(key instanceof String ? key : null));
                String ptrn = WildcardEnabledRegex.ConvertWildCard(pattern);
                Pattern regex = Pattern.compile(ptrn);
                while (en.MoveNext()) {
                    Matcher matcher;
                    if (!(en.getKey() instanceof String) || !(matcher = regex.matcher(en.getKey().toString().toLowerCase())).matches()) continue;
                    HashMap tmp = (HashMap)(en.getValue() instanceof HashMap ? en.getValue() : null);
                    for (Map.Entry pair : tmp.entrySet()) {
                        finalTable.put(pair.getKey(), pair.getValue());
                    }
                }
                return new ArrayList(finalTable.keySet());
            }
            case IREGEX: {
                finalTable = new HashMap();
                String pattern = (String)((Object)(key instanceof String ? key : null));
                String irPatrn = WildcardEnabledRegex.ConvertWildCard(pattern);
                Pattern regex = Pattern.compile(irPatrn);
                skippedKeys = new HashMap();
                while (en.MoveNext()) {
                    HashMap tmp;
                    if (!(en.getKey() instanceof String)) continue;
                    Matcher matcher = regex.matcher(en.getKey().toString().toLowerCase());
                    if (matcher.matches()) {
                        tmp = (HashMap)(en.getValue() instanceof HashMap ? en.getValue() : null);
                        for (Map.Entry pair : tmp.entrySet()) {
                            skippedKeys.put(pair.getKey(), pair.getValue());
                        }
                        continue;
                    }
                    tmp = (HashMap)(en.getValue() instanceof HashMap ? en.getValue() : null);
                    for (Map.Entry pair : tmp.entrySet()) {
                        finalTable.put(pair.getKey(), pair.getValue());
                    }
                }
                ArrayList list = new ArrayList(finalTable.keySet());
                for (int idx = list.size() - 1; idx >= 0; --idx) {
                    if (!skippedKeys.containsKey(list.get(idx))) continue;
                    list.remove(idx);
                }
                return list;
            }
        }
        return keyList;
    }

    public final boolean Contains(Comparable key) {
        RedBlackNode treeNode = this.rbTree;
        while (treeNode != this._sentinelNode) {
            int result = treeNode.getKey().compareTo(key);
            if (result == 0) {
                this.lastNodeFound = treeNode;
                return true;
            }
            if (result > 0) {
                treeNode = treeNode.getLeft();
                continue;
            }
            treeNode = treeNode.getRight();
        }
        return false;
    }

    public final Comparable getMinKey() {
        RedBlackNode treeNode = this.rbTree;
        if (treeNode == null || treeNode == this._sentinelNode) {
            return null;
        }
        while (treeNode.getLeft() != this._sentinelNode) {
            treeNode = treeNode.getLeft();
        }
        this.lastNodeFound = treeNode;
        return treeNode.getKey();
    }

    public final Comparable getMaxKey() throws RedBlackException {
        RedBlackNode treeNode = this.rbTree;
        if (treeNode == null || treeNode == this._sentinelNode) {
            throw new RedBlackException("RedBlack tree is empty");
        }
        while (treeNode.getRight() != this._sentinelNode) {
            treeNode = treeNode.getRight();
        }
        this.lastNodeFound = treeNode;
        return treeNode.getKey();
    }

    public final RedBlackEnumerator GetEnumerator() {
        return this.Elements(true);
    }

    public final RedBlackEnumerator Keys() {
        return this.Keys(true);
    }

    public final RedBlackEnumerator Keys(boolean ascending) {
        return new RedBlackEnumerator(this.rbTree, ascending, this._sentinelNode);
    }

    public final RedBlackEnumerator Elements() {
        return this.Elements(true);
    }

    public final RedBlackEnumerator Elements(boolean ascending) {
        return new RedBlackEnumerator(this.rbTree, ascending, this._sentinelNode);
    }

    public final boolean getIsEmpty() {
        return this.rbTree == null;
    }

    public final void Remove(Object indexKey) throws RedBlackException {
        this.Remove(indexKey, null);
    }

    public final boolean Remove(Object cacheKey, Object node) {
        boolean isNodeRemoved = false;
        RedBlackNodeReference keyNodeReference = (RedBlackNodeReference)node;
        RedBlackNode keyNode = keyNodeReference.getRBReference();
        if (cacheKey != null && keyNode.getData().size() > 1) {
            if (keyNode.getData().containsKey(cacheKey)) {
                keyNode.getData().remove(cacheKey);
                isNodeRemoved = false;
            }
        } else {
            this.Delete(keyNode);
            isNodeRemoved = true;
        }
        if (isNodeRemoved) {
            --this.intCount;
        }
        return isNodeRemoved;
    }

    public final void Remove(Comparable indexKey, Object cacheKey) throws RedBlackException {
        RedBlackNode node;
        boolean isNodeRemoved = false;
        if (indexKey == null) {
            throw new RedBlackException("RedBlackNode key is null");
        }
        int result = indexKey instanceof String ? indexKey.toString().toLowerCase().compareTo(this.lastNodeFound.getKey().toString().toLowerCase()) : indexKey.compareTo(this.lastNodeFound.getKey());
        if (result == 0) {
            node = this.lastNodeFound;
        } else {
            node = this.rbTree;
            while (node != this._sentinelNode && (result = indexKey instanceof String ? indexKey.toString().toLowerCase().compareTo(node.getKey().toString().toLowerCase()) : indexKey.compareTo(node.getKey())) != 0) {
                if (result < 0) {
                    node = node.getLeft();
                    continue;
                }
                node = node.getRight();
            }
            if (node == this._sentinelNode) {
                return;
            }
        }
        try {
            if (cacheKey != null && node.getData().size() > 1) {
                if (node.getData().containsKey(cacheKey)) {
                    node.getData().remove(cacheKey);
                    isNodeRemoved = false;
                }
            } else {
                this.Delete(node);
                isNodeRemoved = true;
            }
        }
        catch (Exception e) {
            return;
        }
        if (isNodeRemoved) {
            --this.intCount;
        }
    }

    private void Delete(RedBlackNode z) {
        RedBlackNode y;
        RedBlackNode x = new RedBlackNode();
        if (z.getLeft() == this._sentinelNode || z.getRight() == this._sentinelNode) {
            y = z;
        } else {
            y = z.getRight();
            while (y.getLeft() != this._sentinelNode) {
                y = y.getLeft();
            }
        }
        x = y.getLeft() != this._sentinelNode ? y.getLeft() : y.getRight();
        x.setParent(y.getParent());
        if (y.getParent() != null) {
            if (y == y.getParent().getLeft()) {
                y.getParent().setLeft(x);
            } else {
                y.getParent().setRight(x);
            }
        } else {
            this.rbTree = x;
        }
        if (y != z) {
            z.setKey(y.getKey());
            z.setData(y.getData());
            z.setRBNodeReference(y.getRBNodeReference());
            z.getRBNodeReference().setRBReference(z);
        }
        if (y.getColor() == 1) {
            this.RestoreAfterDelete(x);
        }
        this.lastNodeFound = this._sentinelNode;
    }

    private void RestoreAfterDelete(RedBlackNode x) {
        while (x != this.rbTree && x.getColor() == 1) {
            RedBlackNode y;
            if (x == x.getParent().getLeft()) {
                y = x.getParent().getRight();
                if (y.getColor() == 0) {
                    y.setColor(1);
                    x.getParent().setColor(0);
                    this.RotateLeft(x.getParent());
                    y = x.getParent().getRight();
                }
                if (y.getLeft().getColor() == 1 && y.getRight().getColor() == 1) {
                    y.setColor(0);
                    x = x.getParent();
                    continue;
                }
                if (y.getRight().getColor() == 1) {
                    y.getLeft().setColor(1);
                    y.setColor(0);
                    this.RotateRight(y);
                    y = x.getParent().getRight();
                }
                y.setColor(x.getParent().getColor());
                x.getParent().setColor(1);
                y.getRight().setColor(1);
                this.RotateLeft(x.getParent());
                x = this.rbTree;
                continue;
            }
            y = x.getParent().getLeft();
            if (y.getColor() == 0) {
                y.setColor(1);
                x.getParent().setColor(0);
                this.RotateRight(x.getParent());
                y = x.getParent().getLeft();
            }
            if (y.getRight().getColor() == 1 && y.getLeft().getColor() == 1) {
                y.setColor(0);
                x = x.getParent();
                continue;
            }
            if (y.getLeft().getColor() == 1) {
                y.getRight().setColor(1);
                y.setColor(0);
                this.RotateLeft(y);
                y = x.getParent().getLeft();
            }
            y.setColor(x.getParent().getColor());
            x.getParent().setColor(1);
            y.getLeft().setColor(1);
            this.RotateRight(x.getParent());
            x = this.rbTree;
        }
        x.setColor(1);
    }

    public final void RemoveMin() throws RedBlackException {
        if (this.rbTree == null) {
            throw new RedBlackException("RedBlackNode is null");
        }
        this.Remove(this.getMinKey());
    }

    public final void RemoveMax() throws RedBlackException {
        if (this.rbTree == null) {
            throw new RedBlackException("RedBlackNode is null");
        }
        this.Remove(this.getMaxKey());
    }

    public final void Clear() {
        this.rbTree = this._sentinelNode;
        this.intCount = 0;
    }

    public final int getSize() {
        return this.intCount;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedBlackNode)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.toString().equals(((RedBlackNode)obj).toString());
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "";
    }

    public static enum COMPARE {
        EQ,
        NE,
        LT,
        GT,
        LTEQ,
        GTEQ,
        REGEX,
        IREGEX;


        public static COMPARE forValue(int value) {
            return COMPARE.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

