/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

import Alachisoft.NCache.Common.SearchAlgorithms.BinarySearch;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SortedList<V>
implements List<V> {
    Comparator comp;
    LinkedList<V> _linkList = new LinkedList();

    public SortedList(Comparator comp) {
        if (comp == null) {
            throw new NullPointerException("Comparator cannot be null");
        }
        this.comp = comp;
    }

    @Override
    public int size() {
        return this._linkList.size();
    }

    @Override
    public boolean isEmpty() {
        return this._linkList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return BinarySearch.searchItem(this._linkList, o, this.comp) >= 0;
    }

    @Override
    public Iterator<V> iterator() {
        return this._linkList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this._linkList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this._linkList.toArray(ts);
    }

    @Override
    public boolean add(V e) {
        BinarySearch.insertItem(this._linkList, e, this.comp);
        return true;
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        int pos = BinarySearch.searchItem(this._linkList, o, this.comp);
        if (pos >= 0) {
            this.remove(pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        for (Object object : clctn) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> clctn) {
        for (V pair : clctn) {
            this.add(pair);
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean addAll(int i, Collection<? extends V> clctn) {
        throw new UnsupportedOperationException("Not possible to force sort the array");
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        for (Object pair : clctn) {
            this.remove(pair);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> clctn) {
        return this._linkList.retainAll(clctn);
    }

    @Override
    public void clear() {
        this._linkList.clear();
    }

    @Override
    public V get(int i) {
        return this._linkList.get(i);
    }

    @Override
    @Deprecated
    public V set(int i, V e) {
        throw new UnsupportedOperationException("Not possible to force sort the array");
    }

    @Override
    @Deprecated
    public void add(int i, V e) {
        throw new UnsupportedOperationException("Not possible to force sort the array");
    }

    @Override
    public V remove(int i) {
        return this._linkList.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this._linkList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return BinarySearch.searchItem(this._linkList, o, this.comp);
    }

    @Override
    public ListIterator<V> listIterator() {
        return this._linkList.listIterator();
    }

    @Override
    public ListIterator<V> listIterator(int i) {
        return this._linkList.listIterator(i);
    }

    @Override
    public List<V> subList(int i, int i1) {
        return this._linkList.subList(i1, i1);
    }
}

