/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.DataStructures;

public class VirtualIndex
implements Comparable {
    private static final int maxSize = 80896;
    private int x;
    private int y;

    public VirtualIndex() {
    }

    public VirtualIndex(int index) {
        this.IncrementBy(index);
    }

    public final void Increment() {
        ++this.x;
        if (this.x == 80896) {
            this.x = 0;
            ++this.y;
        }
    }

    public final void IncrementBy(int count) {
        int number = this.y * 80896 + this.x + count;
        this.x = number % 80896;
        this.y = number / 80896;
    }

    public final int getXIndex() {
        return this.x;
    }

    public final int getYIndex() {
        return this.y;
    }

    public final int getIndexValue() {
        return this.y * 80896 + this.x;
    }

    public final VirtualIndex clone() {
        VirtualIndex clone = new VirtualIndex();
        clone.x = this.x;
        clone.y = this.y;
        return clone;
    }

    public final int compareTo(Object obj) {
        VirtualIndex other = null;
        if (obj instanceof VirtualIndex) {
            other = (VirtualIndex)(obj instanceof VirtualIndex ? obj : null);
        } else if (obj instanceof Integer) {
            other = new VirtualIndex((Integer)obj);
        } else {
            return -1;
        }
        if (other.getIndexValue() == this.getIndexValue()) {
            return 0;
        }
        if (other.getIndexValue() > this.getIndexValue()) {
            return -1;
        }
        return 1;
    }
}

