/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Event;

import Alachisoft.NCache.Common.Event.EventFire;
import Alachisoft.NCache.Common.Event.NEventEnd;
import Alachisoft.NCache.Common.Event.NEventStart;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class NEvent {
    private Map<NEventStart, NEventEnd> _eventListners = Collections.synchronizedMap(new HashMap());
    private List<NEventStart> _eventListnersSync = Collections.synchronizedList(new ArrayList());
    private int _count;
    private ILogger _ncacheLogger;
    private String _name = "";
    private boolean _isSync;

    public NEvent(String name, ILogger _ncacheLogger) {
        this._name = name;
        this._ncacheLogger = _ncacheLogger;
    }

    public static void beginInvoke(NEventStart start, NEventEnd end, ILogger ncacheLogger, boolean removeSubscriberOnException, NEvent source, Object ... obj) {
        EventFire even = new EventFire(start, end, ncacheLogger, source, obj);
        even.setRemoveSubscriberOnException(removeSubscriberOnException);
        Thread thread = new Thread((Runnable)even, "EventFire beginInvoke");
        thread.setDaemon(true);
        thread.start();
    }

    public int getCount() {
        return this._count;
    }

    public String getName() {
        return this._name;
    }

    public boolean getIsSync() {
        return this._isSync;
    }

    public synchronized void addNEventListners(NEventStart start, NEventEnd end) throws IllegalArgumentException {
        if (start == null) {
            throw new IllegalArgumentException("Event Function 'start' cannot be null");
        }
        this._eventListners.put(start, end);
        this._eventListnersSync.add(start);
        ++this._count;
    }

    public synchronized void removeNEventListners(NEventStart start) throws IllegalArgumentException {
        if (start == null) {
            throw new IllegalArgumentException("Event Function 'start' cannot be null");
        }
        this._eventListners.remove(start);
        this._eventListnersSync.remove(start);
        --this._count;
    }

    public synchronized void unsubscribeAllListners() {
        this._eventListners.clear();
        this._eventListnersSync.clear();
        this._count = 0;
    }

    @Deprecated
    public synchronized void addNEventListnersSync(NEventStart start, NEventEnd end) throws IllegalArgumentException {
        this.addNEventListners(start, end);
    }

    @Deprecated
    public synchronized void removeNEventListnersSync(NEventStart start) throws IllegalArgumentException {
        if (start == null && this._eventListnersSync.size() > 0) {
            start = this._eventListnersSync.get(this._eventListnersSync.size() - 1);
        }
        this.removeNEventListners(start);
    }

    @Deprecated
    public synchronized void unsubscribeAllSyncListners() {
        this.unsubscribeAllListners();
    }

    public synchronized void fireEvents(boolean removeSubscriberOnException, Object ... obj) {
        EventFire[] eventFire = new EventFire[this._count];
        Iterator<Map.Entry<NEventStart, NEventEnd>> ide = this._eventListners.entrySet().iterator();
        for (int i = 0; i < this._count; ++i) {
            Map.Entry<NEventStart, NEventEnd> pair = ide.next();
            eventFire[i] = new EventFire(pair.getKey(), pair.getValue(), this._ncacheLogger, this, obj);
            eventFire[i].setRemoveSubscriberOnException(removeSubscriberOnException);
            ThreadPool.getInstance().executeTask(eventFire[i]);
        }
    }

    public synchronized Object fireEventsSynchronous(boolean removeSubscriberOnException, Object ... obj) {
        Object val = null;
        for (NEventStart start : this._eventListnersSync) {
            try {
                val = start.hanleEvent(obj);
            }
            catch (SocketException e) {
                if (this._ncacheLogger != null) {
                    this._ncacheLogger.Error("FireEvent.run.caller: " + this._name, "Event# " + Thread.currentThread().getName() + "with Exception: \t" + e.getMessage());
                }
                if (!removeSubscriberOnException) continue;
                this.removeNEventListnersSync(start);
            }
            catch (Exception e) {
                if (this._ncacheLogger == null) continue;
                this._ncacheLogger.Error("FireEvent.run.caller: " + this._name, "Event# " + Thread.currentThread().getName() + "with Exception: \t" + e.getMessage());
            }
        }
        return val;
    }

    public synchronized HashMap<NEventStart, NEventEnd> getInvocationList() {
        return new HashMap<NEventStart, NEventEnd>(this._eventListners);
    }
}

