/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Locking;

import Alachisoft.NCache.Common.Locking.LockMode;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectInput;
import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import tangible.DotNetToJavaStringHelper;

public class LockManager
implements ICompactSerializable {
    private ArrayList<LockHandle> _readerLocks = new ArrayList();
    private LockHandle _writerLock;
    private LockMode _lockMode = LockMode.None;

    private String GenerateLockId() {
        return UUID.randomUUID().toString() + new NCDateTime(Calendar.getInstance().getTimeInMillis()).getTicks();
    }

    public final LockMode getMode() {
        return this._lockMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean AcquireReaderLock(String lockHandle) {
        LockManager lockManager = this;
        synchronized (lockManager) {
            if (this._lockMode == LockMode.None || this._lockMode == LockMode.Reader) {
                this._readerLocks.add(new LockHandle(lockHandle));
                this._lockMode = LockMode.Reader;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ReleaseReaderLock(String lockId) {
        if (lockId == null) {
            return;
        }
        LockManager lockManager = this;
        synchronized (lockManager) {
            if (this._lockMode == LockMode.Reader && this._readerLocks.contains(new LockHandle(lockId))) {
                this._readerLocks.remove(new LockHandle(lockId));
                if (this._readerLocks.isEmpty()) {
                    this._lockMode = LockMode.None;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean AcquireWriterLock(String lockHandle) {
        LockManager lockManager = this;
        synchronized (lockManager) {
            if (this._lockMode == LockMode.None) {
                this._writerLock = new LockHandle(lockHandle);
                this._lockMode = LockMode.Write;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ReleaseWriterLock(String lockId) {
        LockManager lockManager = this;
        synchronized (lockManager) {
            if (this._lockMode == LockMode.Write && this._writerLock.equals(lockId)) {
                this._writerLock = null;
                this._lockMode = LockMode.None;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean ValidateLock(LockMode mode, String lockId) {
        if (lockId == null && mode != LockMode.None) {
            return false;
        }
        LockManager lockManager = this;
        synchronized (lockManager) {
            switch (mode) {
                case Reader: {
                    return this._readerLocks.contains(new LockHandle(lockId));
                }
                case Write: {
                    return this._writerLock.equals(lockId);
                }
                case None: {
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean ValidateLock(String lockId) {
        return this.ValidateLock(this._lockMode, lockId);
    }

    public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
        this._lockMode = LockMode.forValue(reader.readByte());
        Object tempVar = reader.readObject();
        String writerLockId = (String)(tempVar instanceof String ? tempVar : null);
        if (!DotNetToJavaStringHelper.isNullOrEmpty(writerLockId)) {
            this._writerLock = new LockHandle(writerLockId);
        }
        int readLockCount = reader.readInt();
        this._readerLocks = new ArrayList();
        Object tempVar2 = null;
        for (int i = 0; i < readLockCount; ++i) {
            tempVar2 = reader.readObject();
            this._readerLocks.add(new LockHandle((String)(tempVar2 instanceof String ? tempVar2 : null)));
        }
    }

    public final void serialize(NCacheObjectOutput writer) throws IOException {
        writer.write((int)((byte)this._lockMode.getValue()));
        if (this._writerLock != null) {
            writer.writeObject((Object)this._writerLock.getLockId());
        } else {
            writer.writeObject(null);
        }
        writer.writeInt(this._readerLocks.size());
        for (LockHandle handle : this._readerLocks) {
            writer.writeObject((Object)handle.getLockId());
        }
    }

    private static class LockHandle
    implements ICompactSerializable {
        private String _lockId;
        private Date _lockTime = new Date(0L);

        public LockHandle(String lockId) {
            this._lockId = lockId;
            this._lockTime = new Date();
        }

        public final String getLockId() {
            return this._lockId;
        }

        public final Date getLockTime() {
            return this._lockTime;
        }

        public boolean equals(Object obj) {
            LockHandle other = (LockHandle)(obj instanceof LockHandle ? obj : null);
            if (other != null && other._lockId.equals(this._lockId)) {
                return true;
            }
            if (obj instanceof String) {
                return this._lockId.equals((String)obj);
            }
            return false;
        }

        public final void deserialize(NCacheObjectInput reader) throws ClassNotFoundException, IOException {
            Object tempVar = reader.readObject();
            this._lockId = (String)(tempVar instanceof String ? tempVar : null);
        }

        public final void serialize(NCacheObjectOutput writer) throws IOException {
            writer.writeObject((Object)this._lockId);
        }
    }
}

