/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Logger;

import Alachisoft.NCache.Common.DataStructures.BridgeOperation;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Logger.JLogger;
import Alachisoft.NCache.Common.Logger.LoggerNames;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tangible.DotNetToJavaStringHelper;

public class BridgeActivityMonitorHandler
implements Runnable {
    private String _monitorName;
    private HashMap _bridgeActivityHistory = new HashMap();
    private ILogger _monitorLogger = null;
    private Thread _writerThread;
    private boolean _isThreadStopped = true;

    public final String getMonitorName() {
        return this._monitorName;
    }

    public final void setMonitorName(String value) {
        this._monitorName = value;
    }

    public final void NodeActivity(String key, BridgeOperation operation) {
        Activity activity = this.PopulateKeyActivity(operation.getOpCode().toString(), operation.getBridgeOpTimeStamp().toString(), operation.getIsStateTransferOperation()).clone();
        this.Add(key, activity.clone());
    }

    public final void StartActivity() {
        this._monitorLogger = new JLogger();
        try {
            this._monitorLogger.Initialize(LoggerNames.BridgeActivityLog, this._monitorName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._writerThread = new Thread(new Thread(this));
        this._writerThread.setDaemon(true);
        this._writerThread.setName("BridgeActivityMonitor." + this._monitorName);
        this._writerThread.start();
    }

    public final void StopActivity() {
        this._isThreadStopped = false;
        if (this._writerThread.isAlive()) {
            this._writerThread.stop();
            this._writerThread = null;
        }
    }

    private Activity PopulateKeyActivity(String operation, String timeStamp, boolean isStateTransfer) {
        Activity activity = new Activity();
        activity.operation = operation;
        activity.timestamp = timeStamp;
        activity.isStateTransfer = isStateTransfer;
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Add(String key, Activity activity) {
        ArrayList operationList = null;
        BridgeActivityMonitorHandler bridgeActivityMonitorHandler = this;
        synchronized (bridgeActivityMonitorHandler) {
            if (!this._bridgeActivityHistory.containsKey(key)) {
                operationList = new ArrayList();
                operationList.add(activity.clone());
                this._bridgeActivityHistory.put(key, operationList);
            } else {
                operationList = this._bridgeActivityHistory.get(key) instanceof ArrayList ? this._bridgeActivityHistory.get(key) : null;
                if (operationList != null) {
                    operationList.add(activity.clone());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long sleepTime = 30000L;
        while (this._isThreadStopped) {
            if (this._monitorLogger != null) {
                StringBuilder sb = new StringBuilder();
                HashMap oldTable = this._bridgeActivityHistory;
                BridgeActivityMonitorHandler bridgeActivityMonitorHandler = this;
                synchronized (bridgeActivityMonitorHandler) {
                    this._bridgeActivityHistory = new HashMap();
                }
                Iterator ide = oldTable.entrySet().iterator();
                this._monitorLogger.Info("Start Logging");
                while (ide.hasNext()) {
                    Map.Entry pairs = ide.next();
                    ArrayList operationArray = pairs.getValue() instanceof ArrayList ? pairs.getValue() : null;
                    sb.append(" " + pairs.getKey() + " ");
                    for (int i = 0; i < operationArray.size(); ++i) {
                        sb.append(operationArray.get(i).toString() + "--- ");
                    }
                    sb.append("\n");
                }
                if (!DotNetToJavaStringHelper.isNullOrEmpty(sb.toString())) {
                    this._monitorLogger.Info(sb.toString());
                    oldTable.clear();
                    sb.delete(0, sb.length());
                }
                this._monitorLogger.Info("End Logging");
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static final class Activity {
        public String operation;
        public String timestamp;
        public boolean isStateTransfer;

        private Activity() {
        }

        public String toString() {
            return "(" + this.operation + " ; " + this.timestamp + " ; " + this.isStateTransfer + ")";
        }

        public Activity clone() {
            Activity varCopy = new Activity();
            varCopy.operation = this.operation;
            varCopy.timestamp = this.timestamp;
            varCopy.isStateTransfer = this.isStateTransfer;
            return varCopy;
        }
    }
}

