/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Logger;

import Alachisoft.NCache.Common.DataStructures.BridgeOperation;
import Alachisoft.NCache.Common.Logger.ILogger;
import java.util.HashMap;

public class InMemoryLogger
implements Runnable {
    private static HashMap<String, InMemoryLogger> _inMemoryLoggers = new HashMap();
    private HashMap hashMap;
    private int _addCount = 0;
    private int _updateCount = 0;
    private String _cacheName;
    private Thread _writerThread = null;
    private boolean _isThreadStopped = true;
    private String _loggerType;
    private int _threadWaitInterval = 120000;
    private ILogger _nCachelogger;
    private Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InMemoryLogger GetLogger(String srcCache, String LoggerType, ILogger NCacheLog) {
        InMemoryLogger logger = null;
        HashMap<String, InMemoryLogger> hashMap = _inMemoryLoggers;
        synchronized (hashMap) {
            if (_inMemoryLoggers.containsKey(srcCache)) {
                logger = _inMemoryLoggers.get(srcCache);
            } else {
                logger = new InMemoryLogger();
                logger.Initialize(srcCache, LoggerType, NCacheLog);
                _inMemoryLoggers.put(srcCache, logger);
            }
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Add(String key, BridgeOperation operation) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.hashMap.containsKey(key)) {
                this.hashMap.put(key, operation);
                ++this._updateCount;
            } else {
                this.hashMap.put(key, operation);
                ++this._addCount;
            }
        }
    }

    public final void Initialize(String targetId, String LoggerType, ILogger ncachelogger) {
        this.hashMap = new HashMap();
        this._cacheName = targetId;
        this._loggerType = LoggerType;
        this._nCachelogger = ncachelogger;
        this.Start();
    }

    public final void Start() {
        this._writerThread = new Thread(new Thread(this));
        this._writerThread.setDaemon(true);
        this._writerThread.setName("InMemoryLogger." + this._cacheName + "." + this._loggerType);
        this._writerThread.start();
    }

    @Override
    public void run() {
        try {
            while (this._isThreadStopped) {
                Thread.sleep(this._threadWaitInterval);
                String msg = " ::: Add = " + this._addCount + "  ---- Update = " + this._updateCount + " ::: ";
                this._nCachelogger.DevTrace(msg);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void Stop() {
        this._isThreadStopped = false;
        if (this._writerThread.isAlive()) {
            this._writerThread.stop();
            this._writerThread = null;
        }
        this._addCount = 0;
        this._updateCount = 0;
    }
}

