/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Monitoring;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Monitoring.CacheNodeStatus;
import Alachisoft.NCache.Common.Monitoring.ServerNode;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;

public class CacheNodeStatistics
implements InternalCompactSerializable {
    private ServerNode _node;
    private long _itemCount;
    private long _dataSize;
    private short _clientsConnected;
    private long _totalCacheSize;
    private CacheNodeStatus _nodeStatus = CacheNodeStatus.Stopped;

    public CacheNodeStatistics() {
    }

    public CacheNodeStatistics(ServerNode node) {
        this._node = node;
    }

    public final CacheNodeStatus getStatus() {
        return this._nodeStatus;
    }

    public final void setStatus(CacheNodeStatus value) {
        this._nodeStatus = value;
    }

    public final long getItemCount() {
        return this._itemCount;
    }

    public final void setItemCount(long value) {
        this._itemCount = value;
    }

    public final long getDataSize() {
        return this._dataSize;
    }

    public final void setDataSize(long value) {
        this._dataSize = value;
    }

    public final long getTotalCacheSize() {
        return this._totalCacheSize;
    }

    public final void setTotalCacheSize(long value) {
        this._totalCacheSize = value;
    }

    public final short getClientCount() {
        return this._clientsConnected;
    }

    public final void setClientCount(short value) {
        this._clientsConnected = value;
    }

    public final ServerNode getNode() {
        return this._node;
    }

    public final void setNode(ServerNode value) {
        this._node = value;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._node = (ServerNode)Common.readAs(reader.ReadObject(), ServerNode.class);
        this._itemCount = reader.ReadInt64();
        this._dataSize = reader.ReadInt64();
        this._clientsConnected = Integer.valueOf(reader.ReadUInt16()).shortValue();
        this._totalCacheSize = reader.ReadInt64();
        this._nodeStatus = CacheNodeStatus.forValue(reader.ReadInt32());
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this._node);
        writer.Write(this._itemCount);
        writer.Write(this._dataSize);
        writer.Write(this._clientsConnected);
        writer.Write(this._totalCacheSize);
        writer.Write(this._nodeStatus.getValue());
    }
}

