/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Monitoring;

import Alachisoft.NCache.Common.Monitoring.ClienfInfo;
import Alachisoft.NCache.Common.Monitoring.ClientMonitor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ServerMonitor {
    private static boolean _monitor;
    private static HashMap _clientActivity;
    private static HashMap _threadClientMap;
    private static HashMap _dataStructures;
    private static HashMap _dedicatedThreadsActivity;
    private static Date _startTime;
    private static Date _endTime;
    private static Object _sync;

    public static Date getStartTime() {
        return _startTime;
    }

    public static Date getEndTime() {
        return _endTime;
    }

    public static boolean getMonitorActivity() {
        return _monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StartMonitoring() {
        Object object = _sync;
        synchronized (object) {
            if (_monitor) {
                return;
            }
            _monitor = true;
            _startTime = new Date();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StopMonitoring() {
        Object object = _sync;
        synchronized (object) {
            if (_monitor) {
                _monitor = false;
                _endTime = new Date();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RegisterClient(String clientID, String address) {
        if (clientID == null) {
            return;
        }
        HashMap hashMap = _clientActivity;
        synchronized (hashMap) {
            if (!_clientActivity.containsKey(clientID)) {
                ClientMonitor clientActivity = new ClientMonitor(clientID, address);
                _clientActivity.put(clientID, clientActivity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UnregisterClient(String clientId) {
        if (clientId == null) {
            return;
        }
        HashMap hashMap = _clientActivity;
        synchronized (hashMap) {
            if (_clientActivity.containsKey(clientId)) {
                _clientActivity.remove(clientId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StartClientActivity(String clientId) {
        if (clientId == null) {
            return;
        }
        if (_monitor) {
            ClientMonitor cMonitor = _clientActivity.get(clientId) instanceof ClientMonitor ? _clientActivity.get(clientId) : null;
            if (cMonitor != null) {
                cMonitor.StartActivity();
            }
            long tId = Thread.currentThread().getId();
            HashMap hashMap = _threadClientMap;
            synchronized (hashMap) {
                _threadClientMap.put(tId, cMonitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void StopClientActivity(String clientId) {
        if (_monitor) {
            ClientMonitor cMonitor = _clientActivity.get(clientId) instanceof ClientMonitor ? _clientActivity.get(clientId) : null;
            if (cMonitor != null) {
                cMonitor.StopActivity();
            }
            long tId = Thread.currentThread().getId();
            HashMap hashMap = _threadClientMap;
            synchronized (hashMap) {
                _threadClientMap.remove(tId);
            }
        }
    }

    public static void LogClientActivity(String method, String activity) {
        ClientMonitor cMonitor;
        if (_monitor && (cMonitor = (ClientMonitor)(_threadClientMap.get(Thread.currentThread().getId()) instanceof ClientMonitor ? _threadClientMap.get(Thread.currentThread().getId()) : null)) != null) {
            cMonitor.LogActivity(method, activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap GetCompletedClientActivity() {
        HashMap<ClienfInfo, ArrayList> activityTable = new HashMap<ClienfInfo, ArrayList>();
        HashMap hashMap = _clientActivity;
        synchronized (hashMap) {
            for (Map.Entry pair : _clientActivity.entrySet()) {
                ClientMonitor cMonitor = pair.getValue() instanceof ClientMonitor ? pair.getValue() : null;
                activityTable.put(cMonitor.getInfo(), cMonitor.GetCompletedClientActivities());
            }
        }
        return activityTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap GetCurrentClientActivity() throws CloneNotSupportedException {
        HashMap<ClienfInfo, ArrayList> activityTable = new HashMap<ClienfInfo, ArrayList>();
        HashMap hashMap = _clientActivity;
        synchronized (hashMap) {
            for (Map.Entry pair : _clientActivity.entrySet()) {
                ClientMonitor cMonitor = pair.getValue() instanceof ClientMonitor ? pair.getValue() : null;
                activityTable.put(cMonitor.getInfo(), cMonitor.GetCurrentClientActivities());
            }
        }
        return activityTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Reset() {
        HashMap hashMap;
        if (_clientActivity != null) {
            hashMap = _clientActivity;
            synchronized (hashMap) {
                _clientActivity.clear();
            }
        }
        if (_dedicatedThreadsActivity != null) {
            hashMap = _dedicatedThreadsActivity;
            synchronized (hashMap) {
                _dedicatedThreadsActivity.clear();
            }
        }
    }

    static {
        _clientActivity = new HashMap();
        _threadClientMap = new HashMap();
        _dataStructures = new HashMap();
        _dedicatedThreadsActivity = new HashMap();
        _startTime = new Date(0L);
        _endTime = new Date(0L);
        _sync = new Object();
    }
}

