/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Net;

import com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters.SystemCounter;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class NetworkData {
    static Map<String, Long> rxCurrentMap = new HashMap<String, Long>();
    static Map<String, List<Long>> rxChangeMap = new HashMap<String, List<Long>>();
    static Map<String, Long> txCurrentMap = new HashMap<String, Long>();
    static Map<String, List<Long>> txChangeMap = new HashMap<String, List<Long>>();
    private static Map<String, String> filteredIP = new HashMap<String, String>();
    private static Map<String, Integer> filteredSpeed = new HashMap<String, Integer>();
    private static boolean enabled = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerIPToMonitor(String ip) {
        if (SystemCounter.getSigar() == null) {
            return;
        }
        if (ip != null && !ip.isEmpty() && enabled) {
            try {
                for (String ni : SystemCounter.getSigar().getNetInterfaceList()) {
                    NetInterfaceConfig ifConfig = null;
                    try {
                        ifConfig = SystemCounter.getSigar().getNetInterfaceConfig(ni);
                    }
                    catch (SigarException ex) {
                        Logger.getLogger(NetworkData.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (ip == null || !ip.equals(ifConfig.getAddress())) continue;
                    Map<String, String> map = filteredIP;
                    synchronized (map) {
                        if (!filteredIP.containsKey(ip)) {
                            filteredIP.put(ip, ni);
                        }
                    }
                }
            }
            catch (Throwable exc) {
                enabled = false;
            }
        }
    }

    public static double getNetworkUsage() throws SigarException {
        if (SystemCounter.getSigar() == null) {
            return 0.0;
        }
        double speed = 1.0;
        double totalUsage = -1.0;
        for (String ni : filteredIP.values()) {
            NetInterfaceStat netStat = SystemCounter.getSigar().getNetInterfaceStat(ni);
            NetInterfaceConfig ifConfig = SystemCounter.getSigar().getNetInterfaceConfig(ni);
            String hwaddr = null;
            speed = netStat.getSpeed();
            if (speed == -1.0) {
                if (!filteredSpeed.containsKey(ni)) {
                    filteredSpeed.put(ni, NetworkData.getNICLinuxSpeed());
                }
                speed = filteredSpeed.get(ni).intValue();
            }
            if (!"00:00:00:00:00:00".equals(ifConfig.getHwaddr())) {
                hwaddr = ifConfig.getHwaddr();
            }
            if (hwaddr == null) continue;
            double rxCurrenttmp = netStat.getRxBytes();
            NetworkData.saveChange(rxCurrentMap, rxChangeMap, hwaddr, (long)rxCurrenttmp, ni);
            double txCurrenttmp = netStat.getTxBytes();
            NetworkData.saveChange(txCurrentMap, txChangeMap, hwaddr, (long)txCurrenttmp, ni);
            long totalrxDown = NetworkData.getMetricData(rxChangeMap);
            long totaltxUp = NetworkData.getMetricData(txChangeMap);
            for (List<Long> l : rxChangeMap.values()) {
                l.clear();
            }
            for (List<Long> l : txChangeMap.values()) {
                l.clear();
            }
            Sigar.formatSize((long)totaltxUp);
            double usageForCurrentNIC = 0.0;
            usageForCurrentNIC = speed != 0.0 ? (double)((totalrxDown + totaltxUp) * 8L) / speed * 100.0 : 0.0;
            if (totalUsage == -1.0) {
                totalUsage = usageForCurrentNIC;
                continue;
            }
            totalUsage = (totalUsage + usageForCurrentNIC) / 2.0;
        }
        if (totalUsage == -1.0) {
            totalUsage = 0.0;
        }
        if (totalUsage > 100.0) {
            totalUsage = 100.0;
        }
        return totalUsage;
    }

    public static int getNICLinuxSpeed() {
        try {
            int c;
            String[] cmd = new String[]{"/bin/sh", "-c", "ethtool em1 2>/dev/null | grep Speed"};
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
            StringBuffer buffer = new StringBuffer();
            while ((c = ((InputStream)stdoutStream).read()) != -1) {
                buffer.append((char)c);
            }
            String outputText = buffer.toString();
            ((InputStream)stdoutStream).close();
            outputText = outputText.split(":")[1];
            String number = outputText.replaceAll("[^0-9]", "");
            String rate = outputText.trim().replace(number, "");
            char metric = rate.charAt(0);
            int mult = 1;
            if (metric == 'M') {
                mult = 1000000;
            } else if (metric == 'G') {
                mult = 1000000000;
            } else if (metric == 'T') {
                mult = -727379968;
            }
            return Integer.parseInt(number) * mult;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static String getDefaultGateway() throws SigarException {
        if (SystemCounter.getSigar() == null) {
            return "";
        }
        return SystemCounter.getSigar().getNetInfo().getDefaultGateway();
    }

    private static long getMetricData(Map<String, List<Long>> rxChangeMap) {
        long total = 0L;
        for (Map.Entry<String, List<Long>> entry : rxChangeMap.entrySet()) {
            int average = 0;
            for (Long l : entry.getValue()) {
                average = (int)((long)average + l);
            }
            total += (long)(average / entry.getValue().size());
        }
        return total;
    }

    private static void saveChange(Map<String, Long> currentMap, Map<String, List<Long>> changeMap, String hwaddr, long current, String ni) {
        Long oldCurrent = currentMap.get(ni);
        if (oldCurrent != null) {
            List<Long> list = changeMap.get(hwaddr);
            if (list == null) {
                list = new LinkedList<Long>();
                changeMap.put(hwaddr, list);
            }
            list.add(current - oldCurrent);
        }
        currentMap.put(ni, current);
    }
}

