/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Net;

import Alachisoft.NCache.Common.Net.IRentableObject;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ObjectProvider {
    protected int _initialSize = 30;
    protected Class _objectType;
    private HashMap _available = new HashMap();
    private HashMap _rented = new HashMap();
    private ArrayList _availableRentIds = new ArrayList();
    private Object _sync = new Object();
    private int _rentid = 1;
    private ArrayList list = new ArrayList();

    public ObjectProvider() {
        this.Initialize();
    }

    public ObjectProvider(int initialSize) {
        this._initialSize = initialSize;
        this.Initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Initialize() {
        IRentableObject obj = null;
        Object object = this._sync;
        synchronized (object) {
            for (int i = 0; i < this._initialSize; ++i) {
                obj = this.CreateObject();
                if (obj == null) continue;
                this.ResetObject(obj);
                this.list.add(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRentableObject RentAnObject() {
        IRentableObject obj = null;
        Object object = this._sync;
        synchronized (object) {
            if (this._available.size() > 0) {
                obj = (IRentableObject)this._available.get(this._availableRentIds.get(0));
                this._available.remove(obj.getRentId());
                this._availableRentIds.remove(obj.getRentId());
                this._rented.put(obj.getRentId(), obj);
            } else {
                obj = this.CreateObject();
                obj.setRentId(this._rentid++);
                if (obj != null) {
                    this._rented.put(obj.getRentId(), obj);
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void SubmittObject(IRentableObject obj) {
        Object object = this._sync;
        synchronized (object) {
            if (this._rented.containsKey(obj.getRentId())) {
                this._rented.remove(obj.getRentId());
                this.ResetObject(obj);
                this._available.put(obj.getRentId(), obj);
                this._availableRentIds.add(obj.getRentId());
            }
        }
    }

    protected abstract IRentableObject CreateObject();

    protected abstract void ResetObject(Object var1);

    public abstract Class getObjectType();

    public abstract String getName();

    public final int getTotalObjects() {
        return this._rented.size() + this._available.size();
    }

    public final int getAvailableCount() {
        return this._available.size();
    }

    public final int getRentCount() {
        return this._rented.size();
    }

    public final int getInitialSize() {
        return this._initialSize;
    }

    public final void setInitialSize(int value) {
        this._initialSize = value;
    }
}

