/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common;

import Alachisoft.NCache.Common.IDisposable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public class ResourcePool
implements IDisposable {
    private HashMap resourceTable = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            for (ResourceInfo resourceInfo : this.resourceTable.entrySet()) {
                this.DisposeResource(resourceInfo.getObject());
            }
        }
    }

    public final Collection getKeys() {
        return this.resourceTable.keySet();
    }

    public final int getCount() {
        return this.resourceTable.size();
    }

    public final Object GetResource(Object key) {
        ResourceInfo resourceInfo = this.resourceTable.get(key) instanceof ResourceInfo ? this.resourceTable.get(key) : null;
        if (resourceInfo != null) {
            return resourceInfo.getObject();
        }
        return null;
    }

    public final void AddResource(Object key, Object value) {
        ResourceInfo resourceInfo = this.resourceTable.get(key) instanceof ResourceInfo ? this.resourceTable.get(key) : null;
        if (resourceInfo != null) {
            if (value != null) {
                resourceInfo.setObject(value);
            }
        } else {
            resourceInfo = new ResourceInfo(value);
        }
        this.resourceTable.put(key, resourceInfo);
        resourceInfo.AddRef();
    }

    public final void AddResource(Object key, Object value, int numberOfCallbacks) {
        ResourceInfo resourceInfo = this.resourceTable.get(key) instanceof ResourceInfo ? this.resourceTable.get(key) : null;
        if (resourceInfo != null) {
            if (value != null) {
                resourceInfo.setObject(value);
            }
        } else {
            resourceInfo = new ResourceInfo(value);
        }
        this.resourceTable.put(key, resourceInfo);
        for (int i = 0; i < numberOfCallbacks; ++i) {
            resourceInfo.AddRef();
        }
    }

    public final Object RemoveResource(Object key) {
        ResourceInfo resourceInfo = this.resourceTable.get(key) instanceof ResourceInfo ? this.resourceTable.get(key) : null;
        if (resourceInfo != null) {
            if (resourceInfo.Release() == 0) {
                this.resourceTable.remove(key);
                this.DisposeResource(resourceInfo.getObject());
            }
            return resourceInfo.getObject();
        }
        return null;
    }

    public final Object RemoveResource(Object key, int numberOfCallbacks) {
        ResourceInfo resourceInfo = this.resourceTable.get(key) instanceof ResourceInfo ? this.resourceTable.get(key) : null;
        if (resourceInfo != null) {
            for (int i = 0; i < numberOfCallbacks; ++i) {
                if (resourceInfo.Release() != 0) continue;
                this.resourceTable.remove(key);
                this.DisposeResource(resourceInfo.getObject());
            }
            return resourceInfo.getObject();
        }
        return null;
    }

    public final void RemoveSeveredResource(Object key) {
        ResourceInfo resourceInfo = this.resourceTable.get(key) instanceof ResourceInfo ? this.resourceTable.get(key) : null;
        if (resourceInfo != null) {
            this.resourceTable.remove(key);
            this.DisposeResource(resourceInfo.getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAllResources() {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            Set keys = this.resourceTable.keySet();
            for (Object tempObj : keys) {
                ResourceInfo resourceInfo = this.resourceTable.get(tempObj) instanceof ResourceInfo ? this.resourceTable.get(tempObj) : null;
                if (resourceInfo == null) continue;
                this.DisposeResource(resourceInfo.getObject());
            }
            this.resourceTable.clear();
        }
    }

    private void DisposeResource(Object res) {
        if (res instanceof IDisposable) {
            try {
                ((IDisposable)res).dispose();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] GetAllResourceKeys() {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            return this.resourceTable.keySet().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] GetAllResourceValues() {
        ResourcePool resourcePool = this;
        synchronized (resourcePool) {
            return this.resourceTable.values().toArray();
        }
    }

    public static class ResourceInfo {
        private Object _resource;
        private int _refCount;

        public ResourceInfo(Object resource) {
            this._resource = resource;
        }

        public final int AddRef() {
            return ++this._refCount;
        }

        public final int Release() {
            if (this._refCount > 0) {
                --this._refCount;
            }
            return this._refCount;
        }

        public final Object getObject() {
            return this._resource;
        }

        public final void setObject(Object value) {
            this._resource = value;
        }
    }
}

