/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Enum.CacheStatus;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;

public class StatusInfo
implements InternalCompactSerializable {
    private static final String NODE_EXPIRED_MESSAGE = "Your license for using NCache has expired on {0}. Please contact sales@alachisoft.com for further terms and conditions.";
    private static final String NODE_EXPIRED_MESSAGE2 = "Your license for using NCache has expired. Please contact sales@alachisoft.com for further terms and conditions.";
    public CacheStatus Status = CacheStatus.Unavailable;
    public boolean IsCoordinatorInternal = false;
    private String _info = "";
    private String configID;
    private double configVersion = 0.0;

    public StatusInfo() {
        this(CacheStatus.Unavailable);
    }

    public StatusInfo(CacheStatus status) {
        this(status, "");
    }

    public StatusInfo(CacheStatus status, String info) {
        this.Status = status;
        this._info = info;
    }

    public double getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(double configVersion) {
        this.configVersion = configVersion;
    }

    public final boolean getIsCoordinator() {
        return this.IsCoordinatorInternal;
    }

    public final void setIsCoordinator(boolean value) {
        this.IsCoordinatorInternal = value;
    }

    public final String getConfigID() {
        return this.configID;
    }

    public final void setConfigID(String value) {
        this.configID = value;
    }

    public final String Info(String nodeName) {
        switch (this.Status) {
            case Expired: {
                if (nodeName == null || nodeName.equals("")) {
                    this._info = NODE_EXPIRED_MESSAGE2;
                    break;
                }
                this._info = String.format(NODE_EXPIRED_MESSAGE, nodeName);
                break;
            }
            case Registered: {
                this._info = "Stopped";
                break;
            }
            case Running: 
            case Unavailable: {
                this._info = this.Status.toString();
                break;
            }
            default: {
                this._info = "Stopped";
            }
        }
        return this._info;
    }

    public final boolean getIsRunning() {
        return this.Status == CacheStatus.Running;
    }

    public final boolean getIsUnavailable() {
        return this.Status == CacheStatus.Unavailable;
    }

    public final boolean getIsExpired() {
        return this.Status == CacheStatus.Expired;
    }

    public void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._info = (String)Common.readAs(reader.ReadObject(), String.class);
        this.Status = CacheStatus.forValue(reader.ReadInt32());
        this.IsCoordinatorInternal = reader.ReadBoolean();
        this.configID = reader.ReadString();
        this.configVersion = reader.ReadDouble();
    }

    public void Serialize(CompactWriter writer) throws IOException {
        writer.WriteObject((Object)this._info);
        writer.Write(this.Status.getValue());
        writer.Write(this.IsCoordinatorInternal);
        writer.Write(this.configID);
        writer.Write(this.configVersion);
    }
}

