/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Threading;

import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Threading.Monitor;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.LockingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.io.IOException;
import java.util.LinkedList;

public class AsyncProcessor
implements Runnable {
    Boolean _isShutdown = false;
    Object _shutdownMutex = new Object();
    private LinkedList _eventsHi;
    private LinkedList _eventsLow;
    private ILogger NCacheLog;
    private boolean _started;
    private int _numProcessingThreads = 1;
    private Thread[] _workerThreads;

    public AsyncProcessor(ILogger NCacheLog) {
        this();
        this.NCacheLog = NCacheLog;
    }

    public AsyncProcessor() {
        this(1);
    }

    public AsyncProcessor(int numProcessingThread) {
        if (numProcessingThread < 1) {
            numProcessingThread = 1;
        }
        this._workerThreads = null;
        this._numProcessingThreads = numProcessingThread;
        this._eventsHi = new LinkedList();
        this._eventsLow = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void WindUpTask() {
        this.NCacheLog.CriticalInfo("AsyncProcessor", "WindUp Task Started.");
        if (this._eventsHi != null) {
            this.NCacheLog.CriticalInfo("AsyncProcessor", "Async operation(s) Queue Count: " + this._eventsHi.size());
        }
        this._isShutdown = true;
        AsyncProcessor asyncProcessor = this;
        synchronized (asyncProcessor) {
            Monitor.pulse(this);
        }
        this.NCacheLog.CriticalInfo("AsyncProcessor", "WindUp Task Ended.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void WaitForShutDown(long interval) {
        this.NCacheLog.CriticalInfo("AsyncProcessor", "Waiting for  async process queue shutdown task completion.");
        if (interval > 0L) {
            boolean waitlock = false;
            Object object = this._shutdownMutex;
            synchronized (object) {
                if (this._eventsHi.size() > 0) {
                    try {
                        waitlock = Monitor.wait(this._shutdownMutex, (int)((interval - 1L) * 1000L));
                    }
                    catch (Exception ex) {
                        this.NCacheLog.Error("AsyncProcessor", "Asyncronous operations has intruppted. " + ex.getMessage());
                    }
                }
            }
            if (!waitlock && this._eventsHi.size() > 0) {
                this.NCacheLog.CriticalInfo("AsyncProcessor", "Remaining Async operations in queue: " + this._eventsHi.size());
            }
        }
        this.NCacheLog.CriticalInfo("AsyncProcessor", "Shutdown task completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Enqueue(IAsyncTask evnt) {
        AsyncProcessor asyncProcessor = this;
        synchronized (asyncProcessor) {
            this._eventsHi.offer(evnt);
            Monitor.pulse(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void EnqueueLowPriority(IAsyncTask evnt) {
        AsyncProcessor asyncProcessor = this;
        synchronized (asyncProcessor) {
            this._eventsLow.offer(evnt);
            Monitor.pulse(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Start() {
        block7: {
            try {
                AsyncProcessor asyncProcessor = this;
                synchronized (asyncProcessor) {
                    if (!this._started) {
                        this._workerThreads = new Thread[this._numProcessingThreads];
                        this._started = true;
                        for (int i = 0; i < this._workerThreads.length; ++i) {
                            Thread tThread = new Thread(this);
                            tThread.setDaemon(true);
                            tThread.setName("AsyncProcessor");
                            tThread.start();
                            this._workerThreads[i] = tThread;
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (this.NCacheLog == null) break block7;
                this.NCacheLog.Error("AsyncProcessor.Start)_", ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Stop() {
        AsyncProcessor asyncProcessor = this;
        synchronized (asyncProcessor) {
            if (this._workerThreads != null) {
                for (Thread tThread : this._workerThreads) {
                    if (tThread == null || !tThread.isAlive()) continue;
                    if (this.NCacheLog != null) {
                        this.NCacheLog.Flush();
                    }
                    tThread.interrupt();
                    tThread = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this._workerThreads != null && !Thread.currentThread().isInterrupted()) {
            IAsyncTask evnt = null;
            try {
                Object object = this;
                synchronized (object) {
                    if (this._eventsHi.size() < 1 && this._eventsLow.size() < 1 && !this._isShutdown.booleanValue()) {
                        Monitor.wait(this);
                    }
                    if (this._eventsHi.size() < 1 && this._isShutdown.booleanValue()) {
                        Object object2 = this._shutdownMutex;
                        synchronized (object2) {
                            Monitor.pulse(this._shutdownMutex);
                            break;
                        }
                    }
                    if (this._eventsHi.size() > 0) {
                        evnt = (IAsyncTask)this._eventsHi.poll();
                    } else if (this._eventsLow.size() > 0) {
                        evnt = (IAsyncTask)this._eventsLow.poll();
                    }
                }
                if (evnt == null && this._eventsHi.size() < 1 && this._isShutdown.booleanValue()) {
                    object = this._shutdownMutex;
                    synchronized (object) {
                        Monitor.pulse(this._shutdownMutex);
                        break;
                    }
                }
                if (evnt == null) continue;
                evnt.Process();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                String exceptionString = e.toString();
                if (exceptionString.equals("ChannelNotConnectedException") || exceptionString.equals("ChannelClosedException") || this.NCacheLog == null) continue;
                this.NCacheLog.Error("AsyncProcessor.Run()", exceptionString);
            }
        }
    }

    public static interface IAsyncTask {
        public void Process() throws OperationFailedException, IOException, CacheException, LockingException;
    }
}

