/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Threading;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Threading.Promise;

public class Latch {
    private Promise _initWatch = new Promise();
    private BitSet _status = new BitSet();

    public Latch() {
    }

    public Latch(byte initialStatus) {
        this._status.setData(initialStatus);
    }

    public final BitSet getStatus() {
        return this._status;
    }

    public final boolean AreAllBitsSet(byte status) {
        return this._status.IsBitSet(status);
    }

    public final boolean IsAnyBitsSet(byte status) {
        return this._status.IsAnyBitSet(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Clear() {
        Latch latch = this;
        synchronized (latch) {
            this._status.setData((byte)0);
            this._initWatch.SetResult(this._status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void SetStatusBit(byte bitsToSet, byte bitsToUnset) {
        Latch latch = this;
        synchronized (latch) {
            this._status.Set(bitsToSet, bitsToUnset);
            this._initWatch.SetResult(this._status);
        }
    }

    public final void WaitForAny(byte status) {
        while (!this.IsAnyBitsSet(status)) {
            Object result = this._initWatch.WaitResult(Long.MAX_VALUE);
            if (result != null) continue;
            return;
        }
    }

    public final void WaitForAny(byte status, long timeout) {
        if (timeout > 0L) {
            while (!this.IsAnyBitsSet(status)) {
                Object result = this._initWatch.WaitResult(timeout);
                if (result != null) continue;
                return;
            }
        }
    }

    public void waitForAnyUpdated(byte status) {
        while (!this.IsAnyBitsSet(status)) {
            Object object = this._initWatch.WaitResult(Long.MAX_VALUE);
        }
    }

    public final void WaitForAll(byte status) {
        while (!this.AreAllBitsSet(status)) {
            Object result = this._initWatch.WaitResult(Long.MAX_VALUE);
            if (result != null) continue;
            return;
        }
    }
}

