/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Threading;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ThreadPool {
    ExecutorService threadPool = Executors.newCachedThreadPool();
    private static ThreadPool instance = null;

    private ThreadPool() {
    }

    public static ThreadPool getInstance() {
        if (instance == null) {
            instance = new ThreadPool();
        }
        return instance;
    }

    public void Stop(boolean shutdownImmediate) {
        if (shutdownImmediate) {
            this.threadPool.shutdownNow();
        } else {
            this.threadPool.shutdown();
        }
        instance = null;
    }

    public void executeTask(Runnable task) {
        if (task != null && this.threadPool != null && !this.threadPool.isShutdown()) {
            this.threadPool.execute(task);
        }
    }

    public Future submitTask(Runnable task) {
        if (task != null && this.threadPool != null && !this.threadPool.isShutdown()) {
            return this.threadPool.submit(task);
        }
        return null;
    }
}

