/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Util;

import Alachisoft.NCache.Common.Util.InstallModes;
import Alachisoft.NCache.Common.Util.LanguageContext;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;

public final class AuthenticateFeature {
    private static final String DOTNET_INSTALL_MODE = "DotNetInstallMode";
    private static final String JAVA_INSTALL_MODE = "JavaInstallMode";
    private static InstallModes _dotNetInstallMode = InstallModes.None;
    private static InstallModes _javaInstallMode = InstallModes.None;

    public static boolean getIsJavaEnabled() {
        if (_javaInstallMode == InstallModes.Client) {
            return true;
        }
        if (_javaInstallMode == InstallModes.Developer) {
            return true;
        }
        return _javaInstallMode == InstallModes.Server;
    }

    public static boolean getIsDotNetEnabled() {
        if (_dotNetInstallMode == InstallModes.Client) {
            return true;
        }
        if (_dotNetInstallMode == InstallModes.Developer) {
            return true;
        }
        return _dotNetInstallMode == InstallModes.Server;
    }

    public static InstallModes getJavaInstallMode() {
        return _javaInstallMode;
    }

    public static InstallModes getDotNetInstallMode() {
        return _dotNetInstallMode;
    }

    public static void Authenticate(LanguageContext languageContext) throws ConfigurationException {
        if (languageContext == LanguageContext.DOTNET && !AuthenticateFeature.getIsDotNetEnabled()) {
            throw new ConfigurationException(".net based readThru provider's are not supported in current installed NCache edition");
        }
        if (languageContext == LanguageContext.JAVA && !AuthenticateFeature.getIsJavaEnabled()) {
            throw new ConfigurationException("java based readThru provider's are not supported in current installed NCache edition");
        }
    }

    static {
        try {
            _dotNetInstallMode = InstallModes.Server;
            _javaInstallMode = InstallModes.Server;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

