/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TypeInfoMap {
    private int _typeHandle = 0;
    private HashMap _map;
    private HashMap _typeToHandleMap;
    private StringBuilder _protocolString = null;

    public TypeInfoMap(HashMap indexClasses) {
        this.CreateMap(indexClasses);
    }

    public TypeInfoMap(String protocolString) {
        this.CreateMap(protocolString);
    }

    private void CreateMap(HashMap indexClasses) {
        this._map = new HashMap();
        this._typeToHandleMap = new HashMap();
        for (Map.Entry pair : indexClasses.entrySet()) {
            HashMap innerProps = pair.getValue() instanceof HashMap ? pair.getValue() : null;
            if (innerProps == null) continue;
            HashMap<String, Object> type = new HashMap<String, Object>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            ArrayList<String> attribList = new ArrayList<String>();
            for (Map.Entry pair1 : innerProps.entrySet()) {
                HashMap attribs = pair1.getValue() instanceof HashMap ? pair1.getValue() : null;
                if (attribs == null) continue;
                for (Map.Entry pair2 : attribs.entrySet()) {
                    HashMap attrib = pair2.getValue() instanceof HashMap ? pair2.getValue() : null;
                    if (attrib == null) continue;
                    attribList.add(attrib.get("id") instanceof String ? attrib.get("id") : null);
                    attributes.put(attrib.get("id") instanceof String ? attrib.get("id") : null, attrib.get("data-type") instanceof String ? attrib.get("data-type") : null);
                }
            }
            type.put("name", innerProps.get("name") instanceof String ? innerProps.get("name") : null);
            type.put("attributes", attributes);
            type.put("sequence", attribList);
            this._map.put(this._typeHandle, type);
            this._typeToHandleMap.put(type.get("name") instanceof String ? type.get("name") : null, this._typeHandle);
            ++this._typeHandle;
        }
    }

    private void CreateMap(String value) {
        int startIndex = 0;
        int endIndex = value.indexOf(34, startIndex + 1);
        int typeCount = Integer.parseInt(value.substring(startIndex, startIndex + endIndex - startIndex));
        this._map = new HashMap(typeCount);
        this._typeToHandleMap = new HashMap(typeCount);
        for (int i = 0; i < typeCount; ++i) {
            startIndex = endIndex + 1;
            endIndex = value.indexOf(34, endIndex + 1);
            int typeHandle = Integer.parseInt(value.substring(startIndex, startIndex + endIndex - startIndex));
            startIndex = endIndex + 1;
            endIndex = value.indexOf(34, endIndex + 1);
            String typeName = value.substring(startIndex, startIndex + endIndex - startIndex);
            HashMap<String, Object> typeMap = new HashMap<String, Object>();
            typeMap.put("name", typeName);
            startIndex = endIndex + 1;
            endIndex = value.indexOf(34, endIndex + 1);
            int attributesCount = Integer.parseInt(value.substring(startIndex, startIndex + endIndex - startIndex));
            ArrayList<String> attributes = new ArrayList<String>(attributesCount);
            for (int j = 0; j < attributesCount; ++j) {
                startIndex = endIndex + 1;
                endIndex = value.indexOf(34, endIndex + 1);
                String attributeName = value.substring(startIndex, startIndex + endIndex - startIndex);
                attributes.add(attributeName);
            }
            typeMap.put("sequence", attributes);
            this._map.put(typeHandle, typeMap);
            this._typeToHandleMap.put(typeMap.get("name") instanceof String ? typeMap.get("name") : null, typeHandle);
        }
    }

    public final String GetTypeName(int handle) {
        return (String)((HashMap)this._map.get(handle)).get("name");
    }

    public final ArrayList GetAttribList(int handleId) {
        return (ArrayList)((HashMap)this._map.get(handleId)).get("sequence");
    }

    public final HashMap GetAttributes(int handle) {
        return (HashMap)((HashMap)this._map.get(handle)).get("attributes");
    }

    public final ArrayList GetAttributes(String typeName) {
        int handle = this.GetHandleId(typeName);
        if (handle != -1 && this._map.containsKey(handle)) {
            return (ArrayList)((HashMap)this._map.get(handle)).get("attributes");
        }
        return null;
    }

    public final String ToProtocolString() {
        this._protocolString = new StringBuilder();
        this._protocolString.append(this._map.size()).append("\"");
        for (Map.Entry pair : this._map.entrySet()) {
            this._protocolString.append((Integer)pair.getKey()).append("\"");
            HashMap type = pair.getValue() instanceof HashMap ? pair.getValue() : null;
            this._protocolString.append((String)(type.get("name") instanceof String ? type.get("name") : null)).append("\"");
            ArrayList attributes = (ArrayList)type.get("sequence");
            this._protocolString.append(attributes.size()).append("\"");
            for (int i = 0; i < attributes.size(); ++i) {
                this._protocolString.append((String)(attributes.get(i) instanceof String ? attributes.get(i) : null)).append("\"");
            }
        }
        return this._protocolString.toString();
    }

    public final int GetHandleId(String typeName) {
        if (this._typeToHandleMap.containsKey(typeName)) {
            return (Integer)this._typeToHandleMap.get(typeName);
        }
        return -1;
    }
}

