/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.customcounters;

import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounter;

public abstract class PerformanceCounterBase
implements PerformanceCounter {
    protected double _value;
    protected double _lastValue;
    private String _name;
    private String _instanceName;
    private String _category;

    public PerformanceCounterBase(String name, String instance) {
        this._name = name;
        this._instanceName = instance;
        this._category = null;
        this._value = 0.0;
        this._lastValue = 0.0;
    }

    public PerformanceCounterBase(String category, String name, String instance) {
        this._name = name;
        this._instanceName = instance;
        this._category = category;
        this._value = 0.0;
        this._lastValue = 0.0;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getInstanceName() {
        return this._instanceName;
    }

    @Override
    public String getCategory() {
        return this._category;
    }

    @Override
    public abstract void increment();

    @Override
    public abstract void incrementBy(double var1);

    @Override
    public abstract void decrement();

    @Override
    public abstract void decrementBy(double var1);

    @Override
    public abstract double getValue();

    @Override
    public abstract void setValue(double var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        PerformanceCounterBase performanceCounterBase = this;
        synchronized (performanceCounterBase) {
            this._lastValue = 0.0;
            this._value = 0.0;
        }
    }

    public String toString() {
        Object toStr = "[";
        toStr = (String)toStr + (String)(this._name != null ? "Name :" + this._name : "");
        toStr = (String)toStr + (String)(this._instanceName != null ? "; Instance :" + this._instanceName : "");
        toStr = (String)toStr + (String)(this._category != null ? "; Category :" + this._category + "]" : "");
        return toStr;
    }
}

