/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.monitoring;

import java.util.HashMap;

public enum PerformanceCounterType {
    NumberOfItemsHEX32(0),
    NumberOfItemsHEX64(256),
    NumberOfItems32(65536),
    NumberOfItems64(65792),
    CounterDelta32(0x400400),
    CounterDelta64(0x400500),
    SampleCounter(0x410400),
    CountPerTimeInterval32(0x450400),
    CountPerTimeInterval64(0x450500),
    RateOfCountsPerSecond32(0x10410400),
    RateOfCountsPerSecond64(272696576),
    RawFraction(0x20020400),
    CounterTimer(541132032),
    Timer100Ns(542180608),
    SampleFraction(549585920),
    CounterTimerInverse(557909248),
    Timer100NsInverse(558957824),
    CounterMultiTimer(574686464),
    CounterMultiTimer100Ns(575735040),
    CounterMultiTimerInverse(591463680),
    CounterMultiTimer100NsInverse(592512256),
    AverageTimer32(805438464),
    ElapsedTime(807666944),
    AverageCount64(1073874176),
    SampleBase(1073939457),
    AverageBase(1073939458),
    RawBase(0x40030403),
    CounterMultiBase(1107494144);

    private int intValue;
    private static HashMap<Integer, PerformanceCounterType> mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static HashMap<Integer, PerformanceCounterType> getMappings() {
        if (mappings != null) return mappings;
        Class<PerformanceCounterType> clazz = PerformanceCounterType.class;
        synchronized (PerformanceCounterType.class) {
            if (mappings != null) return mappings;
            mappings = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mappings;
        }
    }

    private PerformanceCounterType(int value) {
        this.intValue = value;
        PerformanceCounterType.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static PerformanceCounterType forValue(int value) {
        return PerformanceCounterType.getMappings().get(value);
    }
}

