/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.monitoring;

import Alachisoft.NCache.Common.Logger.EventLogger;
import Alachisoft.NCache.Common.Logger.ILogger;
import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounter;
import com.alachisoft.ncache.common.caching.statistics.monitoring.Monitor;
import com.alachisoft.ncache.common.caching.statistics.monitoring.ServerMonitorMBean;
import com.alachisoft.ncache.common.caching.statistics.operations.Operations;
import com.alachisoft.ncache.common.caching.statistics.operations.ServerOperations;
import java.util.EnumMap;
import org.weakref.jmx.Managed;

public abstract class ServerMonitor
extends Monitor
implements ServerMonitorMBean {
    private static EnumMap serverCounterStore = new EnumMap(ServerOperations.class);
    private String nodeName;

    public ServerMonitor(String nodeName) {
        super(nodeName);
        this.nodeName = nodeName;
        this.setPort();
    }

    public ServerMonitor(String nodeName, ILogger logger) {
        super(nodeName, logger);
        this.nodeName = nodeName;
        this.setPort();
    }

    public static EnumMap getServerCounterStore() {
        return serverCounterStore;
    }

    @Override
    public void setPort() {
    }

    public final double getServerCounter(Operations operation) {
        return ((PerformanceCounter)ServerMonitor.getServerCounterStore().get(operation)).getValue();
    }

    @Override
    @Managed(description="Last event occured during operation performed on NCache", name="Logged Event")
    public String getLoggedEvent() {
        return EventLogger.getLastLoggedEvent();
    }

    @Override
    @Managed(description="Number of requests received (meaning cache commands like add, get, insert, remove etc.) from all clients by this cache server.", name="Requests/sec")
    public double getRequestsPerSec() {
        return this.getServerCounter(ServerOperations.RequestsPerSec);
    }

    @Override
    @Managed(description="Bytes being received by cache server from all its clients.", name="Client Bytes Received/sec")
    public double getClientBytesRecievedPerSecStats() {
        return this.getServerCounter(ServerOperations.ClientBytesRecievedPerSec);
    }

    @Override
    @Managed(description="Number of responses received by all clients from the cache server.", name="Responses/sec")
    public double getResponsesPerSec() {
        return this.getServerCounter(ServerOperations.ResponsesPerSec);
    }

    @Override
    @Managed(description="Bytes being sent from cache server to all its clients.", name="Client Bytes Sent/sec")
    public double getClientBytesSentPerSecStats() {
        return this.getServerCounter(ServerOperations.ClientBytesSentPerSec);
    }

    @Override
    @Managed(description="Average time, in microseconds, taken to complete one cache-operation.", name="Average \u00c2\u00b5s/cache operations")
    public double getmSecPerCacheOperation() {
        return this.getServerCounter(ServerOperations.MSecPerCacheOperation);
    }

    @Override
    @Managed(description="Total network usage consumed by NCache process. ", name="NCache Network Usage")
    public double getVMNetworkUsage() {
        return this.getServerCounter(ServerOperations.VMNetworkUsage);
    }

    @Override
    public double getmSecPerOperationBase() {
        return this.getServerCounter(ServerOperations.MSecPerCachOperationBase);
    }

    @Override
    @Managed(description="Port used by SNMP manager to published server, cache and  client counter.", name="Cache Ports")
    public final String getCachePorts() {
        return null;
    }

    @Override
    @Managed(description="Total CPU consumed by NCache Server process. ", name="Total CPU Usage")
    public final double getSystemCpuUsage() {
        return this.getServerCounter(ServerOperations.SystemCpuUsage);
    }

    @Override
    @Managed(description="Available free memory for NCache Server process. ", name="Total Free Physical Memory")
    public final double getSystemFreeMemory() {
        return this.getServerCounter(ServerOperations.SystemFreeMemory);
    }

    @Override
    @Managed(description="Total memory used by NCache Server process. ", name="Total Memory Usage")
    public final double getSystemMemoryUsage() {
        return this.getServerCounter(ServerOperations.SystemMemoryUsage);
    }

    @Override
    @Managed(description="CPU consumed by NCache process", name="NCache CPU Usage")
    public final double getVMCpuUsage() {
        return this.getServerCounter(ServerOperations.VMCpuUsage);
    }

    @Override
    @Managed(description="Memory available to NCache process. ", name="NCache Available Memory")
    public final double getVMCommittedMemory() {
        return this.getServerCounter(ServerOperations.VMCommittedMemory);
    }

    @Override
    @Managed(description="Maximum memory occupied by NCache process.", name="NCache Max Memory")
    public final double getVMMaxMemory() {
        return this.getServerCounter(ServerOperations.VMMaxMemory);
    }

    @Override
    @Managed(description="Total memory used by NCache process. ", name="NCache Memory Usage")
    public final double getVMMemroyUsage() {
        return this.getServerCounter(ServerOperations.VMMemoryUsage);
    }
}

