/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.licensing.config;

import com.alachisoft.ncache.licensing.config.DeploymentInfo;
import com.alachisoft.ncache.licensing.config.LicenseInfo;
import com.alachisoft.ncache.licensing.config.NCacheInfo;
import com.alachisoft.ncache.licensing.config.ProductInfo;
import com.alachisoft.ncache.licensing.config.UserInfo;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigHandler {
    public static NCacheInfo readNCacheInfo(String path) throws IOException {
        NCacheInfo info = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException("Unable to locate the file to read it");
            }
            info = new NCacheInfo();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(path));
            document.getDocumentElement().normalize();
            info.setProduct(ConfigHandler.parseProductInfo(document));
            info.setUserInfo(ConfigHandler.parseUserInfo(document));
            info.setDeploymentInfo(ConfigHandler.parseDeploymentInfo(document));
        }
        catch (ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return info;
    }

    private static ProductInfo parseProductInfo(Document document) {
        ProductInfo productInfo = new ProductInfo();
        Node nNode = document.getElementsByTagName("product-info").item(0);
        if (nNode.getNodeType() == 1) {
            Element eElement = (Element)nNode;
            productInfo.setDotNetInstallMode(eElement.getAttribute("dotnet-install-mode"));
            productInfo.setHttpPort(eElement.getAttribute("http-port"));
            productInfo.setInstallCode(ConfigHandler.getNodeValue(eElement, "install-code"));
            productInfo.setInstallDir(ConfigHandler.getNodeValue(eElement, "install-dir"));
            productInfo.setLastReportTime(ConfigHandler.getNodeValue(eElement, "last-report-time"));
            productInfo.setPlatform(ConfigHandler.getNodeValue(eElement, "platform"));
            productInfo.setSPVersion(ConfigHandler.getNodeValue(eElement, "sp-version"));
            productInfo.setTcpPort(ConfigHandler.getNodeValue(eElement, "tcp-port"));
            productInfo.setJavaHome(ConfigHandler.getNodeValue(eElement, "java-home"));
            productInfo.setDotNetCoreHome(ConfigHandler.getNodeValue(eElement, "dotnet-home"));
        }
        return productInfo;
    }

    private static UserInfo parseUserInfo(Document document) {
        UserInfo userInfo = new UserInfo();
        Node nNode = document.getElementsByTagName("user-info").item(0);
        if (nNode.getNodeType() == 1) {
            Element eElement = (Element)nNode;
            userInfo.setAddress(eElement.getElementsByTagName("address").item(0).getTextContent());
            userInfo.setCity(eElement.getElementsByTagName("city").item(0).getTextContent());
            userInfo.setCompany(eElement.getElementsByTagName("company").item(0).getTextContent());
            userInfo.setCountry(eElement.getElementsByTagName("country").item(0).getTextContent());
            userInfo.setEmail(eElement.getElementsByTagName("email").item(0).getTextContent());
            userInfo.setFirstName(eElement.getElementsByTagName("first-name").item(0).getTextContent());
            userInfo.setLastName(eElement.getElementsByTagName("last-name").item(0).getTextContent());
            userInfo.setPhone(eElement.getElementsByTagName("phone").item(0).getTextContent());
            userInfo.setState(eElement.getElementsByTagName("state").item(0).getTextContent());
            userInfo.setZip(eElement.getElementsByTagName("zip").item(0).getTextContent());
        }
        return userInfo;
    }

    private static DeploymentInfo parseDeploymentInfo(Document document) {
        DeploymentInfo deploymentInfo = new DeploymentInfo();
        Node nNode = document.getElementsByTagName("deployment-info").item(0);
        if (nNode.getNodeType() == 1) {
            NodeList nodeList1;
            Element eElement = (Element)nNode;
            NodeList nodeList = eElement.getElementsByTagName("environment-name");
            if (nodeList != null && nodeList.item(0) != null) {
                deploymentInfo.setName(nodeList.item(0).getTextContent());
            }
            if ((nodeList1 = eElement.getElementsByTagName("client-cpus")) != null && nodeList1.item(0) != null) {
                deploymentInfo.setClientCpus(nodeList.item(0).getTextContent());
            }
        }
        return deploymentInfo;
    }

    public static void writeNCacheInfo(String filePath, String xmlString) {
        try {
            if (RegUtil.nCacheInfo == null) {
                return;
            }
            File file = new File(filePath);
            if (!file.exists()) {
                throw new FileNotFoundException("Unable to locate the file to read it");
            }
            try (FileOutputStream os = new FileOutputStream(filePath);
                 OutputStreamWriter writer = new OutputStreamWriter(os);){
                writer.write(xmlString);
                ((Writer)writer).flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static LicenseInfo readLicenseInfo(String LicenseInfoFileOnLinux) throws IOException {
        LicenseInfo info = new LicenseInfo();
        try {
            File file = new File(LicenseInfoFileOnLinux);
            if (!file.exists()) {
                throw new FileNotFoundException("Unable to locate the file to read it");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(LicenseInfoFileOnLinux));
            document.getDocumentElement().normalize();
            Node nNode = document.getElementsByTagName("license-config").item(0);
            if (nNode.getNodeType() == 1) {
                Element eElement = (Element)nNode;
                info.setAuthCode(ConfigHandler.getNodeValue(eElement, "authcode"));
                info.setLicenseKey(ConfigHandler.getNodeValue(eElement, "license-key"));
                info.setExtCode(ConfigHandler.getNodeValue(eElement, "ext-code"));
                info.setDeactCode(ConfigHandler.getNodeValue(eElement, "deact-code"));
                info.setDeactivationKey(ConfigHandler.getNodeValue(eElement, "deactivate-key"));
            }
        }
        catch (ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        return info;
    }

    private static String getNodeValue(Element elsement, String tagName) {
        Node item;
        NodeList elementsByTagName = elsement.getElementsByTagName(tagName);
        if (elementsByTagName != null && (item = elementsByTagName.item(0)) != null) {
            return item.getTextContent();
        }
        return "";
    }
}

