/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Storage;

import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Propagator.IAlertPropagator;
import Alachisoft.NCache.Storage.ClrHeapStorageProvider;
import Alachisoft.NCache.Storage.ICacheStorage;
import Alachisoft.NCache.Storage.StorageProviderBase;
import java.util.Map;

public class CacheStorageFactory {
    public static ICacheStorage CreateStorageProvider(Map properties, String cacheContext, boolean evictionEnabled, ILogger NCacheLog, IAlertPropagator alertPropagator) throws Exception {
        if (properties == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: properties");
        }
        StorageProviderBase cacheStorage = null;
        if (!properties.containsKey("class")) {
            throw new Exception("Missing cache store class.");
        }
        String scheme = String.valueOf(properties.get("class")).toLowerCase();
        Map schemeProps = (Map)properties.get(scheme);
        if (scheme.compareTo("heap") == 0) {
            cacheStorage = new ClrHeapStorageProvider(schemeProps, evictionEnabled, NCacheLog, alertPropagator);
        }
        if (cacheStorage != null) {
            cacheStorage.setCacheContext(cacheContext);
        }
        return cacheStorage;
    }
}

