/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.JSON;

import com.alachisoft.ncache.runtime.JSON.JsonDataType;
import com.alachisoft.ncache.runtime.JSON.JsonValue;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import com.alachisoft.ncache.runtime.errorhandling.ErrorMessages;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class JsonObject
extends JsonValueBase
implements Serializable,
Iterable<Map.Entry<String, JsonValueBase>> {
    private Map<String, JsonValueBase> _propertyMap = new HashMap<String, JsonValueBase>();
    private String type = null;

    public JsonValueBase getItem(String attributeName) {
        return this.getAttributeValue(attributeName);
    }

    @Override
    public Iterator<Map.Entry<String, JsonValueBase>> iterator() {
        return this._propertyMap.entrySet().iterator();
    }

    public void setItem(String attributeName, JsonValueBase value) throws OperationFailedException {
        if (value == null) {
            throw new UnsupportedOperationException("Updating to null value is not supported with indexer.");
        }
        this.addOrUpdateAttribute(attributeName, value);
    }

    public int getCount() {
        return this._propertyMap == null ? 0 : this._propertyMap.size();
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    protected int getSize() {
        int size = super.getSize();
        if (this._propertyMap != null) {
            for (Map.Entry<String, JsonValueBase> property : this._propertyMap.entrySet()) {
                String key = property.getKey();
                JsonValueBase value = property.getValue();
                size += value.getSize() + this.getAttributeNameSize(key);
            }
        }
        return size;
    }

    @Override
    protected int getInMemorySize() {
        int inMemorySize = super.getInMemorySize() + 45;
        if (this._propertyMap != null) {
            for (Map.Entry<String, JsonValueBase> property : this._propertyMap.entrySet()) {
                String key = property.getKey();
                JsonValueBase value = property.getValue();
                inMemorySize += value.getInMemorySize() + this.getAttributeNameInMemorySize(key);
            }
        }
        return inMemorySize;
    }

    public void setType(String type) {
        if (type.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be empty." + System.lineSeparator() + "Parameter name : type");
        }
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public JsonObject() {
        super(null, JsonDataType.Object);
    }

    public JsonObject(String json, String type) {
        this();
        JsonObject.parse(this, json);
        this.type = type;
    }

    public Collection<String> getAttributeNames() {
        return this._propertyMap == null ? Arrays.asList(new String[0]) : this._propertyMap.keySet();
    }

    public void addAttribute(String attributeName, JsonValue attributeValue) throws OperationFailedException {
        this.addAttribute(attributeName, (JsonValueBase)(attributeValue instanceof JsonValueBase ? attributeValue : null));
    }

    public void addAttribute(String attributeName, JsonValueBase attributeValue) throws OperationFailedException {
        this.verifyAttributeName(attributeName);
        if (this._propertyMap.containsKey(attributeName)) {
            throw new OperationFailedException(22500, ErrorMessages.getErrorMessage(22500, new String[0]));
        }
        this.verifyAttributeValue(attributeValue);
        this._propertyMap.put(attributeName, attributeValue);
    }

    public boolean removeAttribute(String attributeName) {
        this.verifyAttributeName(attributeName);
        return this._propertyMap.remove(attributeName) != null;
    }

    public JsonValueBase getAttributeValue(String attributeName) {
        this.verifyAttributeName(attributeName);
        JsonValueBase attributeValue = null;
        attributeValue = this._propertyMap.get(attributeName);
        if (attributeValue != null) {
            return attributeValue;
        }
        return null;
    }

    public boolean containsAttribute(String attributeName) {
        this.verifyAttributeName(attributeName);
        return this._propertyMap.containsKey(attributeName);
    }

    public void clear() {
        if (this._propertyMap != null) {
            this._propertyMap.clear();
        }
    }

    public Iterator<Map.Entry<String, JsonValueBase>> getIterator() {
        return this._propertyMap.entrySet().iterator();
    }

    private void verifyAttributeName(String attributeName) {
        if (attributeName == null || attributeName.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: attributeName");
        }
    }

    private void verifyAttributeValue(JsonValueBase attributeValue) throws OperationFailedException {
        if (attributeValue == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: attributeValue");
        }
        if (attributeValue == this) {
            throw new OperationFailedException(22502, ErrorMessages.getErrorMessage(22502, this.getClass().getSimpleName()));
        }
        HashMap<JsonValueBase, Byte> map = new HashMap<JsonValueBase, Byte>();
        map.put(this, (byte)0);
        attributeValue.invalidateParentReference(map);
    }

    private int getAttributeNameSize(String attributeName) {
        if (attributeName != null) {
            return attributeName.length() * 2;
        }
        return 0;
    }

    private int getAttributeNameInMemorySize(String attributeName) {
        if (attributeName != null) {
            return this.getAttributeNameSize(attributeName) + 24;
        }
        return 0;
    }

    private void addOrUpdateAttribute(String attributeName, JsonValueBase attributeValue) throws OperationFailedException {
        this.verifyAttributeName(attributeName);
        this.verifyAttributeValue(attributeValue);
        this._propertyMap.put(attributeName, attributeValue);
    }

    private boolean shouldOmitAttribute(String attributeName) {
        if (attributeName == null || attributeName == "") {
            return false;
        }
        boolean shouldOmit = false;
        shouldOmit = shouldOmit || attributeName.equals("$id");
        shouldOmit = shouldOmit || attributeName.equals("$type");
        return shouldOmit;
    }

    public boolean equals(Object obj) {
        JsonObject otherJsonObject = (JsonObject)(obj instanceof JsonObject ? obj : null);
        if (otherJsonObject == null) {
            return false;
        }
        for (Map.Entry<String, JsonValueBase> entry : otherJsonObject) {
            String otherJsonObjectAttrName = entry.getKey();
            JsonValueBase otherJsonObjectAttrValue = entry.getValue();
            if (this.shouldOmitAttribute(otherJsonObjectAttrName)) continue;
            JsonValueBase attrValueHere = this.getAttributeValue(otherJsonObjectAttrName);
            if (attrValueHere == null) {
                return false;
            }
            if (attrValueHere.getDataType() != otherJsonObjectAttrValue.getDataType()) {
                return false;
            }
            if (attrValueHere.equals(otherJsonObjectAttrValue)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder jsonBuilder = new StringBuilder();
        Iterator<Map.Entry<String, JsonValueBase>> attributeEnumerator = this._propertyMap.entrySet().iterator();
        jsonBuilder.append('{');
        if (this.type != null) {
            jsonBuilder.append('\"').append("$type$").append('\"').append(':').append('\"').append(this.type).append('\"').append(',');
        }
        int i = 0;
        Iterator<Map.Entry<String, JsonValueBase>> it = attributeEnumerator;
        while (it.hasNext()) {
            Map.Entry<String, JsonValueBase> entry = it.next();
            jsonBuilder.append(i++ != 0 ? ", " : " ").append('\"').append(entry.getKey()).append('\"').append(' ').append(':').append(' ').append(entry.getValue().toString());
        }
        jsonBuilder.append(jsonBuilder.length() > 1 ? " " : "");
        jsonBuilder.append('}');
        return jsonBuilder.toString();
    }
}

