/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.JSON;

import com.alachisoft.ncache.runtime.JSON.JsonArray;
import com.alachisoft.ncache.runtime.JSON.JsonDataType;
import com.alachisoft.ncache.runtime.JSON.JsonNull;
import com.alachisoft.ncache.runtime.JSON.JsonObject;
import com.alachisoft.ncache.runtime.JSON.JsonValue;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Stack;

class JsonParser {
    private JsonFactory _factory;
    private com.fasterxml.jackson.core.JsonParser _parser;
    private String _json;

    public JsonParser() {
    }

    public JsonParser(String json) {
        this._json = json;
    }

    public void setJson(String json) {
        this._json = json;
    }

    public JsonValueBase parse() throws IOException, OperationFailedException {
        if (this._factory == null) {
            this._factory = new JsonFactory();
        }
        this._parser = this._factory.createJsonParser(this._json);
        return this.parseInternal(null, new Stack<ParseType>());
    }

    public JsonValueBase parse(JsonObject jsonObject) throws IOException, OperationFailedException {
        if (this._factory == null) {
            this._factory = new JsonFactory();
        }
        this._parser = this._factory.createJsonParser(this._json);
        return this.parseInternal(jsonObject, new Stack<ParseType>());
    }

    public JsonValueBase parse(JsonArray jsonArray) throws IOException, OperationFailedException {
        if (this._factory == null) {
            this._factory = new JsonFactory();
        }
        this._parser = this._factory.createJsonParser(this._json);
        return this.parseInternal(jsonArray, new Stack<ParseType>());
    }

    public JsonValueBase parse(JsonValue jsonValue) throws IOException, OperationFailedException {
        if (this._factory == null) {
            this._factory = new JsonFactory();
        }
        this._parser = this._factory.createJsonParser(this._json);
        return this.parseInternal(jsonValue, new Stack<ParseType>());
    }

    private JsonValueBase parseInternal(JsonValueBase currentJsonResult, Stack<ParseType> parseTypeStack) throws IOException, OperationFailedException {
        ParseType currentParseType;
        String currentFieldName = null;
        JsonToken currentJsonToken = this._parser.nextToken();
        JsonValueBase currentJsonValue = null;
        ParseType parseType = parseTypeStack.size() == 0 ? (currentJsonToken.equals((Object)JsonToken.START_ARRAY) ? ParseType.Array : ParseType.Object) : (currentParseType = parseTypeStack.peek());
        while (!this._parser.isClosed()) {
            switch (currentJsonToken) {
                case START_OBJECT: {
                    parseTypeStack.push(ParseType.Object);
                    if (currentJsonResult == null) {
                        currentJsonResult = new JsonObject();
                        break;
                    }
                    if (currentFieldName == null) {
                        if (currentParseType == ParseType.Array) {
                            currentJsonValue = new JsonObject();
                            this.parseInternal(currentJsonValue, parseTypeStack);
                            this.addToJsonResult(null, currentJsonValue, currentJsonResult, currentParseType);
                            break;
                        }
                        this.parseInternal(currentJsonResult, parseTypeStack);
                        break;
                    }
                    this.addToJsonResult(currentFieldName, this.parseInternal(new JsonObject(), parseTypeStack), currentJsonResult, currentParseType);
                    break;
                }
                case START_ARRAY: {
                    parseTypeStack.push(ParseType.Array);
                    if (currentJsonResult == null) {
                        currentJsonResult = new JsonArray();
                        break;
                    }
                    if (currentFieldName == null) {
                        if (currentParseType == ParseType.Array) {
                            currentJsonValue = new JsonArray();
                            this.parseInternal(currentJsonValue, parseTypeStack);
                            this.addToJsonResult(null, currentJsonValue, currentJsonResult, currentParseType);
                            break;
                        }
                        this.parseInternal(currentJsonResult, parseTypeStack);
                        break;
                    }
                    this.addToJsonResult(currentFieldName, this.parseInternal(new JsonArray(), parseTypeStack), currentJsonResult, currentParseType);
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    parseTypeStack.pop();
                    return currentJsonResult;
                }
                case FIELD_NAME: {
                    currentFieldName = this._parser.getCurrentName();
                    break;
                }
                case VALUE_STRING: {
                    if (this._parser.getValueAsString() == null) {
                        throw new ClassCastException("Null string value cannot be casted as JsonValue.");
                    }
                    currentJsonValue = new JsonValue(this._parser.getValueAsString(), JsonDataType.String);
                    if (parseTypeStack.empty()) {
                        currentJsonResult = currentJsonValue;
                        break;
                    }
                    this.addToJsonResult(currentFieldName, currentJsonValue, currentJsonResult, parseTypeStack.peek());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    currentJsonValue = new JsonValue(this.getJsonValue(), JsonDataType.Number);
                    if (parseTypeStack.empty()) {
                        currentJsonResult = currentJsonValue;
                        break;
                    }
                    this.addToJsonResult(currentFieldName, currentJsonValue, currentJsonResult, parseTypeStack.peek());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    currentJsonValue = new JsonValue(this.getJsonValue(), JsonDataType.Number);
                    if (parseTypeStack.empty()) {
                        currentJsonResult = currentJsonValue;
                        break;
                    }
                    this.addToJsonResult(currentFieldName, currentJsonValue, currentJsonResult, parseTypeStack.peek());
                    break;
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    currentJsonValue = new JsonValue(this._parser.getValueAsBoolean(), JsonDataType.Boolean);
                    if (parseTypeStack.empty()) {
                        currentJsonResult = currentJsonValue;
                        break;
                    }
                    this.addToJsonResult(currentFieldName, currentJsonValue, currentJsonResult, parseTypeStack.peek());
                    break;
                }
                case VALUE_NULL: {
                    currentJsonValue = new JsonNull();
                    if (parseTypeStack.isEmpty()) {
                        return currentJsonValue;
                    }
                    this.addToJsonResult(currentFieldName, currentJsonValue, currentJsonResult, parseTypeStack.peek());
                }
            }
            currentJsonToken = this._parser.nextToken();
        }
        return currentJsonResult;
    }

    private void addToJsonResult(String currentFieldName, JsonValueBase currentJsonValue, JsonValueBase currentJsonResult, ParseType parseType) throws OperationFailedException {
        if (currentFieldName != null && currentFieldName.equals("$type$")) {
            ((JsonObject)currentJsonResult).setType((String)currentJsonValue.getValue());
            return;
        }
        if (parseType.equals((Object)ParseType.Object)) {
            ((JsonObject)currentJsonResult).addAttribute(currentFieldName, currentJsonValue);
        } else {
            ((JsonArray)currentJsonResult).add(currentJsonValue);
        }
    }

    public <T> T getJsonValue() throws IOException {
        Number value = this._parser.getNumberValue();
        if (value instanceof Byte) {
            return (T)Byte.valueOf(this._parser.getByteValue());
        }
        if (value instanceof Short) {
            return (T)Short.valueOf(this._parser.getShortValue());
        }
        if (value instanceof Integer) {
            return (T)Integer.valueOf(this._parser.getIntValue());
        }
        if (value instanceof Long) {
            return (T)Long.valueOf(this._parser.getValueAsLong());
        }
        if (value instanceof Float) {
            return (T)Float.valueOf(this._parser.getFloatValue());
        }
        if (value instanceof Double) {
            return (T)Double.valueOf(this._parser.getDoubleValue());
        }
        if (value instanceof BigDecimal) {
            return (T)this._parser.getDecimalValue();
        }
        return (T)value;
    }

    private static enum ParseType {
        Object,
        Array;

    }
}

