/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.util;

import com.alachisoft.ncache.runtime.util.NCDateTime;
import java.io.Serializable;
import java.util.Date;

public class TimeSpan
implements Comparable<TimeSpan>,
Serializable {
    public static final long TicksPerMillisecond = 10000L;
    public static final long TicksPerSecond = 10000000L;
    public static final long TicksPerMinute = 600000000L;
    public static final long TicksPerHour = 36000000000L;
    public static final long TicksPerDay = 864000000000L;
    public static final long MaxSeconds = 922337203685L;
    public static final long MinSeconds = -922337203685L;
    public static final long MaxMilliSeconds = 922337203685477L;
    public static final long MinMilliSeconds = -922337203685477L;
    public static final long TicksPerTenthSecond = 1000000L;
    public static final TimeSpan Zero = new TimeSpan(0L);
    public static final TimeSpan MaxValue = new TimeSpan(Long.MAX_VALUE);
    public static final TimeSpan MinValue = new TimeSpan(Long.MIN_VALUE);
    private static final double MillisecondsPerTick = 1.0E-4;
    private static final double SecondsPerTick = 1.0E-7;
    private static final double MinutesPerTick = 1.6666666666666667E-9;
    private static final double HoursPerTick = 2.7777777777777777E-11;
    private static final double DaysPerTick = 1.1574074074074074E-12;
    private static final int MillisPerSecond = 1000;
    private static final int MillisPerMinute = 60000;
    private static final int MillisPerHour = 3600000;
    private static final int MillisPerDay = 86400000;
    public long _ticks;

    public TimeSpan() {
    }

    public TimeSpan(long ticks) {
        this._ticks = ticks;
    }

    public TimeSpan(int hours, int minutes, int seconds) {
        this._ticks = TimeSpan.TimeToTicks(hours, minutes, seconds);
    }

    public TimeSpan(int days, int hours, int minutes, int seconds) {
        this(days, hours, minutes, seconds, 0);
    }

    public TimeSpan(int days, int hours, int minutes, int seconds, int milliseconds) {
        long totalMilliSeconds = ((long)days * 3600L * 24L + (long)hours * 3600L + (long)minutes * 60L + (long)seconds) * 1000L + (long)milliseconds;
        if (totalMilliSeconds > 922337203685477L || totalMilliSeconds < -922337203685477L) {
            throw new IllegalArgumentException("TimeSpan overflowed because the duration is too long");
        }
        this._ticks = totalMilliSeconds * 10000L;
    }

    public static int Compare(TimeSpan t1, TimeSpan t2) {
        if (t1._ticks > t2._ticks) {
            return 1;
        }
        if (t1._ticks < t2._ticks) {
            return -1;
        }
        return 0;
    }

    public static TimeSpan FromDays(double value) {
        return TimeSpan.Interval(value, 86400000);
    }

    public static boolean equals(TimeSpan t1, TimeSpan t2) {
        return t1._ticks == t2._ticks;
    }

    public static TimeSpan FromHours(double value) {
        return TimeSpan.Interval(value, 3600000);
    }

    private static TimeSpan Interval(double value, int scale) {
        double tmp = value * (double)scale;
        double millis = tmp + (value >= 0.0 ? 0.5 : -0.5);
        if (millis > 9.22337203685477E14 || millis < -9.22337203685477E14) {
            throw new IllegalArgumentException("TimeSpan overflowed because the duration is too long");
        }
        return new TimeSpan((long)millis * 10000L);
    }

    public static TimeSpan FromMilliseconds(double value) {
        return TimeSpan.Interval(value, 1);
    }

    public static TimeSpan FromMinutes(double value) {
        return TimeSpan.Interval(value, 60000);
    }

    public static TimeSpan FromSeconds(double value) {
        return TimeSpan.Interval(value, 1000);
    }

    public static TimeSpan FromTicks(long value) {
        return new TimeSpan(value);
    }

    public static long TimeToTicks(int hour, int minute, int second) {
        long totalSeconds = (long)hour * 3600L + (long)minute * 60L + (long)second;
        if (totalSeconds > 922337203685L || totalSeconds < -922337203685L) {
            throw new IllegalArgumentException("TimeSpan overflowed because the duration is too long");
        }
        return totalSeconds * 10000000L;
    }

    public static TimeSpan OpUnaryNegation(TimeSpan t) {
        if (t._ticks == TimeSpan.MinValue._ticks) {
            throw new IllegalArgumentException("TimeSpan overflowed because the duration is too long");
        }
        return new TimeSpan(-t._ticks);
    }

    public static TimeSpan OpSubtraction(TimeSpan t1, TimeSpan t2) {
        return t1.Subtract(t2);
    }

    public static TimeSpan OpUnaryPlus(TimeSpan t) {
        return t;
    }

    public static TimeSpan OpAddition(TimeSpan t1, TimeSpan t2) {
        return t1.Add(t2);
    }

    public static boolean OpEquality(TimeSpan t1, TimeSpan t2) {
        return t1._ticks == t2._ticks;
    }

    public static boolean OpInequality(TimeSpan t1, TimeSpan t2) {
        return t1._ticks != t2._ticks;
    }

    public static boolean OpLessThan(TimeSpan t1, TimeSpan t2) {
        return t1._ticks < t2._ticks;
    }

    public static boolean OpLessThanOrEqual(TimeSpan t1, TimeSpan t2) {
        return t1._ticks <= t2._ticks;
    }

    public static boolean OpGreaterThan(TimeSpan t1, TimeSpan t2) {
        return t1._ticks > t2._ticks;
    }

    public static boolean OpGreaterThanOrEqual(TimeSpan t1, TimeSpan t2) {
        return t1._ticks >= t2._ticks;
    }

    public static TimeSpan subtract(Date from, Date to) throws IllegalArgumentException {
        NCDateTime nc1 = new NCDateTime(from);
        NCDateTime nc2 = new NCDateTime(to);
        long timespan = nc1.getTicks() - nc2.getTicks();
        if (timespan < 0L) {
            timespan *= -1L;
        }
        return new TimeSpan(timespan);
    }

    private long getTicks() {
        return this._ticks;
    }

    public int getDays() {
        return (int)(this._ticks / 864000000000L);
    }

    public int getHours() {
        return (int)(this._ticks / 36000000000L % 24L);
    }

    public int getMilliseconds() {
        return (int)(this._ticks / 10000L % 1000L);
    }

    public int getMinutes() {
        return (int)(this._ticks / 600000000L % 60L);
    }

    public int getSeconds() {
        return (int)(this._ticks / 10000000L % 60L);
    }

    public double getTotalDays() {
        return (double)this._ticks * 1.1574074074074074E-12;
    }

    public double getTotalHours() {
        return (double)this._ticks * 2.7777777777777777E-11;
    }

    public double getTotalMilliseconds() {
        double temp = (double)this._ticks * 1.0E-4;
        if (temp > 9.22337203685477E14) {
            return 9.22337203685477E14;
        }
        if (temp < -9.22337203685477E14) {
            return -9.22337203685477E14;
        }
        return temp;
    }

    public double getTotalMinutes() {
        return (double)this._ticks * 1.6666666666666667E-9;
    }

    public double getTotalSeconds() {
        return (double)this._ticks * 1.0E-7;
    }

    public TimeSpan Add(TimeSpan ts) {
        long result = this._ticks + ts._ticks;
        if (this._ticks >> 63 == ts._ticks >> 63 && this._ticks >> 63 != result >> 63) {
            throw new IllegalArgumentException("TimeSpan overflowed because the duration is too long");
        }
        return new TimeSpan(result);
    }

    public int CompareTo(Object value) {
        if (value == null) {
            return 1;
        }
        if (!(value instanceof TimeSpan)) {
            throw new IllegalArgumentException("Value must be instance of TimeSpan");
        }
        long t = ((TimeSpan)value)._ticks;
        if (this._ticks > t) {
            return 1;
        }
        if (this._ticks < t) {
            return -1;
        }
        return 0;
    }

    public int CompareTo(TimeSpan value) {
        long t = value._ticks;
        if (this._ticks > t) {
            return 1;
        }
        if (this._ticks < t) {
            return -1;
        }
        return 0;
    }

    public TimeSpan Duration() {
        if (this.getTicks() == MinValue.getTicks()) {
            throw new IllegalArgumentException("TimeSpan overflowed because the duration is too long");
        }
        return new TimeSpan(this._ticks >= 0L ? this._ticks : -this._ticks);
    }

    public boolean equals(Object value) {
        if (value instanceof TimeSpan) {
            return this._ticks == ((TimeSpan)value)._ticks;
        }
        return false;
    }

    public boolean equals(TimeSpan obj) {
        return this._ticks == obj._ticks;
    }

    public int hashCode() {
        return (int)this._ticks ^ (int)(this._ticks >> 32);
    }

    public TimeSpan Negate() {
        if (this.getTicks() == MinValue.getTicks()) {
            throw new IllegalArgumentException("TimeSpan overflowed because the duration is too long");
        }
        return new TimeSpan(-this._ticks);
    }

    public TimeSpan Subtract(TimeSpan ts) {
        long result = this._ticks - ts._ticks;
        if (this._ticks >> 63 != ts._ticks >> 63 && this._ticks >> 63 != result >> 63) {
            throw new IllegalArgumentException("TimeSpan overflowed because the duration is too long");
        }
        return new TimeSpan(result);
    }

    @Override
    public int compareTo(TimeSpan o) {
        if (o != null && o instanceof TimeSpan) {
            if (this.getTotalTicks() == o.getTotalTicks()) {
                return 0;
            }
            if (this.getTotalTicks() > o.getTotalTicks()) {
                return 1;
            }
            return -1;
        }
        throw new NullPointerException("argument can not be null");
    }

    public long getTotalTicks() {
        if (this._ticks > 0L) {
            return this._ticks;
        }
        long returnVal = this.getTotalMiliSeconds() * 10000L;
        if (returnVal > 0L) {
            return returnVal;
        }
        return 0L;
    }

    public long getTotalMiliSeconds() {
        long secondsInMsec;
        long minutesInMsec;
        if (this._ticks > 0L) {
            return this._ticks / 10000L;
        }
        long hoursInMsec = (long)this.getHours() * 3600000L;
        long returnVal = hoursInMsec + (minutesInMsec = (long)this.getMinutes() * 60000L) + (secondsInMsec = (long)this.getSeconds() * 1000L) + (long)this.getMilliseconds();
        if (returnVal > 0L) {
            return returnVal;
        }
        return 0L;
    }
}

