/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.Extensibility.ModuleInfo;
import com.alachisoft.ncache.client.CacheDataModificationListener;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.CacheSyncDependency;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.ValueEmissary;
import com.alachisoft.ncache.client.internal.datastructure.DataTypeCreator;
import com.alachisoft.ncache.common.caching.EntryType;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.NamedTagsDictionary;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.datasource.ResyncOptions;
import com.alachisoft.ncache.runtime.caching.expiration.Expiration;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public class CacheItem
implements Cloneable {
    private Object _value;
    private Object _currentValue;
    private Expiration _expiration = new Expiration();
    private CacheItemPriority priority;
    private CacheItemVersion version;
    private Date creationTime = null;
    private Date lastModifiedTime = null;
    private List<Tag> tags;
    private NamedTagsDictionary namedTags;
    private ResyncOptions resyncOptions;
    private String group;
    private CacheSyncDependency syncDependency;
    private CacheDependency dependency;
    private int size;
    private BitSet flagMap;
    private HashMap queryInfo;
    private CacheDataModificationListener cacheItemRemovedListener;
    private CacheDataModificationListener cacheItemUpdatedListener;
    private EventDataFilter itemUpdatedDataFilter;
    private EventDataFilter itemRemovedDataFilter;
    private String typeName;
    private CacheImpl cacheInstance;
    private EntryType entryType;
    private boolean isModuleData;
    private ModuleInfo moduleInfo;

    public CacheItem() {
        this.setCacheItemPriority(CacheItemPriority.Default);
    }

    public CacheItem(Object value) {
        this._value = value;
        this.setCacheItemPriority(CacheItemPriority.Default);
    }

    public final Expiration getExpiration() {
        return this._expiration;
    }

    public final void setExpiration(Expiration value) {
        this._expiration = value;
    }

    public final CacheItemPriority getCacheItemPriority() {
        return this.priority;
    }

    public final void setCacheItemPriority(CacheItemPriority value) {
        this.priority = value;
    }

    public final CacheItemVersion getCacheItemVersion() {
        return this.version;
    }

    public final void setCacheItemVersion(CacheItemVersion value) {
        this.version = value;
    }

    public final Date getCreationTime() {
        return this.creationTime;
    }

    public final Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final List<Tag> getTags() {
        return this.tags;
    }

    public final void setTags(List<Tag> value) {
        this.tags = value;
    }

    public final NamedTagsDictionary getNamedTags() {
        return this.namedTags;
    }

    public final void setNamedTags(NamedTagsDictionary value) {
        this.namedTags = value;
    }

    public final ResyncOptions getResyncOptions() {
        return this.resyncOptions;
    }

    public final void setResyncOptions(ResyncOptions value) {
        this.resyncOptions = value;
    }

    public final String getGroup() {
        return this.group;
    }

    public final void setGroup(String value) {
        this.group = value;
    }

    public final CacheSyncDependency getSyncDependency() {
        return this.syncDependency;
    }

    public final void setSyncDependency(CacheSyncDependency value) {
        this.syncDependency = value;
    }

    public final CacheDependency getDependency() {
        return this.dependency;
    }

    public final void setDependency(CacheDependency value) {
        this.dependency = value;
    }

    void setLastModifiedTime(Date value) {
        this.lastModifiedTime = value;
    }

    void setCreationTime(Date value) {
        this.creationTime = value;
    }

    public BitSet getFlagMapInternal() {
        return this.flagMap;
    }

    void setFlagMapInternal(BitSet value) {
        this.flagMap = value;
    }

    HashMap getQueryInfoInternal() {
        return this.queryInfo;
    }

    void setQueryInfo(HashMap value) {
        this.queryInfo = value;
    }

    CacheDataModificationListener getCacheItemRemovedListener() {
        return this.cacheItemRemovedListener;
    }

    void setCacheItemRemovedListener(CacheDataModificationListener value) {
        this.cacheItemRemovedListener = value;
    }

    CacheDataModificationListener getCacheItemUpdatedListener() {
        return this.cacheItemUpdatedListener;
    }

    void setCacheItemUpdatedListener(CacheDataModificationListener value) {
        this.cacheItemUpdatedListener = value;
    }

    EventDataFilter getItemUpdatedDataFilter() {
        return this.itemUpdatedDataFilter;
    }

    void setItemUpdatedDataFilter(EventDataFilter value) {
        this.itemUpdatedDataFilter = value;
    }

    EventDataFilter getItemRemovedDataFilter() {
        return this.itemRemovedDataFilter;
    }

    void setItemRemovedDataFilter(EventDataFilter value) {
        this.itemRemovedDataFilter = value;
    }

    String getTypeName() {
        return this.typeName;
    }

    public void setTypeNameInternal(String value) {
        this.typeName = value;
    }

    CacheImpl getCacheInstance() {
        return this.cacheInstance;
    }

    void setCacheInstance(CacheImpl value) {
        this.cacheInstance = value;
    }

    EntryType getEntryType() {
        return this.entryType;
    }

    void setEntryType(EntryType value) {
        this.entryType = value;
    }

    boolean getIsModuleData() {
        return this.isModuleData;
    }

    void setIsModuleData(boolean value) {
        this.isModuleData = value;
    }

    ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    void setModuleInfo(ModuleInfo value) {
        this.moduleInfo = value;
    }

    public final void addCacheDataNotificationListener(CacheDataModificationListener listener, EnumSet<EventType> eventType, EventDataFilter datafilter) {
        if (listener == null) {
            return;
        }
        if (eventType.contains(EventType.ItemRemoved)) {
            this.setCacheItemRemovedListener(listener);
            this.setItemRemovedDataFilter(datafilter);
        }
        if (eventType.contains(EventType.ItemUpdated)) {
            this.setCacheItemUpdatedListener(listener);
            this.setItemUpdatedDataFilter(datafilter);
        }
    }

    public void removeCacheDataNotificationListener(CacheDataModificationListener listener, EnumSet<EventType> eventEnumSet) {
        if (listener == null) {
            return;
        }
        if (eventEnumSet.contains(EventType.ItemRemoved)) {
            this.setCacheItemRemovedListener(listener);
            this.setItemRemovedDataFilter(EventDataFilter.None);
        }
        if (eventEnumSet.contains(EventType.ItemUpdated)) {
            this.setCacheItemUpdatedListener(listener);
            this.setItemUpdatedDataFilter(EventDataFilter.None);
        }
    }

    public final <T> T getValue(Class<?> cls) throws OperationFailedException {
        if (this._value instanceof ValueEmissary) {
            Object instanceofT = null;
            if (this._currentValue != null) {
                try {
                    return (T)this._currentValue;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            ValueEmissary emissary = (ValueEmissary)(this._value instanceof ValueEmissary ? this._value : null);
            if (this.cacheInstance == null) {
                return (T)emissary.getData();
            }
            switch (emissary.getType()) {
                case CacheItem: {
                    this._currentValue = this.cacheInstance.safeDeserialize(emissary.getData(), this.cacheInstance.getSerializationContext(), this.flagMap, UserObjectType.CacheItem, cls);
                    break;
                }
                default: {
                    this._currentValue = DataTypeCreator.createDataTypeHandle(emissary.getType(), emissary.getKey(), this.cacheInstance, cls);
                }
            }
            return (T)this._currentValue;
        }
        return (T)this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public final Object clone() {
        CacheItem newItem = new CacheItem();
        newItem.setCacheItemRemovedListener(this.getCacheItemRemovedListener());
        newItem.setCacheItemUpdatedListener(this.getCacheItemUpdatedListener());
        newItem.setCreationTime(this.getCreationTime());
        newItem.setDependency(this.getDependency());
        newItem.setExpiration(this.getExpiration());
        newItem.flagMap = this.flagMap;
        newItem.setGroup(this.getGroup());
        newItem.setItemRemovedDataFilter(this.getItemRemovedDataFilter());
        newItem.setItemUpdatedDataFilter(this.getItemUpdatedDataFilter());
        newItem.setTypeNameInternal(this.getTypeName());
        newItem.setLastModifiedTime(this.getLastModifiedTime());
        newItem.setNamedTags(this.getNamedTags());
        newItem.setCacheItemPriority(this.getCacheItemPriority());
        newItem.queryInfo = this.queryInfo;
        newItem.setResyncOptions(this.getResyncOptions());
        newItem.size = this.size;
        newItem.setSyncDependency(this.getSyncDependency());
        newItem.setTags(this.getTags());
        newItem._value = this._value;
        newItem.setCacheItemVersion(this.getCacheItemVersion());
        newItem.setCacheInstance(this.getCacheInstance());
        newItem.setIsModuleData(this.getIsModuleData());
        return newItem;
    }
}

