/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client;

import Alachisoft.NCache.Caching.CacheFactory;
import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Monitoring.CategoriesConstants;
import Alachisoft.NCache.Common.Monitoring.MetricsPublisher;
import Alachisoft.NCache.Common.Monitoring.MonitoringConfigManager;
import Alachisoft.NCache.Config.Dom.CacheServerConfig;
import Alachisoft.NCache.Management.CacheConfig;
import Alachisoft.NCache.Management.CacheServerModerator;
import Alachisoft.NCache.Management.MetricsTransporterFactoryImpl;
import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.CacheCollection;
import com.alachisoft.ncache.client.CacheConnection;
import com.alachisoft.ncache.client.CacheConnectionOptions;
import com.alachisoft.ncache.client.ClientCacheSyncMode;
import com.alachisoft.ncache.client.Credentials;
import com.alachisoft.ncache.client.IsolationLevel;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.CacheImplBase;
import com.alachisoft.ncache.client.internal.caching.ClientCache;
import com.alachisoft.ncache.client.internal.caching.DisconnectedClientCache;
import com.alachisoft.ncache.client.internal.caching.FailSafeClientCache;
import com.alachisoft.ncache.client.internal.caching.InprocCache;
import com.alachisoft.ncache.client.internal.caching.RemoteCache;
import com.alachisoft.ncache.client.internal.statistics.PerfStatsCollector;
import com.alachisoft.ncache.client.internal.util.ClientConfiguration;
import com.alachisoft.ncache.client.internal.util.ConfigReader;
import com.alachisoft.ncache.client.internal.util.DirectoryUtil;
import com.alachisoft.ncache.common.caching.statistics.monitoring.PublisherContextMetaPublisher;
import com.alachisoft.ncache.common.monitoring.MetricsTransporterFactory;
import com.alachisoft.ncache.runtime.cachemanagement.CacheContext;
import com.alachisoft.ncache.runtime.cachemanagement.CacheHealth;
import com.alachisoft.ncache.runtime.cachemanagement.ServerNode;
import com.alachisoft.ncache.runtime.caching.ClientInfo;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public final class CacheManager {
    private static String _clientCacheID = "";
    private static CacheImpl _cache = new CacheImpl();
    private static boolean s_exceptions = true;
    private static CacheCollection _cacheCollection = new CacheCollection();
    private static String _configPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheCollection getCaches() {
        CacheCollection cacheCollection = _cacheCollection;
        synchronized (cacheCollection) {
            return _cacheCollection;
        }
    }

    public static boolean getExceptionsEnabled() {
        if (_cache != null) {
            s_exceptions = _cache.getExceptionEnabled();
        }
        return s_exceptions;
    }

    public static void setExceptionsEnabled(boolean value) {
        s_exceptions = value;
        if (_cache != null) {
            _cache.setExceptionsEnabled(value);
        }
    }

    public static String getConfigPath() {
        return _configPath;
    }

    public static void setConfigPath(String path) {
        _configPath = path;
    }

    public static Cache getCache(String cacheName) throws Exception {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)cacheName)) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: cacheName");
        }
        return CacheManager.getCache(cacheName, null, null, null);
    }

    public static Cache getCache(String cacheName, CacheConnectionOptions cacheConnectionOptions) throws Exception {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)cacheName)) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: cacheName");
        }
        if (cacheConnectionOptions == null) {
            throw new IllegalArgumentException("Connection Options");
        }
        return CacheManager.getCache(cacheName, cacheConnectionOptions, null, null);
    }

    public static Cache getCache(String cacheName, CacheConnectionOptions cacheConnectionOptions, String clientCacheName, CacheConnectionOptions clientCacheConnectionOptions) throws Exception {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)cacheName)) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: cacheName");
        }
        if (clientCacheName != null) {
            return CacheManager.getCachePrivate(cacheName, cacheConnectionOptions, clientCacheName, clientCacheConnectionOptions);
        }
        boolean isPessimistic = false;
        RefObject tempRef_isPessimistic = new RefObject((Object)isPessimistic);
        boolean isClientCache = CacheManager.IsClientCache(cacheName, (RefObject<Boolean>)tempRef_isPessimistic);
        isPessimistic = (Boolean)tempRef_isPessimistic.argvalue;
        return CacheManager.getCache(cacheName, cacheConnectionOptions, isClientCache, isPessimistic);
    }

    private static Map<ServerNode, List<ClientInfo>> getCacheClients(String cacheName, CacheConnection connection) throws ManagementException {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)cacheName)) {
            throw new IllegalArgumentException("cacheName");
        }
        String serverName = connection != null ? connection.getServer() : "";
        int port = connection != null ? connection.getPort() : 0;
        return CacheServerModerator.getCacheClients((String)cacheName.toLowerCase(), (String)serverName, (CacheContext)CacheContext.TayzGrid, (int)port);
    }

    private static CacheHealth getCacheHealth(String cacheName, CacheConnection connection) throws ManagementException {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)cacheName)) {
            throw new IllegalArgumentException("cacheName");
        }
        String serverName = connection != null ? connection.getServer() : "";
        int port = connection != null ? connection.getPort() : 0;
        return CacheServerModerator.getCacheHealth((String)cacheName.toLowerCase(), (String)serverName, (CacheContext)CacheContext.TayzGrid, (int)port);
    }

    public static void startCache(String cacheName, CacheConnection connection) throws ManagementException, UnknownHostException, ConfigurationException {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)cacheName)) {
            throw new IllegalArgumentException("cacheName");
        }
        Credentials primaryUserCredentials = null;
        Credentials secondaryUserCredentials = null;
        if (connection != null) {
            if (connection.getUserCredentials() == null) {
                ArrayList<Credentials> list = CacheHelper.LoadCredentialsFromConfig(cacheName);
                primaryUserCredentials = (Credentials)list.get(0);
                secondaryUserCredentials = (Credentials)list.get(1);
            } else {
                primaryUserCredentials = connection.getUserCredentials();
            }
        }
        String serverName = connection != null ? connection.getServer() : "";
        int port = connection != null ? connection.getPort() : 8250;
        int maxTries = 2;
        Credentials credentials = CacheManager.verifyCredentials(primaryUserCredentials, secondaryUserCredentials);
        while (true) {
            try {
                CacheServerModerator.StartCache((String)cacheName, (String)serverName, (int)port, (String)credentials.getUserID(), (String)credentials.getPassword());
                return;
            }
            catch (Exception ex) {
                if (--maxTries == 0) {
                    throw ex;
                }
                if (secondaryUserCredentials == null) {
                    throw ex;
                }
                credentials = secondaryUserCredentials;
                if (maxTries > 0) continue;
                return;
            }
            break;
        }
    }

    public static void stopCache(String cacheName, CacheConnection connection, boolean gracefullyShutDownNode) throws ManagementException, UnknownHostException, ConfigurationException {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)cacheName)) {
            throw new IllegalArgumentException("cacheName");
        }
        Credentials primaryUserCredentials = null;
        Credentials secondaryUserCredentials = null;
        if (connection != null) {
            if (connection.getUserCredentials() == null) {
                ArrayList<Credentials> list = CacheHelper.LoadCredentialsFromConfig(cacheName);
                primaryUserCredentials = list.get(0);
                secondaryUserCredentials = list.get(1);
            } else {
                primaryUserCredentials = connection.getUserCredentials();
            }
        }
        String serverName = connection != null ? connection.getServer() : "";
        int port = connection != null ? connection.getPort() : 0;
        int maxTries = 2;
        Credentials credentials = CacheManager.verifyCredentials(primaryUserCredentials, secondaryUserCredentials);
        while (true) {
            try {
                CacheServerModerator.StopCache((String)cacheName, (String)serverName, (int)port, (String)credentials.getUserID(), (String)credentials.getPassword(), (boolean)gracefullyShutDownNode);
                return;
            }
            catch (Exception ex) {
                if (--maxTries == 0) {
                    throw ex;
                }
                if (secondaryUserCredentials == null) {
                    throw ex;
                }
                credentials = secondaryUserCredentials;
                if (maxTries > 0) continue;
                return;
            }
            break;
        }
    }

    public static CacheImpl getCache(String cacheName, CacheConnectionOptions cacheConnectionOptions, boolean isClientCache, boolean isPessimistic) throws Exception {
        if (cacheConnectionOptions == null) {
            cacheConnectionOptions = new CacheConnectionOptions();
        }
        cacheConnectionOptions.initialize(cacheName);
        if (isClientCache) {
            CacheConnectionOptions clientCacheConnectionOptions = new CacheConnectionOptions();
            clientCacheConnectionOptions.setClientCacheMode(isPessimistic ? ClientCacheSyncMode.Pessimistic : ClientCacheSyncMode.Optimistic);
            return CacheManager.getCachePrivate(cacheName, cacheConnectionOptions, _clientCacheID, clientCacheConnectionOptions);
        }
        CacheImpl cache = CacheManager.getCacheInternal(cacheName, cacheConnectionOptions);
        cache.setMessagingServiceCacheImpl(cache.getCacheImpl());
        cache.setDataTypeManagerImpl(cache);
        return cache;
    }

    private static boolean IsClientCache(String clientCacheName, RefObject<Boolean> isPessimistic) throws Exception {
        if (clientCacheName == null) {
            throw new IllegalArgumentException("cacheId");
        }
        String clientCacheID = ConfigReader.ClientCacheID("client.ncconf", clientCacheName, isPessimistic).trim();
        if (clientCacheID.length() > 0) {
            _clientCacheID = clientCacheID.toLowerCase();
            return true;
        }
        return false;
    }

    private static CacheImpl getCachePrivate(String cacheName, CacheConnectionOptions cacheConnectionOptions, String clientCacheName, CacheConnectionOptions clientCacheConnectionOptions) throws Exception {
        String userId = null;
        String password = null;
        if (cacheName.isEmpty()) {
            throw new IllegalArgumentException("cacheName");
        }
        if (cacheName.toLowerCase().compareTo(clientCacheName.toLowerCase()) == 0) {
            throw new OperationFailedException(10000, ErrorMessages.getErrorMessage((int)10000, (String[])new String[0]));
        }
        if (cacheConnectionOptions == null) {
            cacheConnectionOptions = new CacheConnectionOptions();
        }
        if (clientCacheConnectionOptions == null) {
            clientCacheConnectionOptions = new CacheConnectionOptions();
        }
        cacheConnectionOptions.setIsolationLevel(IsolationLevel.OutProc);
        cacheConnectionOptions.initialize(cacheName);
        CacheImpl l2Cache = CacheManager.getCacheInternal(cacheName, cacheConnectionOptions);
        l2Cache.setMessagingServiceCacheImpl(l2Cache.getCacheImpl());
        l2Cache.setDataTypeManagerImpl(l2Cache);
        clientCacheConnectionOptions.initialize(clientCacheName);
        if (clientCacheConnectionOptions.getUserCredentials() != null && clientCacheConnectionOptions.getUserCredentials().getUserID() != null && clientCacheConnectionOptions.getUserCredentials().getPassword() != null) {
            userId = clientCacheConnectionOptions.getUserCredentials().getUserID();
            password = clientCacheConnectionOptions.getUserCredentials().getPassword();
        }
        if (DotNetToJavaStringHelper.isNullOrEmpty(userId) && DotNetToJavaStringHelper.isNullOrEmpty(password) && cacheConnectionOptions.getUserCredentials() != null && cacheConnectionOptions.getUserCredentials().getUserID() != null && cacheConnectionOptions.getUserCredentials().getPassword() != null) {
            userId = cacheConnectionOptions.getUserCredentials().getUserID();
            password = cacheConnectionOptions.getUserCredentials().getPassword();
            clientCacheConnectionOptions.setUserCredentials(new Credentials(userId, password));
        }
        boolean enableFaultTolerance = cacheConnectionOptions.isSkipUnAvailableClientCache();
        CacheImpl l1Cache = CacheManager.initializeClientCache(clientCacheName, clientCacheConnectionOptions, l2Cache, !enableFaultTolerance);
        boolean isPessim = false;
        RefObject tempRef_isPessim = new RefObject((Object)isPessim);
        if (CacheManager.IsClientCache(cacheName, (RefObject<Boolean>)tempRef_isPessim) && !l1Cache.isInProc()) {
            isPessim = (Boolean)tempRef_isPessim.argvalue;
            if (_clientCacheID.equals(clientCacheName)) {
                if (enableFaultTolerance) {
                    return new FailSafeClientCache(l2Cache, l1Cache, userId, password, isPessim, clientCacheConnectionOptions, clientCacheName, cacheConnectionOptions.getRetryL1ConnectionInterval());
                }
                return new DisconnectedClientCache(l2Cache, l1Cache, userId, password, isPessim);
            }
        }
        return new ClientCache(l2Cache, l1Cache, userId, password, clientCacheConnectionOptions.getClientCacheMode() == ClientCacheSyncMode.Pessimistic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheImpl getCacheInternal(String cacheName, CacheConnectionOptions cacheConnectionOptions) throws Exception {
        if (cacheName == null) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: cacheName");
        }
        if (cacheName.isEmpty()) {
            throw new IllegalArgumentException("cacheId cannot be an empty string");
        }
        IsolationLevel mode = cacheConnectionOptions.getIsolationMode();
        Credentials primaryUserCredentials = cacheConnectionOptions.getUserCredentials() == null ? new Credentials(null, null) : cacheConnectionOptions.getUserCredentials();
        Credentials secondaryUserCredentials = cacheConnectionOptions.getSecondaryUserCredentials() == null ? new Credentials(null, null) : cacheConnectionOptions.getSecondaryUserCredentials();
        String cacheIdWithAlias = cacheName + (String)(!cacheConnectionOptions.getHaveBridgeCacheAlias() ? "" : "(" + cacheConnectionOptions.getBridgeCacheAlias() + ")");
        int maxTries = 2;
        Credentials securityParams = primaryUserCredentials;
        CacheServerConfig config = null;
        if (mode != IsolationLevel.OutProc) {
            do {
                try {
                    config = DirectoryUtil.getCacheDom(cacheName, securityParams == null ? null : securityParams.getUserID(), securityParams == null ? null : securityParams.getPassword(), mode == IsolationLevel.InProc);
                }
                catch (SecurityException se) {
                    if (--maxTries == 0) {
                        throw se;
                    }
                    securityParams = secondaryUserCredentials;
                    continue;
                }
                catch (Exception ex) {
                    if (mode == IsolationLevel.Default) {
                        mode = IsolationLevel.OutProc;
                    }
                    throw ex;
                }
                if (config == null) break;
                if (config.getCacheType().toLowerCase().equals("clustered-cache")) {
                    throw new OperationFailedException(10001, ErrorMessages.getErrorMessage((int)10001, (String[])new String[0]));
                }
                switch (mode) {
                    case InProc: {
                        config.setInProc(true);
                        break;
                    }
                    case OutProc: {
                        config.setInProc(false);
                    }
                }
                break;
            } while (maxTries > 0);
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            CacheImpl primaryCache = null;
            Object object = _cacheCollection;
            synchronized (object) {
                if (!_cacheCollection.contains(cacheIdWithAlias)) {
                    block52: {
                        MetricsTransporterFactoryImpl transporterFactory = new MetricsTransporterFactoryImpl();
                        CacheImplBase cacheImpl = null;
                        PerfStatsCollector perfStatsCollector = null;
                        if (config != null && config.getInProc()) {
                            Alachisoft.NCache.Caching.Cache ncache = null;
                            CacheImpl cache = null;
                            maxTries = 2;
                            securityParams = primaryUserCredentials;
                            while (true) {
                                try {
                                    if (config.getCacheType().equals("partitioned-replicas-server") || config.getCacheType().equals("mirror-server")) {
                                        String name = config.getCacheType().equals("mirror-server") ? "Mirror Topology" : "Partitioned Replica Topology";
                                        throw new OperationFailedException(10002, ErrorMessages.getErrorMessage((int)10002, (String[])new String[]{name}));
                                    }
                                    if (config.getInProc() && !config.getCacheType().equalsIgnoreCase("client-cache")) {
                                        throw new OperationNotSupportedException(10000, ErrorMessages.getErrorMessage((int)10000, (String[])new String[]{cacheName}));
                                    }
                                    CacheConfig cacheConfig = CacheConfig.FromDom((CacheServerConfig)config);
                                    cache = new CacheImpl(null, cacheConfig);
                                    ncache = securityParams != null ? CacheFactory.CreateFromPropertyString((String)cacheConfig.getPropertyString(), (CacheServerConfig)config, (String)securityParams.getUserID(), (String)securityParams.getPassword(), (boolean)false, (boolean)false) : CacheFactory.CreateFromPropertyString((String)cacheConfig.getPropertyString(), (CacheServerConfig)config, null, null, (boolean)false, (boolean)false);
                                    cacheImpl = new InprocCache(ncache, cacheConfig, cache, securityParams.getUserID(), securityParams.getPassword());
                                    cache.setCacheImpl(cacheImpl);
                                    if (primaryCache == null) {
                                        primaryCache = cache;
                                        primaryCache.setSecurityParameters(securityParams);
                                        break block52;
                                    }
                                    primaryCache.addSecondaryInprocInstance(cache);
                                }
                                catch (SecurityException se) {
                                    if (--maxTries == 0) {
                                        throw se;
                                    }
                                    securityParams = secondaryUserCredentials;
                                    if (maxTries > 0) continue;
                                }
                                break;
                            }
                        }
                        maxTries = 2;
                        securityParams = primaryUserCredentials;
                        while (true) {
                            try {
                                perfStatsCollector = new PerfStatsCollector(cacheName, false);
                                primaryCache = new CacheImpl(null, cacheName, perfStatsCollector);
                                cacheImpl = new RemoteCache(cacheName, primaryCache, securityParams, cacheConnectionOptions, perfStatsCollector);
                                primaryCache.setSecurityParameters(securityParams);
                                primaryCache.setCacheImpl(cacheImpl);
                                perfStatsCollector.initializePerfCounters(false);
                                try {
                                    if (cacheConnectionOptions.getFromClientCache() || cacheConnectionOptions.getIsBridgeClient() || AppUtil.isMavenOnlyInstallation()) break;
                                    MonitoringConfigManager monitoringConfigManager = new MonitoringConfigManager();
                                    ClientConfiguration clientConfig = new ClientConfiguration(null);
                                    clientConfig.setLoadCacheConfiguration(false);
                                    clientConfig.loadLocalServerIP();
                                    if (monitoringConfigManager.getCongigFile()) {
                                        MetricsPublisher metricsPublisher = new MetricsPublisher((MetricsTransporterFactory)transporterFactory, (PublisherContextMetaPublisher)cacheImpl);
                                        metricsPublisher.setNCacheLog(cacheImpl.getNCacheLog());
                                        metricsPublisher.setSessionId(cacheImpl.getMonitoringSessionId());
                                        metricsPublisher.setCacheConfigID(cacheImpl.getCacheConfigId());
                                        perfStatsCollector.setCategory(monitoringConfigManager.GetCategory(CategoriesConstants.NCacheClient));
                                        perfStatsCollector.setStatsPublisher(metricsPublisher);
                                        perfStatsCollector.RegisterOnMetricsPublisher();
                                        metricsPublisher.Initialize();
                                    }
                                    perfStatsCollector.startPublishingCounters(clientConfig.getLocalServerIP());
                                }
                                catch (Exception monitoringConfigManager) {}
                            }
                            catch (SecurityException se) {
                                if (--maxTries == 0) {
                                    throw se;
                                }
                                securityParams = secondaryUserCredentials;
                                if (maxTries > 0) continue;
                            }
                            break;
                        }
                    }
                    if (primaryCache != null) {
                        primaryCache.initializeCompactFramework();
                        _cacheCollection.addCache(cacheIdWithAlias, primaryCache);
                        primaryCache.InitializeEncryption();
                    }
                } else {
                    CacheImpl cacheImpl = _cacheCollection.getCache(cacheIdWithAlias, false);
                    synchronized (cacheImpl) {
                        block53: {
                            CacheImpl tempVar = _cacheCollection.getCache(cacheIdWithAlias, false);
                            CacheImpl cacheImpl2 = primaryCache = tempVar instanceof CacheImpl ? tempVar : null;
                            if (primaryUserCredentials != null && !DotNetToJavaStringHelper.isNullOrEmpty((String)primaryUserCredentials.getUserID()) && !DotNetToJavaStringHelper.isNullOrEmpty((String)primaryUserCredentials.getPassword())) {
                                try {
                                    primaryCache.checkUserAuthorization(cacheName.toLowerCase(), primaryUserCredentials.getPassword(), primaryUserCredentials.getUserID());
                                }
                                catch (Exception ex) {
                                    if (!(ex instanceof SecurityException)) break block53;
                                    primaryCache.checkUserAuthorization(cacheName.toLowerCase(), secondaryUserCredentials.getPassword(), secondaryUserCredentials.getUserID());
                                }
                            }
                        }
                        primaryCache.addRef();
                    }
                }
            }
            object = _cache;
            synchronized (object) {
                if (_cache.getCacheImpl() == null) {
                    primaryCache.setExceptionEnabled(CacheManager.getExceptionsEnabled());
                    _cache = primaryCache;
                    _cache.setDataTypeManagerImpl(_cache);
                }
            }
            // ** MonitorExit[var9_12] (shouldn't be in output)
            return primaryCache;
        }
    }

    private static Credentials verifyCredentials(Credentials primaryCredentials, Credentials secondaryCredentials) {
        Credentials credentials = primaryCredentials != null ? primaryCredentials : secondaryCredentials;
        return credentials != null ? credentials : new Credentials("", "");
    }

    public static CacheImpl initializeClientCache(String clientCacheName, CacheConnectionOptions clientCacheConnectionOptions, CacheImpl l2Cache, boolean throwInitializationError) throws Exception {
        try {
            CacheImpl cache = CacheManager.getCacheInternal(clientCacheName, clientCacheConnectionOptions);
            cache.setMessagingServiceCacheImpl(l2Cache.getCacheImpl());
            cache.setDataTypeManagerImpl(l2Cache);
            return cache;
        }
        catch (CacheException | RuntimeException ex) {
            if (throwInitializationError || !ex.getMessage().contains("No server")) {
                throw ex;
            }
            return null;
        }
    }
}

