/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Common.DataReader.ColumnCollection;
import Alachisoft.NCache.Common.DataReader.RecordRow;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumerator;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.Queries.AverageResult;
import com.alachisoft.ncache.client.CacheReader;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.DataReaderCommon;
import com.alachisoft.ncache.runtime.JSON.JsonUtil;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import tangible.RefObject;

class CacheDataReader
extends DataReaderCommon
implements CacheReader {
    private RecordSetEnumerator _recordSetEnumerator;
    private RecordRow _currentRow;
    private ColumnCollection _columns;
    private int _hiddenColumnCount = 0;

    public CacheDataReader(RecordSetEnumerator recordSetEnumerator) {
        this(null, recordSetEnumerator);
    }

    public CacheDataReader(CacheImpl cache, RecordSetEnumerator recordSetEnumerator) {
        this._cache = cache;
        this._recordSetEnumerator = recordSetEnumerator;
        ColumnCollection columnCollection = this._columns = this._recordSetEnumerator != null ? this._recordSetEnumerator.getColumnCollection() : null;
        if (this._columns != null) {
            this._hiddenColumnCount = this._columns.getHiddenColumnCount();
        }
    }

    @Override
    public int getFieldCount() {
        return this._columns == null ? 0 : this._columns.getCount() - this._hiddenColumnCount;
    }

    @Override
    public void close() throws Exception {
        if (this._recordSetEnumerator != null) {
            this._recordSetEnumerator.close();
        }
        this._currentRow = null;
        this._columns = null;
    }

    @Override
    public boolean read() {
        if (this._recordSetEnumerator == null) {
            return false;
        }
        boolean next = this._recordSetEnumerator.moveNext();
        if (next) {
            this._currentRow = this._recordSetEnumerator.getCurrent();
            this._columns = this._currentRow.getColumns();
        }
        return next;
    }

    @Override
    public boolean getBoolean(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            return (Boolean)this._currentRow.get(index);
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public String getString(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow.get(index);
            if (obj instanceof AverageResult) {
                return (String)JsonUtil.getValueAs((Object)((AverageResult)obj).getAverage(), String.class);
            }
            return obj == null ? null : obj.toString();
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow.get(index);
            if (obj instanceof AverageResult) {
                return (BigDecimal)JsonUtil.getValueAs((Object)((AverageResult)obj).getAverage(), BigDecimal.class);
            }
            return (BigDecimal)obj;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public double getDouble(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow.get(index);
            if (obj instanceof AverageResult) {
                return (Double)JsonUtil.getValueAs((Object)((AverageResult)obj).getAverage(), Double.class);
            }
            return (Double)obj;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public short getShort(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow.get(index);
            if (obj instanceof AverageResult) {
                return (Short)JsonUtil.getValueAs((Object)((AverageResult)obj).getAverage(), Short.class);
            }
            return (Short)obj;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public int getInt(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow.get(index);
            if (obj instanceof AverageResult) {
                return (Integer)JsonUtil.getValueAs((Object)((AverageResult)obj).getAverage(), Integer.class);
            }
            return (Integer)obj;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public long getLong(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow.get(index);
            if (obj instanceof AverageResult) {
                return (Long)JsonUtil.getValueAs((Object)((AverageResult)obj).getAverage(), Long.class);
            }
            return (Long)obj;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public <T> T getValue(int index, Class<?> cls) throws OperationFailedException, IOException, ClassNotFoundException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow.getColumnValue(index);
            if (!this._currentRow.getColumns().get(index).getIsHidden()) {
                CompressedValueEntry cmpEntry = (CompressedValueEntry)(obj instanceof CompressedValueEntry ? obj : null);
                if (cmpEntry != null) {
                    obj = this.extractFromCompressedValueEntry(cmpEntry, cls);
                }
                if (obj instanceof AverageResult) {
                    return (T)JsonUtil.getValueAs((Object)((AverageResult)obj).getAverage(), cls);
                }
                return (T)JsonUtil.getValueAs((Object)obj, cls);
            }
            throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public <T> T getValue(String columnName, Class<?> cls) throws IOException, ClassNotFoundException, OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (this._currentRow.getColumns().contains(columnName)) {
            CompressedValueEntry cmpEntry;
            Object obj = this._currentRow.getColumnValue(columnName);
            if (!this._currentRow.getColumns().get(columnName).getIsHidden() && (cmpEntry = (CompressedValueEntry)(obj instanceof CompressedValueEntry ? obj : null)) != null) {
                obj = this.extractFromCompressedValueEntry(cmpEntry, cls);
            }
            if (obj instanceof AverageResult) {
                return (T)JsonUtil.getValueAs((Object)((AverageResult)obj).getAverage(), cls);
            }
            return (T)JsonUtil.getValueAs((Object)obj, cls);
        }
        throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
    }

    @Override
    public int getValues(Object[] objects, Class<?> cls) throws IOException, ClassNotFoundException, OperationFailedException {
        if (objects == null) {
            throw new IllegalArgumentException("objects");
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("Index was outside the bounds of the array.");
        }
        if (objects.length < this.getFieldCount()) {
            for (int i = 0; i < objects.length; ++i) {
                objects[i] = this.getSingleValue(i, cls);
            }
            return objects.length;
        }
        for (int i = 0; i < this.getFieldCount(); ++i) {
            objects[i] = this.getSingleValue(i, cls);
        }
        return this.getFieldCount();
    }

    private <T> T getSingleValue(int index, Class<?> cls) throws IOException, ClassNotFoundException, OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow.getColumnValue(index);
            if (!this._currentRow.getColumns().get(index).getIsHidden()) {
                CompressedValueEntry cmpEntry = (CompressedValueEntry)(obj instanceof CompressedValueEntry ? obj : null);
                if (cmpEntry != null) {
                    obj = this.extractFromCompressedValueEntry(cmpEntry, cls);
                }
                if (obj instanceof AverageResult) {
                    return (T)((AverageResult)obj).getAverage();
                }
                return (T)obj;
            }
            return null;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public String getName(int columnIndex) {
        if (this._columns == null) {
            return null;
        }
        if (columnIndex >= 0 && columnIndex < this.getFieldCount()) {
            if (this._columns.get(columnIndex).getIsHidden()) {
                throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
            }
            return this._columns.getColumnName(columnIndex);
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public int getOrdinal(String columnName) {
        if (this._columns == null) {
            return -1;
        }
        if (this._columns.contains(columnName)) {
            if (this._columns.get(columnName).getIsHidden()) {
                throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
            }
            return this._columns.getColumnIndex(columnName);
        }
        throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
    }

    @Override
    public boolean getIsClosed() {
        return this._recordSetEnumerator == null;
    }

    @Override
    public Date getDate(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow.getColumnValue(index);
            return (Date)obj;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    protected boolean tryGetKeyFromCurrentRow(RefObject<String> key) {
        Object possiblyKey = this._currentRow.get("$KEY$");
        key.argvalue = possiblyKey == null ? null : possiblyKey.toString();
        return key.argvalue != null;
    }
}

