/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.AutoExpiration.DependencyHelper;
import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.Cache;
import Alachisoft.NCache.Caching.CacheEntry;
import Alachisoft.NCache.Caching.CacheSynchronization.ISyncCache;
import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Caching.CompactCacheEntry;
import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Caching.Messaging.Message;
import Alachisoft.NCache.Caching.OperationContext;
import Alachisoft.NCache.Caching.OperationContextFieldName;
import Alachisoft.NCache.Caching.OperationContextOperationType;
import Alachisoft.NCache.Caching.Queries.QueryResultSet;
import Alachisoft.NCache.Caching.TagComparisonType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumerator;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumeratorImpl;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataTypes.CollectionCreateOrGetOperation;
import Alachisoft.NCache.Common.DataTypes.CollectionOperation;
import Alachisoft.NCache.Common.DataTypes.Counter.CounterGetOperation;
import Alachisoft.NCache.Common.DataTypes.Counter.CounterOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryAddOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryContainsOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryGetOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryRemoveOperation;
import Alachisoft.NCache.Common.DataTypes.GetCollectionChunkOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetAddOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetContainsOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetGetRandomOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetRemoveOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetRemoveRandomOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithPivotOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithoutIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListGetBulkOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListGetItemOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListInsertWithIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListRemoveWithIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListRemoveWithoutIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListSearchOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueDequeueOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueEnqueueOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueuePeekOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueSearchOperation;
import Alachisoft.NCache.Common.DataTypes.Responses.GetCollectionChunkResponseBase;
import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.Enum.DataFormat;
import Alachisoft.NCache.Common.Enum.SubscriptionType;
import Alachisoft.NCache.Common.Enum.Time;
import Alachisoft.NCache.Common.Enum.TopicOperationType;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.PartitioningStrategy;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.ResourcePool;
import Alachisoft.NCache.Common.Util.HashtableUtil;
import Alachisoft.NCache.Management.CacheConfig;
import com.alachisoft.ncache.client.CacheCollection;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.CacheItemWrapperInternal;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.client.CacheStatusEventListener;
import com.alachisoft.ncache.client.CacheStatusNotificationType;
import com.alachisoft.ncache.client.CacheSyncDependency;
import com.alachisoft.ncache.client.ContinuousQuery;
import com.alachisoft.ncache.client.LockHandle;
import com.alachisoft.ncache.client.StreamMode;
import com.alachisoft.ncache.client.datastructures.DataStructureAttributes;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.CacheImplBase;
import com.alachisoft.ncache.client.internal.caching.CacheListener;
import com.alachisoft.ncache.client.internal.caching.CacheNotificationType;
import com.alachisoft.ncache.client.internal.caching.CustomListener;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.caching.SyncCache;
import com.alachisoft.ncache.client.internal.communication.Connection;
import com.alachisoft.ncache.client.internal.communication.ModuleOperation;
import com.alachisoft.ncache.client.internal.messaging.ReceivedMessages;
import com.alachisoft.ncache.client.internal.util.ConversionUtil;
import com.alachisoft.ncache.common.monitoring.MetricsTransporter;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.CacheItemAttributes;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.SubscriptionPolicyType;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.messaging.TopicPriority;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.DataTypeEventDataFilter;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.InternalCommandException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.exceptions.StreamAlreadyLockedException;
import com.alachisoft.ncache.runtime.exceptions.StreamCloseException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamInvalidLockException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationNotSupportedRuntimeException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import com.alachisoft.ncache.serialization.util.SerializationUtil;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import tangible.RefObject;

public final class InprocCache
extends CacheImplBase {
    public Cache _nCache;
    public CacheConfig _config;
    public int _refCount;
    private CompactCacheEntry _entry;
    private String _serializationContext;
    private ResourcePool _callbackIDsMap;
    private short _rcbInitialVal = 0;
    private short _ucbInitialVal = (short)1000;
    private short _aiacbInitialVal = (short)2000;
    private short _aiucbInitialVal = (short)3000;
    private short _aircbInitialVal = (short)4000;
    private short _acccbInitialVal = (short)5000;
    private long _compressionThresholdSize;
    private boolean _compressionEnabled;
    private String _userId;
    private byte[] _password = null;
    private CacheImpl _parent;
    public static final Date NoAbsoluteExpiration = CacheImpl.NoAbsoluteExpiration;
    public static final TimeSpan NoSlidingExpiration = TimeSpan.Zero;
    private TypeInfoMap _typeMap;
    private String _monitoringSessionId;
    private String _cacheConfigId;

    @Override
    public String getMonitoringSessionId() {
        return null;
    }

    @Override
    public String getCacheConfigId() {
        return null;
    }

    @Override
    boolean isInproc() {
        return true;
    }

    @Override
    protected TypeInfoMap getTypeMap() {
        return this._typeMap;
    }

    @Override
    protected void setTypeMap(TypeInfoMap value) {
        this._typeMap = value;
    }

    @Override
    public long getCompressionThreshold() {
        return this._compressionThresholdSize;
    }

    @Override
    protected void setCompressionThreshold(long value) {
        this._compressionThresholdSize = value;
    }

    @Override
    public boolean getCompressionEnabled() {
        return false;
    }

    @Override
    protected void setCompressionEnabled(boolean value) {
    }

    @Override
    protected void registerCacheClientConnectivityEvent() throws CacheException {
    }

    @Override
    protected void unregisterCacheClientConnectivityEvent() throws CacheException {
    }

    @Override
    void registerCacheStoppedEvent() throws CacheException {
    }

    @Override
    void unregisterCacheStoppedEvent() throws CacheException {
    }

    @Override
    void registerClearEvent() throws CacheException {
    }

    @Override
    void unregisterClearEvent() throws CacheException {
    }

    @Override
    protected boolean getSerializationEnabled() {
        return false;
    }

    public InprocCache(Cache objectCache, CacheConfig config, CacheImpl parent, String userId, String password) throws OperationFailedException {
        this._nCache = objectCache;
        this.setTypeMap(this._nCache.GetTypeInfoMap());
        this.setCompressionThreshold(this._nCache.getCompressThresholdSize());
        this.setCompressionEnabled(false);
        this._config = config;
        this._parent = parent;
        this._parent.setSerializationFormat(this._nCache.getSerializationFormat());
        if (this._nCache != null) {
            this._nCache.OnClientConnected(this.getClientID(), this._config.getCacheId());
            this._serializationContext = this._nCache.getName();
        }
        this.AddRef();
        this._userId = userId;
        if (password != null) {
            this._password = EncryptionUtil.Encrypt((String)password);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AddRef() {
        InprocCache inprocCache = this;
        synchronized (inprocCache) {
            ++this._refCount;
        }
    }

    @Override
    public boolean getEncryptionEnabled() {
        return false;
    }

    @Override
    public void setEncryptionEnabled(boolean value) {
    }

    @Override
    public ILogger getNCacheLog() {
        return null;
    }

    @Override
    protected void registerCustomEventListener(CustomListener listener) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, Exception {
    }

    @Override
    protected void registerCacheEventlistener(CacheListener listener, EnumSet<CacheNotificationType> registerAgainst) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
    }

    @Override
    protected void registerCacheStatusEventlistener(CacheStatusEventListener listener, EnumSet<CacheStatusNotificationType> registerAgainst) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
    }

    @Override
    protected void unregisterCacheEventlistener(CacheListener listener, EnumSet<CacheNotificationType> unregisterAgainst) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
    }

    @Override
    protected void unregisterCacheStatusEventlistener(CacheStatusEventListener listener, EnumSet<CacheStatusNotificationType> unregisterAgainst) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
    }

    @Override
    protected void unregisterCustomEventListener(CustomListener listener) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void DisposeInternal(boolean disposing) {
        InprocCache inprocCache = this;
        synchronized (inprocCache) {
            --this._refCount;
            if (this._refCount > 0) {
                return;
            }
            if (this._refCount < 0) {
                this._refCount = 0;
            }
            CacheCollection cacheCollection = CacheManager.getCaches();
            synchronized (cacheCollection) {
                if (this._config != null) {
                    CacheManager.getCaches().removeCache(this._config.getCacheId());
                }
            }
            if (this._config != null && this._config.getUseInProc() && this._nCache != null) {
                this._nCache.dispose();
            }
            this._nCache = null;
        }
    }

    @Override
    public void dispose(boolean disposing) {
        this.DisposeInternal(true);
    }

    @Override
    public Object getItem(String key) throws Exception {
        return null;
    }

    @Override
    protected Vector getCallbackQueue() {
        return null;
    }

    @Override
    public void setItem(String key, Object value) {
    }

    @Override
    public boolean lock(String key, TimeSpan lockTimeout, LockHandle lockHandle) throws CacheException {
        Object lockId = null;
        Date lockDate = new Date();
        RefObject lockHandleRef = new RefObject((Object)lockHandle);
        if (this._nCache != null) {
            RefObject tempRef_lockId = new RefObject(lockId);
            RefObject tempRef_lockDate = new RefObject((Object)lockDate);
            boolean result = this._nCache.Lock((Object)key, lockTimeout, tempRef_lockId, tempRef_lockDate, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
            lockId = tempRef_lockId.argvalue;
            lockDate = (Date)tempRef_lockDate.argvalue;
            lockHandleRef.argvalue = new LockHandle(lockId == null ? null : (String)(lockId instanceof String ? lockId : null), lockDate);
            return result;
        }
        return false;
    }

    @Override
    public boolean isLocked(String key, LockHandle lockHandle1) throws CacheException {
        RefObject lockHandle = new RefObject((Object)lockHandle1);
        if (this._nCache != null) {
            Object lockId = null;
            Date lockDate = new Date(0L);
            if (lockHandle.argvalue == null) {
                lockHandle.argvalue = new LockHandle();
            }
            RefObject tempRef_lockId = new RefObject(lockId);
            RefObject tempRef_lockDate = new RefObject((Object)lockDate);
            boolean result = this._nCache.IsLocked((Object)key, tempRef_lockId, tempRef_lockDate, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
            lockId = tempRef_lockId.argvalue;
            lockDate = (Date)tempRef_lockDate.argvalue;
            ((LockHandle)lockHandle.argvalue).setLockId(lockId == null ? "" : (String)(lockId instanceof String ? lockId : null));
            ((LockHandle)lockHandle.argvalue).setLockDate(lockDate);
            return result;
        }
        return false;
    }

    @Override
    public void closeStream(String key, String lockHandle) throws Exception {
    }

    @Override
    public int readFromStream(RefObject<byte[]> buffer, String key, String lockHandle, int offset, int streamOffset, int length) throws Exception {
        return 0;
    }

    @Override
    public void writeToStream(String key, String lockHandle, byte[] buffer, int srcOffset, int dstOffset, int length) throws Exception {
    }

    @Override
    public long getStreamLength(String key, String lockHandle) throws Exception {
        return 0L;
    }

    @Override
    public HashMap getEncryptionInfo() {
        return null;
    }

    @Override
    public void unlock(String key) throws CacheException {
        if (this._nCache != null) {
            this._nCache.Unlock((Object)key, null, true, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
        }
    }

    @Override
    public void unlock(String key, String lockId) throws CacheException {
        if (this._nCache != null) {
            boolean isPreemtive = false;
            if (lockId == null) {
                isPreemtive = true;
            }
            this._nCache.Unlock((Object)key, (Object)lockId, isPreemtive, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
        }
    }

    @Override
    public long getCount() throws CacheException {
        if (this._nCache != null) {
            return this._nCache.getCount();
        }
        return 0L;
    }

    @Override
    public void makeTargetCacheActivePassive(boolean makeActive) throws GeneralFailureException, SecurityException, OperationFailedException, AggregateException, ConnectionException, Exception {
    }

    @Override
    public String getName() {
        if (this._nCache != null) {
            return this._nCache.getName();
        }
        return null;
    }

    @Override
    protected String getBridgeTargetCacheUniqueID() {
        return null;
    }

    @Override
    protected void setBridgeTargetCacheUniqueID(String value) {
    }

    @Override
    public void clear(BitSet flagMap, short onDsClearedCallback, String providerName) throws OperationFailedException {
        if (this._nCache == null) {
            return;
        }
        CallbackEntry notification = null;
        if (onDsClearedCallback != -1) {
            notification = new CallbackEntry(this.getClientID(), -1, (Object)-1, -1, -1, onDsClearedCallback, EventDataFilter.None, EventDataFilter.DataWithMetadata);
        }
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        operationContext.Add(OperationContextFieldName.WriteThruProviderName, (Object)providerName);
        this._nCache.Clear(flagMap, notification, operationContext);
    }

    @Override
    public void clearAsync(BitSet flagMap, short onDsClearedCallback, boolean isAsync, String providerName) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, Exception {
    }

    @Override
    public void clearAsync(BitSet flagMap, short onAsyncCacheClearCallback, short onDsClearedCallback, boolean isAsync, String providerName) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, Exception {
    }

    @Override
    public boolean contains(String key) throws OperationFailedException {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        return this._nCache.Contains((Object)key, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    @Override
    public Map<String, Boolean> containsBulk(String[] keys) throws CacheException {
        if (keys == null) {
            throw new IllegalArgumentException("keys");
        }
        HashMap keysFound = this._nCache.Contains(keys, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
        return HashtableUtil.extractKeyStatus((HashMap)keysFound, (String[])keys);
    }

    @Override
    public void raiseCustomEvent(Object notifId, Object data) throws CacheException {
        this._nCache.SendNotification(notifId, data);
    }

    @Override
    public void registerKeyNotificationListener(String key, short updateCallbackid, short removeCallbackid, boolean notifyOnItemExpiration) throws CacheException {
    }

    @Override
    public boolean subscribe(String topicName, String subscriptionName, SubscriptionType subscriptionType, long creationTime, long expiration, SubscriptionPolicyType subscriptionPolicyType) throws CacheException {
        return false;
    }

    @Override
    public long getMessageCount(String topicName) {
        return 0L;
    }

    @Override
    public String openStream(String key, StreamMode mode, String group, Date absExpiration, TimeSpan slidingExpiration, CacheDependency dependency, CacheItemPriority priority) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, StreamAlreadyLockedException, StreamCloseException, StreamInvalidLockException, StreamException, StreamNotFoundException, ConnectionException, Exception {
        return null;
    }

    @Override
    public void registerKeyNotificationListener(String key, short callbackRef, short callbackRef1, EventDataFilter dataFilter, boolean notifyOnItemExpiration) throws CacheException {
    }

    @Override
    public void registerKeyNotificationListener(String[] keys, short callbackRef, short callbackRef1, EventDataFilter dataFilter, boolean notifyOnItemExpiration) throws CacheException {
    }

    private void ValidateKeyValue(String key, Object value) {
        Class<ICompactSerializable> type = ICompactSerializable.class;
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
    }

    private Object MakeCompactEntry(String key, Object value, ExpirationHint dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, short onRemoveCallback, short onUpdateCallback, short onAsyncOperationCompleteCallback, short DsCallback, boolean isResyncExpiredItems, String group, HashMap queryInfo, BitSet Flag, Object lockId, long version, LockAccessType accessType, String providerName, String resyncProviderName, EventDataFilter updateCallbackFilter, EventDataFilter removeCallabackFilter, String clientId) throws ParseException {
        Object notification = null;
        if (this.getSerializationEnabled()) {
            value = UserBinaryObject.createUserBinaryObject((byte[])((byte[])value));
        }
        int expType = CacheHelper.EvaluateExpirationParameters(absoluteExpiration, slidingExpiration);
        int options = 0;
        if (expType < 2) {
            options = expType;
        }
        if (isResyncExpiredItems) {
            int isResync = isResyncExpiredItems ? 1 : 0;
            options |= (isResync <<= 1);
        }
        int prio = priority.value();
        prio += 2;
        options |= (prio <<= 2);
        long expiration = expType == 1 ? absoluteExpiration.getTime() : slidingExpiration.getTotalTicks();
        ExpirationHint hint = dependency == null ? null : dependency;
        Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency syncDep = null;
        if (syncDependency != null) {
            SyncCache syncCache = new SyncCache(syncDependency.getCacheId(), syncDependency.getServer(), syncDependency.getPort(), true);
            syncDep = new Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency(syncDependency.getCacheId(), syncDependency.getKey(), (ISyncCache)syncCache);
        }
        CompactCacheEntry entry = new CompactCacheEntry((Object)key, value, hint, syncDep, expiration, (byte)options, null, group, queryInfo, Flag, lockId, version, accessType, providerName, resyncProviderName);
        return entry;
    }

    @Override
    public boolean setAttributes(String key, CacheItemAttributes attributes) throws CacheException {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes");
        }
        ExpirationHint hint = DependencyHelper.GetExpirationHint((CacheDependency)attributes.getDependency(), (Date)attributes.getAbsoluteExpiration(), (TimeSpan)CacheImpl.NoSlidingExpiration);
        return this._nCache.AddExpirationHint((Object)key, hint, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    @Override
    public boolean getOrCreate(String topicName, RefObject<TopicPriority> priority, TopicOperationType type) throws CacheException {
        return false;
    }

    @Override
    public void acknowledgeMessageReceipt(Map<String, List<String>> topicWiseMessageIds) throws Exception {
    }

    @Override
    public boolean addDependency(String key, CacheDependency dependency, boolean isResyncRequired) throws CacheException {
        ExpirationHint hint = DependencyHelper.GetExpirationHint((CacheDependency)dependency);
        if (isResyncRequired && hint != null) {
            hint.SetBit(2);
        }
        return this._nCache.AddExpirationHint((Object)key, hint, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
    }

    @Override
    public boolean addDependency(String key, CacheSyncDependency syncDependency) throws Exception {
        Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency syncDep = null;
        if (syncDependency != null) {
            try {
                SyncCache syncCache = new SyncCache(syncDependency.getCacheId(), syncDependency.getServer(), syncDependency.getPort(), true);
                syncDep = new Alachisoft.NCache.Caching.CacheSynchronization.CacheSyncDependency(syncDependency.getCacheId(), syncDependency.getKey(), (ISyncCache)syncCache);
            }
            catch (RuntimeException e) {
                return false;
            }
            return this._nCache.AddSyncDependency((Object)key, syncDep, new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation));
        }
        return false;
    }

    @Override
    public CacheItemVersion add(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, short onRemoveCallback, short onUpdateCallback, short onDsItemAddedCallback, boolean isResyncExpiredItems, String group, HashMap queryInfo, BitSet flagMap, String providerName, String resyncProviderName, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, long size, boolean encryptionEnabled, String clientId, String typeName) throws OperationFailedException {
        ExpirationHint hint = DependencyHelper.GetExpirationHint((CacheDependency)dependency);
        Hashtable queryInfoDic = queryInfo.get("query-info") instanceof Hashtable ? queryInfo.get("query-info") : null;
        if (queryInfoDic != null) {
            for (Map.Entry pair : queryInfoDic.entrySet()) {
                ArrayList valuesEnum = (ArrayList)((Object)pair);
                for (int i = 0; i < valuesEnum.size(); ++i) {
                    if (!(valuesEnum.get(i) instanceof Date)) continue;
                    valuesEnum.set(i, ((Date)valuesEnum.get(i)).getTime());
                }
            }
        }
        Object entry = null;
        try {
            entry = this.MakeCompactEntry(key, value, hint, syncDependency, absoluteExpiration, slidingExpiration, priority, onRemoveCallback, onUpdateCallback, (short)-1, onDsItemAddedCallback, isResyncExpiredItems, group, queryInfo, flagMap, null, 0L, LockAccessType.IGNORE_LOCK, providerName, resyncProviderName, itemUpdateDataFilter, itemRemovedDataFilter, clientId);
        }
        catch (ParseException e) {
            throw new OperationFailedException((Throwable)e);
        }
        long itemVersion = NCDateTime.getUTCNow().getTime() - Time.ReferenceTime.getTime();
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
        operationContext.Add(OperationContextFieldName.ValueDataSize, (Object)size);
        operationContext.Add(OperationContextFieldName.ItemVersion, (Object)itemVersion);
        this._nCache.AddEntry(entry, operationContext);
        CacheItemVersion cacheitemVersion = new CacheItemVersion((Long)operationContext.GetValueByField(OperationContextFieldName.ItemVersion));
        return cacheitemVersion;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashMap add(String[] keys, CacheItem[] items, short onDataSourceItemsAdded, String providerName, long[] sizes, boolean encryptionEnabled, String clientId, short itemUpdatedCallback, short itemRemovedCallback, EventDataFilter updateCallbackFilter, EventDataFilter removeCallabackFilter, boolean returnVersions, Map itemVersions, ListenerType listenerType) throws OperationFailedException {
        if (this._nCache == null) {
            return null;
        }
        ExpirationHint hint = null;
        Object[] entries = new Object[items.length];
        for (int i = 0; i < items.length; ++i) {
            String key = keys[i];
            CacheItem item = items[i];
            hint = DependencyHelper.GetExpirationHint((CacheDependency)item.getDependency());
            Hashtable queryInfoDic = CacheItemWrapperInternal.getQueryInfo(item).get("query-info") instanceof Hashtable ? CacheItemWrapperInternal.getQueryInfo(item).get("query-info") : null;
            if (queryInfoDic != null) {
                for (ArrayList arrayList : queryInfoDic.entrySet()) {
                    for (int j = 0; j < arrayList.size(); ++j) {
                        if (!(arrayList.get(j) instanceof Date)) continue;
                        arrayList.set(j, ((Date)arrayList.get(j)).getTime());
                    }
                }
            }
            try {
                void var22_26;
                boolean ResyncOnExpire = false;
                if (item.getResyncOptions() != null) {
                    ResyncOnExpire = item.getResyncOptions().getResyncOnExpiration();
                }
                Object var22_29 = null;
                if (item.getResyncOptions() != null) {
                    String string = item.getResyncOptions().getProviderName();
                }
                entries[i] = this.MakeCompactEntry(key, item.getValue(null), hint, item.getSyncDependency(), ConversionUtil.getAbsoluteExpiration(item.getExpiration()), ConversionUtil.getSlidingExpiration(item.getExpiration()), item.getCacheItemPriority(), itemRemovedCallback, itemUpdatedCallback, (short)-1, onDataSourceItemsAdded, ResyncOnExpire, item.getGroup(), CacheItemWrapperInternal.getQueryInfo(item), CacheItemWrapperInternal.getFlagValue(item), null, 0L, LockAccessType.IGNORE_LOCK, providerName, (String)var22_26, CacheItemWrapperInternal.getItemUpdatedDataFilter(item), CacheItemWrapperInternal.getItemRemovedDataFilter(item), clientId);
                continue;
            }
            catch (ParseException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        if (providerName != null) {
            operationContext.Add(OperationContextFieldName.WriteThruProviderName, (Object)providerName);
        }
        operationContext.Add(OperationContextFieldName.WriteThru, (Object)CacheItemWrapperInternal.getFlagValue(items[0]).IsBitSet((byte)4));
        operationContext.Add(OperationContextFieldName.WriteBehind, (Object)CacheItemWrapperInternal.getFlagValue(items[0]).IsBitSet((byte)8));
        operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
        operationContext.Add(OperationContextFieldName.ValueDataSize, (Object)sizes);
        try {
            return this._nCache.AddEntries(entries, itemVersions, operationContext);
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public Object addAsync(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, short onRemoveCallback, short onUpdateCallback, short onAsyncItemAddCallback, short dsItemAddedCallback, boolean isResyncExpiredItems, String group, HashMap queryInfo, BitSet flagMap, String providerName, String resyncProviderName, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, long size, String clientId, short updateCallbackId, short removeCallbackId, short dsItemAddedCallbackId) throws Exception {
        return null;
    }

    @Override
    public CompressedValueEntry get(String key, BitSet flagMap, String group, CacheItemVersion version, LockHandle lockHandle, TimeSpan lockTimeout, LockAccessType accessType, ReadThruOptions readOption) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConfigurationException, CommandException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException {
        if (this._nCache == null) {
            return null;
        }
        if (this._nCache != null) {
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.ReadThru, (Object)readOption);
            RefObject tempRef_itemVersion = new RefObject((Object)version.getVersion());
            RefObject tempRef_lockId = new RefObject((Object)lockHandle.getLockId());
            RefObject tempRef_lockDate = new RefObject((Object)lockHandle.getLockDate());
            CompressedValueEntry cmpEntry = this._nCache.GetGroup((Object)key, flagMap, group, null, tempRef_itemVersion, tempRef_lockId, tempRef_lockDate, lockTimeout, accessType, readOption, readOption.getProviderName(), operationContext);
            version.setVersion((Long)tempRef_itemVersion.argvalue);
            lockHandle.setLockId((String)tempRef_lockId.argvalue);
            lockHandle.setLockDate((Date)tempRef_lockDate.getValue());
            if (cmpEntry != null && cmpEntry.getValue() != null && cmpEntry.getValue() instanceof UserBinaryObject && cmpEntry.getValue() instanceof UserBinaryObject) {
                UserBinaryObject ubObject = (UserBinaryObject)(cmpEntry.getValue() instanceof UserBinaryObject ? cmpEntry.getValue() : null);
                Object deserialized = ubObject.getFullObject();
                if (deserialized instanceof byte[]) {
                    try {
                        deserialized = CompactBinaryFormatter.fromByteBuffer((byte[])deserialized, (String)this._serializationContext);
                    }
                    catch (IOException | ClassNotFoundException exception) {
                        // empty catch block
                    }
                }
                cmpEntry.setValue(deserialized);
            }
            if (lockHandle == null) {
                lockHandle = new LockHandle();
            }
            cmpEntry.setValue(CacheHelper.getObjectOrInitializedCollection(key, cmpEntry.getType(), cmpEntry.getValue(), this._parent, null));
            return cmpEntry;
        }
        return null;
    }

    @Override
    public HashMap getByTag(Tag[] tags, TagComparisonType comaprisonType) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, IllegalArgumentException, ConnectionException, Exception {
        return null;
    }

    private ReadThruOptions ConvertToReadThruOperation(ReadThruOptions readoption) {
        if (readoption == null) {
            return new ReadThruOptions(ReadMode.None);
        }
        return new ReadThruOptions(readoption.getReadMode(), readoption.getProviderName());
    }

    @Override
    public void removeByTag(Tag[] tags, TagComparisonType comarisonType) throws OperationNotSupportedException, OperationFailedException {
        if (this._nCache == null) {
            return;
        }
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
        this._nCache.RemoveByTag(CacheHelper.getTags(tags), comarisonType, operationContext);
    }

    @Override
    public Collection getKeysByTag(Tag[] tags, TagComparisonType comparisonType) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(10000, ErrorMessages.getErrorMessage((int)10000, (String[])new String[0]));
    }

    @Override
    public ArrayList getGroupKeys(String group) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(10000, ErrorMessages.getErrorMessage((int)10000, (String[])new String[0]));
    }

    @Override
    public HashMap getGroupData(String group) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, Exception {
        return null;
    }

    public <T> Map get(String[] keys, BitSet flagMap, ReadThruOptions readOptions) throws OperationFailedException {
        if (this._nCache != null) {
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            ReadThruOptions readOption = new ReadThruOptions(readOptions.getReadMode(), readOptions.getProviderName());
            operationContext.Add(OperationContextFieldName.ReadThru, (Object)readOption);
            Map items = this._nCache.GetBulk((Object[])keys, flagMap, readOptions.getProviderName(), operationContext);
            if (items != null) {
                HashMap returnItems;
                HashMap finalReturnItems = returnItems = new HashMap();
                items.forEach((key, value) -> {
                    CompressedValueEntry cmpEntry = (CompressedValueEntry)(value instanceof CompressedValueEntry ? value : null);
                    if (cmpEntry != null && cmpEntry.value != null && cmpEntry.value instanceof UserBinaryObject) {
                        UserBinaryObject ubObject = (UserBinaryObject)(cmpEntry.value instanceof UserBinaryObject ? cmpEntry.value : null);
                        cmpEntry.value = ubObject.getFullObject();
                    }
                });
                returnItems = finalReturnItems;
                return CacheHelper.bulkGetObjectOrInitializedCollection(returnItems, this._parent);
            }
        }
        return null;
    }

    @Override
    public Object getCacheItem(String key, BitSet flagMap, String group, CacheItemVersion version, LockHandle lockHandle, TimeSpan lockTimeout, LockAccessType accessType, ReadThruOptions readOption) throws OperationFailedException {
        if (lockHandle == null) {
            lockHandle = new LockHandle();
        }
        Object lockId = lockHandle.getLockId();
        if (version == null) {
            version = new CacheItemVersion();
        }
        Date lockDate = new Date(0L);
        CacheEntry entry = null;
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        operationContext.Add(OperationContextFieldName.ReadThru, (Object)readOption);
        operationContext.Add(OperationContextFieldName.GenerateQueryInfo, (Object)true);
        long ver = version.getVersion();
        RefObject tempRef_lockId = new RefObject(lockId);
        RefObject tempRef_lockDate = new RefObject((Object)lockDate);
        RefObject tempRef_ver = new RefObject((Object)ver);
        Object tempVar = this._nCache.GetCacheEntry((Object)key, group, null, tempRef_lockId, tempRef_lockDate, lockTimeout, tempRef_ver, accessType, operationContext);
        lockId = tempRef_lockId.argvalue;
        lockDate = (Date)tempRef_lockDate.argvalue;
        ver = (Long)tempRef_ver.argvalue;
        entry = (CacheEntry)(tempVar instanceof CacheEntry ? tempVar : null);
        if (entry != null) {
            if (entry.getValue() instanceof UserBinaryObject) {
                entry.setValue((Object)((UserBinaryObject)entry.getValue()).getFullObject());
            }
            version.setVersion(entry.getVersion());
            if (entry.getPriority() == CacheItemPriority.Default) {
                entry.setPriority(CacheItemPriority.getValueFromString((String)this._nCache.getConfiguration().getEvictionPolicy().getDefaultPriority()));
            }
        }
        lockHandle.setLockId(lockId == null ? null : (String)(lockId instanceof String ? lockId : null));
        lockHandle.setLockDate(lockDate);
        return entry;
    }

    @Override
    public Map getCacheItemBulk(String[] keys, BitSet flagMap, ReadThruOptions readOption) {
        if (this._nCache != null) {
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.ReadThru, (Object)readOption);
            Map items = this._nCache.getBulkCache(keys, flagMap, readOption, operationContext);
            Map retItems = null;
            return retItems;
        }
        return null;
    }

    @Override
    public void InvalidateReaders(String toString) {
    }

    @Override
    public void setCompressionThresholdSize(long compressionThreshold) {
    }

    @Override
    public void registerHashmapChangedEvent(Connection connection) throws AggregateException, SecurityException, GeneralFailureException, OperationFailedException, ConfigurationException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
    }

    @Override
    public void getTypeInfoMap(Connection connection) throws AggregateException, InternalCommandException, GeneralFailureException, OperationFailedException, SecurityException, OperationNotSupportedException, StreamException, ConfigurationException, LicensingException, StreamNotFoundException, StreamAlreadyLockedException, CommandException {
    }

    @Override
    public void getThresholdSize(Connection connection) throws AggregateException, InternalCommandException, GeneralFailureException, OperationFailedException, OperationNotSupportedException, StreamException, SecurityException, LicensingException, ConfigurationException, StreamNotFoundException, StreamAlreadyLockedException, CacheException {
    }

    @Override
    public void getExpirationFromServer(Connection connection) throws AggregateException, InternalCommandException, GeneralFailureException, OperationFailedException, OperationNotSupportedException, StreamException, SecurityException, LicensingException, ConfigurationException, StreamNotFoundException, StreamAlreadyLockedException, CommandException {
    }

    @Override
    public void getSerializationFormat(Connection connection) throws AggregateException, InternalCommandException, GeneralFailureException, OperationFailedException, SecurityException, OperationNotSupportedException, StreamException, ConfigurationException, LicensingException, StreamNotFoundException, StreamAlreadyLockedException, CommandException {
    }

    @Override
    public void getCompactTypesFromServer(Connection connection) throws AggregateException, InternalCommandException, GeneralFailureException, OperationFailedException, SecurityException, OperationNotSupportedException, StreamException, ConfigurationException, LicensingException, StreamNotFoundException, StreamAlreadyLockedException, CommandException {
    }

    @Override
    public void getEncryptionKeyFromServer(Connection connection) throws AggregateException, InternalCommandException, GeneralFailureException, OperationFailedException, OperationNotSupportedException, StreamException, SecurityException, LicensingException, ConfigurationException, StreamNotFoundException, StreamAlreadyLockedException, CommandException {
    }

    @Override
    public void reRegisterGeneralNotification(Connection connection) throws AggregateException, SecurityException, GeneralFailureException, OperationFailedException, ConfigurationException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
    }

    @Override
    public void ExecuteModuleOperation(ModuleOperation operation) {
    }

    @Override
    public PartitioningStrategy getPartitioningStrategy() {
        return null;
    }

    @Override
    public boolean checkSecurityAuthorization(String cacheId, byte[] password, String userId) throws OperationFailedException, SecurityException, AggregateException, GeneralFailureException, CommandException, StreamNotFoundException, OperationNotSupportedException, StreamException, ConfigurationException, LicensingException, StreamAlreadyLockedException {
        return false;
    }

    @Override
    public Map publishMessage(String topicName, Map<String, Message> keyMessageBulk, boolean notifyDeliveryFailure) throws OperationFailedException, LicensingException, CommandException, StreamAlreadyLockedException, GeneralFailureException, OperationNotSupportedException, SecurityException, StreamException, ConfigurationException, StreamNotFoundException, AggregateException {
        return null;
    }

    @Override
    public void addCollectionNotificationListener(String collectionName, short addCallbackId, short updateCallbackId, short removeCallbackId, DataTypeEventDataFilter dataFilter, DistributedDataStructure dataType, boolean notifyOnItemExpiration) throws OperationFailedException, LicensingException, CommandException {
    }

    @Override
    public void removeCollectionNotificationListener(String collectionName, short addCallbackId, short updateCallbackId, short removeCallbackId, EventTypeInternal eventType, DistributedDataStructure dataType) throws OperationFailedException, LicensingException, CommandException {
    }

    @Override
    public CacheItemVersion insert(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, short onRemoveCallback, short onUpdateCallback, short onDsItemUpdateCallback, boolean isResyncExpiredItems, String group, HashMap queryInfo, BitSet flagMap, String lockId, CacheItemVersion version, LockAccessType accessType, String providerName, String resyncProviderName, EventDataFilter updateCallbackFilter, EventDataFilter removeCallabackFilter, long size, boolean encryptionEnabled, String clientId, String typeName, ListenerType callbackType) throws CacheException {
        ExpirationHint hint = DependencyHelper.GetExpirationHint((CacheDependency)dependency);
        Hashtable queryInfoDic = queryInfo.get("query-info") instanceof Hashtable ? queryInfo.get("query-info") : null;
        if (queryInfoDic != null) {
            for (ArrayList arrayList : queryInfoDic.entrySet()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!(arrayList.get(i) instanceof Date)) continue;
                    arrayList.set(i, ((Date)arrayList.get(i)).getTime());
                }
            }
        }
        Object entry = null;
        try {
            entry = this.MakeCompactEntry(key, value, hint, syncDependency, absoluteExpiration, slidingExpiration, priority, onRemoveCallback, onUpdateCallback, (short)-1, onDsItemUpdateCallback, isResyncExpiredItems, group, queryInfo, flagMap, lockId, version == null ? 0L : version.getVersion(), accessType, providerName, resyncProviderName, updateCallbackFilter, removeCallabackFilter, clientId);
        }
        catch (ParseException parseException) {
            throw new OperationFailedException((Throwable)parseException);
        }
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
        operationContext.Add(OperationContextFieldName.ValueDataSize, (Object)size);
        long itemVersionOperation = version == null ? NCDateTime.getUTCNow().getTime() - Time.ReferenceTime.getTime() : version.getVersion();
        operationContext.Add(OperationContextFieldName.ItemVersion, (Object)itemVersionOperation);
        long itemVersion = 0L;
        try {
            itemVersion = this._nCache.InsertEntry(entry, operationContext);
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
        return new CacheItemVersion(itemVersion);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashMap<String, RuntimeException> insert(String[] keys, CacheItem[] items, short onDsItemsUpdatedCallback, String providerName, long[] sizes, boolean encryptionEnabled, String clientId, short itemUpdatedCallback, short itemRemovedCallback, EventDataFilter updateCallbackFilter, EventDataFilter removeCallabackFilter, boolean returnVersions, Map itemVersions, ListenerType callbackType) throws CacheException {
        if (this._nCache == null) {
            return null;
        }
        Object[] entries = new Object[items.length];
        ExpirationHint hint = null;
        for (int i = 0; i < items.length; ++i) {
            Hashtable queryInfoDic;
            short[] callbackIds;
            String key = keys[i];
            CacheItem item = items[i];
            hint = DependencyHelper.GetExpirationHint((CacheDependency)item.getDependency());
            if (itemRemovedCallback == -1 && CacheItemWrapperInternal.getCacheItemRemovedListener(item) != null) {
                removeCallabackFilter = CacheItemWrapperInternal.getItemRemovedDataFilter(item);
                callbackIds = this._parent.getEventManager().registerSelectiveEvent(CacheItemWrapperInternal.getCacheItemRemovedListener(item), EnumSet.of(EventType.ItemRemoved), removeCallabackFilter, callbackType);
                if (callbackIds != null && callbackIds.length > 1) {
                    itemRemovedCallback = callbackIds[1];
                }
            }
            if (itemUpdatedCallback == -1 && CacheItemWrapperInternal.getCacheItemUpdatedListener(item) != null) {
                updateCallbackFilter = CacheItemWrapperInternal.getItemUpdatedDataFilter(item);
                callbackIds = this._parent.getEventManager().registerSelectiveEvent(CacheItemWrapperInternal.getCacheItemUpdatedListener(item), EnumSet.of(EventType.ItemUpdated), updateCallbackFilter, callbackType);
                if (callbackIds != null && callbackIds.length > 0) {
                    itemUpdatedCallback = callbackIds[0];
                }
            }
            if ((queryInfoDic = (Hashtable)(CacheItemWrapperInternal.getQueryInfo(item).get("query-info") instanceof Hashtable ? CacheItemWrapperInternal.getQueryInfo(item).get("query-info") : null)) != null) {
                for (ArrayList arrayList : queryInfoDic.entrySet()) {
                    for (int j = 0; j < arrayList.size(); ++j) {
                        if (!(arrayList.get(j) instanceof Date)) continue;
                        arrayList.set(j, ((Date)arrayList.get(j)).getTime());
                    }
                }
            }
            try {
                void var22_26;
                boolean ResyncOnExpire = false;
                if (item.getResyncOptions() != null) {
                    ResyncOnExpire = item.getResyncOptions().getResyncOnExpiration();
                }
                Object var22_29 = null;
                if (item.getResyncOptions() != null) {
                    String string = item.getResyncOptions().getProviderName();
                }
                entries[i] = this.MakeCompactEntry(key, item.getValue(null), hint, item.getSyncDependency(), ConversionUtil.getAbsoluteExpiration(item.getExpiration()), ConversionUtil.getSlidingExpiration(item.getExpiration()), item.getCacheItemPriority(), itemRemovedCallback, itemRemovedCallback, (short)-1, onDsItemsUpdatedCallback, ResyncOnExpire, item.getGroup(), CacheItemWrapperInternal.getQueryInfo(item), CacheItemWrapperInternal.getFlagValue(item), null, 0L, LockAccessType.IGNORE_LOCK, providerName, (String)var22_26, CacheItemWrapperInternal.getItemUpdatedDataFilter(item), CacheItemWrapperInternal.getItemRemovedDataFilter(item), clientId);
                continue;
            }
            catch (ParseException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        operationContext.Add(OperationContextFieldName.WriteThru, (Object)CacheItemWrapperInternal.getFlagValue(items[0]).IsBitSet((byte)4));
        operationContext.Add(OperationContextFieldName.WriteBehind, (Object)CacheItemWrapperInternal.getFlagValue(items[0]).IsBitSet((byte)8));
        operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
        operationContext.Add(OperationContextFieldName.ValueDataSize, (Object)sizes);
        RefObject tempRef_itemVersions = new RefObject((Object)itemVersions);
        try {
            return (HashMap)this._nCache.InsertEntries(entries, operationContext);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public CompressedValueEntry remove(String key, BitSet flagMap, short onDsItemRemovedCallback, String lockId, CacheItemVersion version, LockAccessType accessType, String ProviderName) throws OperationFailedException {
        if (this._nCache != null) {
            CallbackEntry notification = null;
            if (onDsItemRemovedCallback != -1) {
                notification = new CallbackEntry(this.getClientID(), -1, null, -1, -1, onDsItemRemovedCallback, EventDataFilter.None, EventDataFilter.None);
            }
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.ClientId, (Object)this.getClientID());
            operationContext.Add(OperationContextFieldName.WriteThru, (Object)flagMap.IsBitSet((byte)4));
            operationContext.Add(OperationContextFieldName.WriteBehind, (Object)flagMap.IsBitSet((byte)8));
            if (ProviderName != null) {
                operationContext.Add(OperationContextFieldName.WriteThruProviderName, (Object)ProviderName);
            }
            operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
            CompressedValueEntry cmpEntry = this._nCache.Remove(key, flagMap, notification, (Object)lockId, version == null ? 0L : version.getVersion(), accessType, ProviderName, operationContext);
            if (cmpEntry != null && cmpEntry.getValue() != null) {
                if (cmpEntry.getValue() instanceof UserBinaryObject) {
                    UserBinaryObject ubObject = (UserBinaryObject)(cmpEntry.getValue() instanceof UserBinaryObject ? cmpEntry.getValue() : null);
                    cmpEntry.setValue((Object)ubObject.getFullObject());
                }
                cmpEntry.setValue(CacheHelper.getObjectOrInitializedCollection(key, cmpEntry.getType(), cmpEntry.getValue(), this._parent, null));
            }
            return cmpEntry;
        }
        return null;
    }

    @Override
    public void delete(String key, BitSet flagMap, short onDsItemRemovedCallback, String lockId, CacheItemVersion version, LockAccessType accessType, String ProviderName) throws OperationFailedException {
        if (this._nCache != null) {
            CallbackEntry notification = null;
            if (onDsItemRemovedCallback != -1) {
                notification = new CallbackEntry(this.getClientID(), -1, (Object)-1, -1, -1, onDsItemRemovedCallback, EventDataFilter.None, EventDataFilter.None);
            }
            OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
            operationContext.Add(OperationContextFieldName.ClientId, (Object)this.getClientID());
            operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
            this._nCache.Delete(key, flagMap, notification, (Object)lockId, version == null ? 0L : version.getVersion(), accessType, ProviderName, operationContext);
        }
    }

    @Override
    public HashMap remove(String[] keys, BitSet flagMap, String providerName, short onDsItemsRemovedCallback) throws OperationFailedException {
        CallbackEntry notification = null;
        if (onDsItemsRemovedCallback != -1) {
            notification = new CallbackEntry(this.getClientID(), -1, (Object)-1, -1, -1, onDsItemsRemovedCallback, EventDataFilter.None, EventDataFilter.None);
        }
        Object[] baseKeys = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            baseKeys[i] = keys[i];
        }
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        operationContext.Add(OperationContextFieldName.ClientId, (Object)this.getClientID());
        operationContext.Add(OperationContextFieldName.WriteThru, (Object)flagMap.IsBitSet((byte)4));
        operationContext.Add(OperationContextFieldName.WriteBehind, (Object)flagMap.IsBitSet((byte)8));
        if (providerName != null) {
            operationContext.Add(OperationContextFieldName.WriteThruProviderName, (Object)providerName);
        }
        operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
        HashMap items = (HashMap)this._nCache.Remove(baseKeys, flagMap, notification, providerName, operationContext);
        if (items != null) {
            for (Map.Entry val : items.entrySet()) {
                CompressedValueEntry cmpEntry = (CompressedValueEntry)(val instanceof CompressedValueEntry ? val : null);
                if (cmpEntry == null || cmpEntry.getValue() == null || !(cmpEntry.getValue() instanceof UserBinaryObject)) continue;
                UserBinaryObject ubObject = (UserBinaryObject)(cmpEntry.getValue() instanceof UserBinaryObject ? cmpEntry.getValue() : null);
                cmpEntry.setValue((Object)ubObject.getFullObject());
            }
        }
        return items;
    }

    @Override
    public void delete(String[] keys, BitSet flagMap, String providerName, short onDsItemsRemovedCallback) throws OperationFailedException {
        CallbackEntry notification = null;
        if (onDsItemsRemovedCallback != -1) {
            notification = new CallbackEntry(this.getClientID(), -1, null, -1, -1, -1, EventDataFilter.None, EventDataFilter.None);
        }
        Object[] baseKeys = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            baseKeys[i] = keys[i];
        }
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        operationContext.Add(OperationContextFieldName.ClientId, (Object)this.getClientID());
        operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
        this._nCache.Delete(baseKeys, flagMap, notification, providerName, operationContext);
    }

    @Override
    public void remove(String group) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException {
        if (group == null) {
            throw new IllegalArgumentException("group");
        }
        if (this._nCache == null) {
            return;
        }
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        operationContext.Add(OperationContextFieldName.RaiseCQNotification, (Object)true);
        this._nCache.Remove(group, null, operationContext);
    }

    @Override
    public QueryResultSet search(String query, HashMap values) {
        throw new OperationNotSupportedRuntimeException(10000, ErrorMessages.getErrorMessage((int)10000, (String[])new String[0]));
    }

    @Override
    public int executeNonQuery(String query, HashMap values) throws Exception {
        throw new OperationNotSupportedException(10000, ErrorMessages.getErrorMessage((int)10000, (String[])new String[0]));
    }

    @Override
    RecordSetEnumeratorImpl executeReaderCQ(ContinuousQuery continuousQuery, boolean getData, int chunkSize, String clientUniqueId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove) {
        return null;
    }

    @Override
    public Object safeSerialize(Object serializableObject, String serializationContext, BitSet flag, CacheImplBase cacheImpl, RefObject<Long> size, UserObjectType userObjectType, boolean isCustomerAtributeBaseSerialized) throws OperationFailedException, GeneralFailureException {
        try {
            return com.alachisoft.ncache.client.util.SerializationUtil.safeSerializeInProc(serializableObject, serializationContext, flag, this._nCache.getDataFormat() == DataFormat.Binary, this._parent.getSerializationFormat(), size, userObjectType, isCustomerAtributeBaseSerialized);
        }
        catch (IOException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public <T> T safeDeserialize(Object serializedObject, String serializationContext, BitSet flag, CacheImplBase cacheImpl, UserObjectType userObjectType, Class<?> cls) throws OperationFailedException {
        try {
            return com.alachisoft.ncache.client.util.SerializationUtil.safeDeserializeInProc(serializedObject, serializationContext, flag, this._nCache.getDataFormat() == DataFormat.Binary, userObjectType, cls);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public Enumeration getEnumerator() {
        return null;
    }

    @Override
    public ArrayList<EnumerationDataChunk> getNextChunk(ArrayList<EnumerationPointer> pointers) throws SecurityException, GeneralFailureException, OperationFailedException, AggregateException, ConnectionException, UnknownHostException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        return null;
    }

    @Override
    public HashMap getCompactTypes() {
        HashMap types = null;
        HashMap javaTypes = null;
        if (this._config != null && this._config.getCompactKnownTypes() != null) {
            if (this._config.getDataSharingKnownTypes() != null) {
                RefObject tempRef_types = new RefObject(types);
                RefObject tempRef_javaTypes = new RefObject(javaTypes);
                this.filterOutDotNetTypes(this._config.getDataSharingKnownTypes(), (RefObject<HashMap>)tempRef_types, (RefObject<HashMap>)tempRef_javaTypes, true, false);
                types = (HashMap)tempRef_types.argvalue;
                javaTypes = (HashMap)tempRef_javaTypes.argvalue;
            }
            RefObject tempRef_types2 = new RefObject(types);
            RefObject tempRef_javaTypes2 = new RefObject(javaTypes);
            this.filterOutDotNetTypes(this._config.getCompactKnownTypes(), (RefObject<HashMap>)tempRef_types2, (RefObject<HashMap>)tempRef_javaTypes2, this._config.getDataSharingKnownTypes() != null, true);
            types = (HashMap)tempRef_types2.argvalue;
            javaTypes = (HashMap)tempRef_javaTypes2.argvalue;
            try {
                types = SerializationUtil.getCompactTypes((Map)javaTypes, (boolean)false, (String)this.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return types;
    }

    private void filterOutDotNetTypes(HashMap _cmptKnownTypes, RefObject<HashMap> cmptKnownTypesdotNet, RefObject<HashMap> cmptKnownTypesJava, boolean isDataSharing, boolean compact) {
        block14: {
            cmptKnownTypesdotNet.argvalue = new HashMap();
            cmptKnownTypesJava.argvalue = new HashMap();
            if (compact && isDataSharing) {
                this.filterOutDotNetTypes(this._config.getDataSharingKnownTypes(), cmptKnownTypesdotNet, cmptKnownTypesJava, true, false);
            }
            if (_cmptKnownTypes == null) break block14;
            Iterator ide = _cmptKnownTypes.entrySet().iterator();
            if (!compact) {
                while (ide.hasNext()) {
                    Map.Entry keyVal = ide.next();
                    HashMap compactType = (HashMap)keyVal.getValue();
                    HashMap classes = (HashMap)compactType.get("known-classes");
                    for (Map.Entry cls : classes.entrySet()) {
                        HashMap typeInfo = (HashMap)cls.getValue();
                        if (typeInfo.get("type").toString().toLowerCase().equals("java")) {
                            if (!((HashMap)cmptKnownTypesJava.argvalue).containsKey((String)keyVal.getKey())) {
                                ((HashMap)cmptKnownTypesJava.argvalue).put((String)keyVal.getKey(), new HashMap());
                            }
                            ((HashMap)((HashMap)cmptKnownTypesJava.argvalue).get((String)keyVal.getKey())).put((String)typeInfo.get("name"), typeInfo);
                            if (typeInfo.containsKey("portable")) continue;
                            typeInfo.put("portable", compactType.get("portable"));
                            continue;
                        }
                        if (!typeInfo.get("type").toString().toLowerCase().equals("net")) continue;
                        if (!((HashMap)cmptKnownTypesdotNet.argvalue).containsKey((String)keyVal.getKey())) {
                            ((HashMap)cmptKnownTypesdotNet.argvalue).put((String)keyVal.getKey(), new HashMap());
                        }
                        ((HashMap)((HashMap)cmptKnownTypesdotNet.argvalue).get((String)keyVal.getKey())).put((String)typeInfo.get("name"), typeInfo);
                        if (typeInfo.containsKey("portable")) continue;
                        typeInfo.put("portable", compactType.get("portable"));
                    }
                    if (!Boolean.parseBoolean(compactType.get("portable").toString())) continue;
                    if (((HashMap)cmptKnownTypesJava.argvalue).size() > 0 && (HashMap)((HashMap)cmptKnownTypesJava.argvalue).get((String)keyVal.getKey()) != null) {
                        ((HashMap)((HashMap)cmptKnownTypesJava.argvalue).get((String)keyVal.getKey())).put("Alachisoft.NCache.AttributeUnion", compactType.get("attribute-union-list"));
                    }
                    if (((HashMap)cmptKnownTypesdotNet.argvalue).size() <= 0 || (HashMap)((HashMap)cmptKnownTypesdotNet.argvalue).get((String)keyVal.getKey()) == null) continue;
                    ((HashMap)((HashMap)cmptKnownTypesdotNet.argvalue).get((String)keyVal.getKey())).put("Alachisoft.NCache.AttributeUnion", compactType.get("attribute-union-list"));
                }
            } else {
                while (ide.hasNext()) {
                    Map.Entry keyVal = ide.next();
                    HashMap compactType = (HashMap)keyVal.getValue();
                    if (compactType.get("type") == null) continue;
                    if (compactType.get("type").toString().toLowerCase().equals("java")) {
                        if (!((HashMap)cmptKnownTypesJava.argvalue).containsKey((String)keyVal.getKey())) {
                            ((HashMap)cmptKnownTypesJava.argvalue).put((String)keyVal.getKey(), new HashMap());
                        }
                        ((HashMap)((HashMap)cmptKnownTypesJava.argvalue).get((String)keyVal.getKey())).put((String)compactType.get("name"), compactType);
                        continue;
                    }
                    if (!compactType.get("type").toString().toLowerCase().equals("net")) continue;
                    if (compactType.containsValue("arg-types")) {
                        compactType.put("arg-types", this.filterOutNestedGenerics((HashMap)compactType.get("arg-types")));
                    }
                    if (!((HashMap)cmptKnownTypesdotNet.argvalue).containsKey((String)keyVal.getKey())) {
                        ((HashMap)cmptKnownTypesdotNet.argvalue).put((String)keyVal.getKey(), new HashMap());
                    }
                    ((HashMap)((HashMap)cmptKnownTypesdotNet.argvalue).get((String)keyVal.getKey())).put((String)compactType.get("name"), compactType);
                }
            }
        }
    }

    private HashMap filterOutNestedGenerics(HashMap htArgTypes) {
        HashMap htArgTypes2 = null;
        if (htArgTypes != null && htArgTypes.size() > 0) {
            htArgTypes2 = new HashMap();
            for (Map.Entry keyVal : htArgTypes.entrySet()) {
                HashMap innerGenericType = new HashMap();
                htArgTypes2.put(keyVal.getKey().toString(), innerGenericType);
                HashMap argInstances = (HashMap)keyVal.getValue();
                for (Map.Entry argInstance : argInstances.entrySet()) {
                    HashMap instanceArgType = (HashMap)argInstance.getValue();
                    if (instanceArgType.containsKey("arg-types")) {
                        instanceArgType.put("arg-types", this.filterOutNestedGenerics((HashMap)instanceArgType.get("arg-types")));
                    }
                    HashMap<String, HashMap> innerGenericTypeDetail = new HashMap<String, HashMap>();
                    innerGenericTypeDetail.put(instanceArgType.get("name").toString(), instanceArgType);
                    innerGenericType.put(argInstance.getKey().toString(), innerGenericTypeDetail);
                }
            }
        }
        return htArgTypes2;
    }

    @Override
    public boolean removeTopic(String topicName, boolean b) throws CacheException {
        return false;
    }

    @Override
    public void publishMessage(String messageId, Object value, long time, long expiration, Hashtable metaInfo, BitSet flagMap) throws Exception {
    }

    @Override
    public boolean unSubscribe(String topicName, String recepientId, SubscriptionPolicyType subscriptionPolicyType, SubscriptionType pubSubType, boolean dispose) throws Exception {
        throw new OperationNotSupportedException("unSubscribe");
    }

    @Override
    public ReceivedMessages getMessageData(BitSet flagMap) throws CacheException {
        return null;
    }

    @Override
    void createDataType(CollectionCreateOrGetOperation operation, DataStructureAttributes properties) throws OperationFailedException, LicensingException, CommandException {
    }

    @Override
    boolean getDataType(CollectionCreateOrGetOperation operation) {
        return false;
    }

    @Override
    RecordSetEnumerator executeReader(String query, Map values, boolean getData, int chunkSize) {
        return null;
    }

    @Override
    public void listRemoveWithIndex(ListRemoveWithIndexOperation operation) {
    }

    @Override
    public void listAddWithoutIndex(ListAddWithoutIndexOperation operation) {
    }

    @Override
    public boolean listAddWithPivot(ListAddWithPivotOperation operation) {
        return false;
    }

    @Override
    public List<ExtendedJsonValueBase> listGetBulk(ListGetBulkOperation operation) {
        return null;
    }

    @Override
    public int listRemoveWithoutIndex(ListRemoveWithoutIndexOperation operation) {
        return 0;
    }

    @Override
    public void listInsertWithIndex(ListInsertWithIndexOperation tempVar) {
    }

    @Override
    public int listSearch(ListSearchOperation operation) {
        return 0;
    }

    @Override
    public ExtendedJsonValueBase listGetItem(ListGetItemOperation operation) {
        return null;
    }

    @Override
    public String registerCQ(ContinuousQuery query, String clientUniqueId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove) throws CacheException {
        return null;
    }

    @Override
    public void unRegisterCQ(String serverUniqueId, String clientUniqueId) throws CacheException {
    }

    @Override
    public void registerKeyNotificationListener(String key, short update, short remove, EventDataFilter datafilter, boolean notifyOnItemExpiration, ListenerType listenerType) {
    }

    @Override
    public void registerKeyNotificationListener(String[] key, short update, short remove, EventDataFilter datafilter, boolean notifyOnItemExpiration, ListenerType listenerType) {
    }

    @Override
    public void registerKeyNotificationListener(String[] keys, short updateCallbackid, short removeCallbackid) throws CacheException {
    }

    @Override
    public void unRegisterKeyNotificationListener(String key, short updateCallbackid, short removeCallbackid) throws CacheException {
    }

    @Override
    public void unRegisterKeyNotificationListener(String[] key, short update, short remove) throws CacheException {
    }

    @Override
    public void unRegisterGeneralNotificationListener(EventTypeInternal unregister, short sequenceNumber) throws CacheException {
    }

    @Override
    public void registerGeneralNotification(EventTypeInternal eventType, EventDataFilter datafilter, short sequenceNumber) throws CacheException {
    }

    @Override
    public void registerKeyNotificationListener(String[] keys, short updateCallbackid, short removeCallbackid, String clientId, ListenerType listenerType) {
    }

    @Override
    public void touch(ArrayList<String> keys) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(10000, ErrorMessages.getErrorMessage((int)10000, (String[])new String[0]));
    }

    @Override
    public void CollectionClearOperation(CollectionOperation operation) {
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        this._nCache.ClearCollection(operation, operationContext);
    }

    @Override
    public int CollectionCountOperation(CollectionOperation operation) {
        OperationContext operationContext = new OperationContext(OperationContextFieldName.OperationType, (Object)OperationContextOperationType.CacheOperation);
        return this._nCache.GetCollectionCount(operation, operationContext);
    }

    @Override
    GetCollectionChunkResponseBase GetCollectionChunk(GetCollectionChunkOperation operation) {
        return null;
    }

    @Override
    long counterGetOperation(CounterGetOperation counterGetOperation) {
        return 0L;
    }

    @Override
    long counterOperations(CounterOperation operation) {
        return 0L;
    }

    @Override
    void dictionaryAdd(DictionaryAddOperation operation) {
    }

    @Override
    Collection<ExtendedJsonValueBase> dictionaryGet(DictionaryGetOperation operation) {
        return null;
    }

    @Override
    int dictionaryRemove(DictionaryRemoveOperation operation) {
        return 0;
    }

    @Override
    boolean dictionaryContains(DictionaryContainsOperation tempVar) {
        return false;
    }

    @Override
    void hashSetAdd(HashSetAddOperation tempVar) {
    }

    @Override
    int hashSetRemove(HashSetRemoveOperation tempVar) {
        return 0;
    }

    @Override
    List<ExtendedJsonValueBase> hashSetGetRandom(HashSetGetRandomOperation operation) {
        return null;
    }

    @Override
    List<ExtendedJsonValueBase> hashSetRemoveRandom(HashSetRemoveRandomOperation operation) {
        return null;
    }

    @Override
    boolean hashSetContains(HashSetContainsOperation operation) {
        return false;
    }

    @Override
    boolean queueEnqueue(QueueEnqueueOperation operation) {
        return false;
    }

    @Override
    ExtendedJsonValueBase queueDequeue(QueueDequeueOperation operation) {
        return null;
    }

    @Override
    ExtendedJsonValueBase queuePeek(QueuePeekOperation queuePeekOperation) {
        return null;
    }

    @Override
    boolean queueSearch(QueueSearchOperation operation) {
        return false;
    }

    public void PublishMetadata(MetricsTransporter transporter) {
    }
}

