/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Caching.Messaging.Message;
import Alachisoft.NCache.Caching.OpCode;
import Alachisoft.NCache.Caching.Queries.QueryResultSet;
import Alachisoft.NCache.Caching.TagComparisonType;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.DataReader.DistributedGroupedRSEnumerator;
import Alachisoft.NCache.Common.DataReader.DistributedOrderedRSEnumerator;
import Alachisoft.NCache.Common.DataReader.DistributedRSEnumerator;
import Alachisoft.NCache.Common.DataReader.PartitionRSEnumerator;
import Alachisoft.NCache.Common.DataReader.ReaderResultSet;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumerator;
import Alachisoft.NCache.Common.DataReader.RecordSetEnumeratorImpl;
import Alachisoft.NCache.Common.DataReader.RecordSetLoader;
import Alachisoft.NCache.Common.DataStructures.EnumerationDataChunk;
import Alachisoft.NCache.Common.DataStructures.EnumerationPointer;
import Alachisoft.NCache.Common.DataStructures.GroupEnumerationPointer;
import Alachisoft.NCache.Common.DataTypes.CollectionCreateOrGetOperation;
import Alachisoft.NCache.Common.DataTypes.CollectionNotifRegOperation;
import Alachisoft.NCache.Common.DataTypes.CollectionOperation;
import Alachisoft.NCache.Common.DataTypes.Counter.CounterGetOperation;
import Alachisoft.NCache.Common.DataTypes.Counter.CounterOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryAddOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryContainsOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryGetOperation;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryRemoveOperation;
import Alachisoft.NCache.Common.DataTypes.GetCollectionChunkOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetAddOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetContainsOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetGetRandomOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetRemoveOperation;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetRemoveRandomOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithPivotOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithoutIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListGetBulkOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListGetItemOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListInsertWithIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListRemoveWithIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListRemoveWithoutIndexOperation;
import Alachisoft.NCache.Common.DataTypes.List.ListSearchOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueDequeueOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueEnqueueOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueuePeekOperation;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueSearchOperation;
import Alachisoft.NCache.Common.DataTypes.Responses.GetCollectionChunkResponseBase;
import Alachisoft.NCache.Common.Enum.NotificationsType;
import Alachisoft.NCache.Common.Enum.SubscriptionType;
import Alachisoft.NCache.Common.Enum.TopicOperationType;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.Partition;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.PartitioningStrategy;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.ServiceConfiguration;
import Alachisoft.NCache.Common.ServicePropValues;
import Alachisoft.NCache.Common.StopWatch;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import Alachisoft.NCache.Common.Util.DependencyHelper;
import Alachisoft.NCache.Management.Statistics.StatisticsCounter;
import com.alachisoft.ncache.client.CacheConnectionOptions;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.CacheStatusEventListener;
import com.alachisoft.ncache.client.CacheStatusNotificationType;
import com.alachisoft.ncache.client.CacheSyncDependency;
import com.alachisoft.ncache.client.ClientInfo;
import com.alachisoft.ncache.client.ClusterEvent;
import com.alachisoft.ncache.client.ContinuousQuery;
import com.alachisoft.ncache.client.Credentials;
import com.alachisoft.ncache.client.LockHandle;
import com.alachisoft.ncache.client.ServerInfo;
import com.alachisoft.ncache.client.StreamMode;
import com.alachisoft.ncache.client.datastructures.DataStructureAttributes;
import com.alachisoft.ncache.client.internal.caching.ActivityBlockedException;
import com.alachisoft.ncache.client.internal.caching.AsyncCacheClearedCallback;
import com.alachisoft.ncache.client.internal.caching.AsyncItemAddedCallback;
import com.alachisoft.ncache.client.internal.caching.AsyncItemRemovedCallback;
import com.alachisoft.ncache.client.internal.caching.AsyncItemUpdatedCallback;
import com.alachisoft.ncache.client.internal.caching.CacheAsyncEventsListener;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.CacheImplBase;
import com.alachisoft.ncache.client.internal.caching.CacheListener;
import com.alachisoft.ncache.client.internal.caching.CacheListenerWrapper;
import com.alachisoft.ncache.client.internal.caching.CacheNotificationType;
import com.alachisoft.ncache.client.internal.caching.CacheStatusListenerWrapper;
import com.alachisoft.ncache.client.internal.caching.CustomListener;
import com.alachisoft.ncache.client.internal.caching.CustomListenerWrapper;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.caching.RemoteCacheClusterEventsListener;
import com.alachisoft.ncache.client.internal.caching.RemoteCacheEventsListener;
import com.alachisoft.ncache.client.internal.caching.TargetMethodAttribute;
import com.alachisoft.ncache.client.internal.command.AddAttributeCommand;
import com.alachisoft.ncache.client.internal.command.AddCacheSyncDependency;
import com.alachisoft.ncache.client.internal.command.AddCommand;
import com.alachisoft.ncache.client.internal.command.AddDependencyCommand;
import com.alachisoft.ncache.client.internal.command.BridgeMakeTargetCacheActivePassiveCommand;
import com.alachisoft.ncache.client.internal.command.BulkAddCommand;
import com.alachisoft.ncache.client.internal.command.BulkDeleteCommand;
import com.alachisoft.ncache.client.internal.command.BulkGetCacheItemCommand;
import com.alachisoft.ncache.client.internal.command.BulkGetCommand;
import com.alachisoft.ncache.client.internal.command.BulkInsertCommand;
import com.alachisoft.ncache.client.internal.command.BulkRemoveCommand;
import com.alachisoft.ncache.client.internal.command.CheckSecurityAuthorization;
import com.alachisoft.ncache.client.internal.command.ClearCommand;
import com.alachisoft.ncache.client.internal.command.CloseStreamCommand;
import com.alachisoft.ncache.client.internal.command.CollectionClearCommand;
import com.alachisoft.ncache.client.internal.command.CollectionCountCommand;
import com.alachisoft.ncache.client.internal.command.CollectionNotificationRegistrationCommand;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandResponse;
import com.alachisoft.ncache.client.internal.command.ContainsBulkCommand;
import com.alachisoft.ncache.client.internal.command.CounterGetCommand;
import com.alachisoft.ncache.client.internal.command.CounterOperationsCommand;
import com.alachisoft.ncache.client.internal.command.DataTypeCreateCommand;
import com.alachisoft.ncache.client.internal.command.DataTypeGetCommand;
import com.alachisoft.ncache.client.internal.command.DeleteCommand;
import com.alachisoft.ncache.client.internal.command.DeleteQueryCommand;
import com.alachisoft.ncache.client.internal.command.DictionaryAddCommand;
import com.alachisoft.ncache.client.internal.command.DictionaryContainsCommand;
import com.alachisoft.ncache.client.internal.command.DictionaryGetCommand;
import com.alachisoft.ncache.client.internal.command.DictionaryRemoveCommand;
import com.alachisoft.ncache.client.internal.command.DisposeReaderCommand;
import com.alachisoft.ncache.client.internal.command.ExecuteReaderCommand;
import com.alachisoft.ncache.client.internal.command.GetCacheItemCommand;
import com.alachisoft.ncache.client.internal.command.GetCollectionChunkCommand;
import com.alachisoft.ncache.client.internal.command.GetCommand;
import com.alachisoft.ncache.client.internal.command.GetCompactTypesCommand;
import com.alachisoft.ncache.client.internal.command.GetCompressionSettings;
import com.alachisoft.ncache.client.internal.command.GetConnectedClientsCommand;
import com.alachisoft.ncache.client.internal.command.GetCountCommand;
import com.alachisoft.ncache.client.internal.command.GetEncryptionCommand;
import com.alachisoft.ncache.client.internal.command.GetExpirationCommand;
import com.alachisoft.ncache.client.internal.command.GetGroupCommand;
import com.alachisoft.ncache.client.internal.command.GetGroupNextChunkCommand;
import com.alachisoft.ncache.client.internal.command.GetKeysByTagCommand;
import com.alachisoft.ncache.client.internal.command.GetMessageCommand;
import com.alachisoft.ncache.client.internal.command.GetNextChunkCommand;
import com.alachisoft.ncache.client.internal.command.GetRecordSetNextChunkCommand;
import com.alachisoft.ncache.client.internal.command.GetSerializationFormatCommand;
import com.alachisoft.ncache.client.internal.command.GetStreamLengthCommand;
import com.alachisoft.ncache.client.internal.command.GetTagCommand;
import com.alachisoft.ncache.client.internal.command.GetThresholdCommand;
import com.alachisoft.ncache.client.internal.command.GetTopicCommand;
import com.alachisoft.ncache.client.internal.command.GetTypeInfoMapCommand;
import com.alachisoft.ncache.client.internal.command.HashSetAddCommand;
import com.alachisoft.ncache.client.internal.command.HashSetContainsCommand;
import com.alachisoft.ncache.client.internal.command.HashSetGetRandomCommand;
import com.alachisoft.ncache.client.internal.command.HashSetRemoveCommand;
import com.alachisoft.ncache.client.internal.command.HashSetRemoveRandomCommand;
import com.alachisoft.ncache.client.internal.command.InsertCommand;
import com.alachisoft.ncache.client.internal.command.IsLockedCommand;
import com.alachisoft.ncache.client.internal.command.ListAddWithPivotCommand;
import com.alachisoft.ncache.client.internal.command.ListAddWithoutIndexCommand;
import com.alachisoft.ncache.client.internal.command.ListGetBulkItemsCommand;
import com.alachisoft.ncache.client.internal.command.ListGetItemCommand;
import com.alachisoft.ncache.client.internal.command.ListInsertWithIndexCommand;
import com.alachisoft.ncache.client.internal.command.ListRemoveWihoutIndexCommand;
import com.alachisoft.ncache.client.internal.command.ListRemoveWithIndexCommand;
import com.alachisoft.ncache.client.internal.command.ListSearchCommand;
import com.alachisoft.ncache.client.internal.command.LockCommand;
import com.alachisoft.ncache.client.internal.command.MesasgeAcknowledgmentCommand;
import com.alachisoft.ncache.client.internal.command.MessageCountCommand;
import com.alachisoft.ncache.client.internal.command.MessagePublishBulkCommand;
import com.alachisoft.ncache.client.internal.command.MessagePublishCommand;
import com.alachisoft.ncache.client.internal.command.ModuleCommand;
import com.alachisoft.ncache.client.internal.command.OpenStreamCommand;
import com.alachisoft.ncache.client.internal.command.QueueDequeueCommand;
import com.alachisoft.ncache.client.internal.command.QueueEnqueueCommand;
import com.alachisoft.ncache.client.internal.command.QueuePeekCommand;
import com.alachisoft.ncache.client.internal.command.QueueSearchCommand;
import com.alachisoft.ncache.client.internal.command.RaiseCustomEventCommand;
import com.alachisoft.ncache.client.internal.command.ReadFromStreamCommand;
import com.alachisoft.ncache.client.internal.command.RegisterBulkKeyNotificationCommand;
import com.alachisoft.ncache.client.internal.command.RegisterCQCommand;
import com.alachisoft.ncache.client.internal.command.RegisterKeyNotificationCommand;
import com.alachisoft.ncache.client.internal.command.RegisterNotification;
import com.alachisoft.ncache.client.internal.command.RemoveByTagCommand;
import com.alachisoft.ncache.client.internal.command.RemoveCommand;
import com.alachisoft.ncache.client.internal.command.RemoveGroupCommand;
import com.alachisoft.ncache.client.internal.command.RemoveTopicCommand;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.client.internal.command.SearchCommand;
import com.alachisoft.ncache.client.internal.command.SubscribeTopicCommand;
import com.alachisoft.ncache.client.internal.command.TouchCommand;
import com.alachisoft.ncache.client.internal.command.UnRegisterBulkKeyNotification;
import com.alachisoft.ncache.client.internal.command.UnRegisterCQCommand;
import com.alachisoft.ncache.client.internal.command.UnRegisterKeyNotification;
import com.alachisoft.ncache.client.internal.command.UnSubscribeTopicCommand;
import com.alachisoft.ncache.client.internal.command.UnlockCommand;
import com.alachisoft.ncache.client.internal.command.WriteToStreamCommand;
import com.alachisoft.ncache.client.internal.communication.Broker;
import com.alachisoft.ncache.client.internal.communication.Connection;
import com.alachisoft.ncache.client.internal.communication.ModuleOperation;
import com.alachisoft.ncache.client.internal.communication.Request;
import com.alachisoft.ncache.client.internal.messaging.ReceivedMessages;
import com.alachisoft.ncache.client.internal.util.ConversionUtil;
import com.alachisoft.ncache.client.internal.util.HelperUtil;
import com.alachisoft.ncache.client.internal.util.VirtualArray;
import com.alachisoft.ncache.client.util.SerializationUtil;
import com.alachisoft.ncache.common.monitoring.ClientMetaData;
import com.alachisoft.ncache.common.monitoring.MetricsTransporter;
import com.alachisoft.ncache.common.protobuf.DependencyProtocol;
import com.alachisoft.ncache.ncactivate.utils.RegUtil;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.CacheItemAttributes;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.NamedTagsDictionary;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.SubscriptionPolicyType;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.messaging.TopicPriority;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.DataTypeEventDataFilter;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.InternalCommandException;
import com.alachisoft.ncache.runtime.exceptions.InvalidReaderException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.exceptions.StateTransferInProgressException;
import com.alachisoft.ncache.runtime.exceptions.StreamAlreadyLockedException;
import com.alachisoft.ncache.runtime.exceptions.StreamCloseException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamInvalidLockException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import com.alachisoft.ncache.runtime.exceptions.runtime.OperationFailedRuntimeException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheArgumentException;
import com.alachisoft.ncache.serialization.standard.FormatterServices;
import com.alachisoft.ncache.serialization.standard.io.ObjectInputStream;
import com.alachisoft.ncache.serialization.util.TypeInfoMap;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import tangible.RefObject;

public final class RemoteCache
extends CacheImplBase
implements RecordSetLoader {
    public static final TimeSpan NoLockingExpiration = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    public static Date NoAbsoluteExpiration = null;
    public static TimeSpan NoSlidingExpiration = null;
    StatisticsCounter _perfStatsCollector;
    List<CacheListenerWrapper> _cacheCleared = Collections.synchronizedList(new ArrayList());
    List<CacheListenerWrapper> _cacheItemAdded = Collections.synchronizedList(new ArrayList());
    List<CacheListenerWrapper> _cacheItemUpdated = Collections.synchronizedList(new ArrayList());
    List<CacheListenerWrapper> _cacheItemRemoved = Collections.synchronizedList(new ArrayList());
    List<CacheStatusListenerWrapper> _memberJoined = Collections.synchronizedList(new ArrayList());
    List<CacheStatusListenerWrapper> _memberLeft = Collections.synchronizedList(new ArrayList());
    List<CacheStatusListenerWrapper> _cacheStopped = Collections.synchronizedList(new ArrayList());
    List<CustomListenerWrapper> _customListener = Collections.synchronizedList(new ArrayList());
    boolean _clientConnectivityRegistered;
    boolean _clientCacheEnabled = false;
    FormatterServices impl;
    HashMap _compactTypes;
    HashMap _attributeOrder;
    HashMap _portablity;
    private String cacheId = null;
    private String _monitoringSessionId;
    private String _cacheConfigId;
    private boolean exceptionsEnabled = true;
    private boolean memberjoinedFlag = false;
    private boolean memberleftFlag = false;
    private boolean cachestoppedFlag = false;
    private Level _level = Level.SEVERE;
    private Broker Broker = null;
    private int _compressed = 2;
    private Vector callbackQue = new Vector();
    private TypeInfoMap typeMap = null;
    private long _compressionThresholdSize;
    private boolean _compressionEnabled;
    private boolean _addNotifRegistered;
    private boolean _updateNotifRegistered;
    private boolean _removeNotifRegistered;
    private boolean _clearNotifRegistered;
    private boolean _customNotifRegistered;
    private int _refCounter = 0;
    private int forcedViewId = -5;
    private String _bridgeTargetCacheUniqueID;
    private String _serializationContext;
    private HashMap _encryption;
    private HashMap _expirations;
    private CacheImpl _parent;
    private CacheAsyncEventsListener _asyncListener;
    private RemoteCacheClusterEventsListener _clusterListener;
    private RemoteCacheEventsListener _EventsListener;
    private RemoteCacheClusterEventsListener cacheClusterEventsListener;
    private HashMap<String, HashMap<RecordSetEnumerator, Object>> validReaders = new HashMap();
    StopWatch _dedicatedCallMonitoring = new StopWatch();
    boolean _isDedicatedCall = false;
    Object _mutexlock = new Object();

    private RemoteCache() {
    }

    public RemoteCache(String cacheId, CacheImpl parent, Credentials securityParams, CacheConnectionOptions cacheConnectionOptions, StatisticsCounter perfStatsCol) throws GeneralFailureException, ConfigurationException, SecurityException, Exception {
        this._perfStatsCollector = perfStatsCol;
        this._parent = parent;
        if (this._parent != null) {
            this._asyncListener = new CacheAsyncEventsListener(this._parent);
            this._EventsListener = new RemoteCacheEventsListener(this._parent.getEventListener());
            this._clusterListener = new RemoteCacheClusterEventsListener(this._parent);
        }
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null.\nParamenter name: cacheId");
        }
        this.cacheId = cacheId.toLowerCase();
        this.Broker = new Broker(this, securityParams, cacheConnectionOptions, perfStatsCol, this.getLocalClientInfo());
        ServerInfo rServer = this.Broker.GetInitialServer();
        try {
            this.Broker.StartServices(cacheId, rServer.getName(), rServer.getPort());
            this._cacheConfigId = this.Broker.getCacheConfigID();
            this._monitoringSessionId = this.Broker.getMonitoringSessionId();
        }
        catch (SecurityException sec) {
            throw sec;
        }
        catch (CacheException ex) {
            throw new GeneralFailureException(ex.getMessage());
        }
        if (!this.Broker.getIsConnected()) {
            this.Broker.dispose();
            throw new OperationFailedException(17509, ErrorMessages.getErrorMessage((int)17509, (String[])new String[]{this.cacheId}));
        }
    }

    public CacheAsyncEventsListener getAsyncEventListener() {
        return this._asyncListener;
    }

    public RemoteCacheClusterEventsListener getCacheClusterEventsListener() {
        return this._clusterListener;
    }

    public void setCacheClusterEventsListener(RemoteCacheClusterEventsListener cacheClusterEventsListener) {
        this._clusterListener = cacheClusterEventsListener;
    }

    public RemoteCacheEventsListener getEventsListener() {
        return this._EventsListener;
    }

    protected List<CustomListenerWrapper> getCustomEventListenerList() {
        return this._customListener;
    }

    @Override
    boolean isInproc() {
        return false;
    }

    @Override
    public String getMonitoringSessionId() {
        return this._monitoringSessionId;
    }

    @Override
    public String getCacheConfigId() {
        return this._cacheConfigId;
    }

    String getSerializationContext() {
        return this._serializationContext;
    }

    void setSerializationContext(String value) {
        this._serializationContext = value;
    }

    String getTargetCacheUniqueID() {
        return this._bridgeTargetCacheUniqueID;
    }

    void setTargetCacheUniqueID(String value) {
        this._bridgeTargetCacheUniqueID = value;
    }

    void setParentCache(CacheImpl parentCache) {
        this._parent = parentCache;
    }

    @Override
    public String getName() {
        return this.cacheId;
    }

    @Override
    public ILogger getNCacheLog() {
        return this.Broker.getNCacheLog();
    }

    @Override
    Vector getCallbackQueue() {
        return this.callbackQue;
    }

    @Override
    public void setItem(String key, Object value) {
    }

    @Override
    public HashMap getEncryptionInfo() {
        return this._encryption;
    }

    @Override
    public void touch(ArrayList<String> keys) throws OperationFailedException, LicensingException, CommandException, StreamAlreadyLockedException, GeneralFailureException, OperationNotSupportedException, SecurityException, StreamException, ConfigurationException, StreamNotFoundException, AggregateException {
        Request request;
        HashMap keysDistributionMap = new HashMap();
        if (this.Broker.getImportHashmap()) {
            request = new Request(true, this.Broker.getOperationTimeout());
            RefObject tempRef_keysDistributionMap = new RefObject(keysDistributionMap);
            boolean isMrgKeys = this.Broker.getKeysDistributionMap(ConversionUtil.toArray(keys, String.class), null, keysDistributionMap);
            keysDistributionMap = (HashMap)tempRef_keysDistributionMap.argvalue;
            for (Address serverAddress : keysDistributionMap.keySet()) {
                Map.Entry keysAndItems = (Map.Entry)keysDistributionMap.get(serverAddress);
                ArrayList<String> list = new ArrayList<String>();
                for (String key : (String[])keysAndItems.getKey()) {
                    list.add(key);
                }
                TouchCommand command = new TouchCommand(list);
                if (isMrgKeys) {
                    command.setClientLastViewId(-5L);
                } else {
                    command.setClientLastViewId(this.Broker.getClientLastViewId());
                }
                request.addCommand(serverAddress, command);
            }
        } else {
            TouchCommand command = new TouchCommand(keys);
            request = this.Broker.createRequest(command);
        }
        this.Broker.executeRequest(request);
        CommandResponse res = request.getResponse();
        res.parseResponse();
    }

    @Override
    protected TypeInfoMap getTypeMap() {
        return this.typeMap;
    }

    @Override
    protected void setTypeMap(TypeInfoMap value) {
        this.typeMap = value;
    }

    synchronized void addRef() {
        ++this._refCounter;
    }

    public String toString() {
        return this.cacheId;
    }

    public boolean isExceptionsEnabled() {
        return this.exceptionsEnabled;
    }

    public void setExceptionsEnabled(boolean exceptionsEnabled) {
        this.exceptionsEnabled = exceptionsEnabled;
    }

    @Override
    public CacheItemVersion add(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, short onRemoveCallback, short onUpdateCallback, short onDsItemAddedCallback, boolean isResyncExpiredItems, String group, HashMap queryInfo, BitSet flagMap, String providerName, String resyncProviderName, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, long size, boolean encryptionEnabled, String clientId, String typeName) throws OperationFailedException, AggregateException, SecurityException, GeneralFailureException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        AddCommand command = new AddCommand(key, (byte[])value, dependency, syncDependency, absoluteExpiration, slidingExpiration, priority, onRemoveCallback, onUpdateCallback, onDsItemAddedCallback, isResyncExpiredItems, group, -1, false, queryInfo, flagMap, providerName, resyncProviderName, this.getEncryptionEnabled(), this.cacheId, itemUpdateDataFilter, itemRemovedDataFilter, TargetMethodAttribute.getMethodOverload(), clientId, typeName);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
        return HelperUtil.createCacheItemVersion(response.getVersion());
    }

    @Override
    public Object addAsync(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, short onRemoveCallback, short onUpdateCallback, short onAsyncItemAddCallback, short dsItemAddedCallback, boolean isResyncExpiredItems, String group, HashMap queryInfo, BitSet flagMap, String providerName, String resyncProviderName, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, long size, String clientId, short updateCallbackId, short removeCallbackId, short dsItemAddedCallbackId) throws Exception {
        return null;
    }

    @Override
    public HashMap add(String[] keys, CacheItem[] items, short onDataSourceItemsAdded, String providerName, long[] sizes, boolean encryptionEnabled, String clientID, short updateCallbackId, short removeCallbackId, EventDataFilter updateCallbackFilter, EventDataFilter removeCallbackFilter, boolean returnVersions, Map itemVersions, ListenerType listenerType) throws OperationFailedException, SecurityException, AggregateException, GeneralFailureException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        Request request;
        HashMap<Address, Map.Entry<String[], CacheItem[]>> keysDistributionMap = new HashMap<Address, Map.Entry<String[], CacheItem[]>>();
        if (this.Broker.getImportHashmap()) {
            if (this.Broker.poolFullyDisConnected()) {
                throw new OperationFailedException("No server is available to process the request");
            }
            if (!this.Broker.getPoolFullyConnected()) {
                BulkAddCommand command = new BulkAddCommand(keys, items, onDataSourceItemsAdded, this._parent, providerName, encryptionEnabled, this.cacheId, 0, clientID, updateCallbackId, removeCallbackId, updateCallbackFilter, removeCallbackFilter, returnVersions, listenerType);
                request = this.Broker.createDedicatedRequest(command);
            } else {
                request = new Request(true, this.Broker.getOperationTimeout());
                boolean isMrgKeys = this.Broker.getKeysDistributionMap(keys, items, keysDistributionMap);
                for (Address serverAddress : keysDistributionMap.keySet()) {
                    Map.Entry<String[], CacheItem[]> keysAndItems = keysDistributionMap.get(serverAddress);
                    BulkAddCommand command = new BulkAddCommand(keysAndItems.getKey(), keysAndItems.getValue(), onDataSourceItemsAdded, this._parent, providerName, encryptionEnabled, this.cacheId, 0, clientID, updateCallbackId, removeCallbackId, updateCallbackFilter, removeCallbackFilter, returnVersions, listenerType);
                    command.setClientLastViewId(this.Broker.getClientLastViewId());
                    request.addCommand(serverAddress, command);
                    if (isMrgKeys) {
                        command.setClientLastViewId(-5L);
                    } else {
                        command.setClientLastViewId(this.Broker.getClientLastViewId());
                    }
                    request.addCommand(serverAddress, command);
                }
            }
        } else {
            BulkAddCommand command = new BulkAddCommand(keys, items, onDataSourceItemsAdded, this._parent, providerName, encryptionEnabled, this.cacheId, 0, clientID, updateCallbackId, removeCallbackId, updateCallbackFilter, removeCallbackFilter, returnVersions, listenerType);
            request = this.Broker.createRequest(command);
        }
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.getResultMap();
    }

    @Override
    public CacheItemVersion insert(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, short onRemoveCallback, short onUpdateCallback, short onDsItemUpdatedCallback, boolean isResyncExpiredItems, String group, HashMap queryInfo, BitSet flagMap, String lockId, CacheItemVersion version, LockAccessType accessType, String providerName, String resyncProviderName, EventDataFilter updateCallbackFilter, EventDataFilter removeCallabackFilter, long size, boolean encryptionEnabled, String clientId, String typeName, ListenerType listenerType) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        InsertCommand command = new InsertCommand(key, (byte[])value, dependency, syncDependency, absoluteExpiration, slidingExpiration, priority, onRemoveCallback, onUpdateCallback, onDsItemUpdatedCallback, isResyncExpiredItems, group, -1, false, queryInfo, flagMap, lockId, version == null ? 0L : version.getVersion(), accessType, providerName, resyncProviderName, encryptionEnabled, this.cacheId, updateCallbackFilter, removeCallabackFilter, TargetMethodAttribute.getMethodOverload(), clientId, typeName, listenerType);
        Request request = null;
        request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return HelperUtil.createCacheItemVersion(response.getVersion());
    }

    @Override
    public HashMap insert(String[] keys, CacheItem[] items, short onDsItemsUpdatedCallback, String providerName, long[] sizes, boolean encryptionEnabled, String clientId, short updateCallbackId, short removeCallbackId, EventDataFilter updateCallbackFilter, EventDataFilter removeCallbackFilter, boolean returnVersions, Map itemVersions, ListenerType listenerType) throws OperationFailedException, AggregateException, SecurityException, GeneralFailureException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        Request request;
        HashMap<Address, Map.Entry<String[], CacheItem[]>> keysDistributionMap = new HashMap<Address, Map.Entry<String[], CacheItem[]>>();
        if (this.Broker.getImportHashmap()) {
            if (this.Broker.poolFullyDisConnected()) {
                throw new OperationFailedException("No server is available to process the request");
            }
            if (!this.Broker.getPoolFullyConnected()) {
                BulkInsertCommand command = new BulkInsertCommand(keys, items, onDsItemsUpdatedCallback, this._parent, providerName, encryptionEnabled, this.cacheId, 0, clientId, updateCallbackId, removeCallbackId, updateCallbackFilter, removeCallbackFilter, returnVersions, listenerType);
                request = this.Broker.createDedicatedRequest(command);
            } else {
                request = new Request(true, this.Broker.getOperationTimeout());
                boolean isMrgKeys = this.Broker.getKeysDistributionMap(keys, items, keysDistributionMap);
                for (Address serverAddress : keysDistributionMap.keySet()) {
                    Map.Entry<String[], CacheItem[]> keysAndItems = keysDistributionMap.get(serverAddress);
                    BulkInsertCommand command = new BulkInsertCommand(keysAndItems.getKey(), keysAndItems.getValue(), onDsItemsUpdatedCallback, this._parent, providerName, encryptionEnabled, this.cacheId, 0, clientId, updateCallbackId, removeCallbackId, updateCallbackFilter, removeCallbackFilter, returnVersions, listenerType);
                    if (isMrgKeys) {
                        command.setClientLastViewId(-5L);
                    } else {
                        command.setClientLastViewId(this.Broker.getClientLastViewId());
                    }
                    request.addCommand(serverAddress, command);
                }
            }
        } else {
            BulkInsertCommand command = new BulkInsertCommand(keys, items, onDsItemsUpdatedCallback, this._parent, providerName, encryptionEnabled, this.cacheId, 0, clientId, updateCallbackId, removeCallbackId, updateCallbackFilter, removeCallbackFilter, returnVersions, listenerType);
            request = this.Broker.createRequest(command);
        }
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.getResultMap();
    }

    @Override
    public CompressedValueEntry remove(String key, BitSet flagMap, short dsItemRemovedCallbackId, String lockId, CacheItemVersion version, LockAccessType accessType, String providerName) throws CacheException {
        RemoveCommand command = new RemoveCommand(key, flagMap, -1, false, dsItemRemovedCallbackId, lockId, version == null ? 0L : version.getVersion(), accessType, providerName, 0);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        response.getFlagValueEntry().setValue((Object)response.getValue());
        return response.getFlagValueEntry();
    }

    @Override
    public HashMap remove(String[] keys, BitSet flagMap, String providerName, short onDsItemsRemovedCallback) throws CacheException {
        Request request;
        HashMap<Address, Map.Entry<String[], CacheItem[]>> keysDistributionMap = new HashMap<Address, Map.Entry<String[], CacheItem[]>>();
        if (this.Broker.getImportHashmap()) {
            if (this.Broker.poolFullyDisConnected()) {
                throw new OperationFailedException("No server is available to process the request");
            }
            if (!this.Broker.getPoolFullyConnected()) {
                BulkRemoveCommand command = new BulkRemoveCommand(keys, flagMap, providerName, onDsItemsRemovedCallback, 0);
                request = this.Broker.createDedicatedRequest(command);
            } else {
                request = new Request(true, this.Broker.getOperationTimeout());
                boolean isMrgKeys = this.Broker.getKeysDistributionMap(keys, null, keysDistributionMap);
                for (Address serverAddress : keysDistributionMap.keySet()) {
                    Map.Entry<String[], CacheItem[]> keysAndItems = keysDistributionMap.get(serverAddress);
                    BulkRemoveCommand command = new BulkRemoveCommand(keysAndItems.getKey(), flagMap, providerName, onDsItemsRemovedCallback, 0);
                    if (isMrgKeys) {
                        command.setClientLastViewId(-5L);
                    } else {
                        command.setClientLastViewId(this.Broker.getClientLastViewId());
                    }
                    request.addCommand(serverAddress, command);
                }
            }
        } else {
            BulkRemoveCommand command = new BulkRemoveCommand(keys, flagMap, providerName, onDsItemsRemovedCallback, 0);
            request = this.Broker.createRequest(command);
        }
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.getResultMap();
    }

    @Override
    public void delete(String key, BitSet flagMap, short dsItemRemovedCallbackId, String lockId, CacheItemVersion version, LockAccessType accessType, String providerName) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        DeleteCommand command = new DeleteCommand(key, flagMap, -1, false, dsItemRemovedCallbackId, lockId, version == null ? 0L : version.getVersion(), accessType, providerName, 0);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void delete(String[] keys, BitSet flagMap, String providerName, short onDsItemsRemovedCallback) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        Request request;
        HashMap<Address, Map.Entry<String[], CacheItem[]>> keysDistributionMap = new HashMap<Address, Map.Entry<String[], CacheItem[]>>();
        if (this.Broker.getImportHashmap()) {
            if (this.Broker.poolFullyDisConnected()) {
                throw new OperationFailedException("No server is available to process the request");
            }
            if (!this.Broker.getPoolFullyConnected()) {
                BulkDeleteCommand command = new BulkDeleteCommand(keys, flagMap, providerName, onDsItemsRemovedCallback, 0);
                request = this.Broker.createDedicatedRequest(command);
            } else {
                request = new Request(true, this.Broker.getOperationTimeout());
                boolean isMrgKeys = this.Broker.getKeysDistributionMap(keys, null, keysDistributionMap);
                for (Address serverAddress : keysDistributionMap.keySet()) {
                    Map.Entry<String[], CacheItem[]> keysAndItems = keysDistributionMap.get(serverAddress);
                    BulkDeleteCommand command = new BulkDeleteCommand(keysAndItems.getKey(), flagMap, providerName, onDsItemsRemovedCallback, 0);
                    if (isMrgKeys) {
                        command.setClientLastViewId(-5L);
                    } else {
                        command.setClientLastViewId(this.Broker.getClientLastViewId());
                    }
                    request.addCommand(serverAddress, command);
                }
            }
        } else {
            BulkDeleteCommand command = new BulkDeleteCommand(keys, flagMap, providerName, onDsItemsRemovedCallback, 0);
            request = this.Broker.createRequest(command);
        }
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void remove(String group) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException {
        RemoveGroupCommand command = new RemoveGroupCommand(group, false);
        Request request = this.Broker.createRequest(command);
        CommandResponse response = null;
        try {
            this.Broker.executeRequest(request);
            response = request.getResponse();
            if (this.isExceptionsEnabled()) {
                response.parseResponse();
            }
        }
        catch (StateTransferInProgressException ex) {
            command = new RemoveGroupCommand(group, false);
            request = this.Broker.createDedicatedRequest(command);
            try {
                this.Broker.executeRequest(request);
                response = request.getResponse();
                response.parseResponse();
                response.parseResponse();
            }
            catch (Exception exception) {
                throw new OperationFailedException(exception.getMessage());
            }
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
    }

    @Override
    public void clear(BitSet flagMap, short onDsClearedCallback, String providerName) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        ClearCommand command = new ClearCommand(-1, false, flagMap, onDsClearedCallback, providerName, 0);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void clearAsync(BitSet flagMap, short onDsClearedCallback, boolean isAsync, String providerName) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, Exception {
    }

    @Override
    public void clearAsync(BitSet flagMap, short onAsyncCacheClearCallback, short onDsClearedCallback, boolean isAsync, String providerName) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        ClearCommand command = new ClearCommand(-1, isAsync, flagMap, onDsClearedCallback, providerName, 0);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        if (!isAsync) {
            CommandResponse response = request.getResponse();
            if (this.isExceptionsEnabled()) {
                response.parseResponse();
            }
        }
    }

    @Override
    public QueryResultSet search(String query, HashMap values) throws OperationFailedException, GeneralFailureException, AggregateException {
        SearchCommand command = new SearchCommand(query, values, false, false);
        Request request = this.Broker.createRequest(command);
        CommandResponse response = null;
        OperationFailedException exception = null;
        try {
            this.Broker.executeRequest(request);
            response = request.getResponse();
        }
        catch (Exception ex) {
            exception = new OperationFailedException(ex.getMessage());
        }
        try {
            response.parseResponse();
        }
        catch (StateTransferInProgressException ex) {
            try {
                command = new SearchCommand(query, values, false, false);
                request = this.Broker.createDedicatedRequest(command);
                this.Broker.executeRequest(request);
                response = request.getResponse();
                response.parseResponse();
            }
            catch (Exception e) {
                exception = new OperationFailedException(e.getMessage());
            }
        }
        catch (Exception ex) {
            exception = new OperationFailedException(ex.getMessage());
        }
        if (this.isExceptionsEnabled() && exception != null) {
            throw exception;
        }
        QueryResultSet queryResultSet = response.getQueryResultSet();
        return queryResultSet;
    }

    @Override
    public int executeNonQuery(String query, HashMap values) throws OperationFailedException, Exception {
        CommandResponse res = null;
        DeleteQueryCommand command = new DeleteQueryCommand(query, values, true, TargetMethodAttribute.getMethodOverload());
        try {
            Request request = this.Broker.createRequest(command);
            this.Broker.executeRequest(request);
            res = request.getResponse();
            res.parseResponse();
        }
        catch (StateTransferInProgressException ex) {
            try {
                command = new DeleteQueryCommand(query, values, true, TargetMethodAttribute.getMethodOverload());
                Request request = this.Broker.createDedicatedRequest(command);
                this.Broker.executeRequest(request);
                res = request.getResponse();
                res.parseResponse();
            }
            catch (Exception e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        catch (Exception ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        return res.getRemovedKeyCount();
    }

    @Override
    public String registerCQ(ContinuousQuery query, String clientUniqueId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        RegisterCQCommand command = new RegisterCQCommand(query.getQueryInternal(), query.getQueryCommand().getParameters(), clientUniqueId, notifyAdd, notifyUpdate, notifyRemove, query.maxFilterInternal(EventType.ItemAdded).getValue(), query.maxFilterInternal(EventType.ItemRemoved).getValue(), query.maxFilterInternal(EventType.ItemUpdated).getValue(), TargetMethodAttribute.getMethodOverload());
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            if (ex instanceof ActivityBlockedException) {
                command = new RegisterCQCommand(query.getQueryInternal(), query.getValuesInternal(), clientUniqueId, notifyAdd, notifyUpdate, notifyRemove, query.maxFilterInternal(EventType.ItemAdded).getValue(), query.maxFilterInternal(EventType.ItemRemoved).getValue(), query.maxFilterInternal(EventType.ItemUpdated).getValue(), TargetMethodAttribute.getMethodOverload());
                try {
                    CommandResponse response = this.ExecuteCacheRequest(command, true);
                }
                catch (Exception ex1) {
                    throw new OperationFailedException(ex1.getMessage());
                }
            }
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            try {
                response.parseResponse();
            }
            catch (Exception e) {
                if (e instanceof StateTransferInProgressException) {
                    command = new RegisterCQCommand(query.getQueryInternal(), query.getQueryCommand().getParameters(), clientUniqueId, notifyAdd, notifyUpdate, notifyRemove, query.maxFilterInternal(EventType.ItemAdded).getValue(), query.maxFilterInternal(EventType.ItemRemoved).getValue(), query.maxFilterInternal(EventType.ItemUpdated).getValue(), TargetMethodAttribute.getMethodOverload());
                    try {
                        response = this.ExecuteCacheRequest(command, true);
                    }
                    catch (Exception ex) {
                        throw new OperationFailedException(ex.getMessage());
                    }
                    response.parseResponse();
                }
                throw new OperationFailedException(e.getMessage());
            }
        }
        return response.getQueryId();
    }

    @Override
    public void unRegisterCQ(String serverUniqueId, String clientUniqueId) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        UnRegisterCQCommand command = new UnRegisterCQCommand(serverUniqueId, clientUniqueId, TargetMethodAttribute.getMethodOverload());
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
    }

    @Override
    public void registerKeyNotificationListener(String key, short update, short remove, EventDataFilter datafilter, boolean notifyOnItemExpiration, ListenerType listenerType) throws OperationFailedException, CommandException, StreamNotFoundException, StreamException, OperationNotSupportedException, StreamAlreadyLockedException, AggregateException, GeneralFailureException, ConfigurationException, LicensingException, SecurityException {
        RegisterKeyNotificationCommand command = new RegisterKeyNotificationCommand(key, update, remove, datafilter, notifyOnItemExpiration);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
    }

    @Override
    public void registerKeyNotificationListener(String[] keys, short update, short remove, EventDataFilter datafilter, boolean notifyOnItemExpiration, ListenerType listenerType) throws OperationFailedException, CommandException, StreamNotFoundException, StreamException, OperationNotSupportedException, StreamAlreadyLockedException, AggregateException, GeneralFailureException, ConfigurationException, LicensingException, SecurityException {
        RegisterBulkKeyNotificationCommand command = new RegisterBulkKeyNotificationCommand(keys, update, remove, datafilter, notifyOnItemExpiration);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
    }

    @Override
    public void unRegisterGeneralNotificationListener(EventTypeInternal eventTypeInternal, short sequenceNumber) throws CacheException {
        NotificationsType notificationsType;
        if (eventTypeInternal == EventTypeInternal.ItemAdded) {
            notificationsType = NotificationsType.UnregAddNotif;
        } else if (eventTypeInternal == EventTypeInternal.ItemRemoved) {
            notificationsType = NotificationsType.UnregRemoveNotif;
        } else if (eventTypeInternal == EventTypeInternal.ItemUpdated) {
            notificationsType = NotificationsType.UnregUpdateNotif;
        } else {
            return;
        }
        RegisterNotification command = new RegisterNotification(notificationsType.getValue(), sequenceNumber);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
    }

    @Override
    public boolean contains(String key) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamAlreadyLockedException, StreamException, OperationNotSupportedException, LicensingException, StreamNotFoundException, CommandException {
        boolean containsResult = false;
        Map<String, Boolean> bulkResult = this.containsBulk(new String[]{key});
        if (bulkResult.size() > 0) {
            containsResult = bulkResult.get(key) == null ? false : bulkResult.get(key);
        }
        return containsResult;
    }

    @Override
    public Map<String, Boolean> containsBulk(String[] keys) throws OperationFailedException, SecurityException, AggregateException, GeneralFailureException, StreamNotFoundException, OperationNotSupportedException, StreamException, ConfigurationException, LicensingException, StreamAlreadyLockedException, CommandException {
        Request request = null;
        HashMap<Address, Map.Entry<String[], CacheItem[]>> keysDistributionMap = new HashMap<Address, Map.Entry<String[], CacheItem[]>>();
        if (this.Broker.getImportHashmap()) {
            request = new Request(true, this.Broker.getOperationTimeout());
            boolean isMergeKeys = this.Broker.getKeysDistributionMap(keys, null, keysDistributionMap);
            for (Address serverAddress : keysDistributionMap.keySet()) {
                Map.Entry<String[], CacheItem[]> keysAndItems = keysDistributionMap.get(serverAddress);
                ContainsBulkCommand command = new ContainsBulkCommand(keysAndItems.getKey(), 0);
                if (isMergeKeys) {
                    command.setClientLastViewId(-5L);
                } else {
                    command.setClientLastViewId(this.Broker.getClientLastViewId());
                }
                request.addCommand(serverAddress, command);
            }
        } else {
            ContainsBulkCommand command = new ContainsBulkCommand(keys, 0);
            request = this.Broker.createRequest(command);
        }
        CommandResponse response = null;
        this.Broker.executeRequest(request);
        response = request.getResponse();
        response.parseResponse();
        return RemoteCache.extractKeyStatus(response.getResultMap(), keys);
    }

    public static Map<String, Boolean> extractKeyStatus(HashMap hashMap, String[] keys) {
        ArrayList availableKeys = null;
        HashMap<String, Boolean> keyStatus = new HashMap<String, Boolean>();
        if (hashMap.containsKey("items-found")) {
            availableKeys = (ArrayList)hashMap.get("items-found");
        }
        for (String key : keys) {
            keyStatus.put(key, false);
            if (availableKeys == null || !availableKeys.contains(key)) continue;
            keyStatus.put(key, true);
        }
        return keyStatus;
    }

    @Override
    public String openStream(String key, StreamMode mode, String group, Date absExpiration, TimeSpan slidingExpiration, CacheDependency dependency, CacheItemPriority priority) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, StreamAlreadyLockedException, StreamCloseException, StreamInvalidLockException, StreamException, StreamNotFoundException, ConnectionException, Exception {
        OpenStreamCommand command = new OpenStreamCommand(key, mode, group, absExpiration, slidingExpiration, dependency, priority, 0);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.getLockId();
    }

    @Override
    public void closeStream(String key, String lockHandle) throws Exception {
        CloseStreamCommand command = new CloseStreamCommand(key, lockHandle, 0);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public int readFromStream(RefObject<byte[]> buffer, String key, String lockHandle, int offset, int streamOffset, int length) throws Exception {
        ReadFromStreamCommand command = new ReadFromStreamCommand(key, lockHandle, streamOffset, length);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        if (response.BytesRead() > 0) {
            VirtualArray vBuffer = new VirtualArray(response.DataList());
            vBuffer.CopyData((byte[])buffer.argvalue, offset, length);
        }
        return response.BytesRead();
    }

    @Override
    public void writeToStream(String key, String lockHandle, byte[] buffer, int srcOffset, int dstOffset, int length) throws Exception {
        WriteToStreamCommand command = new WriteToStreamCommand(key, lockHandle, srcOffset, dstOffset, length, buffer);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public long getStreamLength(String key, String lockHandle) throws Exception {
        GetStreamLengthCommand command = new GetStreamLengthCommand(key, lockHandle);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.StreamLegnth();
    }

    @Override
    public CompressedValueEntry get(String key, BitSet flagMap, String group, CacheItemVersion version, LockHandle lockHandle, TimeSpan lockTimeout, LockAccessType accessType, ReadThruOptions readThruOptions) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, CommandException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException {
        String lockId = lockHandle.getLockId();
        long itemVersion = version.getVersion();
        GetCommand command = new GetCommand(key, flagMap, group, accessType, lockId, lockTimeout, itemVersion, readThruOptions.getReadMode(), readThruOptions.getProviderName(), ProcessHandle.current().pid(), TargetMethodAttribute.getMethodOverload());
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        lockHandle.setLockId(response.getLockId());
        lockHandle.setLockDate(response.getLockDate().getDate());
        version.setVersion(response.getVersion());
        response.getFlagValueEntry().getFlag().setData((byte)(response.getFlagValueEntry().getFlag().getData() | flagMap.getData()));
        response.getFlagValueEntry().setType(response.getEntryType());
        return response.getFlagValueEntry();
    }

    public final CommandResponse ExecuteCacheRequest(Command command, boolean isDedicated) throws Exception {
        Request request = null;
        request = this.getIsDedicated() ? this.Broker.createDedicatedRequest(command) : this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        return request.getResponse();
    }

    public Map get(String[] keys, BitSet flagMap, ReadThruOptions readThruOptions) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException {
        Request request;
        HashMap<Address, Map.Entry<String[], CacheItem[]>> keysDistributionMap = new HashMap<Address, Map.Entry<String[], CacheItem[]>>();
        if (this.Broker.getImportHashmap() && this.Broker.getPoolFullyConnected()) {
            request = new Request(true, this.Broker.getOperationTimeout());
            boolean isMrgKeys = this.Broker.getKeysDistributionMap(keys, null, keysDistributionMap);
            for (Address serverAddress : keysDistributionMap.keySet()) {
                Map.Entry<String[], CacheItem[]> keysAndItems = keysDistributionMap.get(serverAddress);
                BulkGetCommand command = new BulkGetCommand(keysAndItems.getKey(), flagMap, readThruOptions, 0);
                if (isMrgKeys) {
                    command.setClientLastViewId(-5L);
                } else {
                    command.setClientLastViewId(this.Broker.getClientLastViewId());
                }
                request.addCommand(serverAddress, command);
            }
        } else {
            BulkGetCommand command = new BulkGetCommand(keys, flagMap, readThruOptions, 0);
            request = this.Broker.createRequest(command);
        }
        CommandResponse response = null;
        try {
            this.Broker.executeRequest(request);
            response = request.getResponse();
        }
        catch (Exception ex) {
            if (ex instanceof ActivityBlockedException && request.getCommandRequestType() == RequestType.KeyBulkRead) {
                BulkGetCommand command = new BulkGetCommand(keys, flagMap, readThruOptions, 0);
                try {
                    response = this.ExecuteCacheRequest(command, true);
                }
                catch (Exception ex1) {
                    throw new OperationFailedException(ex1.getMessage());
                }
            }
            throw new OperationFailedException(ex.getMessage());
        }
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.getResultMap();
    }

    @Override
    public Map getCacheItemBulk(String[] keysList, BitSet flagMap, ReadThruOptions readThruOptions) throws OperationFailedException, SecurityException, AggregateException, GeneralFailureException, StreamNotFoundException, OperationNotSupportedException, StreamException, ConfigurationException, LicensingException, StreamAlreadyLockedException {
        Request request;
        HashMap<Address, Map.Entry<String[], CacheItem[]>> keysDistributionMap = new HashMap<Address, Map.Entry<String[], CacheItem[]>>();
        if (this.Broker.getImportHashmap() && this.Broker.getPoolFullyConnected()) {
            request = new Request(true, this.Broker.getOperationTimeout());
            boolean isMrgKeys = this.Broker.getKeysDistributionMap(keysList, null, keysDistributionMap);
            for (Address serverAddress : keysDistributionMap.keySet()) {
                Map.Entry<String[], CacheItem[]> keysAndItems = keysDistributionMap.get(serverAddress);
                BulkGetCacheItemCommand command = new BulkGetCacheItemCommand(keysAndItems.getKey(), flagMap, readThruOptions, TargetMethodAttribute.getMethodOverload());
                if (isMrgKeys) {
                    command.setClientLastViewId(-5L);
                } else {
                    command.setClientLastViewId(this.Broker.getClientLastViewId());
                }
                request.addCommand(serverAddress, command);
            }
        } else {
            BulkGetCacheItemCommand command = new BulkGetCacheItemCommand(keysList, flagMap, readThruOptions, TargetMethodAttribute.getMethodOverload());
            request = this.Broker.createRequest(command);
        }
        CommandResponse response = null;
        try {
            this.Broker.executeRequest(request);
            response = request.getResponse();
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.getResultMap();
    }

    @Override
    public Collection getGroupKeys(String group) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException {
        GetGroupCommand command = new GetGroupCommand(group, true);
        Request request = this.Broker.createRequest(command);
        CommandResponse response = null;
        OperationFailedException exception = null;
        try {
            this.Broker.executeRequest(request);
            response = request.getResponse();
            response.parseResponse();
        }
        catch (Exception ex) {
            if (ex instanceof ActivityBlockedException) {
                command = new GetGroupCommand(group, true);
                try {
                    response = this.ExecuteCacheRequest(command, true);
                }
                catch (Exception ex1) {
                    exception = new OperationFailedException(ex1.getMessage());
                }
            }
            exception = new OperationFailedException(ex.getMessage());
        }
        try {
            response.parseResponse();
        }
        catch (StateTransferInProgressException ex) {
            try {
                command = new GetGroupCommand(group, true);
                request = this.Broker.createDedicatedRequest(command);
                this.Broker.executeRequest(request);
                response = request.getResponse();
                response.parseResponse();
            }
            catch (Exception e) {
                exception = new OperationFailedException(e.getMessage());
            }
        }
        catch (Exception ex) {
            exception = new OperationFailedException(ex.getMessage());
        }
        if (this.isExceptionsEnabled() && exception != null) {
            throw exception;
        }
        return response.getResultList();
    }

    @Override
    public HashMap getGroupData(String group) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException {
        GetGroupCommand command = new GetGroupCommand(group, false);
        Request request = this.Broker.createRequest(command);
        CommandResponse response = null;
        OperationFailedException exception = null;
        try {
            this.Broker.executeRequest(request);
            response = request.getResponse();
        }
        catch (Exception ex) {
            if (ex instanceof ActivityBlockedException) {
                command = new GetGroupCommand(group, false);
                try {
                    response = this.ExecuteCacheRequest(command, true);
                }
                catch (Exception ex1) {
                    exception = new OperationFailedException(ex1.getMessage());
                }
            }
            exception = new OperationFailedException(ex.getMessage());
        }
        try {
            response.parseResponse();
        }
        catch (StateTransferInProgressException ex) {
            try {
                command = new GetGroupCommand(group, false);
                request = this.Broker.createDedicatedRequest(command);
                this.Broker.executeRequest(request);
                response = request.getResponse();
                response.parseResponse();
            }
            catch (Exception e) {
                exception = new OperationFailedException(e.getMessage());
            }
        }
        catch (Exception ex) {
            exception = new OperationFailedException(ex.getMessage());
        }
        if (this.isExceptionsEnabled() && exception != null) {
            throw exception;
        }
        return response.getResultMap();
    }

    @Override
    public Object getCacheItem(String key, BitSet flagMap, String group, CacheItemVersion version, LockHandle lockHandle, TimeSpan lockTimeout, LockAccessType accessType, ReadThruOptions readThruOptions) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        String lockId = lockHandle.getLockId();
        long itemVersion = version.getVersion();
        GetCacheItemCommand command = new GetCacheItemCommand(key, flagMap, group, accessType, lockId, lockTimeout, itemVersion, readThruOptions, TargetMethodAttribute.getMethodOverload());
        Request request = null;
        try {
            request = this.Broker.createRequest(command);
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        lockHandle.setLockId(response.getLockId());
        lockHandle.setLockDate(response.getLockDate().getDate());
        if (response.getItem() == null) {
            return null;
        }
        version.setVersion(response.getItem().getCacheItemVersion() != null ? response.getItem().getCacheItemVersion().getVersion() : 0L);
        return response.getItem();
    }

    @Override
    public HashMap getByTag(Tag[] tags, TagComparisonType comparisonType) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, IllegalArgumentException {
        String[] sTags = this.tagsToStringArray(tags);
        GetTagCommand command = new GetTagCommand(sTags, comparisonType);
        Request request = this.Broker.createRequest(command);
        CommandResponse response = null;
        OperationFailedException exception = null;
        try {
            this.Broker.executeRequest(request);
            response = request.getResponse();
        }
        catch (Exception ex) {
            if (ex instanceof ActivityBlockedException) {
                command = new GetTagCommand(sTags, comparisonType);
                try {
                    response = this.ExecuteCacheRequest(command, true);
                }
                catch (Exception ex1) {
                    exception = new OperationFailedException(ex1.getMessage());
                }
            }
            exception = new OperationFailedException(ex.getMessage());
        }
        try {
            response.parseResponse();
        }
        catch (StateTransferInProgressException ex) {
            try {
                command = new GetTagCommand(sTags, comparisonType);
                request = this.Broker.createDedicatedRequest(command);
                this.Broker.executeRequest(request);
                response = request.getResponse();
                response.parseResponse();
            }
            catch (Exception e) {
                exception = new OperationFailedException(e.getMessage());
            }
        }
        catch (Exception ex) {
            exception = new OperationFailedException(ex.getMessage());
        }
        if (this.isExceptionsEnabled() && exception != null) {
            throw exception;
        }
        if (response.getResultMap() == null) {
            return null;
        }
        return response.getResultMap();
    }

    @Override
    public Collection getKeysByTag(Tag[] tags, TagComparisonType comparisonType) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, IllegalArgumentException, ConnectionException {
        OperationFailedException exception;
        CommandResponse response;
        Request request;
        GetKeysByTagCommand command;
        String[] sTags;
        block11: {
            sTags = this.tagsToStringArray(tags);
            command = new GetKeysByTagCommand(sTags, comparisonType);
            request = this.Broker.createRequest(command);
            response = null;
            exception = null;
            try {
                this.Broker.executeRequest(request);
                response = request.getResponse();
            }
            catch (Exception ex) {
                if (!(ex instanceof ActivityBlockedException)) break block11;
                command = new GetKeysByTagCommand(sTags, comparisonType);
                try {
                    response = this.ExecuteCacheRequest(command, true);
                }
                catch (Exception ex1) {
                    exception = new OperationFailedException(ex1.getMessage());
                }
                exception = new OperationFailedException(ex.getMessage());
            }
        }
        try {
            response.parseResponse();
        }
        catch (StateTransferInProgressException ex) {
            try {
                command = new GetKeysByTagCommand(sTags, comparisonType);
                request = this.Broker.createDedicatedRequest(command);
                this.Broker.executeRequest(request);
                response = request.getResponse();
                response.parseResponse();
            }
            catch (Exception e) {
                exception = new OperationFailedException(e.getMessage());
            }
        }
        catch (Exception ex) {
            exception = new OperationFailedException(ex.getMessage());
        }
        if (this.isExceptionsEnabled() && exception != null) {
            throw exception;
        }
        if (response.getResultMap() == null) {
            return null;
        }
        return response.getResultList();
    }

    @Override
    public void removeByTag(Tag[] tags, TagComparisonType comaprisonType) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, IllegalArgumentException {
        String[] sTags = this.tagsToStringArray(tags);
        RemoveByTagCommand command = new RemoveByTagCommand(sTags, comaprisonType);
        Request request = this.Broker.createRequest(command);
        CommandResponse response = null;
        try {
            this.Broker.executeRequest(request);
            response = request.getResponse();
            response.parseResponse();
            response.parseResponse();
        }
        catch (StateTransferInProgressException ex) {
            command = new RemoveByTagCommand(sTags, TagComparisonType.BY_TAG);
            request = this.Broker.createDedicatedRequest(command);
            try {
                this.Broker.executeRequest(request);
                response = request.getResponse();
                response.parseResponse();
                response.parseResponse();
            }
            catch (Exception exception) {
                throw new OperationFailedException(exception.getMessage());
            }
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
    }

    private String[] tagsToStringArray(Tag[] tags) throws IllegalArgumentException {
        if (tags == null) {
            throw new IllegalArgumentException("Tag");
        }
        String[] sTags = new String[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            if (sTags == null) {
                throw new IllegalArgumentException("Tag is null");
            }
            sTags[i] = tags[i].getTagName();
        }
        return sTags;
    }

    private HashMap getDeserializedValueMap(HashMap map) throws GeneralFailureException {
        if (map == null) {
            return null;
        }
        HashMap result = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry pair = entry = iterator.next();
            CompressedValueEntry valEntry = (CompressedValueEntry)pair.getValue();
            byte[] deflatValue = (byte[])valEntry.value;
            if (valEntry.flag.IsBitSet((byte)2)) {
                try {
                    deflatValue = CompressionUtil.Decompress((byte[])deflatValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result.put(pair.getKey(), this.getDeserializedObject(deflatValue, valEntry.flag));
        }
        return result;
    }

    @Override
    public boolean lock(String key, TimeSpan lockTimeout, LockHandle lockHandle) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, CommandException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException {
        LockCommand command = new LockCommand(key, lockTimeout, ProcessHandle.current().pid(), TargetMethodAttribute.getMethodOverload());
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
        LockHandle respHandle = response.getLockHandle();
        if (respHandle != null) {
            lockHandle.setLockDate(respHandle.getLockDate());
            lockHandle.setLockId(respHandle.getLockId());
        }
        return response.getLockAcquired();
    }

    @Override
    public boolean isLocked(String key, LockHandle lockHandle) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, CommandException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException {
        LockHandle respHandle;
        IsLockedCommand command = new IsLockedCommand(key, lockHandle.getLockId());
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        if ((respHandle = response.getLockHandle()) != null) {
            lockHandle.setLockDate(respHandle.getLockDate());
            lockHandle.setLockId(respHandle.getLockId() == null || respHandle.getLockId().equals("") ? null : respHandle.getLockId());
        }
        return response.getLockAcquired();
    }

    @Override
    public void unlock(String key) throws Exception {
        UnlockCommand command = new UnlockCommand(key, TargetMethodAttribute.getMethodOverload());
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    protected String getBridgeTargetCacheUniqueID() {
        return this._bridgeTargetCacheUniqueID;
    }

    @Override
    protected void setBridgeTargetCacheUniqueID(String value) {
    }

    @Override
    public void unlock(String key, String lockId) throws Exception {
        UnlockCommand command = new UnlockCommand(key, lockId, TargetMethodAttribute.getMethodOverload());
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public boolean addDependency(String key, CacheDependency dep, boolean isResyncRequired) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, CommandException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException {
        AddDependencyCommand command = new AddDependencyCommand(key, dep, isResyncRequired);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.success();
    }

    @Override
    public boolean addDependency(String key, CacheSyncDependency dep) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, CommandException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException {
        AddCacheSyncDependency command = new AddCacheSyncDependency(key, dep);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return new String(response.getValue()).equals("1");
    }

    @Override
    public boolean setAttributes(String key, CacheItemAttributes attributes) throws CacheException {
        AddAttributeCommand command = null;
        try {
            DependencyProtocol.Dependency dependency = null;
            if (attributes.getDependency() != null) {
                dependency = DependencyHelper.getDependencyProtocol((CacheDependency)attributes.getDependency());
            }
            command = new AddAttributeCommand(key, attributes.getAbsoluteExpiration(), dependency);
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage());
        }
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.isOperationSuccess();
    }

    @Override
    public void registerKeyNotificationListener(String key, short updateCallbackid, short removeCallbackid, EventDataFilter datafilter, boolean notifyOnItemExpiration) throws CacheException {
        RegisterKeyNotificationCommand command = new RegisterKeyNotificationCommand(key, updateCallbackid, removeCallbackid, datafilter, notifyOnItemExpiration);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (ConnectionException e) {
            throw new ConnectionException(e.getMessage());
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void registerKeyNotificationListener(String key, short updateCallbackid, short removeCallbackid, boolean notifyOnItemExpiration) throws CacheException {
        RegisterKeyNotificationCommand command = new RegisterKeyNotificationCommand(key, updateCallbackid, removeCallbackid, notifyOnItemExpiration);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (ConnectionException e) {
            throw new ConnectionException(e.getMessage());
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public boolean subscribe(String topicName, String subscriptionName, SubscriptionType subscriptionType, long creationTime, long expiration, SubscriptionPolicyType subscriptionPolicyType) throws CacheException {
        SubscribeTopicCommand command = new SubscribeTopicCommand(topicName, subscriptionName, subscriptionType, creationTime, expiration, subscriptionPolicyType);
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse res = request.getResponse();
        res.parseResponse();
        return res.success();
    }

    @Override
    public long getMessageCount(String topicName) throws OperationFailedException, CommandException, StreamNotFoundException, StreamException, OperationNotSupportedException, StreamAlreadyLockedException, AggregateException, GeneralFailureException, ConfigurationException, LicensingException, SecurityException {
        MessageCountCommand command = new MessageCountCommand(topicName);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse res = request.getResponse();
        res.parseResponse();
        return res.getMessageCount();
    }

    @Override
    public void unRegisterKeyNotificationListener(String key, short updateCallbackid, short removeCallbackid) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, CommandException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException {
        UnRegisterKeyNotification command = new UnRegisterKeyNotification(key, updateCallbackid, removeCallbackid);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void registerKeyNotificationListener(String[] keys, short updateCallbackid, short removeCallbackid) throws CacheException {
        RegisterBulkKeyNotificationCommand command = new RegisterBulkKeyNotificationCommand(keys, updateCallbackid, removeCallbackid);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void registerKeyNotificationListener(String[] keys, short updateCallbackid, short removeCallbackid, EventDataFilter dataFilter, boolean notifyOnItemExpiration) throws CacheException {
        RegisterBulkKeyNotificationCommand command = new RegisterBulkKeyNotificationCommand(keys, updateCallbackid, removeCallbackid, dataFilter, notifyOnItemExpiration);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public boolean checkSecurityAuthorization(String cacheId, byte[] password, String userId) throws OperationFailedException, SecurityException, AggregateException, GeneralFailureException, CommandException, StreamNotFoundException, OperationNotSupportedException, StreamException, ConfigurationException, LicensingException, StreamAlreadyLockedException {
        CheckSecurityAuthorization command = new CheckSecurityAuthorization(cacheId, userId, password);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse res = request.getResponse();
        res.parseResponse();
        return res.isIsAuthorized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void InvalidateReaders(String serverAddress) {
        HashMap<String, HashMap<RecordSetEnumerator, Object>> hashMap = this.validReaders;
        synchronized (hashMap) {
            if (this.validReaders.containsKey(serverAddress)) {
                HashMap<RecordSetEnumerator, Object> readers = this.validReaders.get(serverAddress);
                if (readers != null) {
                    for (RecordSetEnumerator partition : readers.keySet()) {
                        ((PartitionRSEnumerator)partition).setIsValid(false);
                    }
                }
                this.validReaders.remove(serverAddress);
            }
        }
    }

    @Override
    public void setCompressionThresholdSize(long compressionThreshold) {
    }

    @Override
    public void getThresholdSize(Connection connection) throws InternalCommandException, SecurityException, LicensingException, OperationFailedException {
        GetThresholdCommand command = new GetThresholdCommand(false);
        CommandResponse res = this.commandRegisterForExecution(connection, command);
        this.setCompressionEnabled(res.getCompressionEnable());
        this.setCompressionThreshold(res.getCompressionThreshold());
    }

    @Override
    public Map publishMessage(String topicName, Map<String, Message> keyMessageBulk, boolean notifyDeliveryFailure) throws OperationFailedException, LicensingException, CommandException, StreamAlreadyLockedException, GeneralFailureException, OperationNotSupportedException, SecurityException, StreamException, ConfigurationException, StreamNotFoundException, AggregateException {
        Request bulkRequest;
        HashMap<Address, ArrayList<Message>> messagesDistributionMap = new HashMap<Address, ArrayList<Message>>();
        boolean isDedicatedCall = false;
        if (this.Broker.getImportHashmap()) {
            for (Map.Entry<String, Message> message : keyMessageBulk.entrySet()) {
                Address serverAddress = null;
                RefObject tempRef_serverAddress = new RefObject(serverAddress);
                isDedicatedCall = this.Broker.GetServerAddressWithCallStatus(message.getKey(), (RefObject<Address>)tempRef_serverAddress) || isDedicatedCall;
                serverAddress = (Address)tempRef_serverAddress.argvalue;
                this.addToDistributionMap(serverAddress, messagesDistributionMap, message.getValue());
            }
            bulkRequest = new Request(true, this.Broker.getOperationTimeout());
            for (Address serverAddress : messagesDistributionMap.keySet()) {
                MessagePublishBulkCommand messageBulkCommand = new MessagePublishBulkCommand(topicName, (Collection)messagesDistributionMap.get(serverAddress), notifyDeliveryFailure);
                messageBulkCommand.setClientLastViewId(isDedicatedCall ? -5L : this.Broker.getClientLastViewId());
                bulkRequest.addCommand(serverAddress, messageBulkCommand);
            }
        } else {
            MessagePublishBulkCommand messagePublishBulkCommand = new MessagePublishBulkCommand(topicName, keyMessageBulk.values(), notifyDeliveryFailure);
            bulkRequest = this.Broker.createRequest(messagePublishBulkCommand);
        }
        this.Broker.executeRequest(bulkRequest);
        CommandResponse commandResponse = bulkRequest.getResponse();
        commandResponse.parseResponse();
        return commandResponse.getResultMap();
    }

    private void addToDistributionMap(Address serverAddress, HashMap<Address, ArrayList<Message>> messagesDistributionMap, Message value) {
        if (!messagesDistributionMap.containsKey(serverAddress)) {
            messagesDistributionMap.put(serverAddress, new ArrayList<Message>(Arrays.asList(value)));
        } else {
            messagesDistributionMap.get(serverAddress).add(value);
        }
    }

    @Override
    public final void reRegisterGeneralNotification(Connection connection) throws OperationFailedException, SecurityException, ConfigurationException, LicensingException {
        try {
            if (this._clearNotifRegistered) {
                this.registerNotification(connection, 4, true);
                this._clearNotifRegistered = true;
            }
            if (this._customNotifRegistered) {
                this.registerNotification(connection, 5, true);
                this._customNotifRegistered = true;
            }
            if (this._clientConnectivityRegistered) {
                this.registerNotification(connection, 10, true);
                this._customNotifRegistered = true;
            }
            this.registerNotification(connection, 6, true);
            this.registerNotification(connection, 7, true);
        }
        catch (ConfigurationException | LicensingException | SecurityException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void ExecuteModuleOperation(ModuleOperation operation) throws OperationFailedException, CommandException, LicensingException {
        if (operation != null) {
            Request request = new Request(true, this.Broker.getOperationTimeout());
            for (Map.Entry<Partition, byte[]> commandPair : operation.GetPayloads()) {
                ModuleCommand command = new ModuleCommand(commandPair.getValue(), operation.getModule(), operation.getVersion());
                request.addCommand(commandPair.getKey().getAddress(), command);
            }
            this.Broker.executeRequest(request);
            request.getModuleResponses(operation);
        }
    }

    @Override
    public PartitioningStrategy getPartitioningStrategy() {
        if (this.Broker != null) {
            return this.Broker.getPartitioningStrategy();
        }
        return null;
    }

    @Override
    public final void registerHashmapChangedEvent(Connection connection) throws OperationFailedException, SecurityException, ConfigurationException, LicensingException {
        try {
            this.registerNotification(connection, 9, true);
        }
        catch (ConfigurationException | LicensingException | SecurityException e) {
            throw e;
        }
        catch (CacheException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public final void getTypeInfoMap(Connection connection) throws InternalCommandException, SecurityException, LicensingException, OperationFailedException {
        GetTypeInfoMapCommand command = new GetTypeInfoMapCommand(false);
        CommandResponse res = this.commandRegisterForExecution(connection, command);
        this.setTypeMap(res.getTypeMap());
    }

    @Override
    public final void getCompactTypesFromServer(Connection connection) throws InternalCommandException, SecurityException, LicensingException, OperationFailedException {
        GetCompactTypesCommand command = new GetCompactTypesCommand(false);
        CommandResponse res = this.commandRegisterForExecution(connection, command);
        if (res.getResultMap() != null) {
            try {
                this.setCompactTypes(com.alachisoft.ncache.serialization.util.SerializationUtil.getCompactTypes((Map)res.getResultMap(), (boolean)false, (String)this.getName()));
            }
            catch (Exception e) {
                throw new OperationFailedRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public final void getEncryptionKeyFromServer(Connection connection) throws InternalCommandException, OperationFailedException, LicensingException, SecurityException {
        GetEncryptionCommand command = new GetEncryptionCommand(false);
        CommandResponse res = this.commandRegisterForExecution(connection, command);
        if (res.getResultMap() != null) {
            this._encryption = res.getResultMap();
        }
    }

    @Override
    public final void getExpirationFromServer(Connection connection) throws InternalCommandException, OperationFailedException, LicensingException, SecurityException {
        GetExpirationCommand command = new GetExpirationCommand(false);
        CommandResponse res = this.commandRegisterForExecution(connection, command);
        if (res.getResultMap() != null) {
            this._expirations = res.getResultMap();
        }
    }

    @Override
    public final void getSerializationFormat(Connection connection) throws InternalCommandException, OperationFailedException, LicensingException, SecurityException {
        GetSerializationFormatCommand command = new GetSerializationFormatCommand(false);
        CommandResponse res = this.commandRegisterForExecution(connection, command);
        this._parent.setSerializationFormat(res.getSerializationFormat());
    }

    private CommandResponse commandRegisterForExecution(Connection connection, Command executingCommand) throws InternalCommandException, OperationFailedException, SecurityException, LicensingException {
        Request request = new Request(false, this.Broker.getOperationTimeout());
        Address ipAddress = connection.getServerAddress();
        request.addCommand(ipAddress, executingCommand);
        CommandResponse res = null;
        try {
            this.Broker.executeRequest(request, connection, true, true);
            res = request.getResponse();
            res.parseResponse();
        }
        catch (InternalCommandException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (LicensingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage());
        }
        return res;
    }

    public void unRegisterKeyNotificationListener(String key, short updateCallbackid, short removeCallbackid, EventType eventType) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        UnRegisterKeyNotification command = new UnRegisterKeyNotification(key, updateCallbackid, removeCallbackid);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    public void unRegisterKeyNotificationListener(String[] key, short update, short remove, EventType eventType) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        UnRegisterBulkKeyNotification command = new UnRegisterBulkKeyNotification(key, update, remove);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void unRegisterKeyNotificationListener(String[] key, short update, short remove) throws OperationFailedException, GeneralFailureException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        UnRegisterBulkKeyNotification command = new UnRegisterBulkKeyNotification(key, update, remove);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void makeTargetCacheActivePassive(boolean makeActive) throws CacheException {
        BridgeMakeTargetCacheActivePassiveCommand command = new BridgeMakeTargetCacheActivePassiveCommand(makeActive);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void raiseCustomEvent(Object key, Object value) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        RaiseCustomEventCommand command = new RaiseCustomEventCommand(key, value, false);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
    }

    @Override
    public long getCount() throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        GetCountCommand command = new GetCountCommand(TargetMethodAttribute.getMethodOverload());
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (response != null) {
            if (this.isExceptionsEnabled()) {
                response.parseResponse();
            }
            return response.getCount();
        }
        return 0L;
    }

    @Override
    public void dispose(boolean disposing) throws GeneralFailureException, OperationFailedException, ConfigurationException {
        if (this.Broker != null) {
            this.Broker.dispose(disposing);
        }
        this.Broker = null;
        this._parent = null;
        this._encryption = null;
        this._expirations = null;
        this._perfStatsCollector = null;
    }

    @Override
    public Object getItem(String key) throws Exception {
        return null;
    }

    private void streamExceptionOccured(CommandResponse res) throws StreamAlreadyLockedException, StreamException, StreamInvalidLockException, StreamNotFoundException, StreamCloseException {
        if (res != null && res.getExpMessage() != null) {
            switch (res.getExpValue()) {
                case STREAM_ALREADY_LOCKED: {
                    throw new StreamAlreadyLockedException(new String(res.getExpMessage()));
                }
                case STREAM_CLOSED: {
                    throw new StreamCloseException(new String(res.getExpMessage()));
                }
                case STREAM_EXC: {
                    throw new StreamException(new String(res.getExpMessage()));
                }
                case STREAM_INVALID_LOCK: {
                    throw new StreamInvalidLockException(new String(res.getExpMessage()));
                }
                case STREAM_NOT_FOUND: {
                    throw new StreamNotFoundException(new String(res.getExpMessage()));
                }
            }
        }
    }

    @Override
    public Object safeSerialize(Object serializableObject, String serializationContext, BitSet flag, CacheImplBase cacheImpl, RefObject<Long> size, UserObjectType userObjectType, boolean isCustomerAtributeBaseSerialized) throws GeneralFailureException, OperationFailedException {
        return SerializationUtil.safeSerializeOutProc(serializableObject, serializationContext, flag, cacheImpl.getSerializationEnabled(), this._parent.getSerializationFormat(), size, userObjectType, isCustomerAtributeBaseSerialized);
    }

    @Override
    public <T> T safeDeserialize(Object serializedObject, String serializationContext, BitSet flag, CacheImplBase cacheImpl, UserObjectType userObjectType, Class<?> cls) throws OperationFailedException {
        Object deserialized = serializedObject;
        try {
            deserialized = SerializationUtil.safeDeserializeOutProc(serializedObject, serializationContext, flag, cacheImpl.getSerializationEnabled(), userObjectType, cls);
        }
        catch (UnsupportedOperationException e) {
            deserialized = serializedObject;
            throw e;
        }
        catch (ClassNotFoundException e2) {
            deserialized = serializedObject;
        }
        catch (JsonProcessingException e3) {
            throw new OperationFailedException(e3.getMessage());
        }
        catch (ClassCastException ex) {
            throw ex;
        }
        catch (Exception e4) {
            deserialized = serializedObject;
        }
        return (T)deserialized;
    }

    private Object getDeserializedObject(byte[] value, BitSet flag) throws GeneralFailureException {
        try {
            ByteArrayInputStream val = new ByteArrayInputStream(value);
            ObjectInputStream ow = new ObjectInputStream((InputStream)val, this.cacheId);
            return ow.readObject();
        }
        catch (IOException iOException) {
            return value;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GeneralFailureException(classNotFoundException.getMessage());
        }
    }

    @Override
    public void registerGeneralNotification(EventTypeInternal eventTypeInternal, EventDataFilter dataFilter, short sequenceNumber) throws CacheException {
        NotificationsType notificationType;
        if (eventTypeInternal == EventTypeInternal.ItemAdded) {
            notificationType = NotificationsType.RegAddNotif;
        } else if (eventTypeInternal == EventTypeInternal.ItemRemoved) {
            notificationType = NotificationsType.RegRemoveNotif;
        } else if (eventTypeInternal == EventTypeInternal.ItemUpdated) {
            notificationType = NotificationsType.RegUpdateNotif;
        } else {
            return;
        }
        RegisterNotification notif = new RegisterNotification(notificationType.getValue(), dataFilter.getValue(), sequenceNumber);
        Request request = this.Broker.createRequest(notif);
        try {
            this.Broker.executeRequest(request);
        }
        catch (ConnectionException e) {
            throw new ConnectionException(e.getMessage());
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public void registerKeyNotificationListener(String[] keys, short updateCallbackid, short removeCallbackid, String clientId, ListenerType listenerType) {
    }

    @Override
    protected void registerCacheEventlistener(CacheListener listener, EnumSet<CacheNotificationType> registerAgainst) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
        boolean cleared = false;
        boolean added = false;
        boolean removed = false;
        boolean updated = false;
        CacheListenerWrapper wrapper = new CacheListenerWrapper(listener);
        if (registerAgainst.contains((Object)CacheNotificationType.ALL)) {
            if (!this._cacheCleared.contains(wrapper)) {
                this._cacheCleared.add(wrapper);
                cleared = true;
            }
            if (!this._cacheItemAdded.contains(wrapper)) {
                this._cacheItemAdded.add(wrapper);
                added = true;
            }
            if (!this._cacheItemRemoved.contains(wrapper)) {
                this._cacheItemRemoved.add(wrapper);
                removed = true;
            }
            if (!this._cacheItemUpdated.contains(wrapper)) {
                this._cacheItemUpdated.add(wrapper);
                updated = true;
            }
        } else {
            if (registerAgainst.contains((Object)CacheNotificationType.CacheCleared) && !this._cacheCleared.contains(wrapper)) {
                this._cacheCleared.add(wrapper);
                cleared = true;
            }
            if (registerAgainst.contains((Object)CacheNotificationType.ItemAdded) && !this._cacheItemAdded.contains(wrapper)) {
                this._cacheItemAdded.add(wrapper);
                added = true;
            }
            if (registerAgainst.contains((Object)CacheNotificationType.ItemRemoved) && !this._cacheItemRemoved.contains(wrapper)) {
                this._cacheItemRemoved.add(wrapper);
                removed = true;
            }
            if (registerAgainst.contains((Object)CacheNotificationType.ItemUpdated) && !this._cacheItemUpdated.contains(wrapper)) {
                this._cacheItemUpdated.add(wrapper);
                updated = true;
            }
        }
        if (this._cacheCleared.size() == 1 && cleared && (registerAgainst.contains((Object)CacheNotificationType.CacheCleared) || registerAgainst.contains((Object)CacheNotificationType.ALL))) {
            this.registerNotification(4, true);
            this._clearNotifRegistered = true;
        }
        if (this._cacheItemAdded.size() == 1 && added && registerAgainst.contains((Object)CacheNotificationType.ItemAdded) || registerAgainst.contains((Object)CacheNotificationType.ALL)) {
            this.registerNotification(1, true);
            this._addNotifRegistered = true;
        }
        if (this._cacheItemRemoved.size() == 1 && removed && registerAgainst.contains((Object)CacheNotificationType.ItemRemoved) || registerAgainst.contains((Object)CacheNotificationType.ALL)) {
            this.registerNotification(3, true);
            this._removeNotifRegistered = true;
        }
        if (this._cacheItemUpdated.size() == 1 && updated && registerAgainst.contains((Object)CacheNotificationType.ItemUpdated) || registerAgainst.contains((Object)CacheNotificationType.ALL)) {
            this.registerNotification(2, true);
            this._updateNotifRegistered = true;
        }
    }

    @Override
    protected void unregisterCacheEventlistener(CacheListener listener, EnumSet<CacheNotificationType> unregisterAgainst) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
        if (unregisterAgainst.contains((Object)CacheNotificationType.ALL)) {
            this.removeIfCacheListenerExists(this._cacheCleared, listener);
            this.removeIfCacheListenerExists(this._cacheItemAdded, listener);
            this.removeIfCacheListenerExists(this._cacheItemRemoved, listener);
            this.removeIfCacheListenerExists(this._cacheItemUpdated, listener);
        } else {
            if (unregisterAgainst.contains((Object)CacheNotificationType.CacheCleared)) {
                this.removeIfCacheListenerExists(this._cacheCleared, listener);
            }
            if (unregisterAgainst.contains((Object)CacheNotificationType.ItemAdded)) {
                this.removeIfCacheListenerExists(this._cacheItemAdded, listener);
            }
            if (unregisterAgainst.contains((Object)CacheNotificationType.ItemRemoved)) {
                this.removeIfCacheListenerExists(this._cacheItemRemoved, listener);
            }
            if (unregisterAgainst.contains((Object)CacheNotificationType.ItemUpdated)) {
                this.removeIfCacheListenerExists(this._cacheItemUpdated, listener);
            }
        }
        if (this._cacheCleared.size() == 0 && unregisterAgainst.contains((Object)CacheNotificationType.CacheCleared)) {
            this.unregisterNotifications(103);
            this._clearNotifRegistered = false;
        }
        if (this._cacheItemAdded.size() == 0 && unregisterAgainst.contains((Object)CacheNotificationType.ItemAdded)) {
            this.unregisterNotifications(100);
            this._addNotifRegistered = false;
        }
        if (this._cacheItemRemoved.size() == 0 && unregisterAgainst.contains((Object)CacheNotificationType.ItemRemoved)) {
            this.unregisterNotifications(102);
            this._removeNotifRegistered = false;
        }
        if (this._cacheItemUpdated.size() == 0 && unregisterAgainst.contains((Object)CacheNotificationType.ItemUpdated)) {
            this.unregisterNotifications(101);
            this._updateNotifRegistered = false;
        }
    }

    private boolean removeIfCacheListenerExists(List list, EventListener listener) {
        Iterator ite = list.iterator();
        int indexOf = -1;
        if (listener instanceof CacheListener) {
            while (ite.hasNext()) {
                CacheListenerWrapper wrapper = (CacheListenerWrapper)ite.next();
                if (!wrapper.verifyListenerInstance((CacheListener)listener)) continue;
                indexOf = list.indexOf(wrapper);
                break;
            }
        }
        if (indexOf > -1) {
            list.remove(indexOf);
            return true;
        }
        return false;
    }

    private boolean removeIfClusterListenerExists(List list, EventListener listener) {
        Iterator ite = list.iterator();
        int indexOf = -1;
        if (listener instanceof CacheStatusEventListener) {
            while (ite.hasNext()) {
                CacheStatusListenerWrapper wrapper = (CacheStatusListenerWrapper)ite.next();
                if (!wrapper.verifyListenerInstance((CacheStatusEventListener)listener)) continue;
                indexOf = list.indexOf(wrapper);
                break;
            }
        }
        if (indexOf > -1) {
            list.remove(indexOf);
            return true;
        }
        return false;
    }

    private boolean removeIfCustomListenerExists(List list, EventListener listener) {
        Iterator ite = list.iterator();
        int indexOf = -1;
        if (listener instanceof CustomListener) {
            while (ite.hasNext()) {
                CustomListenerWrapper wrapper = (CustomListenerWrapper)ite.next();
                if (!wrapper.verifyListenerInstance((CustomListener)listener)) continue;
                indexOf = list.indexOf(wrapper);
                break;
            }
        }
        if (indexOf > -1) {
            list.remove(indexOf);
            return true;
        }
        return false;
    }

    private void registerNotification(int modifier, boolean checkConnected) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        RegisterNotification command = new RegisterNotification(modifier);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
    }

    private void registerNotification(Connection connection, int modifier, boolean checkConnected) throws OperationFailedException, CommandException, StreamNotFoundException, StreamException, OperationNotSupportedException, StreamAlreadyLockedException, AggregateException, GeneralFailureException, ConfigurationException, LicensingException, SecurityException {
        RegisterNotification command = new RegisterNotification(modifier, -1);
        Request request = new Request(false, this.Broker.getOperationTimeout());
        Address ipAddress = connection.getServerAddress();
        request.addCommand(ipAddress, command);
        try {
            this.Broker.executeRequest(request, connection, checkConnected, true);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
    }

    @Override
    protected void registerCacheStatusEventlistener(CacheStatusEventListener listener, EnumSet<CacheStatusNotificationType> registerAgainst) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
        boolean joined = false;
        boolean left = false;
        boolean stopped = false;
        CacheStatusListenerWrapper wrapper = new CacheStatusListenerWrapper(listener);
        if (registerAgainst.contains((Object)CacheStatusNotificationType.ALL)) {
            if (!this._memberJoined.contains(wrapper)) {
                this._memberJoined.add(wrapper);
                joined = true;
            }
            if (this._memberLeft.contains(wrapper)) {
                this._memberLeft.add(wrapper);
                left = true;
            }
            if (!this._cacheStopped.contains(wrapper)) {
                this._cacheStopped.add(wrapper);
                stopped = true;
            }
        } else {
            if (registerAgainst.contains((Object)CacheStatusNotificationType.MemberJoined) && !this._memberJoined.contains(wrapper)) {
                this._memberJoined.add(wrapper);
                joined = true;
            }
            if (registerAgainst.contains((Object)CacheStatusNotificationType.MemberLeft) && !this._memberLeft.contains(wrapper)) {
                this._memberLeft.add(wrapper);
                left = true;
            }
            if (registerAgainst.contains((Object)CacheStatusNotificationType.CacheStopped) && !this._cacheStopped.contains(wrapper)) {
                this._cacheStopped.add(wrapper);
                stopped = true;
            }
        }
        if (this._memberJoined.size() == 1 && joined && registerAgainst.contains((Object)CacheStatusNotificationType.MemberJoined) || registerAgainst.contains((Object)CacheStatusNotificationType.ALL)) {
            this.registerNotification(6, true);
            this.memberjoinedFlag = true;
        }
        if (this._memberLeft.size() == 1 && left && registerAgainst.contains((Object)CacheStatusNotificationType.MemberLeft) || registerAgainst.contains((Object)CacheStatusNotificationType.ALL)) {
            this.registerNotification(7, true);
            this.memberleftFlag = true;
        }
        if (this._cacheStopped.size() == 1 && stopped && registerAgainst.contains((Object)CacheStatusNotificationType.CacheStopped) || registerAgainst.contains((Object)CacheStatusNotificationType.ALL)) {
            this.registerNotification(8, true);
            this.cachestoppedFlag = true;
        }
    }

    @Override
    protected void unregisterCacheStatusEventlistener(CacheStatusEventListener listener, EnumSet<CacheStatusNotificationType> unregisterAgainst) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
        if (unregisterAgainst.contains((Object)CacheStatusNotificationType.ALL)) {
            this.removeIfCacheListenerExists(this._memberJoined, listener);
            this.removeIfCacheListenerExists(this._memberLeft, listener);
            this.removeIfCacheListenerExists(this._cacheStopped, listener);
        } else {
            if (unregisterAgainst.contains((Object)CacheStatusNotificationType.MemberJoined)) {
                this.removeIfCacheListenerExists(this._memberJoined, listener);
            }
            if (unregisterAgainst.contains((Object)CacheStatusNotificationType.MemberLeft)) {
                this.removeIfCacheListenerExists(this._memberLeft, listener);
            }
            if (unregisterAgainst.contains((Object)CacheStatusNotificationType.CacheStopped)) {
                this.removeIfCacheListenerExists(this._cacheStopped, listener);
            }
        }
        if (this._memberJoined.size() == 1 && unregisterAgainst.contains((Object)CacheStatusNotificationType.MemberJoined)) {
            this.unregisterNotifications(6);
            this.memberjoinedFlag = false;
        }
        if (this._memberLeft.size() == 1 && unregisterAgainst.contains((Object)CacheStatusNotificationType.MemberLeft)) {
            this.unregisterNotifications(7);
            this.memberleftFlag = false;
        }
        if (this._cacheStopped.size() == 1 && unregisterAgainst.contains((Object)CacheStatusNotificationType.CacheStopped)) {
            this.unregisterNotifications(8);
            this.cachestoppedFlag = false;
        }
    }

    @Override
    protected void registerCustomEventListener(CustomListener listener) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, Exception {
        CustomListenerWrapper wrapper;
        if (listener != null && !this._customListener.contains(wrapper = new CustomListenerWrapper(listener))) {
            this._customListener.add(wrapper);
            if (this._customListener.size() == 1) {
                this.registerCustomNotification();
            }
        }
    }

    @Override
    protected void unregisterCustomEventListener(CustomListener listener) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        if (listener != null) {
            this.removeIfCustomListenerExists(this._customListener, listener);
            if (this._customListener.size() == 0) {
                this.unregisterCustomNotification();
            }
        }
    }

    private void registerCustomNotification() throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
        this.registerNotification(5, true);
        this._customNotifRegistered = true;
    }

    private void unregisterCustomNotification() throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, CommandException {
        this.unregisterNotifications(104);
        this._customNotifRegistered = false;
    }

    private void unregisterNotifications(int modifier) throws GeneralFailureException, OperationFailedException, AggregateException, SecurityException, ConfigurationException, ConnectionException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        RegisterNotification command = new RegisterNotification(modifier, -1);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
    }

    private void notifyMemberJoinedEvent(String ip, int port) throws UnknownHostException {
        if (!this.memberjoinedFlag) {
            return;
        }
        final ClusterEvent event = new ClusterEvent(this, CacheStatusNotificationType.MemberJoined, ip, port, this.cacheId);
        int length = this._memberJoined.size();
        for (int i = 0; i < length; ++i) {
            final CacheStatusEventListener listener = this._memberJoined.get(i).getClusterEvent();
            ThreadPool.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    listener.onCacheStatusChanged(event);
                }
            });
        }
    }

    private void notifyMemberLeftEvent(String ip, int port) throws UnknownHostException {
        if (!this.memberleftFlag) {
            return;
        }
        final ClusterEvent event = new ClusterEvent(this, CacheStatusNotificationType.MemberJoined, ip, port, this.cacheId);
        int length = this._memberLeft.size();
        for (int i = 0; i < length; ++i) {
            final CacheStatusEventListener listener = this._memberLeft.get(i).getClusterEvent();
            ThreadPool.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    listener.onCacheStatusChanged(event);
                }
            });
        }
    }

    private void notifyCacheStoppedEvent(String cacheId) {
        if (!this.cachestoppedFlag) {
            return;
        }
        final ClusterEvent event = new ClusterEvent(this, CacheStatusNotificationType.CacheStopped, cacheId);
        int length = this._cacheStopped.size();
        for (int i = 0; i < length; ++i) {
            final CacheStatusEventListener listener = this._cacheStopped.get(i).getClusterEvent();
            ThreadPool.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    listener.onCacheStatusChanged(event);
                }
            });
        }
    }

    private void notifyAsyncAddEvent(int id, final String key, final Object value) {
        Object callback;
        if (id > -1 && (callback = this.callbackQue.get(id)) != null) {
            final AsyncItemAddedCallback item = (AsyncItemAddedCallback)callback;
            ThreadPool.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    item.asyncItemAdded(key, value);
                }
            });
        }
    }

    private void notifyAsyncUpdateEvent(int id, final String key, final Object value) {
        Object callback;
        if (id > -1 && (callback = this.callbackQue.get(id)) != null) {
            final AsyncItemUpdatedCallback item = (AsyncItemUpdatedCallback)callback;
            ThreadPool.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    item.asyncItemUpdated(key, value);
                }
            });
        }
    }

    private void notifyAsyncRemoveEvent(int id, final String key, final Object value) {
        Object callback;
        if (id > -1 && (callback = this.callbackQue.get(id)) != null) {
            final AsyncItemRemovedCallback item = (AsyncItemRemovedCallback)callback;
            ThreadPool.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    item.asyncItemRemoved(key, value);
                }
            });
        }
    }

    private void notifyAsyncClearEvent(int id, final Object value) {
        Object callback;
        if (id > -1 && (callback = this.callbackQue.get(id)) != null) {
            final AsyncCacheClearedCallback item = (AsyncCacheClearedCallback)callback;
            ThreadPool.getInstance().executeTask(new Runnable(){

                @Override
                public void run() {
                    item.asyncCacheCleared(value);
                }
            });
        }
    }

    public void onDataSourceUpdated(short callbackID, HashMap result, OpCode operationCode, boolean notifyAsync) {
        this._asyncListener.onDataSourceUpdated(callbackID, result, operationCode, notifyAsync);
    }

    @Override
    public ArrayList<EnumerationDataChunk> getNextChunk(ArrayList<EnumerationPointer> pointers) throws SecurityException, GeneralFailureException, OperationFailedException, AggregateException, ConnectionException, ConfigurationException, StreamException, StreamAlreadyLockedException, LicensingException, OperationNotSupportedException, StreamNotFoundException, CommandException {
        Request request;
        ArrayList<EnumerationDataChunk> nextChunk = null;
        Command command = null;
        if (pointers.size() > 0 && pointers.get(0).getNodeIpAddress() != null) {
            request = this.Broker.getImportHashmap() ? new Request(true, this.Broker.getOperationTimeout()) : new Request(false, this.Broker.getOperationTimeout());
            for (int i = 0; i < pointers.size(); ++i) {
                EnumerationPointer pointer = pointers.get(i);
                if (pointer.isGroupPointer()) {
                    GroupEnumerationPointer groupPointer = (GroupEnumerationPointer)pointer;
                    command = new GetGroupNextChunkCommand(groupPointer.getId(), groupPointer.getChunkId(), groupPointer.getGroup(), groupPointer.getSubGroup());
                } else {
                    command = new GetNextChunkCommand(pointer.getId(), pointer.getChunkId(), pointer.isDisposable());
                }
                request.addCommand(pointer.getNodeIpAddress(), command);
            }
        } else if (!this.Broker.poolHasAllServers() || !this.Broker.getImportHashmap()) {
            EnumerationPointer pointer = pointers.get(0);
            if (pointer.isGroupPointer()) {
                GroupEnumerationPointer groupPointer = (GroupEnumerationPointer)pointer;
                command = new GetGroupNextChunkCommand(groupPointer.getId(), groupPointer.getChunkId(), groupPointer.getGroup(), groupPointer.getSubGroup());
            } else {
                command = new GetNextChunkCommand(pointer.getId(), pointer.getChunkId(), pointer.isDisposable());
            }
            request = this.Broker.createRequest(command);
        } else {
            request = new Request(true, this.Broker.getOperationTimeout());
            EnumerationPointer pointer = pointers.get(0);
            for (int i = 0; i < this.Broker.getClientServerList().size(); ++i) {
                command = new GetNextChunkCommand(pointer.getId(), pointer.getChunkId(), pointer.isDisposable());
                command.setClientLastViewId(-1L);
                ServerInfo server = (ServerInfo)this.Broker.getClientServerList().get(i);
                command.setIntendedRecipient(server.getName());
                request.addCommand(new Address(server.getName(), server.getPort()), command);
            }
        }
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        response.parseResponse();
        nextChunk = response.getNextChunk();
        return nextChunk;
    }

    @Override
    public Enumeration getEnumerator() {
        return null;
    }

    public void finalize() throws Throwable {
        this.Broker = null;
        this._cacheCleared.clear();
        this._customListener.clear();
        super.finalize();
    }

    private HashMap getQueryInfo(Object value) throws GeneralFailureException {
        HashMap queryInfo = null;
        if (this.typeMap == null) {
            return null;
        }
        try {
            int handleId = this.typeMap.getHandleId(value.getClass().getCanonicalName());
            if (handleId != -1) {
                queryInfo = new HashMap();
                ArrayList<Object> attribValues = new ArrayList<Object>();
                ArrayList attributes = this.typeMap.getAttribList(handleId);
                for (int i = 0; i < attributes.size(); ++i) {
                    Field fieldAttrib = value.getClass().getField((String)attributes.get(i));
                    if (fieldAttrib == null) {
                        throw new Exception("Unable to extract query information from user object.");
                    }
                    Object attribValue = fieldAttrib.get(value);
                    attribValues.add(attribValue);
                }
                queryInfo.put(handleId, attribValues);
            }
        }
        catch (Exception e) {
            throw new GeneralFailureException("Unable to extract query information from user object.");
        }
        return queryInfo;
    }

    private HashMap getTagInfo(Object value, Tag[] tags, ArrayList<Tag> validTags) throws IllegalArgumentException {
        if (tags == null) {
            return null;
        }
        HashMap<String, Object> tagInfo = new HashMap<String, Object>();
        ArrayList<String> tagsList = new ArrayList<String>();
        for (Tag tag : tags) {
            if (tag == null) {
                throw new IllegalArgumentException("Value cannot be null.\r\nParameter name: Tag");
            }
            if (tag.getTagName() == null) continue;
            tagsList.add(tag.getTagName());
            validTags.add(tag);
        }
        String typeName = value.getClass().getName();
        typeName = typeName.replace("+", ".");
        tagInfo.put("type", typeName);
        tagInfo.put("tags-list", tagsList);
        return tagInfo;
    }

    private HashMap getNamedTagsInfo(Object value, NamedTagsDictionary namedTags) throws NullPointerException, IllegalArgumentException {
        if (value == null || namedTags == null || namedTags.getCount() == 0) {
            return null;
        }
        this.CheckDuplicateIndexName(value, namedTags);
        HashMap<String, Object> tagInfo = new HashMap<String, Object>();
        HashMap<String, Object> tagsList = new HashMap<String, Object>();
        Iterator iterator = namedTags.getKeysIterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            Object val = namedTags.getValue(key);
            if (val == null) {
                throw new IllegalArgumentException("Named Tag value cannot be null");
            }
            tagsList.put(key, val);
        }
        String typeName = value.getClass().getCanonicalName();
        typeName = typeName.replace("+", ".");
        tagInfo.put("type", typeName);
        tagInfo.put("named-tags-list", tagsList);
        return tagInfo;
    }

    private void CheckDuplicateIndexName(Object value, NamedTagsDictionary namedTags) throws IllegalArgumentException {
        if (this.typeMap == null) {
            return;
        }
        int handleId = this.typeMap.getHandleId(value.getClass().getCanonicalName());
        if (handleId != -1) {
            ArrayList attributes = this.typeMap.getAttribList(handleId);
            for (int i = 0; i < attributes.size(); ++i) {
                if (!namedTags.contains(attributes.get(i).toString())) continue;
                throw new IllegalArgumentException("Key in named tags conflicts with the indexed attribute name of the specified object.");
            }
        }
    }

    private void InitializeLogging(String fileName, Level logLevel) throws GeneralFailureException {
        if (logLevel == Level.OFF) {
            Logger logger = Logger.getLogger("com.alachisoft");
            logger.setLevel(logLevel);
            return;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
            Object pattern = fileName + "." + sdf.format(new Date()) + ".log-%g.htm";
            String path = null;
            String separator = System.getProperty("file.separator");
            int limit = 1000000;
            int numLogFiles = 3;
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                path = RegUtil.getNCHome();
                if (path != null && !path.endsWith(separator)) {
                    path = path.concat(separator);
                }
                pattern = path.concat(ServicePropValues.LOGS_FOLDER + separator + "Java" + separator + (String)pattern);
                FileHandler fh = new FileHandler((String)pattern, limit, numLogFiles);
                Logger logger = Logger.getLogger("com.alachisoft");
                fh.setLevel(logLevel);
                logger.addHandler(fh);
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.OFF);
            } else {
                path = System.getenv("NCACHE_ROOT");
                if (path != null && !path.equalsIgnoreCase("")) {
                    path = path.concat(separator + (String)pattern);
                } else {
                    path = System.getenv("NCACHE_MEMCACHED_ROOT");
                    if (path != null && !path.equalsIgnoreCase("")) {
                        path = path.concat(separator + (String)pattern);
                    }
                }
                if (path == null) {
                    path = "/usr/local/ncache/";
                }
                if (!path.endsWith(separator)) {
                    path = path.concat(separator);
                }
                pattern = path.concat("logs" + separator + (String)pattern);
                FileHandler fh = new FileHandler((String)pattern, limit, numLogFiles);
                Logger logger = Logger.getLogger("com.alachisoft");
                fh.setLevel(logLevel);
                logger.addHandler(fh);
                logger.setLevel(logLevel);
                logger.setUseParentHandlers(false);
                logger.setLevel(Level.OFF);
            }
        }
        catch (IOException e) {
            throw new GeneralFailureException(e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HashMap GetExpirationInfo() {
        return this._expirations;
    }

    public boolean getClientCacheStatus() {
        return this._clientCacheEnabled;
    }

    @Override
    public long getCompressionThreshold() {
        return this._compressionThresholdSize;
    }

    @Override
    protected void setCompressionThreshold(long value) {
        this._compressionThresholdSize = value;
    }

    @Override
    public boolean getCompressionEnabled() {
        return this._compressionEnabled;
    }

    @Override
    public void setCompressionEnabled(boolean value) {
        this._compressionEnabled = value;
    }

    @Override
    public void registerCacheClientConnectivityEvent() throws CacheException {
        this.registerNotifications(NotificationsType.RegisterClientConnectivityNotif);
    }

    @Override
    protected void unregisterCacheClientConnectivityEvent() throws CacheException {
        this.registerNotifications(NotificationsType.UnregisterClientConnectivityNotif);
    }

    @Override
    void registerCacheStoppedEvent() throws CacheException {
        this.registerNotifications(NotificationsType.RegCacheStoppedNotif);
    }

    @Override
    void unregisterCacheStoppedEvent() throws CacheException {
        this.registerNotifications(NotificationsType.UnregCacheStoppedNotif);
    }

    @Override
    void registerClearEvent() throws CacheException {
        this._clearNotifRegistered = true;
        this.registerNotifications(NotificationsType.RegClearNotif);
    }

    @Override
    void unregisterClearEvent() throws CacheException {
        this.registerNotifications(NotificationsType.UnregClearNotif);
    }

    private void registerNotifications(NotificationsType notifMask) throws CacheException {
        RegisterNotification command = new RegisterNotification(notifMask.getValue(), -1);
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse res = request.getResponse();
        res.parseResponse();
    }

    protected void getCompressionSettings(Connection connection) throws OperationFailedException, GeneralFailureException, SecurityException, ConnectionException, CommandException {
        GetCompressionSettings command = new GetCompressionSettings(false);
        Request request = this.Broker.createRequest(command);
        try {
            this.Broker.executeRequest(request);
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        CommandResponse response = request.getResponse();
        this._compressionThresholdSize = response.getCompressionThreshold();
        this._compressionEnabled = response.getCompressionEnable();
    }

    void initializeCompactFramework() throws NCacheArgumentException, OperationFailedException {
        this.impl = FormatterServices.getDefault();
        HashMap<Class, Short> type = this.getCompactTypes();
        if (!(type == null || type.isEmpty() && type.size() == 0)) {
            this.impl.register(type, this.getAttributeOrder(), this.cacheId, this.getPortability());
        }
    }

    @Override
    public HashMap<Class, Short> getCompactTypes() {
        return this._compactTypes;
    }

    void setCompactTypes(HashMap types) {
        this._compactTypes = types;
    }

    private HashMap getAttributeOrder() {
        return this._attributeOrder;
    }

    private void setAttributeOrder(HashMap attrib) {
        this._attributeOrder = attrib;
    }

    private HashMap getPortability() {
        return this._portablity;
    }

    private void setPortability(HashMap attrib) {
        this._portablity = attrib;
    }

    @Override
    public boolean getOrCreate(String topicName, RefObject<TopicPriority> topicPriority, TopicOperationType type) throws CacheException {
        GetTopicCommand command = new GetTopicCommand(topicName, (TopicPriority)topicPriority.argvalue, type);
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        topicPriority.argvalue = TopicPriority.forValue((int)response.getTopicPriority());
        return response.success();
    }

    @Override
    public boolean unSubscribe(String topicName, String recepientId, SubscriptionPolicyType subscriptionPolicyType, SubscriptionType pubSubType, boolean dispose) throws CacheException, InterruptedException {
        UnSubscribeTopicCommand command = new UnSubscribeTopicCommand(topicName, recepientId, pubSubType, subscriptionPolicyType, dispose);
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.success();
    }

    @Override
    public boolean removeTopic(String topicName, boolean forcefully) throws CacheException {
        RemoveTopicCommand command = new RemoveTopicCommand(topicName, forcefully);
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
        return response.success();
    }

    @Override
    public void publishMessage(String messageId, Object payLoad, long creationTime, long expirationTime, Hashtable metadata, BitSet flagMap) throws CacheException, InterruptedException {
        MessagePublishCommand command = new MessagePublishCommand(messageId, (byte[])payLoad, creationTime, expirationTime, metadata, flagMap);
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse response = request.getResponse();
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    public ReceivedMessages getMessageData(BitSet flagMap) throws CacheException {
        GetMessageCommand command = new GetMessageCommand(flagMap);
        ReceivedMessages response = new ReceivedMessages();
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse res = request.getResponse();
        try {
            res.parseResponse();
        }
        catch (StateTransferInProgressException ex) {
            command = new GetMessageCommand(flagMap);
            request = this.Broker.createDedicatedRequest(command);
            this.Broker.executeRequest(request);
            res = request.getResponse();
            res.parseResponse();
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.getMessage());
        }
        response.setAssignedMessages(res.getMessageDic());
        response.setRegisteredPatterns(res.getRegisteredPatterns());
        return response;
    }

    private BitSet setDSUpdateOptBit(BitSet flagMap, WriteMode mode) {
        if (flagMap == null) {
            flagMap = new BitSet();
        }
        switch (mode) {
            case WriteBehind: {
                flagMap.SetBit((byte)8);
                break;
            }
            case WriteThru: {
                flagMap.SetBit((byte)4);
            }
        }
        return flagMap;
    }

    @Override
    void createDataType(CollectionCreateOrGetOperation operation, DataStructureAttributes properties) throws OperationFailedException, LicensingException, CommandException {
        BitSet flagMap = new BitSet();
        flagMap = this.setDSUpdateOptBit(flagMap, operation.getWriteThruOptions().getMode());
        DataTypeCreateCommand command = null;
        try {
            command = new DataTypeCreateCommand(operation, Integer.MAX_VALUE, flagMap, properties, this._parent, true);
        }
        catch (IOException e) {
            throw new OperationFailedException((Throwable)e);
        }
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse res = request.getResponse();
        try {
            res.parseResponse();
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    boolean getDataType(CollectionCreateOrGetOperation operation) throws OperationFailedException, LicensingException, CommandException {
        DataTypeGetCommand command = new DataTypeGetCommand(operation);
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse res = request.getResponse();
        try {
            res.parseResponse();
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
        return res.getDataTypeResponse().getBoolResponse();
    }

    @Override
    void CollectionClearOperation(CollectionOperation operation) {
        CollectionClearCommand command = new CollectionClearCommand(operation);
        this.executeDataStructuresCommand(command);
    }

    @Override
    public void acknowledgeMessageReceipt(Map<String, List<String>> topicWiseMessageIds) throws Exception {
        CommandResponse response;
        block7: {
            Request request;
            if (topicWiseMessageIds == null) {
                return;
            }
            if (this.Broker.getImportHashmap() && this.Broker.getPoolFullyConnected()) {
                request = new Request(true, this.Broker.getOperationTimeout());
                HashMap<Address, HashMap<String, List<String>>> messagesDistributionMap = new HashMap<Address, HashMap<String, List<String>>>();
                boolean isMrgKey = this.Broker.GetMessageDistribution(topicWiseMessageIds, messagesDistributionMap);
                for (Address serverAddress : messagesDistributionMap.keySet()) {
                    HashMap<String, List<String>> topicWiseMessages = messagesDistributionMap.get(serverAddress);
                    MesasgeAcknowledgmentCommand command = new MesasgeAcknowledgmentCommand(topicWiseMessages);
                    command.setClientLastViewId(isMrgKey ? -5L : this.Broker.getClientLastViewId());
                    request.addCommand(serverAddress, command);
                }
            } else {
                MesasgeAcknowledgmentCommand command = new MesasgeAcknowledgmentCommand(topicWiseMessageIds);
                request = this.Broker.createRequest(command);
            }
            response = null;
            try {
                this.Broker.executeRequest(request);
                response = request.getResponse();
            }
            catch (Exception ex) {
                if (!(ex instanceof ActivityBlockedException) || request.getCommandRequestType() != RequestType.KeyBulkRead) break block7;
                MesasgeAcknowledgmentCommand command = new MesasgeAcknowledgmentCommand(topicWiseMessageIds);
                response = this.ExecuteCacheRequest(command, true);
            }
        }
        if (this.isExceptionsEnabled()) {
            response.parseResponse();
        }
    }

    @Override
    int CollectionCountOperation(CollectionOperation operation) {
        CollectionCountCommand command = new CollectionCountCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getIntResponse();
    }

    @Override
    GetCollectionChunkResponseBase GetCollectionChunk(GetCollectionChunkOperation operation) {
        GetCollectionChunkCommand command = new GetCollectionChunkCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getChunkResponse();
    }

    @Override
    long counterGetOperation(CounterGetOperation counterGetOperation) {
        CounterGetCommand command = new CounterGetCommand(counterGetOperation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getLongResponse();
    }

    @Override
    long counterOperations(CounterOperation operation) {
        CounterOperationsCommand command = new CounterOperationsCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getLongResponse();
    }

    @Override
    void dictionaryAdd(DictionaryAddOperation operation) {
        DictionaryAddCommand command = new DictionaryAddCommand(operation);
        this.executeDataStructuresCommand(command);
    }

    @Override
    Collection<ExtendedJsonValueBase> dictionaryGet(DictionaryGetOperation operation) {
        DictionaryGetCommand command = new DictionaryGetCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getBulkResponse();
    }

    @Override
    int dictionaryRemove(DictionaryRemoveOperation operation) {
        DictionaryRemoveCommand command = new DictionaryRemoveCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getIntResponse();
    }

    @Override
    boolean dictionaryContains(DictionaryContainsOperation operation) {
        DictionaryContainsCommand command = new DictionaryContainsCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getBoolResponse();
    }

    @Override
    void hashSetAdd(HashSetAddOperation operation) {
        HashSetAddCommand command = new HashSetAddCommand(operation);
        this.executeDataStructuresCommand(command);
    }

    @Override
    int hashSetRemove(HashSetRemoveOperation operation) {
        HashSetRemoveCommand command = new HashSetRemoveCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getIntResponse();
    }

    @Override
    List<ExtendedJsonValueBase> hashSetGetRandom(HashSetGetRandomOperation operation) {
        HashSetGetRandomCommand command = new HashSetGetRandomCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getBulkResponse();
    }

    @Override
    List<ExtendedJsonValueBase> hashSetRemoveRandom(HashSetRemoveRandomOperation operation) {
        HashSetRemoveRandomCommand command = new HashSetRemoveRandomCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getBulkResponse();
    }

    @Override
    boolean hashSetContains(HashSetContainsOperation operation) {
        HashSetContainsCommand command = new HashSetContainsCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getBoolResponse();
    }

    @Override
    RecordSetEnumeratorImpl executeReaderCQ(ContinuousQuery continuousQuery, boolean getData, int chunkSize, String clientUniqueId, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove) {
        return null;
    }

    @Override
    RecordSetEnumerator executeReader(String query, Map values, boolean getData, int chunkSize) throws OperationFailedException {
        ExecuteReaderCommand command = new ExecuteReaderCommand(query, values, getData, chunkSize, TargetMethodAttribute.getMethodOverload());
        CommandResponse res = null;
        try {
            try {
                res = this.ExecuteCacheRequest(command, false);
            }
            catch (ActivityBlockedException ex) {
                command = new ExecuteReaderCommand(query, values, getData, chunkSize, TargetMethodAttribute.getMethodOverload());
                res = this.ExecuteCacheRequest(command, true);
            }
            try {
                res.parseResponse();
            }
            catch (StateTransferInProgressException ex) {
                this.SetDedicatedCall();
                command = new ExecuteReaderCommand(query, values, getData, chunkSize, TargetMethodAttribute.getMethodOverload());
                res = this.ExecuteCacheRequest(command, true);
                res.parseResponse();
            }
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
        List<ReaderResultSet> readerResultSets = null;
        readerResultSets = res.getReaderResultSets();
        ArrayList<PartitionRSEnumerator> prsEnum = new ArrayList<PartitionRSEnumerator>();
        for (ReaderResultSet resultSet : readerResultSets) {
            if (resultSet.getRecordSet() == null) continue;
            RecordSetEnumerator rse = resultSet.getRecordSet().getEnumerator();
            PartitionRSEnumerator partitionRS = new PartitionRSEnumerator(rse, resultSet.getReaderID(), resultSet.getNodeAddress(), resultSet.getNextIndex(), (RecordSetLoader)this);
            prsEnum.add(partitionRS);
            this.updateOpenReaders(partitionRS.getServer(), partitionRS);
        }
        Object drsEnum = null;
        if (readerResultSets.size() > 0) {
            drsEnum = readerResultSets.get(0).getIsGrouped() ? new DistributedGroupedRSEnumerator(prsEnum, readerResultSets.get(0).getOrderByArguments(), this.validReaders) : (readerResultSets.get(0).getOrderByArguments() != null && readerResultSets.get(0).getOrderByArguments().size() > 0 ? new DistributedOrderedRSEnumerator(prsEnum, readerResultSets.get(0).getOrderByArguments(), this.validReaders) : new DistributedRSEnumerator(prsEnum, this.validReaders));
        }
        return drsEnum;
    }

    @Override
    public boolean queueEnqueue(QueueEnqueueOperation operation) {
        QueueEnqueueCommand command = new QueueEnqueueCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getBoolResponse();
    }

    @Override
    public ExtendedJsonValueBase queueDequeue(QueueDequeueOperation operation) {
        QueueDequeueCommand command = new QueueDequeueCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getItemResponse();
    }

    @Override
    public ExtendedJsonValueBase queuePeek(QueuePeekOperation operation) {
        QueuePeekCommand command = new QueuePeekCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getItemResponse();
    }

    @Override
    public boolean queueSearch(QueueSearchOperation operation) {
        QueueSearchCommand command = new QueueSearchCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getBoolResponse();
    }

    @Override
    public void listAddWithoutIndex(ListAddWithoutIndexOperation operation) {
        ListAddWithoutIndexCommand command = new ListAddWithoutIndexCommand(operation);
        this.executeDataStructuresCommand(command);
    }

    @Override
    public boolean listAddWithPivot(ListAddWithPivotOperation operation) {
        ListAddWithPivotCommand command = new ListAddWithPivotCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getBoolResponse();
    }

    @Override
    public List<ExtendedJsonValueBase> listGetBulk(ListGetBulkOperation operation) {
        ListGetBulkItemsCommand command = new ListGetBulkItemsCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getBulkResponse();
    }

    @Override
    public int listRemoveWithoutIndex(ListRemoveWithoutIndexOperation operation) {
        ListRemoveWihoutIndexCommand command = new ListRemoveWihoutIndexCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getIntResponse();
    }

    @Override
    public void listRemoveWithIndex(ListRemoveWithIndexOperation operation) {
        ListRemoveWithIndexCommand command = new ListRemoveWithIndexCommand(operation);
        this.executeDataStructuresCommand(command);
    }

    @Override
    public void listInsertWithIndex(ListInsertWithIndexOperation operation) {
        ListInsertWithIndexCommand command = new ListInsertWithIndexCommand(operation);
        this.executeDataStructuresCommand(command);
    }

    @Override
    public int listSearch(ListSearchOperation operation) {
        ListSearchCommand command = new ListSearchCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getIntResponse();
    }

    @Override
    public ExtendedJsonValueBase listGetItem(ListGetItemOperation operation) {
        ListGetItemCommand command = new ListGetItemCommand(operation);
        CommandResponse res = this.executeDataStructuresCommand(command);
        return res.getDataTypeResponse().getItemResponse();
    }

    private CommandResponse executeDataStructuresCommand(Command command) {
        Request request = null;
        try {
            request = this.Broker.createRequest(command);
            this.Broker.executeRequest(request);
            request.setLogger(this.Broker.getLogger());
        }
        catch (Exception e) {
            throw new OperationFailedRuntimeException((Throwable)e);
        }
        CommandResponse res = null;
        try {
            res = request.getResponse();
        }
        catch (Exception e) {
            throw new OperationFailedRuntimeException((Throwable)e);
        }
        res.parseDataStructuresResponse();
        return res;
    }

    @Override
    public void addCollectionNotificationListener(String collectionName, short addCallbackId, short updateCallbackId, short removeCallbackId, DataTypeEventDataFilter dataFilter, DistributedDataStructure dataType, boolean notifyOnItemExpiration) throws OperationFailedException, LicensingException, CommandException {
        CollectionNotifRegOperation notifRegOp = new CollectionNotifRegOperation(collectionName, dataType, null, new TimeSpan());
        notifRegOp.setFilter(dataFilter);
        notifRegOp.setAddCallbackId(addCallbackId);
        notifRegOp.setUpdateCallbackId(updateCallbackId);
        notifRegOp.setRemoveCallbackId(removeCallbackId);
        notifRegOp.setNotifyItemExpiration(notifyOnItemExpiration);
        notifRegOp.setRegType(CollectionNotifRegOperation.RegistrationType.Register);
        CollectionNotificationRegistrationCommand command = new CollectionNotificationRegistrationCommand(notifRegOp);
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse res = request.getResponse();
        try {
            res.parseResponse();
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void removeCollectionNotificationListener(String collectionName, short addCallbackId, short updateCallbackId, short removeCallbackId, EventTypeInternal eventType, DistributedDataStructure dataType) throws OperationFailedException, LicensingException, CommandException {
        CollectionNotifRegOperation notifRegOp = new CollectionNotifRegOperation(collectionName, dataType, null, new TimeSpan());
        notifRegOp.setFilter(DataTypeEventDataFilter.None);
        notifRegOp.setAddCallbackId(addCallbackId);
        notifRegOp.setUpdateCallbackId(updateCallbackId);
        notifRegOp.setRemoveCallbackId(removeCallbackId);
        notifRegOp.setNotifyItemExpiration(false);
        notifRegOp.setRegType(CollectionNotifRegOperation.RegistrationType.Unregister);
        CollectionNotificationRegistrationCommand command = new CollectionNotificationRegistrationCommand(notifRegOp);
        Request request = this.Broker.createRequest(command);
        this.Broker.executeRequest(request);
        CommandResponse res = request.getResponse();
        try {
            res.parseResponse();
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public ReaderResultSet getRecordSet(String readerID, int nextIndex, String nodeIP, String reciepent) throws OperationFailedException {
        GetRecordSetNextChunkCommand command = new GetRecordSetNextChunkCommand(readerID, reciepent, nextIndex);
        try {
            Request request;
            if (this.Broker.getImportHashmap()) {
                request = new Request(true, this.Broker.getOperationTimeout());
                request.addCommand(new Address(nodeIP, this.Broker._clientConfig.getServerPort()), command);
            } else {
                request = this.Broker.createRequest(command);
            }
            CommandResponse res = null;
            try {
                this.Broker.executeRequest(request);
                res = request.getResponse();
            }
            catch (Exception ex) {
                if (ex instanceof ActivityBlockedException) {
                    command = new GetRecordSetNextChunkCommand(readerID, nodeIP, nextIndex);
                    res = this.ExecuteCacheRequest(command, false);
                }
                throw ex;
            }
            try {
                if (res == null) {
                    throw new InvalidReaderException("Reader state has been lost.");
                }
                res.parseResponse();
            }
            catch (StateTransferInProgressException ex) {
                this.SetDedicatedCall();
                command = new GetRecordSetNextChunkCommand(readerID, nodeIP, nextIndex);
                res = this.ExecuteCacheRequest(command, false);
                res.parseResponse();
            }
            return res.getReaderNextChunk();
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void disposeReader(String readerId, String nodeIp) throws OperationFailedException {
        DisposeReaderCommand command = new DisposeReaderCommand(readerId, nodeIp, TargetMethodAttribute.getMethodOverload());
        try {
            Request request;
            if (this.Broker.getImportHashmap()) {
                request = new Request(true, this.Broker.getOperationTimeout());
                request.addCommand(new Address(nodeIp, this.Broker._clientConfig.getServerPort()), command);
            } else {
                request = this.Broker.createRequest(command);
            }
            CommandResponse res = null;
            try {
                this.Broker.executeRequest(request);
                res = request.getResponse();
            }
            catch (Exception ex) {
                if (ex instanceof ActivityBlockedException) {
                    command = new DisposeReaderCommand(readerId, nodeIp, TargetMethodAttribute.getMethodOverload());
                    res = this.ExecuteCacheRequest(command, false);
                }
                throw ex;
            }
            try {
                res.parseResponse();
            }
            catch (StateTransferInProgressException ex) {
                this.SetDedicatedCall();
                command = new DisposeReaderCommand(readerId, nodeIp, TargetMethodAttribute.getMethodOverload());
                res = this.ExecuteCacheRequest(command, false);
                res.parseResponse();
            }
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getIsDedicated() {
        Object object = this._mutexlock;
        synchronized (object) {
            if (this._dedicatedCallMonitoring.getElapsedTime() > 60000L) {
                this._dedicatedCallMonitoring.stop();
                this._isDedicatedCall = false;
            }
            return this._isDedicatedCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SetDedicatedCall() {
        Object object = this._mutexlock;
        synchronized (object) {
            this._isDedicatedCall = true;
            this._dedicatedCallMonitoring.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOpenReaders(String address, PartitionRSEnumerator partition) {
        HashMap<String, HashMap<RecordSetEnumerator, Object>> hashMap = this.validReaders;
        synchronized (hashMap) {
            HashMap<Object, Object> readers = new HashMap<PartitionRSEnumerator, Object>();
            if (this.validReaders.containsKey(address)) {
                readers = this.validReaders.get(address);
                if (readers != null) {
                    readers.put(partition, null);
                }
            } else {
                readers = new HashMap();
                readers.put(partition, null);
            }
            this.validReaders.put(address, readers);
        }
    }

    @Override
    public List<ClientInfo> getConnectedClientList() throws OperationFailedException, CommandException, StreamNotFoundException, StreamException, OperationNotSupportedException, StreamAlreadyLockedException, AggregateException, GeneralFailureException, ConfigurationException, LicensingException, SecurityException {
        Request request = this.Broker.createRequest(new GetConnectedClientsCommand());
        this.Broker.executeRequest(request);
        CommandResponse response = request.getResponse();
        response.parseResponse();
        return response.getConnectedClients();
    }

    public void PublishMetadata(MetricsTransporter transporter) throws Exception {
        ClientMetaData tempVar = new ClientMetaData();
        tempVar.setCacheConfigId(this._cacheConfigId);
        tempVar.setCacheName(this.cacheId);
        tempVar.setBindIP(ServiceConfiguration.getBindToClientServerIP().toString());
        ClientMetaData clientMetaData = tempVar;
        transporter.PublishMetadata(this._monitoringSessionId, "5.2", clientMetaData);
    }

    public class Entry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        protected Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        protected Entry() {
        }

        protected Object clone() {
            return new Entry<K, V>(this.key, this.value);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public void setKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.key = key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public String toString() {
            return this.key.toString() + "=" + (this.value != null ? this.value.toString() : "null");
        }
    }
}

