/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Net.Address;
import com.alachisoft.ncache.client.CacheStatusEventListener;
import com.alachisoft.ncache.client.CacheStatusNotificationType;
import com.alachisoft.ncache.client.ClusterEvent;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import java.util.ArrayList;

public class RemoteCacheClusterEventsListener
implements IDisposable {
    CacheImpl _parent;

    public RemoteCacheClusterEventsListener(CacheImpl parent) {
        this._parent = parent;
    }

    public void dispose() {
    }

    public void OnMemberJoined(Address clusterAddress, Address serverAddress) {
        try {
            ArrayList<CacheStatusEventListener> listeners = this._parent.getMemberJoinedListeners();
            if (listeners != null && !listeners.isEmpty()) {
                for (CacheStatusEventListener listener : listeners) {
                    try {
                        listener.onCacheStatusChanged(new ClusterEvent(this, CacheStatusNotificationType.MemberJoined, serverAddress.getIpAddress().getHostAddress(), serverAddress.getPort(), this._parent._cacheId));
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void OnMemberLeft(Address clusterAddress, Address serverAddress) {
        try {
            ArrayList<CacheStatusEventListener> listeners = this._parent.getMemberLeftListeners();
            if (listeners != null && !listeners.isEmpty()) {
                for (CacheStatusEventListener listener : listeners) {
                    try {
                        listener.onCacheStatusChanged(new ClusterEvent(this, CacheStatusNotificationType.MemberLeft, serverAddress.getIpAddress().getHostAddress(), serverAddress.getPort(), this._parent._cacheId));
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

