/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.AddAttributeProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.DependencyProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public class AddAttributeCommand
extends Command {
    protected Date _date;
    protected DependencyProtocol.Dependency _dependency;
    protected AddAttributeProtocol.AddAttributeCommand _commandInstance;
    protected AddAttributeProtocol.AddAttributeCommand.Builder build;

    public AddAttributeCommand(String key, Date date, DependencyProtocol.Dependency dependency) throws Exception {
        this.name = "AddAttributeCommand";
        this.key = key;
        this._date = date;
        this._dependency = dependency;
        this.buildCommand();
    }

    private void buildCommand() {
        if (this.key == null || this.key.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Paramenter name: key");
        }
        this.build = AddAttributeProtocol.AddAttributeCommand.newBuilder();
        this.build.setKey(this.key);
        if (this._dependency != null) {
            this.build.setDependency(this._dependency);
        }
        if (this._date != CacheImpl.NoAbsoluteExpiration) {
            this.build.setAbsExpiration(HelperFxn.getUTCTicks((Date)this._date));
        }
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.ADD_ATTRIBUTE;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    protected void createCommand() throws CommandException {
        this.build.setRequestId(this.getRequestId());
        this._commandInstance = this.build.build();
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.ADD_ATTRIBUTE.getNumber();
    }
}

