/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.BitSetConstants;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.Util.DependencyHelper;
import com.alachisoft.ncache.client.CacheSyncDependency;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.AddCommandProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.ObjectQueryInfoProtocol;
import com.alachisoft.ncache.common.protobuf.SyncDependencyProtocol;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public final class AddCommand
extends Command {
    private int _methodOverload;
    private String groupType;
    private String group;
    private String subGroup;
    private Date absoluteExpiration;
    private TimeSpan slidingExpiration;
    private boolean isResyncExpiredItems;
    private CacheItemPriority priority;
    private CacheDependency dependency;
    private int remCallbackID;
    private int upCallbackID;
    private CacheSyncDependency syncDependency;
    private HashMap queryInfo;
    private int flagMap;
    private String providerName;
    private String resyncProviderName;
    private int datasourceItemAddedCallbackID;
    private boolean encryption;
    private String cacheId;
    private int updateCallbackFilter;
    private int removeCallbackFilter;
    private short _updateCallbackId;
    private short _removeCallbackId;
    private String _clientId;
    protected AddCommandProtocol.AddCommand _commandInstance;

    public AddCommand(String key, byte[] value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, short remId, short upId, int dsItemAddedCallback, boolean isResyncExpiredItems, String group, short itemAdded, boolean async, HashMap queryInfo, BitSet flagMap, String providerName, String resyncProviderName, boolean encryption, String cacheId, EventDataFilter updateDataFilter, EventDataFilter removeDataFilter, int methodOverload, String clientId, String typeName) {
        this.name = "AddCommand";
        this.asyncCallbackSpecified = this.isAsync && itemAdded != -1;
        this.key = key;
        this.value = value;
        this.dependency = dependency;
        this.syncDependency = syncDependency;
        this.absoluteExpiration = absoluteExpiration;
        this.slidingExpiration = slidingExpiration;
        this.priority = priority;
        this.remCallbackID = remId;
        this.upCallbackID = upId;
        this.datasourceItemAddedCallbackID = dsItemAddedCallback;
        this.isResyncExpiredItems = isResyncExpiredItems;
        this.group = group;
        this.subGroup = this.subGroup;
        this.asyncCallbackId = itemAdded;
        this.isAsync = async;
        this.queryInfo = queryInfo;
        this.flagMap = BitSetConstants.getBitSetData((BitSet)flagMap);
        this.providerName = providerName;
        this.resyncProviderName = resyncProviderName;
        this.encryption = encryption;
        this.cacheId = cacheId;
        this.updateCallbackFilter = updateDataFilter.getValue();
        this.removeCallbackFilter = removeDataFilter.getValue();
        this._methodOverload = methodOverload;
        this._clientId = clientId;
        this.groupType = typeName;
    }

    @Override
    public void createCommand() throws CommandException {
        long sldExp = 0L;
        long absExp = 0L;
        try {
            if (this.absoluteExpiration.equals(NCDateTime.getUTCDate((Date)CacheImpl.defaultAbsolute))) {
                absExp = 1L;
            } else if (this.absoluteExpiration.equals(NCDateTime.getUTCDate((Date)CacheImpl.defaultAbsoluteLonger))) {
                absExp = 2L;
            } else if (this.absoluteExpiration != CacheImpl.NoAbsoluteExpiration) {
                absExp = HelperFxn.getTicks((Date)this.absoluteExpiration);
            }
            if (this.slidingExpiration.equals(CacheImpl.DefaultSliding)) {
                sldExp = 1L;
            } else if (this.slidingExpiration.equals(CacheImpl.DefaultSlidingLonger)) {
                sldExp = 2L;
            } else if (this.slidingExpiration != CacheImpl.NoSlidingExpiration) {
                sldExp = this.slidingExpiration.getTotalTicks();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        UserBinaryObject userBin = UserBinaryObject.createUserBinaryObject((byte[])this.value);
        List dataList = userBin.getDataList();
        ArrayList<ByteString> dataChunks = new ArrayList<ByteString>();
        for (int i = 0; i < dataList.size(); ++i) {
            dataChunks.add(ByteString.copyFrom((byte[])((byte[])dataList.get(i))));
        }
        AddCommandProtocol.AddCommand.Builder builder = AddCommandProtocol.AddCommand.newBuilder().setKey(this.key).addAllData(dataChunks).setRequestId(this.getRequestId()).setUpdateCallbackId(this.upCallbackID).setRemoveCallbackId(this.remCallbackID).setDatasourceItemAddedCallbackId(this.datasourceItemAddedCallbackID).setIsAsync(this.isAsync).setPriority(this.priority.value()).setIsResync(this.isResyncExpiredItems).setAbsExpiration(absExp).setSldExpiration(sldExp);
        if (this.group != null) {
            builder = builder.setGroup(this.group);
            if (this.subGroup != null) {
                builder = builder.setSubGroup(this.subGroup);
            }
            if (this.groupType != null) {
                builder = builder.setGroupType(this.groupType);
            }
        }
        builder.setFlag(this.flagMap);
        if (this.providerName != null) {
            builder = builder.setProviderName(this.providerName);
        }
        if (this.resyncProviderName != null) {
            builder = builder.setResyncProviderName(this.resyncProviderName);
        }
        if (this._clientId != null) {
            builder = builder.setClientID(this._clientId);
        }
        builder.setUpdateDataFilter(this.updateCallbackFilter).setRemoveDataFilter(this.removeCallbackFilter);
        if (this.syncDependency != null) {
            SyncDependencyProtocol.SyncDependency protoSyncDep = SyncDependencyProtocol.SyncDependency.newBuilder().setCacheId(this.syncDependency.getCacheId()).setKey(this.syncDependency.getKey()).setPort(this.syncDependency.getPort()).setServer(this.syncDependency.getServer() == null ? "" : this.syncDependency.getServer()).setUserId(this.syncDependency.getUserId()).setPassword(ByteString.copyFrom((byte[])this.syncDependency.getPassword())).build();
            builder = builder.setSyncDependency(protoSyncDep);
        }
        ObjectQueryInfoProtocol.ObjectQueryInfo.Builder objectQueryInfoBuilder = ObjectQueryInfoProtocol.ObjectQueryInfo.newBuilder();
        if (this.queryInfo.get("query-info") != null) {
            objectQueryInfoBuilder = objectQueryInfoBuilder.setQueryInfo(AddCommand.getQueryInfoObj((HashMap)this.queryInfo.get("query-info")));
        }
        if (this.queryInfo.get("tag-info") != null) {
            objectQueryInfoBuilder = objectQueryInfoBuilder.setTagInfo(AddCommand.getTagInfo((HashMap)this.queryInfo.get("tag-info")));
        }
        if (this.queryInfo.get("named-tag-info") != null) {
            objectQueryInfoBuilder = objectQueryInfoBuilder.setNamedTagInfo(AddCommand.GetNamedTagInfoObj((HashMap)this.queryInfo.get("named-tag-info")));
        }
        if (this.encryption & (objectQueryInfoBuilder.getNamedTagInfo() != null || objectQueryInfoBuilder.getQueryInfo() != null || objectQueryInfoBuilder.getTagInfo() != null)) {
            byte[] encryptedResult = CacheHelper.EncryptData(objectQueryInfoBuilder.build().toByteArray(), this.cacheId);
            builder = builder.addObjectQueryInfoEncrypted(ByteString.copyFrom((byte[])encryptedResult));
        } else {
            builder = builder.setObjectQueryInfo(objectQueryInfoBuilder.build());
        }
        if (this.dependency != null) {
            try {
                builder = builder.setDependency(DependencyHelper.getDependencyProtocol((CacheDependency)this.dependency));
            }
            catch (Exception ex) {
                throw new CommandException(ex.getMessage());
            }
        }
        this._commandInstance = builder.setVersion(VERSION).build();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.ADD;
    }

    public int AsycItemAddedOpComplete() {
        return this.asyncCallbackId;
    }

    @Override
    public boolean getIsSafe() {
        return false;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.ADD.getNumber();
    }
}

