/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.BitSetConstants;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.BulkGetCacheItemCommandProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public final class BulkGetCacheItemCommand
extends Command {
    private ReadMode readMode;
    private int _methodOverload;
    private String[] keys;
    private BitSet flagMap;
    private String providerName;
    protected BulkGetCacheItemCommandProtocol.BulkGetCacheItemCommand _commandInstance;

    public BulkGetCacheItemCommand(String[] keys, BitSet flagMap, ReadThruOptions readThruOptions, int methodOverload) {
        this.name = "BulkGetCacheItemCommand";
        this.keys = keys;
        this.flagMap = flagMap;
        this.providerName = readThruOptions.getProviderName();
        this.readMode = readThruOptions.getReadMode();
        this._methodOverload = methodOverload;
        super.setBulkKeys(keys);
    }

    @Override
    protected void createCommand() throws CommandException {
        if (this.keys == null) {
            throw new NullPointerException("keys");
        }
        if (this.keys.length == 0) {
            throw new IllegalArgumentException("There is no key present in keys array");
        }
        BulkGetCacheItemCommandProtocol.BulkGetCacheItemCommand.Builder builder = BulkGetCacheItemCommandProtocol.BulkGetCacheItemCommand.newBuilder();
        builder.addAllKeys(Arrays.asList(this.keys)).setRequestId(super.getRequestId()).setFlag(BitSetConstants.getBitSetData((BitSet)this.flagMap));
        if (this.providerName != null) {
            builder.setProviderName(this.providerName);
        }
        if (this.readMode != null) {
            builder.setReadMode(this.readMode.getValue());
        }
        if (this.getIntendedRecipient() != null) {
            builder.setIntendedRecipient(this.getIntendedRecipient());
        }
        this._commandInstance = builder.setClientLastViewId(this.getClientLastViewId()).setCommandVersion(1).setMethodOverload(this._methodOverload).build();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.GET_BULK_CACHEITEM;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.KeyBulkRead;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.GET_BULK_CACHEITEM.getNumber();
    }
}

