/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.BitSetConstants;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.Util.DependencyHelper;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemWrapperInternal;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.client.internal.util.ConversionUtil;
import com.alachisoft.ncache.common.protobuf.BulkInsertCommandProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.InsertCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ObjectQueryInfoProtocol;
import com.alachisoft.ncache.common.protobuf.SyncDependencyProtocol;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public final class BulkInsertCommand
extends Command {
    private int _methodOveload;
    private EventDataFilter itemUpdateDataFilter;
    private EventDataFilter itemRemoveDataFilter;
    private boolean _returnVersions;
    private ListenerType _listenerType;
    private String[] keys;
    private CacheItem[] items;
    private String group = "";
    private String subGroup = "";
    private HashMap[] queryInfo;
    private boolean isResyncExpiredItems = false;
    private int dsItemUpdatedtCallbackId;
    private String providerName;
    private boolean encryption;
    private String cacheId;
    private short _updateCallbackId;
    private short _removeCallbackId;
    private short _dsItemAddedCallbackId;
    private String _clientId;
    private CacheImpl _parent;
    protected BulkInsertCommandProtocol.BulkInsertCommand _commandInstance;
    BulkInsertCommandProtocol.BulkInsertCommand.Builder builder = BulkInsertCommandProtocol.BulkInsertCommand.newBuilder();

    public BulkInsertCommand(String[] keys, CacheItem[] items, short onDataSourceItemUpdateCallbackId, CacheImpl parent, String providerName, boolean encryption, String cacheId, int methodOverload, String clientId, short updateCallbackId, short removeCallbackId, EventDataFilter updateCallbackDataFilter, EventDataFilter removeCallbackDataFilter, boolean returnVersions, ListenerType listenerType) throws CommandException {
        this.name = "BulkInsertCommand";
        this.keys = keys;
        this.items = items;
        this.dsItemUpdatedtCallbackId = onDataSourceItemUpdateCallbackId;
        this._parent = parent;
        this.providerName = providerName;
        this.encryption = encryption;
        this.cacheId = cacheId;
        this._methodOveload = methodOverload;
        this._clientId = clientId;
        this._updateCallbackId = updateCallbackId;
        this._removeCallbackId = removeCallbackId;
        this.itemUpdateDataFilter = updateCallbackDataFilter;
        this.itemRemoveDataFilter = removeCallbackDataFilter;
        this._returnVersions = returnVersions;
        this._listenerType = listenerType;
        super.setBulkKeys(keys);
        this.buildCommand();
    }

    protected void buildCommand() throws CommandException {
        if (this.keys == null) {
            throw new IllegalArgumentException("keys");
        }
        if (this.items == null) {
            throw new IllegalArgumentException("items");
        }
        if (this.keys.length == 0) {
            throw new IllegalArgumentException("There is no key present in keys array");
        }
        if (this.items.length == 0) {
            throw new IllegalArgumentException("There is no cache item in items array");
        }
        if (this.keys.length != this.items.length) {
            throw new IllegalArgumentException("keys count is not equal to items count");
        }
        if (this.providerName != null) {
            this.builder = this.builder.setProviderName(this.providerName);
        }
        this.builder = this.builder.setDatasourceUpdatedCallbackId(this.dsItemUpdatedtCallbackId).setReturnVersions(this._returnVersions);
        int keyLen = this.keys.length;
        short initialUpdateCallbackId = this._updateCallbackId;
        short initialRemoveCallBackId = this._removeCallbackId;
        for (int i = 0; i < keyLen; ++i) {
            short[] callabackIds;
            CacheItem item = this.items[i];
            if (this.keys[i] == null) {
                throw new IllegalArgumentException("keys");
            }
            long absExp = 0L;
            long sldExp = 0L;
            try {
                if (ConversionUtil.getAbsoluteExpiration(item.getExpiration()).equals(NCDateTime.getUTCDate((Date)CacheImpl.defaultAbsolute))) {
                    absExp = 1L;
                } else if (ConversionUtil.getAbsoluteExpiration(item.getExpiration()).equals(NCDateTime.getUTCDate((Date)CacheImpl.defaultAbsoluteLonger))) {
                    absExp = 2L;
                } else if (ConversionUtil.getAbsoluteExpiration(item.getExpiration()) != CacheImpl.NoAbsoluteExpiration) {
                    absExp = HelperFxn.getUTCTicks((Date)ConversionUtil.getAbsoluteExpiration(item.getExpiration()));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (ConversionUtil.getSlidingExpiration(item.getExpiration()).equals(CacheImpl.DefaultSliding)) {
                sldExp = 1L;
            } else if (ConversionUtil.getSlidingExpiration(item.getExpiration()).equals(CacheImpl.DefaultSlidingLonger)) {
                sldExp = 2L;
            } else if (ConversionUtil.getSlidingExpiration(item.getExpiration()) != CacheImpl.NoSlidingExpiration) {
                sldExp = ConversionUtil.getSlidingExpiration(item.getExpiration()).getTotalTicks();
            }
            if (absExp != 0L && sldExp != 0L) {
                throw new NullPointerException("You cannot set both sliding and absolute expirations on the same cached item");
            }
            if (item.getGroup() != null) {
                this.group = item.getGroup();
            }
            if (item.getResyncOptions() != null) {
                this.isResyncExpiredItems = item.getResyncOptions().getResyncOnExpiration();
            }
            InsertCommandProtocol.InsertCommand.Builder insertBuilder = InsertCommandProtocol.InsertCommand.newBuilder();
            insertBuilder = insertBuilder.setKey(this.keys[i]).setAbsExpiration(absExp).setSldExpiration(sldExp).setFlag(BitSetConstants.getBitSetData((BitSet)CacheItemWrapperInternal.getFlagValue(item))).setPriority(item.getCacheItemPriority().value()).setIsResync(this.isResyncExpiredItems).setCallbackType(this._listenerType.getValue());
            if (this._clientId != null) {
                insertBuilder.setClientID(this._clientId);
            }
            if (this.group != null) {
                insertBuilder = insertBuilder.setGroup(this.group);
                if (this.subGroup != null) {
                    insertBuilder = insertBuilder.setSubGroup(this.subGroup);
                }
                if (CacheItemWrapperInternal.getTypeName(item) != null) {
                    insertBuilder.setGroupType(CacheItemWrapperInternal.getTypeName(item));
                }
            }
            if (item.getSyncDependency() != null) {
                SyncDependencyProtocol.SyncDependency protoSyncDep = SyncDependencyProtocol.SyncDependency.newBuilder().setCacheId(item.getSyncDependency().getCacheId()).setKey(item.getSyncDependency().getKey()).setPort(item.getSyncDependency().getPort()).setServer(item.getSyncDependency().getServer() == null ? "" : item.getSyncDependency().getServer()).build();
                insertBuilder = insertBuilder.setSyncDependency(protoSyncDep);
            }
            ObjectQueryInfoProtocol.ObjectQueryInfo.Builder objectQueryInfoBuilder = ObjectQueryInfoProtocol.ObjectQueryInfo.newBuilder();
            if (CacheItemWrapperInternal.getQueryInfo(item).get("query-info") != null) {
                objectQueryInfoBuilder = objectQueryInfoBuilder.setQueryInfo(Command.getQueryInfoObj((HashMap)CacheItemWrapperInternal.getQueryInfo(item).get("query-info")));
            }
            if (CacheItemWrapperInternal.getQueryInfo(item).get("tag-info") != null) {
                objectQueryInfoBuilder = objectQueryInfoBuilder.setTagInfo(Command.getTagInfo((HashMap)CacheItemWrapperInternal.getQueryInfo(item).get("tag-info")));
            }
            if (CacheItemWrapperInternal.getQueryInfo(item).get("named-tag-info") != null) {
                objectQueryInfoBuilder = objectQueryInfoBuilder.setNamedTagInfo(Command.GetNamedTagInfoObj((HashMap)CacheItemWrapperInternal.getQueryInfo(item).get("named-tag-info")));
            }
            if (this.encryption & (objectQueryInfoBuilder.getNamedTagInfo() != null || objectQueryInfoBuilder.getQueryInfo() != null || objectQueryInfoBuilder.getTagInfo() != null)) {
                byte[] encryptedResult = CacheHelper.EncryptData(objectQueryInfoBuilder.build().toByteArray(), this.cacheId);
                insertBuilder = insertBuilder.addObjectQueryInfoEncrypted(ByteString.copyFrom((byte[])encryptedResult));
            } else {
                insertBuilder = insertBuilder.setObjectQueryInfo(objectQueryInfoBuilder.build());
            }
            if (item.getDependency() != null) {
                try {
                    insertBuilder.setDependency(DependencyHelper.getDependencyProtocol((CacheDependency)item.getDependency()));
                }
                catch (Exception ex) {
                    throw new CommandException(ex.getMessage());
                }
            }
            if (this._removeCallbackId <= 0 && CacheItemWrapperInternal.getCacheItemRemovedListener(item) != null) {
                this.itemRemoveDataFilter = CacheItemWrapperInternal.getItemRemovedDataFilter(item);
                callabackIds = new short[]{};
                try {
                    callabackIds = this._parent.getEventManager().registerSelectiveEvent(CacheItemWrapperInternal.getCacheItemRemovedListener(item), EnumSet.of(EventType.ItemRemoved), this.itemRemoveDataFilter, this._listenerType);
                }
                catch (CacheException e) {
                    throw new CommandException(e.getMessage());
                }
                this._removeCallbackId = callabackIds[1];
            }
            if (this._updateCallbackId <= 0 && CacheItemWrapperInternal.getCacheItemUpdatedListener(item) != null) {
                this.itemUpdateDataFilter = CacheItemWrapperInternal.getItemUpdatedDataFilter(item);
                callabackIds = new short[]{};
                try {
                    callabackIds = this._parent.getEventManager().registerSelectiveEvent(CacheItemWrapperInternal.getCacheItemUpdatedListener(item), EnumSet.of(EventType.ItemUpdated), this.itemUpdateDataFilter, this._listenerType);
                }
                catch (CacheException e) {
                    throw new CommandException(e.getMessage());
                }
                this._updateCallbackId = callabackIds[0];
            }
            if (this.itemUpdateDataFilter == null) {
                this.itemUpdateDataFilter = EventDataFilter.None;
            }
            if (this.itemRemoveDataFilter == null) {
                this.itemRemoveDataFilter = EventDataFilter.None;
            }
            insertBuilder.setRemoveCallbackId((int)this._removeCallbackId).setUpdateCallbackId((int)this._updateCallbackId).setUpdateDataFilter(this.itemUpdateDataFilter.getValue()).setRemoveDataFilter(this.itemRemoveDataFilter.getValue());
            UserBinaryObject userBin = null;
            try {
                userBin = UserBinaryObject.createUserBinaryObject((byte[])((byte[])item.getValue(Object.class)));
            }
            catch (OperationFailedException e) {
                throw new CommandException(e.getMessage());
            }
            List dataList = userBin.getDataList();
            int noOfChunks = dataList.size();
            ArrayList<ByteString> dataChunks = new ArrayList<ByteString>();
            for (int j = 0; j < noOfChunks; ++j) {
                dataChunks.add(ByteString.copyFrom((byte[])((byte[])dataList.get(j))));
            }
            insertBuilder = insertBuilder.addAllData(dataChunks);
            this.builder.addInsertCommand(insertBuilder.build());
            this._updateCallbackId = initialUpdateCallbackId;
            this._removeCallbackId = initialRemoveCallBackId;
        }
        if (this.getIntendedRecipient() != null) {
            this.builder.setIntendedRecipient(this.getIntendedRecipient());
        }
    }

    @Override
    protected void createCommand() throws CommandException {
        this.builder = this.builder.setRequestId(super.getRequestId());
        this.builder.setClientLastViewId(this.getClientLastViewId()).setVersion(Command.VERSION).setMethodOverload(this._methodOveload);
        this._commandInstance = this.builder.build();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.INSERT_BULK;
    }

    @Override
    public boolean getIsSafe() {
        return false;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.KeyBulkWrite;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.INSERT_BULK.getNumber();
    }
}

