/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.DataTypes.CollectionCreateOrGetOperation;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.DataTypeManagementCommandProtocol;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DataTypeGetCommand
extends Command {
    private ReadMode _readMode;
    String _provideName;
    DistributedDataStructure _dataType;
    private DataTypeManagementCommandProtocol.DataTypeManagementCommand _dataTypeManagementCommand;

    public DataTypeGetCommand(CollectionCreateOrGetOperation operation) {
        this.name = "DataTypeManagementCommand";
        this.key = operation.getName();
        this._readMode = operation.getReadThruOptions().getReadMode();
        this._provideName = operation.getReadThruOptions().getProviderName();
        this._dataType = operation.getType();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicRead;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._dataTypeManagementCommand.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.DATATYPE_MANAGEMENT.getNumber();
    }

    @Override
    protected void createCommand() {
        DataTypeManagementCommandProtocol.DataTypeManagementCommand.Builder builder = DataTypeManagementCommandProtocol.DataTypeManagementCommand.newBuilder();
        builder.setRequestId(super.getRequestId()).setName(this.key).setMethod(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Method.GET).setDsReadOption(this._readMode.getValue());
        if (this._provideName != null) {
            builder.setProviderName(this._provideName);
        }
        switch (this._dataType) {
            case List: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.LIST);
                break;
            }
            case Queue: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.QUEUE);
                break;
            }
            case Map: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.DICTIONARY);
                break;
            }
            case Set: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.SET);
                break;
            }
            case Counter: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.COUNTER);
            }
        }
        this._dataTypeManagementCommand = builder.build();
    }
}

