/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryContainsOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.DictionaryCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.DictionaryCommandProtocol;
import com.alachisoft.ncache.common.protobuf.DictionaryContainsProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;

public class DictionaryContainsCommand
extends DictionaryCommandBase {
    private String _key;
    private ExtendedJsonValueBase _value;
    DictionaryContainsOperation.OpType _operationType;
    private DictionaryContainsProtocol.DictionaryContains.Builder _dictionaryContainsCommand;

    public DictionaryContainsCommand(DictionaryContainsOperation operation) {
        this.name = "DictionaryContains";
        this.key = operation.getName();
        this._writeThruOption = operation.getWriteThruOptions();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._key = operation.getKey();
        this._value = operation.getValue();
        this._operationType = operation.getOperationType();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicRead;
    }

    @Override
    protected void createCommand() throws CommandException {
        this._dictionaryContainsCommand = DictionaryContainsProtocol.DictionaryContains.newBuilder();
        this._dictionaryContainsCommand.setKey(this._key);
        if (this._value != null) {
            UserBinaryObject valueObject = UserBinaryObject.createUserBinaryObject((byte[])this._value.toJson().getBytes(StandardCharsets.UTF_8));
            CollectionItemProtocol.CollectionItem.Builder valueItemBuilder = CollectionItemProtocol.CollectionItem.newBuilder();
            for (byte[] bytes : valueObject.getDataList()) {
                valueItemBuilder.addData(ByteString.copyFrom((byte[])bytes));
            }
            this._dictionaryContainsCommand.setValue(valueItemBuilder);
        }
        switch (this._operationType) {
            case Contains: {
                this._dictionaryContainsCommand.setOperationType(DictionaryContainsProtocol.DictionaryContains.OperationType.Contains);
                break;
            }
            case ContainsKey: {
                this._dictionaryContainsCommand.setOperationType(DictionaryContainsProtocol.DictionaryContains.OperationType.ContainsKey);
            }
        }
        super.createCommand();
        this._dictionaryCommandBuilder.setType(DictionaryCommandProtocol.DictionaryCommand.Type.DICTIONARY_CONTAINS);
        this._dictionaryCommandBuilder.setDictionaryContains(this._dictionaryContainsCommand);
    }
}

