/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.client.internal.util.QueryCommandHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.ExecuteReaderCommandProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValueProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class ExecuteReaderCommand
extends Command {
    String _query;
    Map _values;
    boolean _getData;
    int _chunkSize;
    int _methodOverload;
    protected ExecuteReaderCommandProtocol.ExecuteReaderCommand _commandInstance;
    List<KeyValueProtocol.KeyValue> valuesToSend;

    public ExecuteReaderCommand(String query, Map values, boolean getData, int chunkSize, int methodOverload) {
        this.name = "ExecuteReaderCommand";
        this._query = query;
        this._values = values;
        this._getData = getData;
        this._chunkSize = chunkSize;
        this._methodOverload = methodOverload;
        this.valuesToSend = QueryCommandHelper.getValuesFromMap(this._values);
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.NonKeyBulkRead;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.EXECUTE_READER;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected void createCommand() throws CommandException {
        ExecuteReaderCommandProtocol.ExecuteReaderCommand.Builder builder = ExecuteReaderCommandProtocol.ExecuteReaderCommand.newBuilder();
        builder.setQuery(this._query).setGetData(this._getData).setChunkSize(this._chunkSize).setMethodOverload(this._methodOverload);
        if (this.valuesToSend != null) {
            builder.addAllValues(this.valuesToSend);
        }
        this._commandInstance = builder.setRequestId(super.getRequestId()).setCommandId(this.getCommandID()).setCommandVersion(1).setClientLastViewId(super.getClientLastViewId()).build();
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.EXECUTE_READER.getNumber();
    }
}

