/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithPivotOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.ListCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.ListAddWithPivotProtocol;
import com.alachisoft.ncache.common.protobuf.ListCommandProtocol;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;

public class ListAddWithPivotCommand
extends ListCommandBase {
    private ListAddWithPivotOperation.OpType _operationType;
    private ExtendedJsonValueBase _value;
    private ExtendedJsonValueBase _pivot;
    private ListAddWithPivotProtocol.ListAddWithPivot.Builder _listAddWithPivotCommandBuilder;

    public ListAddWithPivotCommand(ListAddWithPivotOperation operation) {
        this.name = "ListAddWithPivot";
        this.key = operation.getName();
        this._writeThruOption = operation.getWriteThruOptions();
        this._value = operation.getValue();
        this._pivot = operation.getPivot();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._operationType = operation.getOperationType();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected void createCommand() {
        this._listAddWithPivotCommandBuilder = ListAddWithPivotProtocol.ListAddWithPivot.newBuilder();
        UserBinaryObject valueObject = UserBinaryObject.createUserBinaryObject((byte[])this._value.toJson().getBytes(StandardCharsets.UTF_8));
        UserBinaryObject pivotObject = UserBinaryObject.createUserBinaryObject((byte[])this._pivot.toJson().getBytes(StandardCharsets.UTF_8));
        CollectionItemProtocol.CollectionItem.Builder valueItem = CollectionItemProtocol.CollectionItem.newBuilder();
        for (byte[] value : valueObject.getDataList()) {
            valueItem.addData(ByteString.copyFrom((byte[])value));
        }
        CollectionItemProtocol.CollectionItem.Builder pivotItem = CollectionItemProtocol.CollectionItem.newBuilder();
        for (byte[] value : pivotObject.getDataList()) {
            pivotItem.addData(ByteString.copyFrom((byte[])value));
        }
        this._listAddWithPivotCommandBuilder.setValue(valueItem);
        this._listAddWithPivotCommandBuilder.setPivot(pivotItem);
        switch (this._operationType) {
            case InsertAfter: {
                this._listAddWithPivotCommandBuilder.setMethod(ListAddWithPivotProtocol.ListAddWithPivot.Method.INSERTAFTER);
                break;
            }
            case InsertBefore: {
                this._listAddWithPivotCommandBuilder.setMethod(ListAddWithPivotProtocol.ListAddWithPivot.Method.INSERBEFORE);
            }
        }
        super.createCommand();
        this._listCommandBuilder.setType(ListCommandProtocol.ListCommand.Type.LIST_ADD_WITH_PIVOT);
        this._listCommandBuilder.setListAddWithPivot(this._listAddWithPivotCommandBuilder);
    }
}

