/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataTypes.List.ListAddWithoutIndexOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.ListCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.ListAddWithoutIndexProtocol;
import com.alachisoft.ncache.common.protobuf.ListCommandProtocol;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class ListAddWithoutIndexCommand
extends ListCommandBase {
    private ListAddWithoutIndexOperation.OpType _operationType;
    private List<ExtendedJsonValueBase> _collection;
    private ListAddWithoutIndexProtocol.ListAddWithoutIndex.Builder _listAddWithoutIndexCommandBuilder;

    public ListAddWithoutIndexCommand(ListAddWithoutIndexOperation operation) {
        this.name = "ListAddWithoutIndex";
        this.key = operation.getName();
        this._writeThruOption = operation.getWriteThruOptions();
        this._collection = operation.getCollection();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._operationType = operation.getOperationType();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.KeyBulkWrite;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected void createCommand() {
        this._listAddWithoutIndexCommandBuilder = ListAddWithoutIndexProtocol.ListAddWithoutIndex.newBuilder();
        for (int i = 0; i < this._collection.size(); ++i) {
            byte[] serializeValue = this._collection.get(i).toJson().getBytes(StandardCharsets.UTF_8);
            UserBinaryObject ubObject = UserBinaryObject.createUserBinaryObject((byte[])serializeValue);
            CollectionItemProtocol.CollectionItem.Builder cItem = CollectionItemProtocol.CollectionItem.newBuilder();
            for (byte[] value : ubObject.getDataList()) {
                cItem.addData(ByteString.copyFrom((byte[])value));
            }
            this._listAddWithoutIndexCommandBuilder.addData(cItem.build());
        }
        switch (this._operationType) {
            case AddRange: {
                this._listAddWithoutIndexCommandBuilder.setMethod(ListAddWithoutIndexProtocol.ListAddWithoutIndex.Method.ADDRANGE);
                break;
            }
            case InsertAtHead: {
                this._listAddWithoutIndexCommandBuilder.setMethod(ListAddWithoutIndexProtocol.ListAddWithoutIndex.Method.INSERTATHEAD);
                break;
            }
            case InsertAtTail: {
                this._listAddWithoutIndexCommandBuilder.setMethod(ListAddWithoutIndexProtocol.ListAddWithoutIndex.Method.INSERTATTAIL);
            }
        }
        super.createCommand();
        this._listCommandBuilder.setType(ListCommandProtocol.ListCommand.Type.LIST_ADD_WITHOUT_INDEX);
        this._listCommandBuilder.setListAddWithoutIndex(this._listAddWithoutIndexCommandBuilder);
    }
}

