/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.LockCommandProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LockCommand
extends Command {
    private final long _threadId;
    private TimeSpan _lockTimeout;
    private int _methodOverload = 0;
    protected LockCommandProtocol.LockCommand _commandInstance;

    public LockCommand(String key, TimeSpan lockTimeout, long threadId, int methodOverload) {
        this.name = "LockCommand";
        this.key = key;
        this._lockTimeout = lockTimeout;
        this._threadId = threadId;
        this._methodOverload = methodOverload;
    }

    @Override
    protected void createCommand() throws CommandException {
        long ticks = 0L;
        if (this._lockTimeout != CacheImpl.NoLockingExpiration) {
            ticks = this._lockTimeout.getTotalTicks();
        }
        LockCommandProtocol.LockCommand.Builder builder = LockCommandProtocol.LockCommand.newBuilder();
        builder = builder.setRequestId(this.getRequestId()).setKey(this.key).setLockTimeout(ticks).setThreadId(Math.toIntExact(this._threadId));
        this._commandInstance = builder.setMethodOverload(this._methodOverload).build();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.LOCK;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    public boolean getIsSafe() {
        return false;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.LOCK.getNumber();
    }
}

