/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValueProtocol;
import com.alachisoft.ncache.common.protobuf.MesasgeAcknowledgmentCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ValueWithTypeProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class MesasgeAcknowledgmentCommand
extends Command {
    private final Map<String, List<String>> topicWiseMessageIds;
    protected MesasgeAcknowledgmentCommandProtocol.MesasgeAcknowledgmentCommand _commandInstance;

    public MesasgeAcknowledgmentCommand(Map<String, List<String>> topicWiseMessageIds) {
        this.name = "MesasgeAcknowledgmentCommand";
        this.topicWiseMessageIds = topicWiseMessageIds;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.MESSAGE_ACKNOWLEDGMENT;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.KeyBulkRead;
    }

    @Override
    protected void createCommand() throws CommandException {
        MesasgeAcknowledgmentCommandProtocol.MesasgeAcknowledgmentCommand.Builder messageAckCommand = MesasgeAcknowledgmentCommandProtocol.MesasgeAcknowledgmentCommand.newBuilder();
        messageAckCommand.setRequestId(this.getRequestId());
        for (Map.Entry<String, List<String>> dataValue : this.topicWiseMessageIds.entrySet()) {
            KeyValueProtocol.KeyValue.Builder keyValPair = KeyValueProtocol.KeyValue.newBuilder();
            keyValPair = keyValPair.setKey(dataValue.getKey());
            for (String value : dataValue.getValue()) {
                keyValPair = keyValPair.addValue(ValueWithTypeProtocol.ValueWithType.newBuilder().setValue(value).build());
            }
            messageAckCommand.addValues(keyValPair.build());
        }
        CommandProtocol.Command.Builder commandBuilder = CommandProtocol.Command.newBuilder();
        if (this.getIntendedRecipient() != null) {
            messageAckCommand.setIntendedRecipient(this.getIntendedRecipient());
        }
        this._commandInstance = messageAckCommand.setClientLastViewId(this.getClientLastViewId()).setVersion(VERSION).setCommandVersion(1).build();
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.MESSAGE_ACKNOWLEDGMENT.getNumber();
    }
}

