/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValuePairProtocol;
import com.alachisoft.ncache.common.protobuf.MessagePublishCommandProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MessagePublishCommand
extends Command {
    private final byte[] payLoad;
    private final long creationTime;
    private final long expirationTime;
    private final Hashtable metadata;
    private final BitSet flagMap;
    protected MessagePublishCommandProtocol.MessagePublishCommand _commandInstance;

    public MessagePublishCommand(String messageId, byte[] payLoad, long creationTime, long expirationTime, Hashtable metadata, BitSet flagMap) {
        this.name = "PublishMessageCommand";
        this.key = messageId;
        this.payLoad = payLoad;
        this.creationTime = creationTime;
        this.expirationTime = expirationTime;
        this.metadata = metadata;
        this.flagMap = flagMap;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.PUBLISHMESSAGE;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    protected void createCommand() throws CommandException {
        UserBinaryObject userBin = UserBinaryObject.createUserBinaryObject((byte[])this.payLoad);
        List dataList = userBin.getDataList();
        int noOfChunks = dataList.size();
        ArrayList<ByteString> dataChunks = new ArrayList<ByteString>();
        for (int i = 0; i < noOfChunks; ++i) {
            dataChunks.add(ByteString.copyFrom((byte[])((byte[])dataList.get(i))));
        }
        MessagePublishCommandProtocol.MessagePublishCommand.Builder messageCommand = MessagePublishCommandProtocol.MessagePublishCommand.newBuilder();
        messageCommand.setRequestId(this.getRequestId()).setCreationTime(this.creationTime).addAllData(dataChunks).setExpiration(this.expirationTime).setFlag((int)this.flagMap.getData()).setMessageId(this.key);
        Set keys = this.metadata.keySet();
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            KeyValuePairProtocol.KeyValuePair.Builder keyValPair = KeyValuePairProtocol.KeyValuePair.newBuilder();
            String key = (String)itr.next();
            keyValPair.setKey(key);
            keyValPair.setValue((String)this.metadata.get(key));
            messageCommand.addKeyValuePair(keyValPair.build());
        }
        if (this.getIntendedRecipient() != null) {
            messageCommand.setIntendedRecipient(this.getIntendedRecipient());
        }
        this._commandInstance = messageCommand.setClientLastViewId(this.getClientLastViewId()).setVersion(VERSION).setCommandVersion(1).build();
    }

    @Override
    public boolean getIsSafe() {
        return false;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.MESSAGE_PUBLISH.getNumber();
    }
}

