/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValueProtocol;
import com.alachisoft.ncache.common.protobuf.SearchCQCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ValueWithTypeProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class SearchCQCommand
extends Command {
    private static char Delimitor = (char)124;
    private String query;
    private HashMap values;
    private boolean isSearchEntries;
    private String clientUniqueId;
    private boolean notifyAdd;
    private boolean notifyUpdate;
    private boolean notifyRemove;
    private int addDF;
    private int removeDF;
    private int updateDF;
    private int _methodOverload = 0;
    protected SearchCQCommandProtocol.SearchCQCommand _commandInstance;

    public SearchCQCommand(String query, HashMap values, String clientUniqueId, boolean isSearchEntries, boolean notifyAdd, boolean notifyUpdate, boolean notifyRemove, int addDF, int removeDF, int updateDF) {
        this.query = query;
        this.values = values;
        this.isSearchEntries = isSearchEntries;
        this.clientUniqueId = clientUniqueId;
        this.notifyAdd = notifyAdd;
        this.notifyRemove = notifyRemove;
        this.notifyUpdate = notifyUpdate;
        this.addDF = addDF;
        this.removeDF = removeDF;
        this.updateDF = updateDF;
    }

    @Override
    public void createCommand() throws CommandException {
        SearchCQCommandProtocol.SearchCQCommand.Builder builder = SearchCQCommandProtocol.SearchCQCommand.newBuilder();
        builder = builder.setRequestId(this.getRequestId()).setQuery(this.query).setSearchEntries(this.isSearchEntries).setNotifyAdd(this.notifyAdd).setNotifyUpdate(this.notifyUpdate).setNotifyRemove(this.notifyRemove).setClientUniqueId(this.clientUniqueId).setAddDataFilter(this.addDF).setRemvoeDataFilter(this.removeDF).setUpdateDataFilter(this.updateDF);
        boolean totalValuesCount = false;
        Set keySet = this.values.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            try {
                String typeKey = (String)iterator.next();
                KeyValueProtocol.KeyValue.Builder keyValPair = KeyValueProtocol.KeyValue.newBuilder();
                keyValPair = keyValPair.setKey(typeKey);
                if (this.values.get(typeKey) instanceof ArrayList) {
                    ArrayList list = (ArrayList)this.values.get(typeKey);
                    for (int i = 0; i < list.size(); ++i) {
                        Object typeValue = list.get(i);
                        keyValPair = keyValPair.addValue(ValueWithTypeProtocol.ValueWithType.newBuilder().setType(typeValue.getClass().getName()).setValue(this.getValueString(typeValue)).build());
                    }
                } else {
                    Object typeValue = this.values.get(typeKey);
                    keyValPair = keyValPair.addValue(ValueWithTypeProtocol.ValueWithType.newBuilder().setType(typeValue.getClass().getName()));
                }
                builder = builder.addValues(keyValPair);
            }
            catch (Exception e) {
                throw new CommandException("Error parsing values.");
            }
        }
        this._commandInstance = builder.setClientLastViewId(this.getClientLastViewId()).setMethodOverload(this._methodOverload).build();
    }

    private String getValueString(Object value) throws Exception {
        if (value == null) {
            throw new CommandException("NCache query does not support null values");
        }
        if (value instanceof String) {
            value = value.toString().toLowerCase();
        }
        if (value instanceof Date) {
            value = HelperFxn.getTicks((Date)((Date)value));
        }
        return value.toString();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.SEARCH_CQ;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.NonKeyBulkRead;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.SEARCH_CQ.getNumber();
    }
}

