/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Caching.EventId;
import Alachisoft.NCache.Common.Communication.Secure.SslConfiguration;
import Alachisoft.NCache.Common.DataStructures.NewHashmap;
import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.PartitioningStrategy;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Logger.JLogger;
import Alachisoft.NCache.Common.Logger.LoggerNames;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Threading.AsyncProcessor;
import Alachisoft.NCache.Common.Threading.Latch;
import Alachisoft.NCache.Common.Threading.Monitor;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import Alachisoft.NCache.Common.Threading.ThrottlingManager;
import Alachisoft.NCache.Common.Util.ReaderWriterLock;
import Alachisoft.NCache.Management.Statistics.StatisticsCounter;
import com.alachisoft.ncache.client.CacheConnectionOptions;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.ClientInfo;
import com.alachisoft.ncache.client.Credentials;
import com.alachisoft.ncache.client.ServerInfo;
import com.alachisoft.ncache.client.internal.caching.ActivityBlockedException;
import com.alachisoft.ncache.client.internal.caching.LicenseVerification;
import com.alachisoft.ncache.client.internal.caching.RemoteCache;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandResponse;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.DisposeCommand;
import com.alachisoft.ncache.client.internal.command.GetCacheHostPortCommand;
import com.alachisoft.ncache.client.internal.command.GetHashmapCommand;
import com.alachisoft.ncache.client.internal.command.GetOptimalServer;
import com.alachisoft.ncache.client.internal.command.GetRunningServersCommand;
import com.alachisoft.ncache.client.internal.command.GetServerMappingCommand;
import com.alachisoft.ncache.client.internal.command.InitCommand;
import com.alachisoft.ncache.client.internal.command.InitSecondarySocketCommand;
import com.alachisoft.ncache.client.internal.command.InquiryRequestCommand;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.client.internal.command.SurrogateCommand;
import com.alachisoft.ncache.client.internal.communication.AddressUtil;
import com.alachisoft.ncache.client.internal.communication.BulkEventStructure;
import com.alachisoft.ncache.client.internal.communication.ClientLicenseType;
import com.alachisoft.ncache.client.internal.communication.Connection;
import com.alachisoft.ncache.client.internal.communication.ConnectionKeepAlive;
import com.alachisoft.ncache.client.internal.communication.ConnectionPool;
import com.alachisoft.ncache.client.internal.communication.DistributedPartitioningStrategy;
import com.alachisoft.ncache.client.internal.communication.ErrorType;
import com.alachisoft.ncache.client.internal.communication.Extensions;
import com.alachisoft.ncache.client.internal.communication.LocalCachePartitioningStrategy;
import com.alachisoft.ncache.client.internal.communication.PersistenceManager;
import com.alachisoft.ncache.client.internal.communication.ReconnectTask;
import com.alachisoft.ncache.client.internal.communication.Request;
import com.alachisoft.ncache.client.internal.communication.RequestModerator;
import com.alachisoft.ncache.client.internal.communication.ResponseIntegrator;
import com.alachisoft.ncache.client.internal.communication.ServerLostListener;
import com.alachisoft.ncache.client.internal.communication.ShutDownServerInfo;
import com.alachisoft.ncache.client.internal.communication.SocketManagerHandler;
import com.alachisoft.ncache.client.internal.communication.StartBalancingClients;
import com.alachisoft.ncache.client.internal.communication.UpdateCompactTypes;
import com.alachisoft.ncache.client.internal.communication.UpdateHashmapAsync;
import com.alachisoft.ncache.client.internal.util.ClientConfiguration;
import com.alachisoft.ncache.client.internal.util.Logs;
import com.alachisoft.ncache.common.protobuf.BlockActivityEventResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ShutDownServerInfoProtocol;
import com.alachisoft.ncache.common.protobuf.UnBlockActivityEventResponseProtocol;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.ConnectionException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.InternalCommandException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.exceptions.StreamAlreadyLockedException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import tangible.RefObject;

public class Broker
implements ServerLostListener {
    public static final int ForcedViewId = -5;
    private static Map<String, Long> _requestDic = new HashMap<String, Long>();
    public boolean _perfStatsEnabled = false;
    public ClientConfiguration _clientConfig;
    public StatisticsCounter _perfStatsColl;
    public Latch _hashMapStatus = new Latch(2);
    private byte[] _value;
    private AtomicLong _requestId = new AtomicLong(-1L);
    private final Long MAXREQUESTID = new Long("9999999999");
    private long _allowedRequests = 200000L;
    private long _shutdownTimeout = 180L;
    private double _retryConnectionDelayInMinutes = 1.0;
    private int _connectionRetries = 5;
    private int _connectionTimeout = 5000;
    private int _connectionMutexTimeout = -1;
    private int _port;
    private int _asyncProccesorThreadCount = 1;
    private boolean _connectionRectified;
    private boolean _retryConnection = true;
    private boolean _isLocalAddress = false;
    private boolean _fromClientCache = false;
    private boolean _connectingFirstTime = true;
    private boolean _balanceNode;
    private boolean _isBridgeClient;
    private boolean _notifyAsync = true;
    private String _cacheId;
    private String _cacheConfigId;
    private String _monitoringSessionId;
    private String _licenceCode;
    private ConnectionKeepAlive _connectionPinger;
    private ArrayList<EventId> missingEvents = new ArrayList();
    private HashMap<Long, Request> _requestTable = null;
    private ReaderWriterLock _lock = new ReaderWriterLock();
    private LocalDateTime _retryConnectionStartTime = LocalDateTime.now();
    private RemoteCache _cache = null;
    private Credentials _securityParams = null;
    private AsyncProcessor _processor = null;
    private AsyncProcessor _eventProcessor = null;
    private ResponseIntegrator _responseIntegrator = new ResponseIntegrator();
    private RequestModerator requestModerator = new RequestModerator();
    private Address _serverIP;
    private AddressUtil _addressUtil;
    private Object _requestsLock = new Object();
    private LicenseManager.LicenseType _type;
    private ClientInfo _clientInfo;
    private Object _hashmapUpdateMutex = new Object();
    private HashMap<Address, ShutDownServerInfo> _shutdownServers = new HashMap();
    private PersistenceManager _persistenceManager = null;
    private ThrottlingManager _throttleManager = new ThrottlingManager(100L);
    private Map<Address, ReconnectTask> _reconnectTasks = new HashMap<Address, ReconnectTask>();
    private Logs privateLogger = new Logs();
    private ILogger _ncacheLogger;
    private boolean privateIsPersistenceEnabled;
    private int privatePersistInterval;
    private PartitioningStrategy privatePartitioningStrategy;
    private ClientLicenseType clientLicenseType = ClientLicenseType.values()[0];
    private InetAddress nodeAddress;
    private int newServerPort;
    private boolean importHashmap = false;
    private Connection connection;
    private boolean privateIsDisposing;
    private ConnectionPool connectionPool = null;
    private SocketManagerHandler privateSocketManagerHandler;
    private int retryInterval = 1;
    private int operationTimeout = 90000;
    private boolean _pipeliningEnabled;
    private int _pipeliningBatchInterval;

    public Broker(RemoteCache cache, Credentials securityParams, CacheConnectionOptions cacheConnectionOptions, StatisticsCounter statsCol, ClientInfo clientInfo) {
        this(cache, securityParams, true, statsCol, cacheConnectionOptions);
        this._clientInfo = clientInfo;
    }

    private Broker(RemoteCache cache, Credentials securityParams, boolean importHashMap, StatisticsCounter perfStatsColl, CacheConnectionOptions cacheConnectionOptions) {
        this._clientConfig = new ClientConfiguration(cache.getName(), cacheConnectionOptions);
        this._cache = cache;
        this._licenceCode = "LicenceCode";
        this._securityParams = securityParams;
        this._balanceNode = this._clientConfig.getBalanceNodes();
        this.importHashmap = this._clientConfig.getImportHashmap();
        this.operationTimeout = this._clientConfig.getClientRequestTimeout();
        this._connectionTimeout = this._clientConfig.getConnectionTimeout();
        this._connectionRetries = this._clientConfig.getConnectionRetries();
        this.retryInterval = this._clientConfig.getRetryInterval();
        this._retryConnectionDelayInMinutes = this._clientConfig.getRetryConnectionDelay();
        this._isBridgeClient = this._clientConfig.getCacheConnectionOptions().getIsBridgeClient();
        this._perfStatsColl = perfStatsColl;
        this._requestTable = new HashMap();
        this.setPool(new ConnectionPool());
        this._fromClientCache = this._clientConfig.getCacheConnectionOptions().getFromClientCache();
    }

    public String getMonitoringSessionId() {
        return this._monitoringSessionId;
    }

    public String getCacheConfigID() {
        return this._cacheConfigId;
    }

    public ClientConfiguration getClientConfig() {
        return this._clientConfig;
    }

    public Latch getHashMapStatus() {
        return this._hashMapStatus;
    }

    public int getPort() {
        return this._port;
    }

    public HashMap<Long, Request> getRequestTable() {
        return this._requestTable;
    }

    public ReaderWriterLock getlock() {
        return this._lock;
    }

    public ResponseIntegrator getResponseIntegrator() {
        return this._responseIntegrator;
    }

    Address getServerIP() {
        return this._serverIP;
    }

    public Object getHashmapUpdateMutex() {
        return this._hashmapUpdateMutex;
    }

    public HashMap<Address, ShutDownServerInfo> getShutdownServers() {
        return this._shutdownServers;
    }

    public LicenseManager.LicenseType getLicenseType() {
        return this._type;
    }

    public RemoteCache getCache() {
        return this._cache;
    }

    public final Logs getLogger() {
        return this.privateLogger;
    }

    public final void setLogger(Logs value) {
        this.privateLogger = value;
    }

    public final void setNCacheLog(ILogger logger) {
        this._ncacheLogger = logger;
    }

    public final ILogger getNCacheLog() {
        return this._ncacheLogger;
    }

    public final int getRetryInterval() {
        return this.retryInterval;
    }

    public final boolean getIsPersistenceEnabled() {
        return this.privateIsPersistenceEnabled;
    }

    private void setIsPersistenceEnabled(boolean value) {
        this.privateIsPersistenceEnabled = value;
    }

    public final int getPersistInterval() {
        return this.privatePersistInterval;
    }

    private void setPersistInterval(int value) {
        this.privatePersistInterval = value;
    }

    private long getRequestId() {
        long requestId = this._requestId.incrementAndGet();
        if (requestId > this.MAXREQUESTID) {
            this._requestId.set(0L);
            requestId = this._requestId.incrementAndGet();
        }
        return requestId;
    }

    public final long getClientLastViewId() {
        return this.getPool().getLastViewId();
    }

    public final PartitioningStrategy getPartitioningStrategy() {
        return this.privatePartitioningStrategy;
    }

    public final void setPartitioningStrategy(PartitioningStrategy value) {
        this.privatePartitioningStrategy = value;
    }

    public final ClientLicenseType getClientLicenseType() {
        return this.clientLicenseType;
    }

    public final void setClientLicenseType(ClientLicenseType value) {
        this.clientLicenseType = value;
    }

    public final InetAddress getNodeIP() {
        return this.nodeAddress;
    }

    public final void setNodeIP(InetAddress value) {
        this.nodeAddress = value;
    }

    public final int getNewServerPort() {
        return this.newServerPort;
    }

    public final void setNewServerPort(int value) {
        this.newServerPort = value;
    }

    public final boolean getIsConnected() {
        return this.getConnection() != null && this.getConnection().getIsConnected();
    }

    public final boolean getPoolHasAllServers() {
        return this._clientConfig.getServerCount() == this.getPool().getServers().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getPoolFullyConnected() {
        Object object = this._hashmapUpdateMutex;
        synchronized (object) {
            boolean poolFullyConnected = this.getPool().getFullyConnnected();
            if (!poolFullyConnected && this.getPool().getConnections() != null) {
                try {
                    for (Object item : this.getPool().getConnections().values()) {
                        Connection connection = (Connection)item;
                        if (connection == null || connection.getIsConnected()) continue;
                        this.ReconectInBackground(connection.getServerAddress(), connection);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._shutdownServers.size() > 1) {
                return false;
            }
            return poolFullyConnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean poolFullyDisConnected() {
        Object object = this._hashmapUpdateMutex;
        synchronized (object) {
            if (this.getPool().getFullyDisConnnected()) {
                if (this.getPool().getConnections() != null) {
                    try {
                        for (Object item : this.getPool().getConnections().values()) {
                            Connection connection = (Connection)item;
                            if (connection == null) continue;
                            this.ReconectInBackground(connection.getServerAddress(), connection);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                return true;
            }
        }
        return false;
    }

    public final boolean getImportHashmap() {
        return this.importHashmap;
    }

    public final void setImportHashmap(boolean value) {
        this.importHashmap = value;
    }

    public final ArrayList getClientServerList() {
        return this._clientConfig.getServerList();
    }

    public final byte[] getValue() {
        return this._value;
    }

    public final void setValue(byte[] value) {
        if (value != null) {
            this._value = new byte[value.length];
            System.arraycopy(value, 0, this._value, 0, value.length);
        }
    }

    final Connection getConnection() {
        return this.connection;
    }

    public final void setConnection(Connection value) {
        this.connection = value;
    }

    public final int getOperationTimeout() {
        return this.operationTimeout;
    }

    public final void setOperationTimeout(int value) {
        this.operationTimeout = value;
    }

    public final boolean getIsDisposing() {
        return this.privateIsDisposing;
    }

    public final void setIsDisposing(boolean value) {
        this.privateIsDisposing = value;
    }

    public final ConnectionPool getPool() {
        return this.connectionPool;
    }

    public final void setPool(ConnectionPool value) {
        this.connectionPool = value;
    }

    public final SocketManagerHandler getSocketManagerHandler() {
        return this.privateSocketManagerHandler;
    }

    public final void setSocketManagerHandler(SocketManagerHandler value) {
        this.privateSocketManagerHandler = value;
    }

    public final ServerInfo GetInitialServer() {
        ServerInfo serverInfo = new ServerInfo();
        List<ServerInfo> list = this._clientConfig.getCacheConnectionOptions().getServerList();
        if (list.size() > 0) {
            serverInfo = list.get(0);
        }
        return serverInfo;
    }

    public final void StartServices(String cacheId, String server, int port) throws Exception {
        try {
            block38: {
                block37: {
                    int conTimeout;
                    this.setSocketManagerHandler(new SocketManagerHandler(this));
                    this.getSocketManagerHandler().StartSocketManager(true);
                    this._cacheId = cacheId;
                    try {
                        String AsynEventNotification = System.getProperty("NCacheClient.AsynchronousEventNotification");
                        if (AsynEventNotification != null && !AsynEventNotification.isEmpty()) {
                            this._notifyAsync = Boolean.parseBoolean(AsynEventNotification);
                        }
                    }
                    catch (Exception ex) {
                        throw new OperationFailedException(17505, ErrorMessages.getErrorMessage((int)17505, (String[])new String[0]));
                    }
                    if (!this._notifyAsync) {
                        try {
                            String asyncProccesorThreadCountString = System.getProperty("NCacheClient.NumberofEventProccesingThreads");
                            if (asyncProccesorThreadCountString != null && asyncProccesorThreadCountString.isEmpty()) {
                                this._asyncProccesorThreadCount = Integer.getInteger(asyncProccesorThreadCountString);
                            }
                        }
                        catch (Exception ex) {
                            throw new OperationFailedException(17504, ErrorMessages.getErrorMessage((int)17504, (String[])new String[0]));
                        }
                        if (this._asyncProccesorThreadCount <= 0) {
                            this._asyncProccesorThreadCount = 1;
                        }
                        if (this._asyncProccesorThreadCount > 5) {
                            this._asyncProccesorThreadCount = 5;
                        }
                        this._eventProcessor = new AsyncProcessor(this._asyncProccesorThreadCount);
                        this._eventProcessor.Start();
                    }
                    try {
                        this._clientConfig.loadConfiguration();
                    }
                    catch (ConfigurationException ex) {
                        // empty catch block
                    }
                    boolean enable_logs = false;
                    boolean detailed_logs = false;
                    enable_logs = System.getProperty("enableNCWebLogs") != null ? Boolean.parseBoolean(System.getProperty("enableNCWebLogs")) : this._clientConfig.getEnableClientLogs();
                    detailed_logs = System.getProperty("enableDetailedNCWebLogs") != null ? Boolean.parseBoolean(System.getProperty("enableDetailedNCWebLogs")) : this._clientConfig.getEnableDetailedClientLogs();
                    this.InitializeLogs(enable_logs, detailed_logs);
                    if (System.getProperty("enablePerfStats") != null) {
                        this._perfStatsEnabled = Boolean.parseBoolean(System.getProperty("enablePerfStat"));
                    }
                    try {
                        LicenseVerification licenseVerification = new LicenseVerification();
                        this._type = licenseVerification.verifyLicense();
                        this.clientLicenseType = this._type == LicenseManager.LicenseType.ActivePerProcessor ? ClientLicenseType.EnterprisePaidClient : ClientLicenseType.EnterpriseFreeClient;
                        if (this._type == LicenseManager.LicenseType.InEvaluation) {
                            this._licenceCode = "InEvaluation";
                        }
                    }
                    catch (LicensingException e) {
                        this.setClientLicenseType(ClientLicenseType.EnterpriseFreeClient);
                    }
                    if (this.getClientLicenseType() == ClientLicenseType.EnterpriseFreeClient) {
                        this._clientConfig.setEnableKeepAlive(true);
                    }
                    if ((conTimeout = this._connectionRetries * (this._connectionTimeout + this.getRetryInterval())) > 0) {
                        this._connectionMutexTimeout = conTimeout;
                    }
                    if (this.getOperationTimeout() < 60000) {
                        this.setOperationTimeout(60000);
                    }
                    this.setConnection(new Connection(this, this.getLogger(), this._perfStatsColl, this._responseIntegrator, this._clientConfig.getBindIP(), this._cacheId));
                    ServerInfo remoteServer = new ServerInfo(server, port);
                    if (this.getImportHashmap()) {
                        this._processor = new AsyncProcessor();
                    }
                    if (remoteServer.getIP() != null) {
                        remoteServer.setIsUserProvidedInternal(true);
                        this._clientConfig.addServer(remoteServer);
                        try {
                            this.ConnectRemoteServer(this.getConnection(), remoteServer, true);
                        }
                        catch (SecurityException se) {
                            if (this.getLogger().getIsErrorLogsEnabled()) {
                                this.getLogger().getNCacheLog().Error("Broker.StartServices", se.toString());
                            }
                        }
                        catch (InternalCommandException ex) {
                            if (!this.getLogger().getIsErrorLogsEnabled()) break block37;
                            this.getLogger().getNCacheLog().Error("Broker.StartServices", ex.toString());
                        }
                    }
                }
                if (!this.getIsConnected()) {
                    try {
                        this.TryNextServer();
                    }
                    catch (SecurityException ex) {
                        if (this.getLogger().getIsErrorLogsEnabled()) {
                            this.getLogger().getNCacheLog().Error("Broker.StartServices", ex.toString());
                        }
                        throw ex;
                    }
                }
                if (this._clientConfig.getEnableKeepAlive()) {
                    try {
                        this._connectionPinger = new ConnectionKeepAlive(this, this._clientConfig.getKeepAliveInterval());
                        this._connectionPinger.Start();
                    }
                    catch (Exception ex) {
                        if (!this.getLogger().getIsErrorLogsEnabled()) break block38;
                        this.getLogger().getNCacheLog().Error("Broker.StartServices", "Problem occured while starting 'ConnectionKeepAlive'" + ex.toString());
                    }
                }
            }
            if (this._pipeliningEnabled) {
                try {
                    Extensions.setTimeout(this._pipeliningBatchInterval);
                    this.getSocketManagerHandler().StartPipelining();
                }
                catch (Exception ex) {
                    if (this.getLogger().getIsErrorLogsEnabled()) {
                        this.getLogger().getNCacheLog().Error("Broker.StartPipelining", "Problem occured while starting forceful pipelining. " + ex.toString());
                    }
                }
            }
        }
        catch (Exception e2) {
            this.getSocketManagerHandler().StopWriter();
            throw e2;
        }
    }

    private void InitializeLogs(boolean enablelogs, boolean detailedlogs) {
        if (enablelogs) {
            Logs localLogger = new Logs();
            localLogger.setIsErrorLogsEnabled(enablelogs);
            if (localLogger.getIsErrorLogsEnabled()) {
                localLogger.setIsDetailedLogsEnabled(detailedlogs);
            }
            long pid = ProcessHandle.current().pid();
            localLogger.setNCacheLog((ILogger)new JLogger());
            try {
                localLogger.getNCacheLog().Initialize(LoggerNames.ClientLogs, this._cacheId);
                if (detailedlogs) {
                    localLogger.getNCacheLog().SetLevel("ALL");
                } else {
                    localLogger.getNCacheLog().SetLevel("INFO");
                }
                localLogger.getNCacheLog().Info("Broker.InitializeLogs", "PID :" + pid + " ClientID : " + this._cache.getClientID());
                this.setLogger(localLogger);
                this.setNCacheLog(localLogger.getNCacheLog());
            }
            catch (Exception e) {
                System.out.println(e);
            }
        } else if (this.getLogger().getNCacheLog() != null) {
            this.getLogger().getNCacheLog().Flush();
            this.getLogger().getNCacheLog().SetLevel("OFF");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnection(Address address) {
        if (this.getConnection() != null) {
            this.getConnection().Disconnect();
            this.getConnection().dispose();
            try {
                this.ResetBroker(Address.Parse((String)this.getConnection().getIpAddress()));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        try {
            this._lock.AcquireWriterLock();
            if (this.getPool() != null && this.getPool().getConnections() != null) {
                Iterator iterator = this.getPool().getConnections().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry item;
                    Map.Entry entry = item = iterator.next();
                    Address ip = (Address)entry.getKey();
                    Connection connection = (Connection)entry.getValue();
                    connection.Disconnect();
                    connection.dispose();
                    this.ResetBroker(ip);
                }
            }
        }
        finally {
            this._lock.ReleaseWriterLock();
        }
    }

    int NextWaitInterval(RefObject<Integer> totalTimeToWait, int timeSlice) {
        if ((Integer)totalTimeToWait.argvalue == 0) {
            timeSlice = 0;
        } else if (timeSlice > (Integer)totalTimeToWait.argvalue) {
            timeSlice = (Integer)totalTimeToWait.argvalue;
            totalTimeToWait.argvalue = 0;
        } else {
            RefObject<Integer> refObject = totalTimeToWait;
            refObject.argvalue = (Integer)refObject.argvalue - timeSlice;
        }
        return timeSlice;
    }

    private void SecureConnectionIfEnabled(Connection connection, boolean enabledOnServer) {
        if (!SslConfiguration.getSslConnectionEnabled() && !enabledOnServer) {
            return;
        }
        if (SslConfiguration.getSslConnectionEnabled() && enabledOnServer) {
            return;
        }
        throw new RuntimeException(String.format("Mistmatch between Client-Server connection security detected. The %1$s node must have Secured-Connection (SSL/TLS)enabled in order to communicate with a %2$s node with Secured-Connection.", enabledOnServer ? "Client" : "Server", enabledOnServer ? "Server" : "Client"));
    }

    public final void InitializeSecondarySocket(Connection connection, InetAddress address, int port) throws Exception {
        connection.ConnectSecondarySocket(address, port);
        InitSecondarySocketCommand command = new InitSecondarySocketCommand(this._cache.getClientID());
        this.DoSendCommand(connection, command, false, false);
        CommandResponse res = connection.RecieveCommandResponse(true);
        if (res != null) {
            res.parseResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ProcessResponse(CommandResponse response, Address remoteServerAddress) throws IOException, OperationFailedException {
        Command command = null;
        Request request = null;
        HashMap<Long, Request> hashMap = this._requestTable;
        synchronized (hashMap) {
            HashMap<Address, Command> commands;
            if (this.getLogger().getIsDetailedLogsEnabled()) {
                this.getLogger().getNCacheLog().Info("Broker.ProcessResponse", "Response recieved for request ID:" + response.getRequestId());
            }
            if ((request = this._requestTable.get(response.getRequestId())) == null && !response.isNeedsDeserialization() && request != null && (commands = request.getCommands()).size() > 0) {
                if (commands.containsKey(remoteServerAddress)) {
                    command = request.getCommands().get(remoteServerAddress);
                } else {
                    for (Command cmd : request.getCommands().values()) {
                        if (!cmd.getFinalDestinationAddress().equals((Object)remoteServerAddress)) continue;
                        command = cmd;
                        break;
                    }
                }
            }
        }
        response.setCacheId(this._cacheId);
        if (command != null) {
            response.setCommandId(command.getCommandID());
        }
        switch (response.getType()) {
            case INIT: 
            case ADD: 
            case REMOVE: 
            case GET: 
            case INSERT: 
            case CLEAR: 
            case COUNT: 
            case REGISTER_NOTIF: 
            case GET_OPTIMAL_SERVER: 
            case GET_ENUMERATOR: 
            case ADD_DEPENDENCY: 
            case ADD_SYNC_DEPENDENCY: 
            case ADD_BULK: 
            case INSERT_BULK: 
            case GET_BULK: 
            case BULK_GET_CACHEITEM: 
            case REMOVE_BULK: 
            case CONTAINS: 
            case CONTAINS_BULK: 
            case GET_CACHE_ITEM: 
            case GET_GROUP_DATA: 
            case GET_GROUP_KEYS: 
            case RAISE_CUSTOM_EVENT: 
            case REMOVE_GROUP: 
            case SEARCH: 
            case SEARCH_ENTRIES: 
            case REGISTER_KEY_NOTIF: 
            case REGISTER_BULK_KEY_NOTIF: 
            case UNREGISTER_KEY_NOTIF: 
            case UNREGISTER_BULK_KEY_NOTIF: 
            case GET_TYPEINFO_MAP: 
            case GET_THRESHOLD_SIZE: 
            case GET_HASHMAP: 
            case GET_COMPACT_TYPES: 
            case HYBRID_BULK: 
            case UNLOCK: 
            case LOCK: 
            case ISLOCKED: 
            case GET_TAG: 
            case GET_LOGGING_INFO: 
            case OPEN_STREAM: 
            case CLOSE_STREAM: 
            case GET_STREAM_LENGTH: 
            case READ_FROM_STREAM: 
            case WRITE_TO_STREAM: 
            case DISPOSE: 
            case REMOVE_TAG: 
            case BRIDGE_MAKE_TARGET_CACHE_ACTIVE_PASSIVE: 
            case UNREGISTER_CQ: 
            case REGISTER_CQ: 
            case GET_KEYS_TAG: 
            case DELETE: 
            case DELETE_BULK: 
            case EXCEPTION: 
            case GET_GROUP_NEXT_CHUNK: 
            case GET_NEXT_CHUNK: 
            case SEARCH_CQ: 
            case SEARCH_ENTRIES_CQ: 
            case ADD_ATTRIBUTE: 
            case GET_ENCRYPTION: 
            case SYNC_EVENTS: 
            case DELETE_QUERY: 
            case REMOVE_QUERY: 
            case GET_SERVER_MAPPING: 
            case INQUIRY_REQUEST_RESPONSE: 
            case MAP_REDUCE_TASK: 
            case TASK_CALLBACK: 
            case RUNNING_TASKS: 
            case CANCEL_TASK: 
            case TASK_PROGRESS: 
            case TASK_ENUMERATOR: 
            case TASK_NEXT_RECORD: 
            case INVOKE_ENTRY_PROCESSOR: 
            case EXECUTE_READER: 
            case EXECUTE_READER_CQ: 
            case DISPOSE_READER: 
            case GET_READER_CHUNK: 
            case EXPIRATION_RESPONSE: 
            case POLL: 
            case REGISTER_POLL_NOTIF: 
            case GET_SECURITY_RESPONSE: 
            case GET_CONNECTED_CLIENTS: 
            case TOUCH: 
            case GET_TOPIC: 
            case REMOVE_TOPIC: 
            case SUBSCRIBE_TOPIC: 
            case UNSUBSCRIBE_TOPIC: 
            case GET_MESSAGE: 
            case MESSAGE_PUBLISH: 
            case MESSAGE_PUBLISH_BULK: 
            case MESSAGE_ACKNOWLEDGEMENT: 
            case PING: 
            case MESSAGE_COUNT: 
            case DATATYPE_RESPONSE: 
            case GET_SERIALIZATION_FORMAT: 
            case GETMODULESTATE: 
            case SETMODULESTATE: 
            case MODULE: {
                this.ProcessRawResponse(request, response, remoteServerAddress);
                break;
            }
            case SURROGATE: {
                response.setSurrogate(true);
                this.ProcessRawResponse(request, response, remoteServerAddress);
                break;
            }
            default: {
                this.ProcessInternalResponse(response, remoteServerAddress, command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessRawResponse(Request request, CommandResponse response, Address remoteServerAddress) {
        if (request == null) {
            return;
        }
        Request request2 = request;
        synchronized (request2) {
            request.addResponse(remoteServerAddress, response);
            request.setCacheId(this._cacheId);
            Monitor.pulse((Object)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ProcessInternalResponse(CommandResponse response, Address remoteServerAddress, Command command) throws IOException, OperationFailedException {
        Address clusterAddress = null;
        Address serverAddress = null;
        response.deserializeResponse();
        switch (response.getType()) {
            case BULK_EVENT: {
                if (response.getEventList().size() <= 0) return;
                BulkEventStructure bulkEventStructure = new BulkEventStructure(remoteServerAddress, response.getEventList(), this, this._perfStatsColl, this._eventProcessor, this._notifyAsync);
                ThreadPool.getInstance().executeTask((Runnable)bulkEventStructure);
                return;
            }
            case NODE_LEFT_EVENT: {
                ServerInfo serverLeft = new ServerInfo();
                if (response.getServerPort() > 0) {
                    serverLeft = this._clientConfig.getMappedServer(response.getIp(), response.getServerPort());
                    this._clientConfig.removeServer(serverLeft);
                }
                clusterAddress = new Address(serverLeft.getIP(), serverLeft.getPort());
                serverAddress = new Address(serverLeft.getIP(), serverLeft.getPort());
                this._cache.getCacheClusterEventsListener().OnMemberLeft(clusterAddress, serverAddress);
                if (!this.getImportHashmap()) return;
                this._cache.InvalidateReaders(serverAddress.getIpAddress().toString());
                return;
            }
            case CACHE_STOPPED_EVENT: {
                return;
            }
            case NODE_JOINED_EVENT: {
                StartBalancingClients startBalancingClients = new StartBalancingClients();
                startBalancingClients.setResponse(response);
                startBalancingClients.setParent(this);
                ThreadPool.getInstance().executeTask((Runnable)startBalancingClients);
                return;
            }
            case HASHMAP_CHANGED_EVENT: {
                UpdateHashmapAsync updateHashmapAsync = new UpdateHashmapAsync(this);
                updateHashmapAsync.setData(response.getValue());
                ThreadPool.getInstance().executeTask((Runnable)updateHashmapAsync);
                return;
            }
            case CONFIG_MODIFIED_EVENT: {
                this._cache.setCompressionEnabled(response.getHotConfig().is_compressionEnabled());
                this._cache.setCompressionThresholdSize(response.getHotConfig().get_compressionThreshold());
                return;
            }
            case COMPACT_TYPE_REGISTER_EVENT: {
                UpdateCompactTypes updateCompactTypes = new UpdateCompactTypes();
                updateCompactTypes.setData(response.getValue());
                updateCompactTypes.setParent(this);
                ThreadPool.getInstance().executeTask((Runnable)updateCompactTypes);
                return;
            }
            case LOGGING_INFO_MODIFIED_EVENT: {
                this.InitializeLogs(response.isEnableErrorLogs(), response.isEnableDetailedLogs());
                return;
            }
            case DS_UPDATE_CALLBACK: {
                if (this._cache == null || this._cache.getAsyncEventListener() == null) return;
                this._cache.getAsyncEventListener().onDataSourceUpdated(response.getCallbackId(), response.getResultMap(), response.getDSOperationCode(), true);
                return;
            }
            case BLOCK_ACTIVITY: {
                ShutDownServerInfo ssinfo = new ShutDownServerInfo();
                BlockActivityEventResponseProtocol.BlockActivityEventResponse blockActivityEventResponse = response.getProtobufResponse().getBlockActivityEvent();
                ssinfo.setUniqueBlockingId(blockActivityEventResponse.getUniqueKey());
                ssinfo.setBlockServerAddress(new Address(blockActivityEventResponse.getServerIP(), blockActivityEventResponse.getPort()));
                ssinfo.setBlockInterval(blockActivityEventResponse.getTimeoutInterval());
                ssinfo.setStartBlockingTime(new Date());
                if (!this._shutdownServers.containsKey(ssinfo.getBlockServerAddress())) {
                    this._shutdownServers.put(ssinfo.getBlockServerAddress(), ssinfo);
                    long maxTimeout = 0L;
                    for (ShutDownServerInfo sInfo : this._shutdownServers.values()) {
                        if (maxTimeout == 0L) {
                            maxTimeout = sInfo.getBlockInterval();
                        }
                        if (maxTimeout >= sInfo.getBlockInterval()) continue;
                        maxTimeout = sInfo.getBlockInterval();
                    }
                    double additionaltime = (float)maxTimeout * 0.05f;
                    this._shutdownTimeout = maxTimeout = (maxTimeout + (long)((int)additionaltime)) * 1000L;
                    try {
                        Object iter = null;
                        HashMap<Long, Request> hashMap = this._requestTable;
                        synchronized (hashMap) {
                            for (Map.Entry<Long, Request> entry : this._requestTable.entrySet()) {
                                Request req;
                                Request request = req = entry.getValue();
                                synchronized (request) {
                                    if (!req.getIsRequestTimeoutReset()) {
                                        req.setRequestTimeout(req.getRequestTimeout() + maxTimeout);
                                        req.setIsRequestTimeoutReset(true);
                                    }
                                }
                            }
                            return;
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().getNCacheLog().Error("Broker.ProcessResponse", ex.toString());
                    }
                    return;
                }
                ShutDownServerInfo oldInfo = this._shutdownServers.get(ssinfo.getBlockServerAddress());
                if (oldInfo.getUniqueBlockingId().equals(ssinfo.getUniqueBlockingId())) return;
                long startTime = oldInfo.getStartBlockingTime().getTime() - System.currentTimeMillis();
                int timeout = (int)(oldInfo.getBlockInterval() * 1000L) - (int)(System.currentTimeMillis() - startTime);
                if (timeout > 0) return;
                this._shutdownServers.put(oldInfo.getBlockServerAddress(), ssinfo);
                return;
            }
            case UNBLOCK_ACTIVITY: {
                Connection con;
                ShutDownServerInfo ssInfo;
                UnBlockActivityEventResponseProtocol.UnBlockActivityEventResponse unblockActivityEventResponse = response.getProtobufResponse().getUnblockActivityEvent();
                Address blockServer = null;
                blockServer = new Address(unblockActivityEventResponse.getServerIP(), unblockActivityEventResponse.getPort());
                if (!this._shutdownServers.containsKey(blockServer) || (ssInfo = this._shutdownServers.get(blockServer)) == null || !ssInfo.getUniqueBlockingId().equals(unblockActivityEventResponse.getUniqueKey())) return;
                Connection shutdownCon = null;
                if (this.getPool().Contains(blockServer)) {
                    shutdownCon = this.getPool().getItem(blockServer);
                    this.getPool().Remove(blockServer);
                }
                if (this.getConnection().getServerAddress().equals((Object)blockServer) && (con = this.getPool().GetAnyConnection()) != null) {
                    this.setConnection(con);
                }
                if (this.getConnection() != null) {
                    this.ReconectInBackground(this.getConnection().getServerAddress(), this.getConnection());
                }
                Object object = ssInfo.getWaitForBlockedActivity();
                synchronized (object) {
                    this._shutdownServers.remove(blockServer);
                    Monitor.pulse((Object)ssInfo.getWaitForBlockedActivity());
                }
                if (shutdownCon == null) return;
                shutdownCon.Disconnect();
                return;
            }
            case OPERATIONCHANGEDEVNET: {
                Address address = null;
                try {
                    address = Address.Parse((String)response.getProtobufResponse().getOperationModeChangeEventResponse().getServerIP());
                }
                catch (UnknownHostException e) {
                    throw new OperationFailedException((Throwable)e);
                }
                this.disconnection(address);
            }
        }
    }

    public final void GetHashmap() throws LicensingException, CommandException, OperationFailedException, InternalCommandException, SecurityException, ConfigurationException, ActivityBlockedException {
        this.GetHashmap(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getKeysDistributionMap(String[] keys, CacheItem[] items, HashMap<Address, Map.Entry<String[], CacheItem[]>> keysDistributionMap) {
        boolean itemsAvailable;
        boolean result = false;
        boolean bl = itemsAvailable = items != null;
        if (this.getImportHashmap()) {
            HashMap<Address, HashMap> keysDistributionList = new HashMap<Address, HashMap>();
            HashMap keysAndItems = null;
            String key = "";
            CacheItem item = null;
            for (int i = 0; i < keys.length; ++i) {
                Address address;
                key = keys[i];
                if (itemsAvailable) {
                    item = items[i];
                }
                this._hashMapStatus.WaitForAny((byte)1);
                Object object = this._hashmapUpdateMutex;
                synchronized (object) {
                    address = this.getPool().GetIp(key);
                }
                if (keysDistributionList.containsKey(address)) {
                    keysAndItems = (HashMap)keysDistributionList.get(address);
                    keysAndItems.put(key, item);
                    continue;
                }
                keysAndItems = new HashMap();
                keysAndItems.put(key, item);
                keysDistributionList.put(address, keysAndItems);
            }
            for (Map.Entry pair : keysDistributionList.entrySet()) {
                Address loadbaanced;
                int index = 0;
                Address serverAddress = (Address)pair.getKey();
                keysAndItems = (HashMap)pair.getValue();
                String[] distributedKeys = new String[keysAndItems.size()];
                CacheItem[] distributedItems = null;
                if (itemsAvailable) {
                    distributedItems = new CacheItem[keysAndItems.size()];
                }
                for (Map.Entry entryObject : keysAndItems.entrySet()) {
                    Map.Entry entry = entryObject;
                    String string = distributedKeys[index] = entry.getKey() instanceof String ? (String)entry.getKey() : null;
                    if (itemsAvailable) {
                        distributedItems[index] = entry.getValue() instanceof CacheItem ? (CacheItem)entry.getValue() : null;
                    }
                    ++index;
                }
                CacheItem[] finalDistributedItems = distributedItems;
                Map.Entry<String[], CacheItem[]> tmp = new AbstractMap.SimpleEntry<String[], CacheItem[]>(distributedKeys, distributedItems);
                Connection conn = this.getPool().getItem(serverAddress);
                Address adrs = serverAddress;
                if (conn != null && !conn.getIsConnected() && (loadbaanced = this.GetLoadBalancedAddress()) != null) {
                    adrs = loadbaanced;
                }
                if (keysDistributionMap.containsKey(adrs)) {
                    Map.Entry<String[], CacheItem[]> newtmp = keysDistributionMap.get(adrs);
                    tmp = this.MergeDistributioonMap(tmp, newtmp, itemsAvailable);
                    keysDistributionMap.put(adrs, tmp);
                    result = true;
                    continue;
                }
                keysDistributionMap.put(adrs, tmp);
            }
        }
        return result;
    }

    public final Map.Entry<String[], CacheItem[]> MergeDistributioonMap(Map.Entry<String[], CacheItem[]> map1, Map.Entry<String[], CacheItem[]> map2, boolean itemsAvailable) {
        int i;
        String[] distributedKeys = new String[map1.getKey().length + map2.getKey().length];
        CacheItem[] distributedItems = null;
        if (itemsAvailable) {
            distributedItems = new CacheItem[map1.getValue().length + map2.getValue().length];
        }
        int size = map1.getKey().length;
        for (i = 0; i < map1.getKey().length; ++i) {
            distributedKeys[i] = map1.getKey()[i];
            if (!itemsAvailable) continue;
            distributedItems[i] = map1.getValue()[i];
        }
        for (i = 0; i < map2.getKey().length; ++i) {
            distributedKeys[size + i] = map2.getKey()[i];
            if (!itemsAvailable) continue;
            distributedItems[size + i] = map2.getValue()[i];
        }
        return new AbstractMap.SimpleEntry<String[], CacheItem[]>(distributedKeys, distributedItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Request createRequest(Command command) throws OperationFailedException {
        Request request = null;
        switch (command.getCommandType()) {
            case GET_GROUP: 
            case GET_TAG: 
            case SEARCH: 
            case SEARCH_CQ: 
            case GET_KEYS_TAG: 
            case GETGROUP_NEXT_CHUNK: 
            case GET_NEXT_CHUNK: 
            case REMOVE_BY_TAG: 
            case REMOVE_GROUP: 
            case DELETEQUERY: 
            case TASK_ENUMERATOR: 
            case EXECUTE_READER: 
            case EXECUTE_READER_CQ: 
            case DISPOSE_READER: 
            case GET_READER_CHUNK: 
            case POLL: 
            case GETMESSAGE: 
            case REGISTER_NOTIF: {
                if (this.getImportHashmap()) {
                    if (this.poolFullyDisConnected()) {
                        throw new OperationFailedException(17500, ErrorMessages.getErrorMessage((int)17500, (String[])new String[0]));
                    }
                    if (!this.getPoolFullyConnected()) {
                        request = this.createDedicatedRequest(command);
                    } else {
                        request = new Request(true, this.getOperationTimeout());
                        Object object = this._hashmapUpdateMutex;
                        synchronized (object) {
                            command.setClientLastViewId(this.getClientLastViewId());
                            for (Address item : this.getPool().getServers()) {
                                request.addCommand(item, command);
                            }
                        }
                    }
                } else {
                    request = new Request(false, this.getOperationTimeout());
                    request.addCommand(this.getConnection().getServerAddress(), command);
                }
                request.setIsAsync(command.isAsync);
                request.setIsAyncCallbackSpecified(command.asyncCallbackSpecified);
                break;
            }
            default: {
                request = new Request(false, this.getOperationTimeout());
                request.setIsAsync(command.isAsync);
                request.setIsAyncCallbackSpecified(command.asyncCallbackSpecified);
                Address ipAddress = null;
                try {
                    ipAddress = this.GetConnectionIP(command);
                }
                catch (CacheException e) {
                    throw new OperationFailedException(17500, ErrorMessages.getErrorMessage((int)17500, (String[])new String[0]));
                }
                if (ipAddress == null) {
                    ipAddress = this.getConnection().getServerAddress();
                }
                request.addCommand(ipAddress, command);
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Request CreateRequestOnServer(String nodeAddress, Command command) throws OperationFailedException {
        Request request = null;
        request = new Request(true, this.getOperationTimeout());
        Connection conn = null;
        Object object = this._hashmapUpdateMutex;
        synchronized (object) {
            conn = this.getPool().GetConnection(nodeAddress);
        }
        if (conn == null) {
            return this.createDedicatedRequest(command);
        }
        request.addCommand(conn.getServerAddress(), command);
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Request createDedicatedRequest(Command command) throws OperationFailedException {
        Request request = null;
        command.resetCommand();
        if (this.getImportHashmap()) {
            request = new Request(true, this.getOperationTimeout());
            command.setClientLastViewId(-5L);
            Address server = this.GetLoadBalancedAddress();
            if (server == null) throw new OperationFailedException(17500, ErrorMessages.getErrorMessage((int)17500, (String[])new String[0]));
            request.addCommand(server, command);
        } else {
            request = new Request(false, this.getOperationTimeout());
            command.setClientLastViewId(-5L);
            request.addCommand(this.getConnection().getServerAddress(), command);
        }
        request.setIsAsync(command.isAsync);
        request.setIsAyncCallbackSpecified(command.asyncCallbackSpecified);
        return request;
    }

    public final Address GetLoadBalancedAddress() {
        if (this.getPool() != null) {
            return this.getPool().GetNextAddress();
        }
        return null;
    }

    private void RetrySendCommand(Command command) throws OperationFailedException {
        int tries = 1;
        boolean retry = true;
        while (retry) {
            retry = tries < this._clientConfig.getCommandRetries();
            try {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().CriticalInfo("RetrySendCommand", "Command: " + command.getCommandType() + " retried. RequestId: " + command.getParent().getRequestId() + ", Sent as dedicated. command.ClientLastViewId == ForcedViewId => " + (command.getClientLastViewId() == -5L));
                }
                command.setIsRetry(true);
                this.SendCommand(command, true);
                retry = false;
            }
            catch (ConnectionException e) {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.RetrySendCommand", "RequestID :" + command.getParent().getRequestId() + " " + command.getCommandName() + " can not sent to server " + new Address(e.getaddress(), e.getport()).toString() + e.toString());
                }
                if (retry) {
                    ++tries;
                    if (this._clientConfig.getCommandRetryInterval() == 0.0f) continue;
                    try {
                        Thread.sleep((long)(this._clientConfig.getCommandRetryInterval() * 1000.0f));
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new OperationFailedException(17500, ErrorMessages.getErrorMessage((int)17500, (String[])new String[0]));
            }
            catch (ActivityBlockedException e) {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.RetrySendCommand", "RequestID :" + command.getParent().getRequestId() + " " + command.getCommandName() + " can not sent to server " + e.getBlockedServerIp() + e.toString());
                }
                if (retry) {
                    ++tries;
                    if (this._clientConfig.getCommandRetryInterval() == 0.0f) continue;
                    try {
                        Thread.sleep((long)(this._clientConfig.getCommandRetryInterval() * 1000.0f));
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw new OperationFailedException(17500, ErrorMessages.getErrorMessage((int)17500, (String[])new String[0]));
            }
            catch (Exception e) {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.RetrySendCommand", "RequestID :" + command.getParent().getRequestId() + " " + command.getCommandName() + " can not sent to server. " + e.toString());
                }
                throw new OperationFailedException((Throwable)e);
            }
        }
    }

    private boolean RetrySendBulkCommand(Command command) throws OperationFailedException {
        Command resendCommand = null;
        boolean isDedicatedResend = false;
        if (command.getCommandRequestType() == RequestType.KeyBulkWrite && !command.getParent().getIsDedicatedRequest()) {
            resendCommand = command;
            command.getParent().RemoveResponse(command.getFinalDestinationAddress(), command.getCommandID());
            command.resetCommand();
        } else {
            resendCommand = Command.getDedicatedCommand(command.getParent().getCommands().values(), this._serverIP.toString());
            isDedicatedResend = true;
            resendCommand.getParent().ClearResponses();
        }
        this.RetrySendCommand(resendCommand);
        return isDedicatedResend;
    }

    private void RetryBulkRequest(Iterable<Map.Entry<Address, Command>> faliedCommands) throws OperationFailedException, InternalCommandException {
        block4: for (Map.Entry<Address, Command> pair : faliedCommands) {
            Address address = pair.getKey();
            Command command = pair.getValue();
            if (command.getSendError() == null) continue;
            ErrorType errorType = command.getSendError().getType();
            Exception exception = command.getSendError().getException();
            switch (errorType) {
                case ConnectionException: 
                case ActivityBlocked: {
                    if (command.getCommandRequestType() == RequestType.ChunkRead) {
                        throw new OperationFailedException("Enumeration has been modified");
                    }
                    if (!command.getIsInternalCommand()) {
                        boolean dedicatedResend = this.RetrySendBulkCommand(command);
                        if (!dedicatedResend) continue block4;
                    }
                    throw new InternalCommandException(exception.getMessage(), (CacheException)((Object)exception));
                }
                case Exception: {
                    if (this.getLogger().getIsErrorLogsEnabled()) {
                        this.getLogger().getNCacheLog().Error("Broker.RetryBulkRequest", "RequestID :" + command.getRequestId() + " " + command.getCommandName() + " can not sent to server " + address + exception.toString());
                    }
                    throw new OperationFailedException((Throwable)exception);
                }
            }
        }
    }

    private void RetryNonBulkRequest(Iterable<Map.Entry<Address, Command>> faliedCommands) throws OperationFailedException {
        for (Map.Entry<Address, Command> pair : faliedCommands) {
            Command command = pair.getValue();
            if (command.getSendError() == null) continue;
            ErrorType errorType = command.getSendError().getType();
            Exception exception = command.getSendError().getException();
            switch (errorType) {
                case ConnectionException: 
                case ActivityBlocked: {
                    if (!command.getIsInternalCommand()) {
                        this.RetrySendCommand(command);
                        break;
                    }
                    throw new OperationFailedException((Throwable)exception);
                }
                case Exception: {
                    throw new OperationFailedException((Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void executeRequest(Request request, Connection connection, boolean checkConnected, boolean waitForResponse) throws LicensingException, OperationFailedException, InternalCommandException, ActivityBlockedException, CommandException, SecurityException, ConfigurationException {
        this.Throttle();
        if (waitForResponse && this._shutdownServers.size() > 0 && request.getRequestTimeout() == (long)this.getOperationTimeout()) {
            request.setRequestTimeout(request.getRequestTimeout() + this._shutdownTimeout);
        }
        try {
            if (waitForResponse) {
                this.AddRequestToRequestTable(request);
            }
            if (!request.getIsBulk()) {
                for (Command command : request.getCommands().values()) {
                    boolean nullConnection = connection == null;
                    try {
                        if (nullConnection) {
                            this.SendCommand(command, false);
                            continue;
                        }
                        this.SendCommand(connection, command, checkConnected, false);
                    }
                    catch (ActivityBlockedException | ConnectionException ex) {
                        if (this.getLogger().getIsErrorLogsEnabled()) {
                            this.getLogger().getNCacheLog().Error("Broker.executeRequest", "RequestID :" + command.getRequestId() + " " + command.getCommandName() + " can not sent to server " + connection.getIpAddress() + " " + ex.toString());
                        }
                        if (command.getIsInternalCommand()) throw new InternalCommandException(ex.getMessage(), (CacheException)((Object)ex));
                        this.RetrySendCommand(command);
                    }
                }
            } else {
                for (Map.Entry entry : request.getCommands().entrySet()) {
                    boolean dedicatedResend;
                    Command command;
                    boolean optimizeConnection;
                    Address ip = (Address)entry.getKey();
                    connection = this.VerifyServerConnectivity(ip, optimizeConnection = (command = (Command)entry.getValue()).getCommandType() != CommandType.GET_NEXT_CHUNK || command.getCommandType() == CommandType.GET_NEXT_CHUNK && (command.getIntendedRecipient() != null && !command.getIntendedRecipient().isEmpty() || !this.getImportHashmap()));
                    if (connection == null && command.getCommandType() == CommandType.GET_NEXT_CHUNK) {
                        throw new OperationFailedException(17507, ErrorMessages.getErrorMessage((int)17507, (String[])new String[0]));
                    }
                    try {
                        if (command.getSupportsSurrogation()) {
                            command = this.GetSurrogateCommand(request, command, connection, ip);
                        }
                        this.SendCommand(connection, command, true, false);
                    }
                    catch (ActivityBlockedException ex) {
                        if (this.getLogger().getIsErrorLogsEnabled()) {
                            this.getLogger().getNCacheLog().Error("Broker.executeRequest", "RequestID :" + command.getRequestId() + " " + command.getCommandName() + " can not sent to server " + connection.getIpAddress() + " " + ex.toString());
                        }
                        if (command.getCommandRequestType() == RequestType.ChunkRead) {
                            throw new OperationFailedException(17507, ErrorMessages.getErrorMessage((int)17507, (String[])new String[0]));
                        }
                        if (command.getIsInternalCommand()) throw new InternalCommandException(ex.getMessage(), (CacheException)ex);
                        dedicatedResend = this.RetrySendBulkCommand(command);
                        if (!dedicatedResend) continue;
                        break;
                    }
                    catch (ConnectionException ex) {
                        if (this.getLogger().getIsErrorLogsEnabled()) {
                            this.getLogger().getNCacheLog().Error("Broker.executeRequest", "RequestID :" + command.getRequestId() + " " + command.getCommandName() + " can not sent to server " + connection.getIpAddress() + " " + ex.toString());
                        }
                        if (command.getCommandRequestType() == RequestType.ChunkRead) {
                            throw new OperationFailedException(17507, ErrorMessages.getErrorMessage((int)17507, (String[])new String[0]));
                        }
                        if (command.getIsInternalCommand()) throw new InternalCommandException(ex.getMessage(), (CacheException)((Object)ex));
                        if (command.getSupportsSurrogation()) {
                            connection = this.VerifyServerConnectivity(ip, true);
                            command = this.GetSurrogateCommand(request, command, connection, ip);
                            this.SendCommand(connection, command, true, true);
                            continue;
                        }
                        dedicatedResend = this.RetrySendBulkCommand(command);
                        if (!dedicatedResend) continue;
                        break;
                    }
                    catch (Exception e) {
                        if (!this.getLogger().getIsErrorLogsEnabled()) throw new OperationFailedException((Throwable)e);
                        this.getLogger().getNCacheLog().Error("Broker.executeRequest", "RequestID :" + command.getRequestId() + " " + command.getCommandName() + " can not sent to server " + connection.getAddress() + e.toString());
                        throw new OperationFailedException((Throwable)e);
                    }
                }
            }
            if (!waitForResponse) return;
            boolean reacquiredLock = true;
            int n = (int)request.getRequestTimeout();
            long startTime = (Calendar.getInstance().getTime().getTime() - 621355968000000000L) / 10000L;
            boolean recheckCommandStatus = false;
            try {
                int n2;
                while (n2 > 0) {
                    recheckCommandStatus = false;
                    if (request.getIsAsync()) {
                        return;
                    }
                    ArrayList<Map.Entry<Address, Command>> failedSendCommands = request.GetSendFailureCommands();
                    if (failedSendCommands != null) {
                        request.RemoveResponse(failedSendCommands);
                        if (request.getIsBulk()) {
                            this.RetryBulkRequest(failedSendCommands);
                        } else {
                            this.RetryNonBulkRequest(failedSendCommands);
                        }
                    }
                    if (request.getIsCompleteResponseReceived()) {
                        if (request.getHasFailedResponses()) continue;
                        if (request.getFailedCommands().size() <= 0) return;
                        if (this.getLogger().getIsErrorLogsEnabled()) {
                            this.getLogger().getNCacheLog().Error("executeRequest", "failed to receive response(s) from " + request.getFailedCommands().size() + " command(s) for requestId: " + request.getRequestId());
                        }
                        Command[] failedCommands = request.getFailedCommands().toArray(new Command[0]);
                        request.getFailedCommands().clear();
                        if (failedCommands[0].getIsInternalCommand()) {
                            throw new InternalCommandException("Could not receive response for internal command. ");
                        }
                        if (failedCommands[0].getIsSafe()) {
                            this.RetrySafeCommand(request, request.getCommands().values());
                        } else {
                            recheckCommandStatus = this.RetryUnsafeCommand(request, failedCommands, startTime, failedCommands[0].getCommandRequestType() == RequestType.NonKeyBulkWrite);
                        }
                    }
                    Request request2 = request;
                    // MONITORENTER : request2
                    if (recheckCommandStatus) {
                        // MONITOREXIT : request2
                        continue;
                    }
                    n2 = (int)request.getRequestTimeout() - (int)((Calendar.getInstance().getTime().getTime() - 621355968000000000L) / 10000L - startTime);
                    if (!request.getIsCompleteResponseReceived() && n2 > 0) {
                        try {
                            reacquiredLock = Monitor.wait((Object)request, (long)n2);
                        }
                        catch (InterruptedException e) {
                            throw new OperationFailedException((Throwable)e);
                        }
                    }
                    if (!reacquiredLock && request.getIsRequestTimeoutReset() && (n2 = (int)request.getRequestTimeout() - (int)((Calendar.getInstance().getTime().getTime() - 621355968000000000L) / 10000L - startTime)) > 0) {
                        reacquiredLock = true;
                        try {
                            reacquiredLock = Monitor.wait((Object)request, (long)n2);
                        }
                        catch (InterruptedException e) {
                            throw new OperationFailedException((Throwable)e);
                        }
                    }
                    if (!reacquiredLock && !request.getIsCompleteResponseReceived()) {
                        if (this._perfStatsColl != null) {
                            this._perfStatsColl.DecrementRequestQueueSizeStats();
                        }
                        if (!this.getLogger().getIsErrorLogsEnabled()) throw new OperationFailedException(request.getTimeoutMessage());
                        this.getLogger().getNCacheLog().Error("Broker.SendCommand", request.getTimeoutMessage());
                        this.getLogger().getNCacheLog().Error("Broker.executeRequest->timeout", Long.valueOf(request.getRequestId()).toString());
                        throw new OperationFailedException(request.getTimeoutMessage());
                    }
                    // MONITOREXIT : request2
                }
                return;
            }
            finally {
                HashMap<Long, Request> hashMap = this._requestTable;
            }
        }
        finally {
            if (waitForResponse && !request.getIsAsync()) {
                this.RemoveRequestFromRequestTable(request);
            }
            this.requestModerator.unRegisterRequest(request.getRequestId());
        }
    }

    private Command GetSurrogateCommand(Request request, Command command, Connection connection, Address actualTargetNode) {
        SurrogateCommand surrogateCommand = null;
        if (command instanceof SurrogateCommand) {
            surrogateCommand = (SurrogateCommand)(command instanceof SurrogateCommand ? command : null);
            request.RemoveSurrogateCommand(connection.getServerAddress());
            command = surrogateCommand.getWrappedCommand();
        }
        if (command.getSupportsSurrogation() && connection != null && !connection.getServerAddress().equals((Object)actualTargetNode)) {
            surrogateCommand = new SurrogateCommand(command, actualTargetNode, connection.getRequestInquiryEnabled());
            request.AddSurrogateCommand(surrogateCommand, connection.getServerAddress());
            command = surrogateCommand;
        }
        return command;
    }

    private void RetrySafeCommand(Request request, Collection<Command> failedCommands) throws OperationFailedException {
        request.ClearResponses();
        Command dedicatedCommand = Command.getDedicatedCommand(failedCommands, this._serverIP.toString());
        dedicatedCommand.setIsRetry(true);
        this.RetrySendCommand(dedicatedCommand);
    }

    private boolean RetryUnsafeCommand(Request request, Command[] failedCommands, long executionStartTime, boolean sendDedicatedRequest) throws OperationFailedException, InternalCommandException, LicensingException, CommandException, ActivityBlockedException, SecurityException, ConfigurationException {
        boolean checkRequestStatus = false;
        boolean retrySend = false;
        boolean retryDedicated = false;
        if (failedCommands == null || failedCommands.length == 0) {
            return false;
        }
        for (Command command : failedCommands) {
            CommandResponse inquiryResponse;
            retrySend = false;
            request.RemoveResponse(command.getFinalDestinationAddress(), command.getCommandID());
            int timeout = (int)request.getRequestTimeout() - (int)((Calendar.getInstance().getTime().getTime() - 621355968000000000L) / 10000L - executionStartTime);
            if (this.getLogger().getIsDetailedLogsEnabled()) {
                this.getLogger().getNCacheLog().CriticalInfo("executeRequest", "Inquiring for command " + command.getCommandType() + " of RequestId: " + command.getParent().getRequestId());
            }
            if ((inquiryResponse = this.Inquire(command, timeout)).getInquiryResponse() != null) {
                if (this.getLogger().getIsDetailedLogsEnabled()) {
                    this.getLogger().getNCacheLog().CriticalInfo("executeRequest", "Inquiry Result for command " + command.getCommandType() + ": " + inquiryResponse.getInquiryResponse().getStatus());
                }
                switch (inquiryResponse.getInquiryResponse().getStatus()) {
                    case 3: {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        for (ByteString bytesString : inquiryResponse.getInquiryResponse().getValueList()) {
                            stream.write(bytesString.toByteArray(), 0, bytesString.toByteArray().length);
                        }
                        CommandResponse cmdResponse = new CommandResponse(false, command.getFinalDestinationAddress());
                        cmdResponse.setRawResult(stream.toByteArray());
                        request.InitializeResponse(command.getFinalDestinationAddress(), command);
                        request.addResponse(command.getFinalDestinationAddress(), cmdResponse);
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        retrySend = true;
                        break;
                    }
                    case 2: {
                        request.getFailedCommands().add(command);
                        request.InitializeFailedResponse(command.getFinalDestinationAddress(), command);
                        checkRequestStatus = true;
                    }
                }
            } else {
                retrySend = true;
            }
            if (!retrySend) continue;
            if (sendDedicatedRequest) {
                retryDedicated |= retrySend;
                continue;
            }
            this.RetrySendCommand(command);
        }
        if (retryDedicated) {
            Command dedicatedCommmand = null;
            if (sendDedicatedRequest) {
                dedicatedCommmand = Command.getDedicatedCommand(Arrays.asList(failedCommands), this._serverIP.toString());
                this.RetrySendCommand(dedicatedCommmand);
            }
        }
        return checkRequestStatus;
    }

    public final CommandResponse Inquire(Command command, long timeout) throws OperationFailedException, LicensingException, CommandException, InternalCommandException, ActivityBlockedException, SecurityException, ConfigurationException {
        Request inquiryRequest = new Request(false, timeout);
        InquiryRequestCommand inquiryCommand = new InquiryRequestCommand(command.getRequestId(), command.getCommandID(), command.getFinalDestinationAddress().getIpAddress().toString());
        Address ipAddress = null;
        try {
            ipAddress = this.GetConnectionIP(command);
        }
        catch (CacheException e) {
            throw new OperationFailedException((Throwable)e);
        }
        inquiryRequest.addCommand(ipAddress, inquiryCommand);
        this.executeRequestForInternalCommand(inquiryRequest);
        return inquiryRequest.getResponse();
    }

    public final void executeRequestForInternalCommand(Request request) throws OperationFailedException, LicensingException, CommandException, InternalCommandException, SecurityException, ActivityBlockedException, ConfigurationException {
        this.executeRequest(request, null, true, true);
    }

    public final void executeRequest(Request request) throws OperationFailedException, LicensingException, CommandException {
        try {
            this.executeRequest(request, null, true, true);
        }
        catch (SecurityException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (ActivityBlockedException | ConfigurationException | InternalCommandException object) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Address GetConnectionIP(Command command) throws SecurityException, ConfigurationException, LicensingException, CommandException, GeneralFailureException, OperationFailedException, OperationNotSupportedException, StreamException, StreamAlreadyLockedException, StreamNotFoundException, AggregateException, ActivityBlockedException {
        Connection connection = this.getConnection();
        if (command.getKey() != null && !command.getKey().equals("") && this.getImportHashmap()) {
            Address ip;
            Object object = this._hashmapUpdateMutex;
            synchronized (object) {
                ip = this.getPool().GetIp(command.getKey());
            }
            if (ip != null && ((connection = this.GetConnection(ip, true)) == null || connection != null && !connection.getIsConnected())) {
                connection = this.TryPool();
            }
        }
        return connection.getServerAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void SendCommand(Command command, boolean waitUntilSend) throws SecurityException, ConfigurationException, LicensingException, ActivityBlockedException, OperationFailedException, CommandException {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.setIntendedRecipientIPAddress("");
        }
        if (command.getKey() != null && !command.getKey().equals("") && this.getImportHashmap()) {
            Address ip;
            Object object = this._hashmapUpdateMutex;
            synchronized (object) {
                ip = this.getPool().GetIp(command.getKey());
            }
            if (ip != null && ((connection = this.GetConnection(ip, true)) == null || connection != null && !connection.getIsConnected())) {
                connection = this.TryPool();
            }
        } else if (this.getImportHashmap() && !connection.getIsConnected() && (connection = this.TryPool()) != null && connection.getServerAddress() != null) {
            this.setConnection(connection);
        }
        if (!this.getImportHashmap() && connection != null && !connection.getIsConnected()) {
            this.TryNextServer();
            connection = this.getConnection();
        }
        this.SendCommand(connection, command, true, waitUntilSend);
    }

    public final void SendCommand(Connection connection, Command command, boolean checkConnected, boolean waitUntilSend) throws OperationFailedException, ConnectionException, ActivityBlockedException {
        Address ip = connection.getServerAddress();
        if (checkConnected) {
            connection.getStatusLatch().waitForAnyUpdated((byte)14);
        }
        try {
            this.DoSendCommand(connection, command, checkConnected, waitUntilSend);
            if (this.getLogger().getIsDetailedLogsEnabled()) {
                this.getLogger().getNCacheLog().Debug("Broker.SendCommand", "RequestID : " + command.getRequestId() + " " + command.getCommandName() + " sent to server " + connection.getIpAddress());
            }
        }
        catch (ConnectionException connectionException) {
            if (this.getLogger().getIsErrorLogsEnabled()) {
                this.getLogger().getNCacheLog().Error("Broker.SendCommand", "RequestID :" + command.getRequestId() + " " + command.getCommandName() + " can not sent to server " + connection.getIpAddress() + " " + connectionException.toString());
            }
            throw connectionException;
        }
        catch (OperationFailedException e) {
            if (this.getLogger().getIsErrorLogsEnabled()) {
                this.getLogger().getNCacheLog().Error("Broker.SendCommand", "RequestID :" + command.getRequestId() + " " + command.getCommandName() + " can not sent to server " + connection.getIpAddress() + " " + e.toString());
            }
            throw e;
        }
        catch (ActivityBlockedException ex) {
            if (this.getLogger().getIsErrorLogsEnabled()) {
                this.getLogger().getNCacheLog().Error("Broker.SendCommand", "RequestID :" + command.getRequestId() + " " + command.getCommandName() + " can not sent to server " + connection.getIpAddress() + " " + ex.toString());
            }
            throw ex;
        }
        catch (Exception e) {
            if (this.getLogger().getIsErrorLogsEnabled()) {
                this.getLogger().getNCacheLog().Error("Broker.SendCommand", "RequestID :" + command.getRequestId() + " " + command.getCommandName() + " can not sent to server " + connection.getIpAddress() + " " + e.toString());
            }
            throw new OperationFailedException((Throwable)e);
        }
    }

    public final void dispose() {
        this.dispose(false);
    }

    public final void dispose(boolean disposingGracefully) {
        this.setIsDisposing(true);
        if (this._connectionPinger != null) {
            this._connectionPinger.Stop();
        }
        ConcurrentHashMap connections = this.getPool().CloneConnectionTable();
        for (Map.Entry item : connections.entrySet()) {
            Connection connection;
            Map.Entry entry = item;
            Connection connection2 = connection = entry.getValue() instanceof Connection ? (Connection)entry.getValue() : null;
            if (connection != null) {
                if (connection.getIsConnected() && disposingGracefully) {
                    DisposeCommand command = new DisposeCommand();
                    try {
                        Request request = this.createRequest(command);
                        this.executeRequest(request, connection, true, false);
                    }
                    catch (CacheException cacheException) {
                        // empty catch block
                    }
                }
                connection.Disconnect();
                this.getPool().Remove(connection.getServerAddress());
            }
            connection.dispose();
        }
        if (this._processor != null) {
            this._processor.Stop();
        }
        if (this._eventProcessor != null) {
            this._eventProcessor.Stop();
        }
        try {
            if (this.requestModerator != null) {
                this.requestModerator.close();
            }
            if (this.getLogger().getNCacheLog() != null) {
                this.getLogger().getNCacheLog().Flush();
                this.getLogger().getNCacheLog().close();
            }
            this.getSocketManagerHandler().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final Connection VerifyServerConnectivity(Address serverIP, boolean optimizeConnection) throws LicensingException, ConfigurationException, SecurityException, CommandException, OperationFailedException, ActivityBlockedException {
        Connection con = null;
        if (optimizeConnection) {
            con = this.GetConnection(serverIP, false);
            if (!con.getIsConnected()) {
                con = this.TryPool();
            }
        } else {
            con = this.GetConnection(serverIP, true);
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void DoSendCommand(Connection connection, Command command, boolean checkConnected, boolean waitUntilSend) throws Exception {
        block28: {
            Object object;
            if (this._shutdownServers.size() > 0) {
                ShutDownServerInfo ssInfo;
                boolean reacquiredLock = true;
                if (command.getCommandRequestType() != RequestType.InternalCommand && (ssInfo = this._shutdownServers.get(connection.getServerAddress())) != null) {
                    object = ssInfo.getWaitForBlockedActivity();
                    synchronized (object) {
                        if (this._shutdownServers.containsKey(connection.getServerAddress())) {
                            long startTime = (ssInfo.getStartBlockingTime().getTime() - 621355968000000000L) / 100001L;
                            int timeout = (int)(ssInfo.getBlockInterval() * 1000L) - (int)((Calendar.getInstance().getTime().getTime() - 621355968000000000L) / 10000L - startTime);
                            if (timeout > 0) {
                                try {
                                    reacquiredLock = Monitor.wait((Object)ssInfo.getWaitForBlockedActivity(), (long)timeout);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                throw new ActivityBlockedException(17508, ErrorMessages.getErrorMessage((int)17508, (String[])new String[0]), ssInfo.getBlockServerAddress());
                            }
                        }
                    }
                }
            }
            if (command.getCommandType() == CommandType.INQUIRY_REQUEST && !connection.getRequestInquiryEnabled()) {
                throw new OperationFailedException(17506, ErrorMessages.getErrorMessage((int)17506, (String[])new String[0]));
            }
            this.InitializeResponse(connection, command);
            command.setCacheId(this._cacheId);
            try {
                long acknowledgement = -1L;
                if (connection.getRequestInquiryEnabled() && !command.getIsSafe()) {
                    acknowledgement = this.requestModerator.registerRequest(connection.getIpAddress(), command.getRequestId());
                    command.setAcknowledgmentId(acknowledgement);
                }
                if (!connection.getOptimized()) {
                    if (connection.getIsSecured()) {
                        connection.AssureSendSecure(command.toByte(acknowledgement, connection.getRequestInquiryEnabled()), connection.getPrimarySecureStream(), checkConnected);
                    } else {
                        connection.AssureSendDirect(command.toByte(acknowledgement, connection.getRequestInquiryEnabled()), connection.getPrimaryClientSocket(), checkConnected);
                    }
                    break block28;
                }
                if (command instanceof InitSecondarySocketCommand) {
                    if (connection.getIsSecured()) {
                        connection.AssureSendSecure(command.toByte(acknowledgement, connection.getRequestInquiryEnabled()), connection.getSecondarySecureStream(), checkConnected);
                    } else {
                        connection.AssureSendDirect(command.toByte(acknowledgement, connection.getRequestInquiryEnabled()), connection.getSecondaryClientSocket(), checkConnected);
                    }
                    break block28;
                }
                if (checkConnected) {
                    command.setPulseOnSend(waitUntilSend);
                    command.setSentOverWire(false);
                    command.setSendError(null);
                    connection.TryEnqueue(command, checkConnected);
                    if (!waitUntilSend) break block28;
                    object = command;
                    synchronized (object) {
                        if (!command.getSentOverWire()) {
                            Monitor.wait((Object)command);
                        }
                        if (command.getSendError() != null) {
                            throw command.getSendError().getException();
                        }
                        break block28;
                    }
                }
                connection.SendCommand(command.toByte(acknowledgement, connection.getRequestInquiryEnabled()), checkConnected);
                connection.Flush();
            }
            catch (ConnectionException e) {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.DoSendCommand", e.toString());
                }
                this.RemoveResponse(connection, command);
                throw e;
            }
            catch (Exception e) {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.DoSendCommand", e.toString());
                }
                this.RemoveResponse(connection, command);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AddRequestToRequestTable(Request request) {
        if (!request.getIsAsync() || request.getIsAyncCallbackSpecified()) {
            request.setRequestId(this.getRequestId());
            HashMap<Long, Request> hashMap = this._requestTable;
            synchronized (hashMap) {
                this._requestTable.put(request.getRequestId(), request);
            }
            if (this._perfStatsColl != null) {
                this._perfStatsColl.incrementRequestQueueSizeStats();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Request GetRequest(long requestId) {
        Request request = null;
        HashMap<Long, Request> hashMap = this._requestTable;
        synchronized (hashMap) {
            if (this._requestTable.containsKey(requestId)) {
                request = this._requestTable.get(requestId);
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RemoveRequestFromRequestTable(Request request) {
        boolean requestExistedInTable = false;
        HashMap<Long, Request> hashMap = this._requestTable;
        synchronized (hashMap) {
            requestExistedInTable = this._requestTable.containsKey(request.getRequestId());
            if (requestExistedInTable) {
                this._requestTable.remove(request.getRequestId());
            }
        }
        if (this._perfStatsColl != null && requestExistedInTable) {
            this._perfStatsColl.DecrementRequestQueueSizeStats();
        }
    }

    private void InitializeResponse(Connection connection, Command command) {
        command.getParent().InitializeResponse(connection.getServerAddress(), command);
    }

    private void RemoveResponse(Connection connection, Command command) {
        command.getParent().RemoveResponse(connection.getServerAddress(), command.getCommandID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ServerLost(Address ip, boolean forcedDisconnected) {
        block28: {
            if (this.getLogger().getIsDetailedLogsEnabled()) {
                this.getLogger().getNCacheLog().Info("ServerLost", "Server lost " + ip + "; forcedDisconnected = " + forcedDisconnected);
            }
            try {
                if (this.getImportHashmap()) {
                    if (!forcedDisconnected) {
                        try {
                            this.ReregisterEvents(ip);
                            Connection connection = this.getPool().getItem(ip);
                            if (connection != null) {
                                this.ReconectInBackground(connection.getServerAddress(), connection);
                            }
                        }
                        catch (Exception exc) {
                            if (this.getLogger().getIsErrorLogsEnabled()) {
                                this.getLogger().getNCacheLog().Error("Broker.ServerLost", exc.getMessage());
                            }
                        }
                    }
                } else {
                    this.getPool().Remove(ip);
                    if (this._shutdownServers.containsKey(ip)) {
                        ShutDownServerInfo ssInfo = this._shutdownServers.get(ip);
                        Object object = ssInfo.getWaitForBlockedActivity();
                        synchronized (object) {
                            Monitor.pulse((Object)ssInfo.getWaitForBlockedActivity());
                            this._shutdownServers.remove(ip);
                        }
                    }
                }
                this.ResetBroker(ip);
                this._clientConfig.removeServer(new ServerInfo(ip.getIpAddress(), ip.getPort()));
                if (forcedDisconnected || this.getConnection().getStatusLatch().IsAnyBitsSet((byte)1)) {
                    return;
                }
                try {
                    if (!this.getConnection().getIsConnected() && !this.getImportHashmap()) {
                        try {
                            this.TryNextServer();
                        }
                        catch (Exception ex) {
                            if (this.getLogger().getIsErrorLogsEnabled()) {
                                this.getLogger().getNCacheLog().Error("Broker.ServerLost", ex.toString());
                            }
                        }
                    }
                }
                finally {
                    if (this._isBridgeClient) {
                        this._cache.getEventsListener().OnCacheStopped(this._cacheId, this._notifyAsync);
                    } else if (!this.getConnection().getIsConnected() && !this.TryPool().getIsConnected()) {
                        this._cache.getEventsListener().OnCacheStopped(this._cacheId, this._notifyAsync);
                    } else if (this.getConnection().getIsConnected()) {
                        this._cache.getEventsListener().OnReregisterTopic();
                    }
                }
            }
            catch (Exception e) {
                if (!this.getLogger().getIsErrorLogsEnabled()) break block28;
                this.getLogger().getNCacheLog().Error("Broker.ServerLost", e.toString());
            }
        }
    }

    private void ReregisterEvents(Address ip) throws Exception {
        this.ReregisterEvents(this.getPool().getItem(ip));
    }

    private void ReregisterEvents(Connection connection) throws SecurityException, ConfigurationException, OperationFailedException, LicensingException, ActivityBlockedException, CommandException {
        if (connection != null && connection.getNotifRegistered()) {
            connection.setNotifRegistered(false);
            Connection selected = this.getConnection();
            if (!selected.getIsConnected()) {
                selected = this.TryPool();
            }
            if (selected != null && selected.getIsConnected()) {
                this._cache.reRegisterGeneralNotification(selected);
                selected.setNotifRegistered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ResetBroker(Address ip) {
        try {
            Iterator<Request> iter = null;
            HashMap<Long, Request> hashMap = this._requestTable;
            synchronized (hashMap) {
                for (Request request : this._requestTable.values()) {
                    if (!request.ExpectingResponseFrom(ip)) continue;
                    Request request2 = request;
                    synchronized (request2) {
                        request.Reset(ip);
                        Monitor.pulse((Object)request);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().getNCacheLog().Error("Broker.ResetBroker", ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void TryNextServer() throws SecurityException, LicensingException, ConfigurationException, OperationFailedException, CommandException, ActivityBlockedException {
        byte setStatus;
        int retries;
        Hashtable<String, LicensingException> invalidServers;
        ArrayList<String> deniedServers;
        ServerInfo startingServer;
        boolean connected;
        block49: {
            connected = false;
            startingServer = null;
            deniedServers = null;
            invalidServers = new Hashtable<String, LicensingException>();
            retries = this._connectionRetries;
            try {
                this._lock.AcquireWriterLock();
            }
            catch (Throwable e) {
                return;
            }
            this.CheckRetryConnectionDelay();
            if (this._retryConnection) break block49;
            byte setStatus2 = connected ? (byte)2 : 4;
            byte unsetStatus = (byte)((!connected ? 2 : 4) | 1);
            this.getConnection().getStatusLatch().SetStatusBit(setStatus2, unsetStatus);
            this._retryConnection = connected;
            this._lock.ReleaseWriterLock();
            if (!connected) {
                if (deniedServers != null && deniedServers.size() > 0) {
                    boolean first = true;
                    StringBuilder sb = new StringBuilder("You do not have permissions to perform the operation on : ");
                    Iterator ie = deniedServers.iterator();
                    while (ie.hasNext()) {
                        Object next;
                        if (!first) {
                            sb.append(" ,");
                            first = false;
                        }
                        sb.append("'" + ((next = ie.next()) instanceof String ? next : null) + "'");
                    }
                    throw new SecurityException(sb.toString());
                }
                if (invalidServers != null && invalidServers.size() > 0) {
                    boolean first = true;
                    StringBuilder sb = new StringBuilder();
                    Iterator ie = invalidServers.entrySet().iterator();
                    while (ie.hasNext()) {
                        if (!first) {
                            sb.append(" ,");
                            first = false;
                        }
                        Map.Entry entry = ie.next();
                        sb.append(entry.getKey());
                        sb.append(' ');
                        sb.append(entry.getValue());
                    }
                    throw new LicensingException(sb.toString());
                }
            }
            return;
        }
        try {
            while (retries-- > 0 && !this.getIsDisposing()) {
                try {
                    if (!this.getConnection().getIsConnected()) {
                        this.getConnection().getStatusLatch().SetStatusBit((byte)1, (byte)6);
                        if (this._clientConfig == null) {
                            this._clientConfig = new ClientConfiguration(this._cacheId);
                        }
                        int nretries = 3;
                        while (true) {
                            try {
                                this._clientConfig.loadConfiguration();
                            }
                            catch (ConfigurationException ie) {
                                if (--nretries == 0) {
                                    throw ie;
                                }
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException first) {}
                                continue;
                            }
                            break;
                        }
                        if (this._clientConfig.getServerCount() > 0) {
                            ServerInfo nextServer;
                            if (!this._clientConfig.getBalanceNodes()) {
                                this._clientConfig.setCurrentServerIndex(0);
                            }
                            startingServer = nextServer = this._clientConfig.getNextServer();
                            boolean triedWithParamPort = true;
                            while (!connected && nextServer != null) {
                                if (nextServer.getIP() != null) {
                                    for (int i = 0; i < nextServer.getPortRangeInternal(); ++i) {
                                        try {
                                            if (!connected) {
                                                Exception exception = null;
                                                RefObject tempRef_exception = new RefObject(exception);
                                                connected = this.ConnectRemoteServer(this.getConnection(), nextServer.getIP(), nextServer.getPort() + i, this._balanceNode, this.getImportHashmap(), true, (RefObject<Exception>)tempRef_exception, true);
                                                exception = (Exception)tempRef_exception.argvalue;
                                            }
                                            if (!connected) continue;
                                            break;
                                        }
                                        catch (SecurityException e2) {
                                            if (deniedServers == null) {
                                                deniedServers = new ArrayList<String>();
                                            }
                                            if (deniedServers.contains(nextServer.getName())) continue;
                                            deniedServers.add(nextServer.getName());
                                            continue;
                                        }
                                        catch (LicensingException ex) {
                                            if (invalidServers.contains(nextServer.getName())) continue;
                                            invalidServers.put(nextServer.getName(), ex);
                                            continue;
                                        }
                                        catch (InternalCommandException ex) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (connected) continue;
                                if (triedWithParamPort && this._clientConfig.isDifferentParamPort(nextServer.getPort())) {
                                    triedWithParamPort = false;
                                    nextServer.setPort(this._clientConfig.getConfigServerPort());
                                    continue;
                                }
                                triedWithParamPort = true;
                                nextServer = this._clientConfig.getNextServer();
                                if (!startingServer.equals(nextServer)) continue;
                            }
                            if (connected) break;
                            Thread.sleep(this.getRetryInterval());
                            continue;
                        }
                        throw new ConfigurationException(10009, ErrorMessages.getErrorMessage((int)10009, (String[])new String[0]));
                    }
                    connected = true;
                }
                catch (InterruptedException nretries) {}
            }
            setStatus = connected ? (byte)2 : 4;
        }
        catch (Throwable throwable) {
            byte setStatus3 = connected ? (byte)2 : 4;
            byte unsetStatus = (byte)((!connected ? 2 : 4) | 1);
            this.getConnection().getStatusLatch().SetStatusBit(setStatus3, unsetStatus);
            this._retryConnection = connected;
            this._lock.ReleaseWriterLock();
            if (!connected) {
                if (deniedServers != null && deniedServers.size() > 0) {
                    boolean first = true;
                    StringBuilder sb = new StringBuilder("You do not have permissions to perform the operation on : ");
                    Iterator ie = deniedServers.iterator();
                    while (ie.hasNext()) {
                        Object next;
                        if (!first) {
                            sb.append(" ,");
                            first = false;
                        }
                        sb.append("'" + ((next = ie.next()) instanceof String ? next : null) + "'");
                    }
                    throw new SecurityException(sb.toString());
                }
                if (invalidServers != null && invalidServers.size() > 0) {
                    boolean first = true;
                    StringBuilder sb = new StringBuilder();
                    Iterator ie = invalidServers.entrySet().iterator();
                    while (ie.hasNext()) {
                        if (!first) {
                            sb.append(" ,");
                            first = false;
                        }
                        Map.Entry entry = ie.next();
                        sb.append(entry.getKey());
                        sb.append(' ');
                        sb.append(entry.getValue());
                    }
                    throw new LicensingException(sb.toString());
                }
            }
            throw throwable;
        }
        byte unsetStatus = (byte)((!connected ? 2 : 4) | 1);
        this.getConnection().getStatusLatch().SetStatusBit(setStatus, unsetStatus);
        this._retryConnection = connected;
        this._lock.ReleaseWriterLock();
        if (!connected) {
            Iterator<Object> ie;
            boolean first;
            if (deniedServers != null && deniedServers.size() > 0) {
                first = true;
                StringBuilder sb = new StringBuilder("You do not have permissions to perform the operation on : ");
                ie = deniedServers.iterator();
                while (ie.hasNext()) {
                    Object next;
                    if (!first) {
                        sb.append(" ,");
                        first = false;
                    }
                    sb.append("'" + ((next = ie.next()) instanceof String ? next : null) + "'");
                }
                throw new SecurityException(sb.toString());
            }
            if (invalidServers != null && invalidServers.size() > 0) {
                first = true;
                StringBuilder sb = new StringBuilder();
                ie = invalidServers.entrySet().iterator();
                while (ie.hasNext()) {
                    if (!first) {
                        sb.append(" ,");
                        first = false;
                    }
                    Map.Entry entry = (Map.Entry)ie.next();
                    sb.append(entry.getKey());
                    sb.append(' ');
                    sb.append(entry.getValue());
                }
                throw new LicensingException(sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean GetServerAddressWithCallStatus(String key, RefObject<Address> serverAddress) {
        Address nextAvailableAddress;
        Address hashMapAddress;
        this._hashMapStatus.WaitForAny((byte)1);
        Object object = this._hashmapUpdateMutex;
        synchronized (object) {
            hashMapAddress = this.connectionPool.GetIp(key);
        }
        Connection conn = this.connectionPool.getItem(hashMapAddress);
        if (!(conn != null && conn.getIsConnected() || (nextAvailableAddress = this.GetLoadBalancedAddress()) == null)) {
            serverAddress.argvalue = nextAvailableAddress;
            return true;
        }
        serverAddress.argvalue = hashMapAddress;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection ReconnectServer(Connection connection, ServerInfo nextServer) throws SecurityException, LicensingException, CommandException, OperationFailedException, ConfigurationException, ActivityBlockedException {
        byte setStatus;
        int retries;
        ArrayList<String> invalidServers;
        ArrayList<String> deniedServers;
        boolean connected;
        block41: {
            connected = false;
            deniedServers = null;
            invalidServers = null;
            retries = this._connectionRetries;
            if (this.getLogger().getIsDetailedLogsEnabled()) {
                this.getLogger().getNCacheLog().Debug("ReconnectServer", "Trying to reconnect to :" + connection.getIpAddress());
            }
            try {
                this._lock.AcquireWriterLock();
            }
            catch (Exception e) {
                if (this.getLogger().getIsDetailedLogsEnabled()) {
                    this.getLogger().getNCacheLog().Debug("reconnectServer:\tFailed to acquire lock");
                }
                return connection;
            }
            this.CheckRetryConnectionDelay();
            if (this._retryConnection) break block41;
            Connection e = connection;
            byte setStatus2 = connected ? (byte)2 : 4;
            byte unsetStatus = (byte)((!connected ? 2 : 4) | 1);
            connection.getStatusLatch().SetStatusBit(setStatus2, unsetStatus);
            this._retryConnection = connected;
            this._lock.ReleaseWriterLock();
            if (!connected) {
                if (deniedServers != null && deniedServers.size() > 0) {
                    boolean first = true;
                    StringBuilder sb = new StringBuilder("You do not have permissions to perform the operation on : ");
                    Iterator ie = deniedServers.iterator();
                    while (ie.hasNext()) {
                        if (!first) {
                            sb.append(" ,");
                            first = false;
                        }
                        sb.append("'" + (ie.next() instanceof String ? ie.next() : null) + "'");
                    }
                    throw new SecurityException(sb.toString());
                }
                if (invalidServers != null && invalidServers.size() > 0) {
                    boolean first = true;
                    StringBuilder sb = new StringBuilder("You do not have valid license to communicate with : ");
                    Iterator ie = invalidServers.iterator();
                    while (ie.hasNext()) {
                        if (!first) {
                            sb.append(" ,");
                            first = false;
                        }
                        sb.append("'" + (ie.next() instanceof String ? ie.next() : null) + "'");
                    }
                    throw new LicensingException(sb.toString());
                }
            }
            return e;
        }
        try {
            while (retries-- > 0 && !this.getIsDisposing()) {
                if (!connection.getIsConnected()) {
                    connection.getStatusLatch().SetStatusBit((byte)1, (byte)6);
                    if (nextServer == null) break;
                    if (nextServer.getIP() != null) {
                        for (int i = 0; i < nextServer.getPortRangeInternal(); ++i) {
                            try {
                                if (!connected) {
                                    Exception exception = null;
                                    RefObject tempRef_exception = new RefObject(exception);
                                    connected = this.ConnectRemoteServer(connection, nextServer.getIP(), nextServer.getPort() + i, this._balanceNode, this.getImportHashmap(), true, (RefObject<Exception>)tempRef_exception, true);
                                    exception = (Exception)tempRef_exception.argvalue;
                                }
                                if (!connected) continue;
                                if (!this.getLogger().getIsDetailedLogsEnabled()) break;
                                this.getLogger().getNCacheLog().CriticalInfo("ReconnectServer", "Reconnected with: " + connection.getIpAddress());
                                break;
                            }
                            catch (SecurityException e2) {
                                if (deniedServers == null) {
                                    deniedServers = new ArrayList<String>();
                                }
                                if (deniedServers.contains(nextServer.getName())) continue;
                                deniedServers.add(nextServer.getName());
                                continue;
                            }
                            catch (LicensingException e3) {
                                if (invalidServers == null) {
                                    invalidServers = new ArrayList<String>();
                                }
                                if (invalidServers.contains(nextServer.getName())) continue;
                                invalidServers.add(nextServer.getName());
                                continue;
                            }
                            catch (InternalCommandException internalException) {
                                if (!this.getLogger().getIsErrorLogsEnabled()) continue;
                                this.getLogger().getNCacheLog().Error("ReconnectServer", "Reconnected with: " + connection.getIpAddress());
                            }
                        }
                    }
                    try {
                        Thread.sleep(this.getRetryInterval());
                    }
                    catch (InterruptedException i) {}
                    continue;
                }
                connected = true;
                break;
            }
            setStatus = connected ? (byte)2 : 4;
        }
        catch (Throwable throwable) {
            byte setStatus3 = connected ? (byte)2 : 4;
            byte unsetStatus = (byte)((!connected ? 2 : 4) | 1);
            connection.getStatusLatch().SetStatusBit(setStatus3, unsetStatus);
            this._retryConnection = connected;
            this._lock.ReleaseWriterLock();
            if (!connected) {
                if (deniedServers != null && deniedServers.size() > 0) {
                    boolean first = true;
                    StringBuilder sb = new StringBuilder("You do not have permissions to perform the operation on : ");
                    Iterator ie = deniedServers.iterator();
                    while (ie.hasNext()) {
                        if (!first) {
                            sb.append(" ,");
                            first = false;
                        }
                        sb.append("'" + (ie.next() instanceof String ? ie.next() : null) + "'");
                    }
                    throw new SecurityException(sb.toString());
                }
                if (invalidServers != null && invalidServers.size() > 0) {
                    boolean first = true;
                    StringBuilder sb = new StringBuilder("You do not have valid license to communicate with : ");
                    Iterator ie = invalidServers.iterator();
                    while (ie.hasNext()) {
                        if (!first) {
                            sb.append(" ,");
                            first = false;
                        }
                        sb.append("'" + (ie.next() instanceof String ? ie.next() : null) + "'");
                    }
                    throw new LicensingException(sb.toString());
                }
            }
            throw throwable;
        }
        byte unsetStatus = (byte)((!connected ? 2 : 4) | 1);
        connection.getStatusLatch().SetStatusBit(setStatus, unsetStatus);
        this._retryConnection = connected;
        this._lock.ReleaseWriterLock();
        if (!connected) {
            if (deniedServers != null && deniedServers.size() > 0) {
                boolean first = true;
                StringBuilder sb = new StringBuilder("You do not have permissions to perform the operation on : ");
                Iterator ie = deniedServers.iterator();
                while (ie.hasNext()) {
                    if (!first) {
                        sb.append(" ,");
                        first = false;
                    }
                    sb.append("'" + (ie.next() instanceof String ? ie.next() : null) + "'");
                }
                throw new SecurityException(sb.toString());
            }
            if (invalidServers != null && invalidServers.size() > 0) {
                boolean first = true;
                StringBuilder sb = new StringBuilder("You do not have valid license to communicate with : ");
                Iterator ie = invalidServers.iterator();
                while (ie.hasNext()) {
                    if (!first) {
                        sb.append(" ,");
                        first = false;
                    }
                    sb.append("'" + (ie.next() instanceof String ? ie.next() : null) + "'");
                }
                throw new LicensingException(sb.toString());
            }
        }
        return connection;
    }

    private Connection GetConnection(Address ip, boolean strictMatch) throws SecurityException, OperationFailedException, LicensingException, ConfigurationException, ActivityBlockedException, CommandException {
        Connection connection = this.getPool().getItem(ip);
        if (connection != null) {
            if (!connection.getIsConnected()) {
                if (connection.getNotifRegistered()) {
                    this.ReregisterEvents(connection);
                }
                if (!connection.getIsReconnecting()) {
                    this.ReconectInBackground(connection.getServerAddress(), connection);
                }
            } else {
                return connection;
            }
        }
        if (this.getImportHashmap() && !strictMatch) {
            connection = this.TryPool();
        }
        if (connection != null) {
            connection.setIntendedRecipientIPAddress("");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean NeedsNotifRegistration() {
        boolean bl;
        try {
            ConcurrentHashMap connections;
            this._lock.AcquireReaderLock();
            ConcurrentHashMap concurrentHashMap = connections = this.getPool().getConnections();
            // MONITORENTER : concurrentHashMap
            for (Map.Entry entry : connections.entrySet()) {
                if (!((Connection)entry.getValue()).getIsConnected()) continue;
                bl = false;
                // MONITOREXIT : concurrentHashMap
            }
        }
        catch (Throwable throwable) {
            this._lock.ReleaseReaderLock();
            throw throwable;
        }
        {
            this._lock.ReleaseReaderLock();
            return bl;
        }
        boolean bl2 = true;
        // MONITOREXIT : concurrentHashMap
        this._lock.ReleaseReaderLock();
        return bl2;
    }

    /*
     * Exception decompiling
     */
    public final boolean TryConnecting(Connection connection, RefObject<Exception> exception, int connectionWaitInterval, boolean importHashmap, boolean changeStatus) throws CommandException, OperationFailedException, ConfigurationException, ActivityBlockedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final Connection TryPool() throws ConfigurationException, SecurityException, LicensingException, OperationFailedException, CommandException, ActivityBlockedException {
        ServerInfo nextServer;
        Connection connection = null;
        if (this._clientConfig == null) {
            this._clientConfig = new ClientConfiguration(this._cacheId);
        }
        int retries = 3;
        while (!this.getIsDisposing()) {
            try {
                this._clientConfig.loadConfiguration();
                break;
            }
            catch (ConfigurationException ie) {
                if (--retries == 0) {
                    throw ie;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!this._clientConfig.getBalanceNodes()) {
            this._clientConfig.setCurrentServerIndex(0);
        }
        int index = 0;
        ServerInfo startingServer = nextServer = this._clientConfig.getServerAt(index);
        while (!this.getIsDisposing()) {
            if (this._clientConfig.getServerCount() > 0 && index < this._clientConfig.getServerCount()) {
                connection = this.getPool().getItem(new Address(nextServer.getName(), nextServer.getPort()));
                if (connection != null && connection.getIsConnected()) break;
                if (connection != null && !connection.getIsReconnecting()) {
                    this.ReconectInBackground(connection.getServerAddress(), connection);
                    continue;
                }
                if (++index >= this._clientConfig.getServerCount()) {
                    index = 0;
                }
                if (!startingServer.equals(nextServer = this._clientConfig.getServerAt(index))) continue;
                break;
            }
            if (index < this._clientConfig.getServerCount()) break;
            nextServer = startingServer;
            break;
        }
        if (connection == null || !connection.getIsConnected()) {
            index = 0;
            nextServer = this._clientConfig.getServerAt(index);
            while (!this.getIsDisposing()) {
                if (this._clientConfig.getServerCount() > 0 && index < this._clientConfig.getServerCount()) {
                    boolean found = false;
                    Address address = new Address(nextServer.getName(), nextServer.getPort());
                    if (this.getPool().Contains(address)) {
                        connection = this.getPool().getItem(address);
                        found = true;
                    } else {
                        connection = new Connection(this, this.getLogger(), this._perfStatsColl, this._responseIntegrator, this._clientConfig.getBindIP(), this._cacheId);
                    }
                    if (connection.getIsConnected()) break;
                    if (!connection.getIsReconnecting()) {
                        if ((connection = this.ReconnectServer(connection, nextServer)).getServerAddress() == null) {
                            connection.setServerAddress(address);
                        }
                        if (connection.getIsConnected()) {
                            if (this.getPool().Contains(address)) break;
                            this.getPool().setItem(address, connection);
                            break;
                        }
                    }
                    if (++index >= this._clientConfig.getServerCount()) {
                        index = 0;
                    }
                    if (!startingServer.equals(nextServer = this._clientConfig.getServerAt(index))) continue;
                    break;
                }
                if (index < this._clientConfig.getServerCount()) break;
                nextServer = startingServer;
                break;
            }
        }
        return connection;
    }

    private void CheckRetryConnectionDelay() {
        LocalDateTime currentTime = LocalDateTime.now();
        Duration duration = Duration.between(currentTime, this._retryConnectionStartTime);
        long diff = Math.abs(duration.toMinutes());
        if ((double)diff >= this._retryConnectionDelayInMinutes) {
            this._retryConnectionStartTime = LocalDateTime.now();
            this._retryConnection = true;
        }
    }

    private void Throttle() throws LicensingException {
        if (LicenseManager.isDeveloper() && this._addressUtil != null && !this._isLocalAddress) {
            this._throttleManager.throttle(1L);
            this.CheckPendingRequests(this._cacheId.toLowerCase());
        }
    }

    public boolean ConnectRemoteServer(Connection connection, ServerInfo server, boolean registerNotifs) throws Exception {
        boolean connected = false;
        Exception exception = null;
        if (server != null && server.getIP() != null) {
            RefObject tempRef_exception = new RefObject(exception);
            connected = this.ConnectRemoteServer(connection, server.getIP(), server.getPort(), this._balanceNode, this.getImportHashmap(), registerNotifs, (RefObject<Exception>)tempRef_exception, true);
            exception = (Exception)tempRef_exception.argvalue;
        }
        return connected;
    }

    /*
     * Unable to fully structure code
     */
    public boolean ConnectRemoteServer(Connection connection, InetAddress addr, int port, boolean balanceNodes, boolean importHashmap, boolean registerNotifs, RefObject<Exception> exception, boolean changeStatus) throws SecurityException, LicensingException, InternalCommandException, CommandException, ConfigurationException, OperationFailedException, ActivityBlockedException {
        connected = connection.connect(addr, port);
        this._responseIntegrator.RemoveServer(new Address(addr, port));
        if (connected) {
            try {
                if (this._clientConfig.getIPMappingConfigured()) {
                    this.GetServerMapping(connection, true);
                }
                connected = this.ConnectWithCacheHost(connection, addr, port);
                if (balanceNodes) {
                    response = this.IsOptimalServer(connection, addr, port);
                    rm = this._clientConfig.getMappedServer(response.getIp(), response.getServerPort());
                    if (!(response == null || addr.toString().equals(rm.getName()) && port == rm.getPort())) {
                        connected = this.TryConnectTo(connection, rm);
                    }
                }
                if (!connected) ** GOTO lbl58
                if (this.getLogger().getIsDetailedLogsEnabled()) {
                    this.getLogger().getNCacheLog().Info("Broker.ConnectRemoteServer", "[Local : (" + (connection.getPrimaryClientSocket() != null ? (connection.getPrimaryClientSocket().getInetAddress() != null ? connection.getPrimaryClientSocket().getInetAddress().toString() : "localendpointNULL") : "primaryclientsocketNULL") + ") Server : (" + addr.toString() + ":" + port + ")] connected successfully");
                }
                this.InitializeCache(connection, addr, port, balanceNodes);
                this.StartThrottlingOnRemoteServer(connection);
                if (connection.getSupportDualSocket()) {
                    this.InitializeSecondarySocket(connection, addr, port);
                }
                runningServers = this.GetRunningServers(connection, addr, port);
                connection.Init();
                if (runningServers != null) {
                    outPort = 0;
                    for (String str : runningServers.keySet()) {
                        rServer = new ServerInfo();
                        outPort = runningServers.get(str);
                        rServer.setName(str);
                        address = new Address(str, outPort);
                        rServer.setIP(address.getIpAddress());
                        rServer.setPort(address.getPort());
                        rServer.setPriorityInternal((short)32767);
                        this._clientConfig.addServer(rServer);
                    }
                }
                if (!this.getLogger().getIsErrorLogsEnabled()) ** GOTO lbl58
                this.getLogger().getNCacheLog().CriticalInfo("Broker.ConnectRemoteServer", "[Local : (" + connection.getPrimaryClientSocket().getInetAddress().toString() + ") Server : (" + addr.toString() + ":" + port + ")] initialized cache successfully");
            }
            catch (SecurityException sec_ex) {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.ConnectRemoteServer", sec_ex.toString());
                }
                connection.Disconnect();
                connected = false;
                throw sec_ex;
            }
            catch (LicensingException lic) {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.ConnectRemoteServer", lic.toString());
                }
                connection.Disconnect();
                connected = false;
                throw lic;
            }
            catch (Exception e) {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.ConnectRemoteServer", e.toString());
                }
                connection.Disconnect(changeStatus);
                connected = false;
                exception.argvalue = e;
            }
        } else if (this.getLogger().getIsErrorLogsEnabled()) {
            this.getLogger().getNCacheLog().Error("Broker.ConnectRemoteServer", "Could not connect to server (" + addr.toString() + ":" + port + ")");
        }
lbl58:
        // 7 sources

        if (connected) {
            if (this._processor != null) {
                this._processor.Start();
            }
            connection.getStatusLatch().SetStatusBit((byte)2, (byte)5);
            this._serverIP = connection.getServerAddress();
            this._port = connection.getPort();
            this.getPool().Add(connection.getServerAddress(), connection);
            if (importHashmap) {
                this.GetHashmap(connection);
            }
            if (registerNotifs) {
                this._cache.reRegisterGeneralNotification(connection);
                connection.setNotifRegistered(true);
            }
            if (this.getImportHashmap()) {
                this._cache.registerHashmapChangedEvent(connection);
            }
            this._cache.getTypeInfoMap(connection);
            this._cache.getThresholdSize(connection);
            this._cache.getEncryptionKeyFromServer(connection);
            this._cache.getExpirationFromServer(connection);
            this._cache.getSerializationFormat(connection);
            if (this.getLogger() != null && this.getLogger().getIsErrorLogsEnabled() && this._cache != null) {
                this.getLogger().getNCacheLog().CriticalInfo("Broker.ConnectRemoteServer", "Compression Enbaled : { " + this._cache.getCompressionEnabled() + "} ; Compression Threshold : { " + this._cache.getCompressionThreshold() + "} ; Encryption Enabled : { " + this._cache.getEncryptionEnabled() + "} ; Pipelining Enabled : { " + this._pipeliningEnabled + "} ; Pipelining Batch Interval : { " + this._pipeliningEnabled + "}");
            }
            if (importHashmap) {
                this._cache.getCompactTypesFromServer(connection);
            }
            this._connectingFirstTime = false;
            if (this.getConnection() == null || this.getConnection().getServerAddress() == null) {
                this._connectionRectified = true;
                if (this.getLogger() != null && this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.ConnectRemoteServer", "_connection anamoly detected connection ? " + (this.getConnection() == null));
                }
                this.setConnection(connection);
            }
        }
        return connected;
    }

    public final void GetHashmap(Connection connection) throws OperationFailedException, CommandException, InternalCommandException, ActivityBlockedException, SecurityException, ConfigurationException, LicensingException {
        GetHashmapCommand command = new GetHashmapCommand();
        Request request = new Request(false, this.getOperationTimeout());
        Address ipAddress = connection == null ? this.getConnection().getServerAddress() : connection.getServerAddress();
        request.addCommand(ipAddress, command);
        if (connection != null) {
            try {
                this.executeRequest(request, connection, true, true);
            }
            catch (CacheException e) {
                throw new OperationFailedException((Throwable)e);
            }
        } else {
            this.executeRequestForInternalCommand(request);
        }
        CommandResponse res = request.getResponse();
        try {
            res.parseResponse();
        }
        catch (CacheException e) {
            throw new OperationFailedException((Throwable)e);
        }
        NewHashmap hashmap = res.getNewHashmap();
        if (hashmap == null) {
            if (this._processor != null) {
                this._processor.Stop();
            }
            this.setImportHashmap(false);
            return;
        }
        UpdateHashmapAsync updateHashmapAsync = new UpdateHashmapAsync(this);
        updateHashmapAsync.sethashmap(hashmap);
        this.connectionPool.setBucketSize(res.getBucketSize());
        ThreadPool.getInstance().executeTask((Runnable)updateHashmapAsync);
    }

    private void StartThrottlingOnRemoteServer(Connection connection) throws LicensingException {
        if (LicenseManager.isDeveloper() && connection != null && connection.getAddress() != null && this._addressUtil == null) {
            this._addressUtil = new AddressUtil();
            this._isLocalAddress = this._addressUtil.verifyLocalAddress(connection.getAddress());
            if (!this._isLocalAddress) {
                this._throttleManager.start();
                this.CheckPendingRequests(this._cacheId.toLowerCase());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CheckPendingRequests(String cacheId) throws LicensingException {
        long val = 0L;
        Object object = this._requestsLock;
        synchronized (object) {
            if (_requestDic.containsKey(cacheId.toLowerCase())) {
                val = _requestDic.get(cacheId.toLowerCase());
                if (val >= 0L) {
                    if (val >= this._allowedRequests) {
                        throw new LicensingException("Clients running under DEV license cannot send more than 200,000 requests to remote cache.");
                    }
                    _requestDic.put(cacheId.toLowerCase(), ++val);
                }
            } else {
                _requestDic.put(cacheId.toLowerCase(), 1L);
            }
        }
    }

    public final void InitializeCache(Connection connection, InetAddress address, int port, boolean balanceNodes) throws OperationFailedException, InternalCommandException, AggregateException, GeneralFailureException, LicensingException, SecurityException, SecurityException, ConfigurationException, StreamException, StreamAlreadyLockedException, OperationNotSupportedException, StreamNotFoundException, IOException, InterruptedException, CommandException {
        boolean isLicenseclient = false;
        InitCommand initCommand = new InitCommand(this._cache.getClientID(), this._cacheId, EncryptionUtil.Encrypt((String)this._securityParams.getUserID()), EncryptionUtil.Encrypt((String)this._securityParams.getPassword()), this._licenceCode, LicenseManager.getLicenseInfo(), isLicenseclient, this._isBridgeClient, connection.getClientLocalIP(), connection.getAddress(), this._clientInfo, this.getClientLicenseType(), SslConfiguration.getSslConnectionEnabled(), this.getOperationTimeout(), this._fromClientCache);
        Request request = new Request(false, this.getOperationTimeout());
        request.addCommand(connection.getServerAddress(), initCommand);
        try {
            this.executeRequest(request, connection, false, false);
        }
        catch (CacheException e) {
            throw new OperationFailedException((Throwable)e);
        }
        connection.setOptimized(true);
        CommandResponse res = connection.RecieveCommandResponse(false);
        this.SecureConnectionIfEnabled(connection, res.isSecureConnectionEnabled());
        switch (res.getCacheType()) {
            case "partitioned-server": 
            case "partitioned-replicas-server": {
                this._balanceNode = false;
                this.setPartitioningStrategy(new DistributedPartitioningStrategy(this));
                break;
            }
            case "local-cache": {
                this._balanceNode = false;
                this.setImportHashmap(false);
                this.setPartitioningStrategy(new LocalCachePartitioningStrategy(connection));
            }
            case "mirror-server": {
                this._balanceNode = false;
                this.setImportHashmap(false);
            }
            case "replicated-server": {
                this.setImportHashmap(false);
            }
        }
        connection.setRequestInquiryEnabled(res.isRequestLoggingEnabled());
        if (res != null) {
            res.parseResponse();
        }
        this._pipeliningEnabled = res.getIspipeliningEnabled();
        this._pipeliningBatchInterval = res.getPipeliningBatchInterval();
        this.getSocketManagerHandler().setEnablePipelining(this._pipeliningEnabled);
        this.setIsPersistenceEnabled(res.getIsPersistenceEnabled());
        this.setPersistInterval(res.getPersistInterval());
        if (this.getIsPersistenceEnabled() && this._persistenceManager == null) {
            this._persistenceManager = new PersistenceManager(this.getPersistInterval() + 10);
        } else if (!this.getIsPersistenceEnabled() && this._persistenceManager != null) {
            this._persistenceManager.dispose();
            this._persistenceManager = null;
        } else if (this.getIsPersistenceEnabled() && this._persistenceManager != null) {
            this._persistenceManager.StartEventDuplicationCheck();
        }
        if (res.getProtobufResponse().getInitCache().getIsShutDownProcessEnabled()) {
            for (ShutDownServerInfoProtocol.ShutDownServerInfo sInfo : res.getProtobufResponse().getInitCache().getShutDownServerInfoList()) {
                Address blockedServer = new Address(sInfo.getServerIP(), sInfo.getPort());
                if (this._shutdownServers.containsKey(blockedServer)) continue;
                ShutDownServerInfo shutdownServer = new ShutDownServerInfo();
                shutdownServer.setBlockInterval(sInfo.getTimeoutInterval());
                shutdownServer.setBlockServerAddress(blockedServer);
                shutdownServer.setUniqueBlockingId(sInfo.getUniqueKey());
                this._shutdownServers.put(blockedServer, shutdownServer);
            }
        }
        this._monitoringSessionId = res.getProtobufResponse().getInitCache().getMonitoringSessionId();
        this._cacheConfigId = res.getProtobufResponse().getInitCache().getCacheConfigId();
    }

    private HashMap<String, Integer> GetRunningServers(Connection conn, InetAddress coonectedServerAddress, int port) throws IOException, OperationFailedException, InternalCommandException, AggregateException, GeneralFailureException, LicensingException, SecurityException, ConfigurationException, StreamException, StreamAlreadyLockedException, OperationNotSupportedException, StreamNotFoundException, InterruptedException, CommandException, ActivityBlockedException {
        GetRunningServersCommand command = new GetRunningServersCommand(this._cacheId, EncryptionUtil.Encrypt((String)this._securityParams.getUserID()), EncryptionUtil.Encrypt((String)this._securityParams.getPassword()));
        Request request = new Request(false, this.getOperationTimeout());
        request.addCommand(conn.getServerAddress(), command);
        this.executeRequest(request, conn, false, false);
        CommandResponse runningServers = conn.RecieveCommandResponse(false);
        if (runningServers != null) {
            runningServers.parseResponse();
            return runningServers.getRunningServers();
        }
        return null;
    }

    public void GetServerMapping(Connection connection, boolean initialRequest) throws OperationFailedException {
        block5: {
            GetServerMappingCommand command = new GetServerMappingCommand();
            CommandResponse commandResponse = null;
            Request request = this.createRequest(command);
            try {
                if (initialRequest) {
                    this.executeRequest(request, connection, false, false);
                    commandResponse = connection.RecieveCommandResponse(false);
                } else {
                    this.executeRequest(request);
                    commandResponse = request.getResponse();
                }
                if (commandResponse != null) {
                    commandResponse.parseResponse();
                }
                this._clientConfig.addMappedServers(commandResponse.getServerMappingList());
            }
            catch (Exception exp) {
                if (!this.getLogger().getIsDetailedLogsEnabled()) break block5;
                this.getLogger().getNCacheLog().Debug(exp.getMessage());
            }
        }
    }

    private int GetCachePort(Connection connection) throws OperationFailedException, InternalCommandException, AggregateException, GeneralFailureException, LicensingException, SecurityException, ConfigurationException, StreamException, StreamAlreadyLockedException, OperationNotSupportedException, StreamNotFoundException, IOException, InterruptedException, CommandException, ActivityBlockedException {
        GetCacheHostPortCommand command = new GetCacheHostPortCommand(this._cacheId, EncryptionUtil.Encrypt((String)this._securityParams.getUserID()), EncryptionUtil.Encrypt((String)this._securityParams.getPassword()));
        Request request = new Request(false, this.getOperationTimeout());
        request.addCommand(connection.getServerAddress(), command);
        this.executeRequest(request, connection, false, false);
        CommandResponse response = connection.RecieveCommandResponse(false);
        if (response != null) {
            response.parseResponse();
        }
        return response.getCacheManagementPort();
    }

    private CommandResponse IsOptimalServer(Connection connection, InetAddress connectedServerAddress, int port) throws IOException, OperationFailedException, AggregateException, GeneralFailureException, InternalCommandException, LicensingException, SecurityException, ConfigurationException, StreamException, StreamAlreadyLockedException, OperationNotSupportedException, StreamNotFoundException, InterruptedException, CommandException, ActivityBlockedException {
        GetOptimalServer command = new GetOptimalServer(this._cacheId, EncryptionUtil.Encrypt((String)this._securityParams.getUserID()), EncryptionUtil.Encrypt((String)this._securityParams.getPassword()));
        Request request = new Request(false, this.getOperationTimeout());
        request.addCommand(connection.getServerAddress(), command);
        this.executeRequest(request, connection, false, false);
        CommandResponse balanceNodeRes = connection.RecieveCommandResponse(false);
        if (balanceNodeRes != null) {
            balanceNodeRes.parseResponse();
        }
        return balanceNodeRes;
    }

    private boolean TryConnectTo(Connection connection, ServerInfo remoteServer) {
        boolean connected;
        block18: {
            int mainPort = connection.getPort();
            InetAddress mainIp = connection.getAddress();
            boolean mainDisconnected = false;
            connected = true;
            try {
                connection.Disconnect();
                mainDisconnected = true;
                connected = connection.connect(remoteServer.getIP(), remoteServer.getPort());
                if (connected) {
                    connected = this.ConnectWithCacheHost(connection, remoteServer.getIP(), remoteServer.getPort());
                    break block18;
                }
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.ConnectRemoteServer", "Unable to connect to [" + remoteServer.getIP() + ":" + remoteServer.getPort() + "], restoring existing connection with [" + mainIp + ":" + mainPort + "]");
                }
                try {
                    connection.Disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connected = connection.connect(mainIp, mainPort);
                if (connected) {
                    connected = this.ConnectWithCacheHost(connection, mainIp, mainPort);
                } else if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.ConnectRemoteServer", "Unable to restoring connection to [" + mainIp + ":" + mainPort + "]");
                }
            }
            catch (IOException | RuntimeException e) {
                if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.ConnectRemoteServer", "Error connecting. Error: " + e.toString());
                }
                if (!mainDisconnected) break block18;
                try {
                    connection.Disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connected = connection.connect(mainIp, mainPort);
                if (connected) {
                    try {
                        connected = this.ConnectWithCacheHost(connection, mainIp, mainPort);
                    }
                    catch (Exception exception) {}
                } else if (this.getLogger().getIsErrorLogsEnabled()) {
                    this.getLogger().getNCacheLog().Error("Broker.ConnectRemoteServer", "Unable to restoring connection to [" + mainIp + ":" + mainPort + "]");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return connected;
    }

    private boolean ConnectWithCacheHost(Connection connection, InetAddress address, int port) throws IOException, InternalCommandException, GeneralFailureException, AggregateException, OperationFailedException, LicensingException, SecurityException, StreamNotFoundException, StreamException, StreamAlreadyLockedException, ConfigurationException, OperationNotSupportedException, InterruptedException, CommandException, ActivityBlockedException {
        boolean connectedWithHost = true;
        int cachePort = this.GetCachePort(connection);
        if (cachePort != port) {
            connection.Disconnect(false);
            connectedWithHost = connection.SwitchTo(this, this.getLogger(), this._perfStatsColl, this._responseIntegrator, this._clientConfig.getBindIP(), this._cacheId, address, cachePort);
            if (!connectedWithHost && this.getLogger().getIsErrorLogsEnabled()) {
                this.getLogger().getNCacheLog().Error("Broker.ConnectWithCacheHost", "Failed to connect with cache host directly on port :" + cachePort);
            }
        }
        return connectedWithHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean GetMessageDistribution(Map<String, List<String>> topicWiseMessageIds, HashMap<Address, HashMap<String, List<String>>> messageDistributionMap) {
        boolean result = false;
        for (Map.Entry<String, List<String>> pair : topicWiseMessageIds.entrySet()) {
            String topicName = pair.getKey();
            List<String> messageList = pair.getValue();
            for (String messageId : messageList) {
                HashMap<String, List<String>> topicDic;
                Address loadbaanced;
                Address address;
                Object object = this._hashmapUpdateMutex;
                synchronized (object) {
                    address = this.getPool().GetIp(messageId);
                }
                Connection conn = this.getPool().getItem(address);
                Address adrs = address;
                if (conn != null && !conn.getIsConnected() && (loadbaanced = this.GetLoadBalancedAddress()) != null) {
                    adrs = loadbaanced;
                }
                if (messageDistributionMap.containsKey(adrs)) {
                    topicDic = messageDistributionMap.get(adrs);
                    this.PopulateList(topicDic, topicName, messageId);
                    result = true;
                    continue;
                }
                topicDic = new HashMap();
                this.PopulateList(topicDic, topicName, messageId);
                messageDistributionMap.put(adrs, topicDic);
            }
        }
        return result;
    }

    private void PopulateList(HashMap<String, List<String>> topicDic, String topicName, String messageId) {
        if (topicDic.containsKey(topicName)) {
            List<String> list = topicDic.get(topicName);
            list.add(messageId);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(messageId);
            topicDic.put(topicName, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ReconectInBackground(Address address, Connection connection) {
        Map<Address, ReconnectTask> map = this._reconnectTasks;
        synchronized (map) {
            if (!this._reconnectTasks.containsKey(address) && !connection.getIsReconnecting()) {
                ReconnectTask task = new ReconnectTask(this, connection);
                this._reconnectTasks.put(address, task);
                this._processor.Enqueue((AsyncProcessor.IAsyncTask)task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void UnregisterReconnectTask(Address address) {
        Map<Address, ReconnectTask> map = this._reconnectTasks;
        synchronized (map) {
            this._reconnectTasks.remove(address);
        }
    }

    @Override
    public void OnServerLost(Address ip, boolean foredDisocnnect) {
        this.ServerLost(ip, foredDisocnnect);
    }

    public boolean poolHasAllServers() {
        return this._clientConfig.getServerCount() == this.connectionPool.getServers().size();
    }
}

